/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.memberedit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.utils.MemberAddServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.datalock.DataLockService;
import kd.epm.eb.common.lazytree.datalock.DataLockUtils;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.TreeNodeUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class PeriodAddContainsPlugin
extends AbstractFormPlugin {
    private static Map<String, Set<String>> levelNumberMap = new HashMap<String, Set<String>>(16);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setEnable(Boolean.FALSE, new String[]{"quarter", "halfyear"});
        List<String> periodStatus = this.getPeriodStatus();
        for (String status : periodStatus) {
            if (!((Boolean)this.getModel().getValue(status)).booleanValue()) continue;
            this.getModel().setValue(status, (Object)Boolean.FALSE);
            this.getView().setEnable(Boolean.TRUE, new String[]{status});
        }
        if (this.isDetailedQuarter()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"quarter"});
            this.getModel().setValue("quarter", (Object)Boolean.FALSE);
        }
        this.getPageCache().put("quarterInitValue", (Boolean)this.getModel().getValue("quarter") != false ? "1" : "0");
        this.getPageCache().put("halfyearInitValue", (Boolean)this.getModel().getValue("halfyear") != false ? "1" : "0");
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("btn_save".equals(evt.getItemKey())) {
            String halfyearValue;
            String quarterValue = (Boolean)this.getModel().getValue("quarter") != false ? "1" : "0";
            String string = halfyearValue = (Boolean)this.getModel().getValue("halfyear") != false ? "1" : "0";
            if (!quarterValue.equals(this.getPageCache().get("quarterInitValue")) || !halfyearValue.equals(this.getPageCache().get("halfyearInitValue"))) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6dfb\u52a0\u540e\u6570\u636e\u5c06\u4e0d\u5141\u8bb8\u5220\u9664\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"PeriodAddContainsPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("btn_save"));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6dfb\u52a0\u7684\u6570\u636e\u3002", (String)"PeriodAddContainsPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (MessageBoxResult.Yes != evt.getResult()) {
            return;
        }
        if ("btn_save".equals(evt.getCallBackId())) {
            this.saveData();
            ArrayList<String> returnData = new ArrayList<String>(2);
            if (((Boolean)this.getModel().getValue("quarter")).booleanValue()) {
                returnData.add("quarter");
            }
            if (((Boolean)this.getModel().getValue("halfyear")).booleanValue()) {
                returnData.add("halfyear");
            }
            if (returnData.size() > 0) {
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(returnData));
            }
            this.getView().close();
        }
    }

    private void saveData() {
        DynamicObject[] members = this.queryAllPeriods();
        HashMap<String, DynamicObject> dynamicObjectMap = new HashMap<String, DynamicObject>(32);
        HashMap<String, TreeNode> treeNodeMap = new HashMap<String, TreeNode>(32);
        for (DynamicObject member : members) {
            treeNodeMap.computeIfAbsent(member.getString("id"), v -> this.createNode(member));
            dynamicObjectMap.computeIfAbsent(member.getString("number"), v -> member);
        }
        String rootid = ((DynamicObject)dynamicObjectMap.get("Period")).getString("id");
        TreeNode root = TreeNodeUtils.createTree(treeNodeMap, (TreeNode)((TreeNode)treeNodeMap.get(rootid)));
        Map<String, DynamicObject> createMembers = this.getCreateMembers(root, dynamicObjectMap);
        this.hanleLevelData(root, null, dynamicObjectMap, createMembers);
        DynamicObject model = this.updateModel();
        IModelCacheHelper modelCache = this.getIModelCacheHelper();
        List periods = DataLockUtils.getPeriods((IModelCacheHelper)modelCache, (boolean)false);
        try (TXHandle tx = TX.requiresNew((String)"savePeriod");){
            try {
                SaveServiceHelper.save((DynamicObject[])dynamicObjectMap.values().toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])createMembers.values().toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{model});
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
            finally {
                CubeUtils.get().checkDimension(this.getModelId(), Long.valueOf(this.getDimensionId()));
            }
        }
        IModelCacheHelper newModelCache = ModelCacheContext.getOrCreate((Long)this.getModelId(), (boolean)true);
        List newPeriods = DataLockUtils.getPeriods((IModelCacheHelper)newModelCache, (boolean)false);
        DataLockService.getInstance().updatePeriods(this.getModelId().longValue(), periods, newPeriods);
        this.syncOlapData(createMembers.keySet());
    }

    protected void syncOlapData(Set<String> numbers) {
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Model modelobj = orCreate.getModelobj();
        ArrayList<Dataset> lists = new ArrayList<Dataset>(1);
        lists.add(new Dataset(modelobj.getId(), modelobj.getNumber()));
        ArrayList<Member> members = new ArrayList<Member>(numbers.size());
        for (String number : numbers) {
            members.add(orCreate.getMember("Period", null, number));
        }
        ShrekConfig config = ShrekConfigServiceHelper.getDefaultConfig((Model)modelobj);
        ShrekOlapServiceHelper.addCubeMembers((Model)modelobj, lists, (String)"Period", members, (ShrekConfig)config);
    }

    private void hanleLevelData(TreeNode node, TreeNode parent, Map<String, DynamicObject> dynamicObjectMap, Map<String, DynamicObject> createMembers) {
        List children = node.getChildren();
        if (parent != null) {
            String number = node.getText();
            DynamicObject object = dynamicObjectMap.get(number);
            if (object == null) {
                object = createMembers.get(number);
            }
            object.set("parent", (Object)parent.getId());
            Map data = (Map)parent.getData();
            String longnumber = data.get("longnumber") + "!" + number;
            int level = Integer.parseInt(data.get("level").toString()) + 1;
            object.set("longnumber", (Object)longnumber);
            object.set("level", (Object)level);
            TreeNodeUtils.writeProperties((String)"longnumber", (Object)longnumber, (TreeNode)node);
            TreeNodeUtils.writeProperties((String)"level", (Object)level, (TreeNode)node);
            if (children != null && children.size() > 0) {
                object.set("isleaf", (Object)"0");
            } else {
                object.set("isleaf", (Object)"1");
            }
        }
        if (children != null) {
            for (TreeNode child : children) {
                this.hanleLevelData(child, node, dynamicObjectMap, createMembers);
            }
        }
    }

    private Map<String, DynamicObject> getCreateMembers(TreeNode root, Map<String, DynamicObject> dynamicObjectMap) {
        Map<String, DynamicObject> members;
        String prefix = this.isDetailedQuarter() ? "Q" : "M";
        TreeNode parent = this.getParent(root.getChildren(), prefix + "_YearTotal");
        List children = parent.getChildren();
        HashMap<String, DynamicObject> createMembers = new HashMap<String, DynamicObject>(16);
        if (((Boolean)this.getModel().getValue("halfyear")).booleanValue() && dynamicObjectMap.get(prefix + "_HF1") == null) {
            boolean hasQuarter = dynamicObjectMap.get(prefix + "_Q1") != null;
            members = this.createMembers(false, prefix);
            for (DynamicObject halfyear : members.values()) {
                this.insertMembers(parent, halfyear, halfyear.getString("number").substring(1), !hasQuarter, prefix);
            }
            createMembers.putAll(members);
        }
        if (((Boolean)this.getModel().getValue("quarter")).booleanValue() && dynamicObjectMap.get(prefix + "_Q1") == null) {
            boolean hasHalfYear = ((TreeNode)children.get(0)).getText().startsWith(prefix + "_HF");
            members = this.createMembers(true, prefix);
            for (DynamicObject quarter : members.values()) {
                String number = quarter.getString("number");
                if (hasHalfYear) {
                    parent = this.getParent(children, this.findParentNums(number, prefix));
                }
                this.insertMembers(parent, quarter, number.substring(1), false, prefix);
            }
            createMembers.putAll(members);
        }
        return createMembers;
    }

    private void insertMembers(TreeNode parent, DynamicObject object, String number, boolean findFrandSon, String prefix) {
        TreeNode node = this.createNode(object);
        Set<String> childenNums = this.findChildenNums(number, findFrandSon, prefix);
        List children = parent.getChildren();
        children.removeIf(c -> {
            if (childenNums.contains(c.getText())) {
                node.addChild(c);
                return true;
            }
            return false;
        });
        children.add(node);
    }

    private DynamicObject[] queryAllPeriods() {
        QFilter[] qFilters = new QFilter[]{new QFilter("model", "=", (Object)this.getModelId())};
        String filed = "id,number,parent,longnumber,level,isleaf";
        DynamicObject[] members = BusinessDataServiceHelper.load((String)"epm_periodmembertree", (String)filed, (QFilter[])qFilters);
        return members;
    }

    @Override
    public Long getModelId() {
        return Long.valueOf(this.getView().getFormShowParameter().getCustomParam("model").toString());
    }

    private long getDimensionId() {
        return Long.parseLong(this.getView().getFormShowParameter().getCustomParam("dimensionId").toString());
    }

    private List<String> getPeriodStatus() {
        return (List)SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParam("periodStatus")), List.class);
    }

    private Map<String, DynamicObject> createMembers(boolean isquarter, String prefix) {
        long modelId = this.getModelId();
        long dimensionId = this.getDimensionId();
        int count = isquarter ? 4 : 2;
        HashMap<String, DynamicObject> createMembers = new HashMap<String, DynamicObject>(16);
        MemberAddServiceHelper instance = MemberAddServiceHelper.getInstance();
        for (int i = 1; i <= count; ++i) {
            DynamicObject member = instance.createCommonMemberObject(Long.valueOf(modelId), Long.valueOf(dimensionId), "epm_periodmembertree");
            if (isquarter) {
                member.set("number", (Object)(prefix + "_Q" + i));
                member.set("name", (Object)(i + this.quarter()));
                if (i == 1) {
                    member.set("effmonth", (Object)"1");
                    member.set("effday", (Object)"1");
                    member.set("expmonth", (Object)"3");
                    member.set("expday", (Object)"31");
                    member.set("effdate", (Object)(1 + this.month() + 1 + this.Date()));
                    member.set("expdate", (Object)(3 + this.month() + 31 + this.Date()));
                } else if (i == 2) {
                    member.set("effmonth", (Object)"4");
                    member.set("effday", (Object)"1");
                    member.set("expmonth", (Object)"6");
                    member.set("expday", (Object)"30");
                    member.set("effdate", (Object)(4 + this.month() + 1 + this.Date()));
                    member.set("expdate", (Object)(6 + this.month() + 30 + this.Date()));
                } else if (i == 3) {
                    member.set("effmonth", (Object)"7");
                    member.set("effday", (Object)"1");
                    member.set("expmonth", (Object)"9");
                    member.set("expday", (Object)"30");
                    member.set("effdate", (Object)(7 + this.month() + 1 + this.Date()));
                    member.set("expdate", (Object)(9 + this.month() + 30 + this.Date()));
                } else {
                    member.set("effmonth", (Object)"10");
                    member.set("effday", (Object)"1");
                    member.set("expmonth", (Object)"12");
                    member.set("expday", (Object)"31");
                    member.set("effdate", (Object)(10 + this.month() + 1 + this.Date()));
                    member.set("expdate", (Object)(12 + this.month() + 31 + this.Date()));
                }
            } else {
                member.set("number", (Object)(prefix + "_HF" + i));
                if (i == 1) {
                    member.set("name", (Object)this.uphalfyear());
                    member.set("effmonth", (Object)"1");
                    member.set("effday", (Object)"1");
                    member.set("expmonth", (Object)"6");
                    member.set("expday", (Object)"30");
                    member.set("effdate", (Object)(1 + this.month() + 1 + this.Date()));
                    member.set("expdate", (Object)(6 + this.month() + 30 + this.Date()));
                } else {
                    member.set("name", (Object)this.downhalfyear());
                    member.set("effmonth", (Object)"7");
                    member.set("effday", (Object)"1");
                    member.set("expmonth", (Object)"12");
                    member.set("expday", (Object)"31");
                    member.set("effdate", (Object)(7 + this.month() + 1 + this.Date()));
                    member.set("expdate", (Object)(12 + this.month() + 31 + this.Date()));
                }
            }
            member.set("isleaf", (Object)"0");
            member.set("membersource", (Object)"1");
            member.set("dseq", (Object)i);
            member.set("storagetype", (Object)"2");
            long id = DBServiceHelper.genGlobalLongId();
            member.set("id", (Object)id);
            member.set("masterid", (Object)id);
            createMembers.put(member.getString("number"), member);
        }
        return createMembers;
    }

    private TreeNode createNode(DynamicObject object) {
        TreeNode node = new TreeNode(object.getString("parent.id"), object.getString("id"), object.getString("number"));
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("longnumber", object.getString("longnumber"));
        data.put("level", object.getInt("level"));
        data.put("isleaf", object.getBoolean("isleaf"));
        node.setData(data);
        return node;
    }

    private TreeNode getParent(List<TreeNode> nodes, String parentNumber) {
        TreeNode parent = null;
        if (nodes != null) {
            for (TreeNode node : nodes) {
                if (!parentNumber.equals(node.getText())) continue;
                parent = node;
                break;
            }
        }
        if (parent == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u4e0a\u7ea7\uff1a%1\u3002", (String)"PeriodAddContainsPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return parent;
    }

    private String findParentNums(String number, String prefix) {
        number = number.substring(1);
        for (Map.Entry<String, Set<String>> entry : levelNumberMap.entrySet()) {
            if (!entry.getValue().contains(number)) continue;
            return prefix + entry.getKey();
        }
        throw new KDBizException("member number error");
    }

    private Set<String> findChildenNums(String number, boolean findGrandSon, String prefix) {
        HashSet<String> numbers = new HashSet<String>(16);
        Set<String> strings = levelNumberMap.get(number);
        if (findGrandSon) {
            for (String string : strings) {
                Set<String> strings1 = levelNumberMap.get(string);
                for (String s : strings1) {
                    numbers.add(prefix + s);
                }
            }
        } else {
            for (String s : strings) {
                numbers.add(prefix + s);
            }
        }
        return numbers;
    }

    private DynamicObject updateModel() {
        DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)this.getModelId(), (String)"epm_model");
        String periodDetailed = (String)this.getView().getFormShowParameter().getCustomParam("periodDetailed");
        Boolean quarter = (Boolean)this.getModel().getValue("quarter");
        Boolean halfyear = (Boolean)this.getModel().getValue("halfyear");
        if ("month".equals(periodDetailed)) {
            if (quarter.booleanValue()) {
                model.set("mincludeqrt", (Object)"1");
            }
            if (halfyear.booleanValue()) {
                model.set("mincludeyear", (Object)"1");
            }
        } else if (halfyear.booleanValue() && "quarter".equals(periodDetailed)) {
            model.set("qrtincludeyear", (Object)"1");
        }
        return model;
    }

    private boolean isDetailedQuarter() {
        return "quarter".equals(this.getView().getFormShowParameter().getCustomParam("periodDetailed"));
    }

    private String month() {
        return ResManager.loadKDString((String)"\u6708", (String)"PeriodAddContainsPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private String Date() {
        return ResManager.loadKDString((String)"\u65e5", (String)"PeriodAddContainsPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private String quarter() {
        return ResManager.loadKDString((String)"\u5b63\u5ea6", (String)"PeriodAddContainsPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private String uphalfyear() {
        return ResManager.loadKDString((String)"\u4e0a\u534a\u5e74", (String)"PeriodAddContainsPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private String downhalfyear() {
        return ResManager.loadKDString((String)"\u4e0b\u534a\u5e74", (String)"PeriodAddContainsPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    static {
        levelNumberMap.put("_HF1", new HashSet<String>(Arrays.asList("_Q1", "_Q2")));
        levelNumberMap.put("_HF2", new HashSet<String>(Arrays.asList("_Q3", "_Q4")));
        levelNumberMap.put("_Q1", new HashSet<String>(Arrays.asList("_M01", "_M02", "_M03")));
        levelNumberMap.put("_Q2", new HashSet<String>(Arrays.asList("_M04", "_M05", "_M06")));
        levelNumberMap.put("_Q3", new HashSet<String>(Arrays.asList("_M07", "_M08", "_M09")));
        levelNumberMap.put("_Q4", new HashSet<String>(Arrays.asList("_M10", "_M11", "_M12")));
    }
}

