/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.memberf7;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.BillList;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.utils.CommonMethod;

public class DatasetAccountTreePlugin
extends StandardTreeListPlugin
implements BeforeF7SelectListener,
CommonMethod {
    private static final String MODEL_KEY = "model";
    private static final String DATASET_KEY = "dataset";
    private static final String TREEVIEW_KEY = "treeview";
    private static final String BUSINESS_MODEL_KEY = "businessmodel";

    public void initialize() {
        ITreeModel treeModel;
        ITreeListView treeView = this.getTreeListView();
        if (treeView != null && (treeModel = treeView.getTreeModel()) instanceof TreeListModel) {
            TreeListModel treeListModel = (TreeListModel)treeModel;
            QFilter qfUserdefineds = new QFilter("1", "=", (Object)1);
            Map params = this.getView().getFormShowParameter().getCustomParams();
            if (params == null || params.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DatasetAccountTreePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            params.remove("searchValueMap");
            params.remove("searchFields");
            if (params.containsKey("mbg_queryFilter")) {
                Map _params = (Map)params.get("mbg_queryFilter");
                if (_params == null || _params.isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DatasetAccountTreePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                for (Map.Entry entry : _params.entrySet()) {
                    if (BUSINESS_MODEL_KEY.equalsIgnoreCase((String)entry.getKey())) continue;
                    qfUserdefineds.and(new QFilter((String)entry.getKey(), "=", entry.getValue()));
                }
            } else {
                for (Map.Entry entry : params.entrySet()) {
                    if (BUSINESS_MODEL_KEY.equalsIgnoreCase((String)entry.getKey())) continue;
                    qfUserdefineds.and(new QFilter((String)entry.getKey(), "=", entry.getValue()));
                }
            }
            treeListModel.getTreeFilter().add(qfUserdefineds);
        }
    }

    public void setView(IFormView formView) {
        super.setView(formView);
        this.setBgMarkOnSetView(formView);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit edit = (BasedataEdit)this.getControl(DATASET_KEY);
        if (edit != null) {
            edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initDataset();
        this.initLeftTree();
    }

    private void initBillList() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    private void initLeftTree() {
        TreeView treeLeft = (TreeView)this.getControl(TREEVIEW_KEY);
        if (this.getPageParam(MODEL_KEY).equals(0)) {
            treeLeft.deleteAllNodes();
            return;
        }
        TreeNode leftNode = this.generateTree();
        treeLeft.deleteAllNodes();
        treeLeft.updateNode(leftNode);
        treeLeft.addNode(leftNode);
        treeLeft.focusNode(leftNode);
        this.spreadAllNode(leftNode);
    }

    private TreeNode generateTree() {
        QFilter qf = new QFilter(MODEL_KEY, "=", this.getPageParam(MODEL_KEY)).and("isleaf", "=", (Object)"0");
        String selectFields = "id,name,parent.id,isleaf,level,dataset";
        DynamicObjectCollection docs = QueryServiceHelper.query((String)"epm_accountmembertree", (String)selectFields, (QFilter[])qf.toArray(), (String)"level,parent,createtime");
        TreeNode rootleft = null;
        if (docs != null && !docs.isEmpty()) {
            List root = docs.stream().filter(p -> "1".equals(p.getString("level"))).collect(Collectors.toList());
            rootleft = new TreeNode(null, ((DynamicObject)root.get(0)).getString("id"), ((DynamicObject)root.get(0)).getString("name"));
            DynamicObject dataset = (DynamicObject)this.getModel().getValue(DATASET_KEY);
            long curDatasetId = dataset != null ? dataset.getLong("id") : 0L;
            List accounts = docs.stream().filter(p -> curDatasetId == p.getLong(DATASET_KEY)).collect(Collectors.toList());
            for (DynamicObject account : accounts) {
                TreeNode parentNode;
                TreeNode node = new TreeNode();
                node.setId(account.getString("id"));
                node.setText(account.getString("name"));
                node.setParentid(account.getString("parent.id"));
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("name", account.getString("name"));
                data.put("level", account.getString("level"));
                data.put("id", account.getString("id"));
                node.setData(data);
                if (rootleft == null || (parentNode = rootleft.getTreeNode(node.getParentid(), 20)) == null) continue;
                if (parentNode.getChildren() == null) {
                    parentNode.setChildren(new ArrayList(16));
                }
                parentNode.getChildren().add(node);
            }
        }
        return rootleft;
    }

    private void spreadAllNode(TreeNode treenode) {
        if (treenode == null) {
            return;
        }
        treenode.setIsOpened(true);
        if (null != treenode.getChildren()) {
            List nodes = treenode.getChildren();
            for (TreeNode t : nodes) {
                this.spreadAllNode(t);
            }
        }
    }

    private void initDataset() {
        QFilter qf = new QFilter(MODEL_KEY, "=", this.getPageParam(MODEL_KEY)).and(BUSINESS_MODEL_KEY, "=", this.getPageParam(BUSINESS_MODEL_KEY));
        DynamicObjectCollection datasets = QueryServiceHelper.query((String)"eb_dataset", (String)"id,number", (QFilter[])qf.toArray());
        if (datasets != null && datasets.size() > 0) {
            datasets.stream().filter(p -> "default".equalsIgnoreCase(p.getString("number"))).forEach(dataset -> this.getModel().setValue(DATASET_KEY, dataset.get("id")));
            if (this.getModel().getValue(DATASET_KEY) == null) {
                this.getModel().setValue(DATASET_KEY, ((DynamicObject)datasets.get(0)).get("id"));
            }
        }
        if (this.isNewEbForm()) {
            this.setBgDefaultField();
        }
    }

    private Object getPageParam(String key) {
        Map params = (Map)this.getView().getFormShowParameter().getCustomParam("mbg_queryFilter");
        Object value = params != null ? params.get(key) : this.getView().getFormShowParameter().getCustomParam(key);
        return value == null ? Long.valueOf(0L) : value;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propKey;
        super.propertyChanged(e);
        switch (propKey = e.getProperty().getName()) {
            case "dataset": {
                Object obj = this.getModel().getValue(DATASET_KEY);
                if (obj == null) break;
                this.initLeftTree();
                this.initBillList();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String f7Key = arg0.getProperty().getName();
        ListShowParameter showP = (ListShowParameter)arg0.getFormShowParameter();
        List qs = showP.getListFilterParameter().getQFilters();
        switch (f7Key) {
            case "dataset": {
                qs.add(new QFilter(MODEL_KEY, "=", this.getPageParam(MODEL_KEY)));
                qs.add(new QFilter(BUSINESS_MODEL_KEY, "=", this.getPageParam(BUSINESS_MODEL_KEY)));
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(new QFilter(DATASET_KEY, "=", (Object)((DynamicObject)this.getModel().getValue(DATASET_KEY)).getLong("id")));
        e.setOrderBy("number");
    }

    public String getBizModelKey() {
        return DATASET_KEY;
    }
}

