/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.memberf7;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.entity.property.CustomProperty;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.ShowTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.pojo.BooleanObj;
import kd.epm.eb.common.pojo.MultiDim.DimViewInfo;
import kd.epm.eb.common.pojo.MultiDim.MultiDimMembResult;
import kd.epm.eb.common.pojo.MultiDim.MultiDimMemberVal;
import kd.epm.eb.common.pojo.TreeActionType;
import kd.epm.eb.common.pojo.serch.EntrySearchInfo;
import kd.epm.eb.common.pojo.serch.SearchType;
import kd.epm.eb.common.pojo.serch.TreeSearchInfo;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.compress.NewGzipUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.memberf7.SimpleTreeNodeUtil;
import kd.epm.eb.formplugin.memberf7.entity.SimpleTreeNode;
import kd.epm.eb.model.utils.ModelUtil;

public class MultiDimMemberF7Plugin
extends AbstractFormPlugin
implements SearchEnterListener,
BeforeF7SelectListener {
    private static final int preDimSize = 6;
    private static final String T_RootNodeId = "0";
    private static final String T_RootNodeTEXT = "root";
    private static final String T_flexApKey = "leftchoosemembers";
    private static final String T_dimTitleKey = "labelleftchoose";
    private static final String T_memberTypeKey = "membertype";
    private static final String T_allChooseKey = "allchoose";
    private static final String T_allClearKey = "allclear";
    private static final String T_allExpandKey = "allexpand";
    private static final String T_allShrinkKey = "allshrink";
    private static final String T_searchKey = "searchapleft";
    private static final String T_searchBKey = "searchleftbefore";
    private static final String T_searchNKey = "searchleftnext";
    private static final String T_memberTreeKey = "treeleft";
    private static final String M_searchKey = "searchapright";
    private static final String M_searchBKey = "searchbefore";
    private static final String M_searchNKey = "searchnext";
    private static final String M_entityKey = "selentryentity";
    private static final String M_membTypeKey = "ismember";
    private static final String M_membIdKey = "membid";
    private static final String M_membTextKey = "membtext";
    private static final String M_viewKey = "view";
    private static final String BUTTONADDKEY = "buttonadd";
    private static final String BUTTONDELETE = "buttondelete";
    private static final String BTN_SURE = "BTN_SURE";
    private Map<Integer, BasedataPojo> dimIndexMap;
    private Map<String, Set<Long>> memberFilters;
    private Map<String, Set<Long>> propFilters;

    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initDimInfo();
        this.initTreeAndEntry();
    }

    private void initDimInfo() {
        List dimNums = (List)this.getFormCustomParam("mutildimf7_dimNums");
        HashMap<Integer, BasedataPojo> dimIndexMap = new HashMap<Integer, BasedataPojo>(16);
        IFormView formView = this.getView();
        if (dimNums != null && dimNums.size() > 0) {
            Long bizModelId = this.getBizModelId();
            IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
            for (int i = 0; i < dimNums.size(); ++i) {
                String dimNum = (String)dimNums.get(i);
                Dimension dimension = modelCacheHelper.getDimension(dimNum);
                if (dimension == null) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u83b7\u53d6\u7ef4\u5ea6%1\u5931\u8d25", (String)"MultiDimMemberF7Plugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{dimNum}));
                }
                String viewKey = M_viewKey + i;
                boolean canEditView = false;
                if (SysDimensionEnum.dimHasView((String)dimension.getNumber())) {
                    Long defaultViewId = null;
                    if (this.isEmpty(bizModelId)) {
                        defaultViewId = modelCacheHelper.getDefaultViewIdOnDim(dimNum);
                    } else {
                        List viewIds = modelCacheHelper.getViewGroupViewsByBusModelAndDimNumber(bizModelId, dimNum);
                        if (viewIds != null) {
                            defaultViewId = (Long)viewIds.get(0);
                        }
                    }
                    this.getModel().setValue(viewKey, (Object)defaultViewId);
                    canEditView = modelCacheHelper.getModelobj().isModelByBGMD() || this.isNewEbForm() && SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber());
                }
                formView.setEnable(Boolean.valueOf(canEditView), new String[]{viewKey});
                dimIndexMap.put(i, new BasedataPojo(dimension.getId(), dimension.getName(), dimension.getNumber()));
            }
        }
        this.getOrCacheDimInfo(dimIndexMap);
        if (dimIndexMap.size() > 1) {
            HashMap<String, String> leftCtlParams = new HashMap<String, String>(16);
            leftCtlParams.put("id", "flexpanelapleftchoose");
            leftCtlParams.put("type", "flexpanel");
            HashMap<String, String> rightCtlParams = new HashMap<String, String>(16);
            rightCtlParams.put("id", "flexpanelaprightselect");
            rightCtlParams.put("type", "flexpanel");
            if (dimIndexMap.size() == 2) {
                leftCtlParams.put("w", (String)new LocaleString("63%"));
                rightCtlParams.put("w", (String)new LocaleString("32%"));
            } else {
                leftCtlParams.put("w", (String)new LocaleString("52.5%"));
                rightCtlParams.put("w", (String)new LocaleString("42.5%"));
            }
            formView.updateControlMetadata("flexpanelapleftchoose", leftCtlParams);
            formView.updateControlMetadata("flexpanelaprightselect", rightCtlParams);
        }
    }

    public Map<String, Set<Long>> getMemberFilters() {
        if (this.memberFilters == null) {
            this.memberFilters = this.loadFilterInfo("mutildimf7_memberfilter");
        }
        return this.memberFilters;
    }

    public Map<String, Set<Long>> getPropFilters() {
        if (this.propFilters == null) {
            this.propFilters = this.loadFilterInfo("mutildimf7_propvalfilter");
        }
        return this.propFilters;
    }

    private Map<String, Set<Long>> loadFilterInfo(String paramKey) {
        String paramStr = (String)this.getFormCustomParam(paramKey);
        if (this.notEmpty(paramStr)) {
            return (Map)SerializationUtils.deSerializeFromBase64((String)paramStr);
        }
        return new HashMap<String, Set<Long>>(16);
    }

    private void initTreeAndEntry() {
        Map<Integer, BasedataPojo> dimInfo = this.getOrCacheDimInfo(null);
        ArrayList<String> toHideKeys = new ArrayList<String>(16);
        ArrayList<String> toShowKeys = new ArrayList<String>(16);
        EntryGrid entryGrid = (EntryGrid)this.getControl(M_entityKey);
        Long modelId = this.getModelId();
        boolean isOldEb = ModelServiceHelper.isOldEbModel((Long)modelId);
        for (int i = 0; i < 6; ++i) {
            BasedataPojo dimObj = dimInfo.get(i);
            if (dimObj == null) {
                toHideKeys.add(T_flexApKey + i);
                toHideKeys.add(M_membTextKey + i);
                continue;
            }
            Label dimTitleCtrl = (Label)this.getControl(T_dimTitleKey + i);
            dimTitleCtrl.setText(ResManager.loadResFormat((String)"\u9009\u62e9%1\u6210\u5458", (String)"MultiDimMemberF7Plugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{dimObj.getName()}));
            entryGrid.setColumnProperty(M_membTextKey + i, "header", (Object)new LocaleString(dimObj.getName()));
            SysDimensionEnum enumByNumber = SysDimensionEnum.getEnumByNumber((String)dimObj.getNumber());
            if (!isOldEb && (enumByNumber == null || enumByNumber == SysDimensionEnum.Entity || enumByNumber.getMemberTreemodel().equals(SysDimensionEnum.Project.getMemberTreemodel()))) {
                toShowKeys.add(T_memberTypeKey + i);
            } else {
                toHideKeys.add(T_memberTypeKey + i);
            }
            this.initLeftTree(dimObj, i, false);
        }
        this.getView().setVisible(Boolean.valueOf(false), toHideKeys.toArray(new String[0]));
        this.getView().setVisible(Boolean.valueOf(true), toShowKeys.toArray(new String[0]));
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTONADDKEY, BUTTONDELETE, BTN_SURE, "allclearright", M_searchNKey, M_searchBKey});
        int dimCount = this.getOrCacheDimInfo(null).size();
        this.batAddTreeItemListener(dimCount);
        for (int seq = 0; seq < dimCount; ++seq) {
            this.addF7SelectListener(this, new String[]{M_viewKey + seq});
        }
    }

    private void batAddTreeItemListener(int dimCount) {
        LinkedList<String> toSearchKeys = new LinkedList<String>();
        LinkedList<String> clickKeys = new LinkedList<String>();
        toSearchKeys.add(M_searchKey);
        for (int seq = 0; seq < dimCount; ++seq) {
            toSearchKeys.add(T_searchKey + seq);
            clickKeys.add(T_searchBKey + seq);
            clickKeys.add(T_searchNKey + seq);
            clickKeys.add(T_allExpandKey + seq);
            clickKeys.add(T_allShrinkKey + seq);
        }
        this.addSearchListener(this, toSearchKeys.toArray(new String[1]));
        this.addClickListeners(clickKeys.toArray(new String[1]));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ("showtypeleft".equals(propName)) {
            this.upLeftTreeShowType();
        } else if ("showtyperight".equals(propName)) {
            this.upRightEntryShowType();
        } else if (propName.startsWith(T_memberTypeKey)) {
            this.upLeftTree(propName);
        } else if ("showdisable".equals(propName)) {
            BasedataPojo dimObj;
            Map<Integer, BasedataPojo> dimInfo = this.getOrCacheDimInfo(null);
            for (int i = 0; i < 6 && (dimObj = dimInfo.get(i)) != null; ++i) {
                if (!this.isMemberTree(i)) continue;
                this.initLeftTree(dimObj, i, false);
            }
        } else if (this.notEmpty(propName) && propName.startsWith(M_viewKey)) {
            this.dealViewChange(propName, e);
        }
    }

    private void dealViewChange(String viewKey, PropertyChangedArgs e) {
        if (this.isEmpty(this.getPageCache().get("doNotDealViewChange"))) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (this.isEmpty(newValue)) {
                this.getPageCache().put("doNotDealViewChange", "true");
                this.getModel().setValue(viewKey, e.getChangeSet()[0].getOldValue());
                this.getPageCache().remove("doNotDealViewChange");
            } else {
                this.upLeftTree(viewKey);
                this.delAllEntryRow();
            }
        }
    }

    private void upLeftTree(String itemKey) {
        int dimSeq = this.getDimIndexByItemKey(itemKey);
        boolean isMember = this.isMemberTree(dimSeq);
        BasedataPojo dimObj = this.getOrCacheDimInfo(null).get(dimSeq);
        this.initLeftTree(dimObj, dimSeq, !isMember);
        this.getView().setVisible(Boolean.valueOf(isMember), new String[]{M_viewKey + dimSeq});
    }

    private void upLeftTreeShowType() {
        ShowTypeEnum showTypeEnum = this.getShowType(false);
        Map<Integer, BasedataPojo> dimInfo = this.getOrCacheDimInfo(null);
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)this.getModelId());
        dimInfo.forEach((dimSeq, dimObj) -> {
            SimpleTreeNode treeInfo = this.getOrCacheTreeInfo(null, (int)dimSeq);
            Dimension dimension = modelCacheHelper.getDimension(dimObj.getNumber());
            String treeType = (String)this.getValue(T_memberTypeKey + dimSeq, null);
            Long viewId = this.getCDimViewId((int)dimSeq);
            if (treeInfo != null && dimension != null) {
                boolean isMember = RangeF7PropertyCataEnum.Member.getIndex().equals(treeType);
                Map<String, Dataset> datasetMap = null;
                if (dimObj.getNumber().equals(SysDimensionEnum.Account.getNumber()) && !ModelUtil.isEbOrBgModel((Long)this.getModelId())) {
                    datasetMap = DatasetServiceHelper.getInstance().getDataSetObjByBizModelId(this.getBizModelId()).stream().collect(Collectors.toMap(obj1 -> String.valueOf(obj1.getId()), obj2 -> obj2));
                }
                TreeNode rootNode = SimpleTreeNodeUtil.buildTree(treeInfo, isMember ? dimension : memberPropCache, viewId, datasetMap, showTypeEnum);
                this.upTree2Form((int)dimSeq, rootNode, datasetMap != null && datasetMap.size() > 0);
            }
        });
    }

    private void upRightEntryShowType() {
        ShowTypeEnum showTypeEnum = this.getShowType(true);
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity(M_entityKey);
        if (entryRows.isEmpty()) {
            return;
        }
        Map<Integer, BasedataPojo> dimInfo = this.getOrCacheDimInfo(null);
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)this.getModelId());
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        dimInfo.forEach((dimSeq, dimObj) -> {
            Dimension dimension = modelCacheHelper.getDimension(dimObj.getNumber());
            if (dimension != null) {
                String showText = null;
                Long viewId = this.getCDimViewId((int)dimSeq);
                for (DynamicObject row : entryRows) {
                    Long membId = row.getLong(M_membIdKey + dimSeq);
                    if (row.getBoolean(M_membTypeKey + dimSeq)) {
                        Member member = dimension.getMember(viewId, membId);
                        if (member != null) {
                            showText = CommonServiceHelper.buildShowText((String)member.getNumber(), (String)member.getName(), (ShowTypeEnum)showTypeEnum);
                        }
                    } else {
                        CustomPropertyValue propVal = memberPropCache.getPropertyValue(dimension.getNumber(), membId);
                        if (propVal != null) {
                            showText = CommonServiceHelper.buildShowText((String)propVal.getNumber(), (String)propVal.getName(), (ShowTypeEnum)showTypeEnum);
                        }
                    }
                    row.set(M_membTextKey + dimSeq, (Object)showText);
                }
            }
        });
        this.getView().updateView(M_entityKey);
    }

    private ShowTypeEnum getShowType(boolean isEntry) {
        String typeVal = (String)this.getValue(isEntry ? "showtyperight" : "showtypeleft", null);
        ShowTypeEnum showTypeEnum = ShowTypeEnum.getShowTypeByValue((String)typeVal);
        return showTypeEnum;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
    }

    private SimpleTreeNode getOrCacheTreeInfo(TreeNode rootNode, int treeSeq) {
        String cacheKey = "MemberTreeInfo" + treeSeq;
        SimpleTreeNode treeNodeInfo = null;
        if (rootNode == null) {
            String cacheStr = this.getPageCache().getBigObject(cacheKey);
            if (this.notEmpty(cacheStr)) {
                cacheStr = (String)NewGzipUtils.unCompress((String)cacheStr);
                treeNodeInfo = (SimpleTreeNode)SerializationUtils.fromJsonString((String)cacheStr, SimpleTreeNode.class);
            }
        } else {
            treeNodeInfo = SimpleTreeNodeUtil.buildTree(rootNode);
            this.getPageCache().putBigObject(cacheKey, NewGzipUtils.compress((Object)SerializationUtils.toJsonString((Object)treeNodeInfo, (boolean)false)));
        }
        return treeNodeInfo;
    }

    private void delAllEntryRow() {
        this.getModel().deleteEntryData(M_entityKey);
        this.clearAllEntrySearchInfo();
    }

    private void moveRight() {
        BasedataPojo dimInfo;
        int i;
        Map<Integer, BasedataPojo> dimInfos = this.getOrCacheDimInfo(null);
        ArrayList<List<Object>> selMembers = new ArrayList<List<Object>>(dimInfos.size());
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)this.getModelId());
        for (i = 0; i < 6 && (dimInfo = dimInfos.get(i)) != null; ++i) {
            TreeView memberTree = (TreeView)this.getControl(T_memberTreeKey + i);
            boolean isProp = "2".equals(this.getValue(T_memberTypeKey + i, null));
            List checkedNodeIds = memberTree.getTreeState().getCheckedNodeIds();
            if (checkedNodeIds.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8fd8\u672a\u9009\u62e9%1\u6210\u5458", (String)"MultiDimMemberF7Plugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{dimInfo.getName()}));
                return;
            }
            ArrayList<Object> members = new ArrayList<Object>(16);
            if (isProp) {
                for (String nodeId : checkedNodeIds) {
                    CustomPropertyValue propertyValue = memberPropCache.getPropertyValue(dimInfo.getNumber(), Long.valueOf(nodeId));
                    if (propertyValue != null) {
                        members.add(propertyValue);
                        continue;
                    }
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u7684\u5c5e\u6027\u503c%2\u4e0d\u5b58\u5728", (String)"MultiDimMemberF7Plugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{dimInfo.getName(), nodeId}));
                    return;
                }
            } else {
                Dimension dimension = modelCacheHelper.getDimension(dimInfo.getNumber());
                Long viewId = this.getCDimViewId(i);
                for (String nodeId : checkedNodeIds) {
                    Member member = dimension.getMember(viewId, Long.valueOf(nodeId));
                    if (member != null) {
                        members.add(member);
                        continue;
                    }
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u7684\u6210\u5458%2\u4e0d\u5b58\u5728", (String)"MultiDimMemberF7Plugin_5", (String)"epm-eb-formplugin", (Object[])new Object[]{dimInfo.getName(), nodeId}));
                    return;
                }
            }
            selMembers.add(members);
        }
        this.addSelRow2Entry(selMembers);
        for (i = 0; i < 6; ++i) {
            TreeView treeView = (TreeView)this.getControl(T_memberTreeKey + i);
            if (treeView == null) continue;
            treeView.uncheckNode(T_RootNodeId);
        }
        this.clearAllEntrySearchInfo();
    }

    private void addSelRow2Entry(List<List<Object>> selMembers) {
        BasedataPojo[] dimInfoArray = this.getDimInfoArray();
        DynamicObjectCollection entryRow = this.getModel().getEntryEntity(M_entityKey);
        int leastSize = 10000 - entryRow.size();
        if (leastSize <= 0) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6700\u5927\u7ef4\u5ea6\u7ec4\u5408\u6570\u4e3a%1\uff0c\u5df2\u8df3\u8fc7\u591a\u4f59\u7684\u7ef4\u5ea6\u7ec4\u5408\u3002", (String)"MultiDimMemberF7Plugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{10000}));
            return;
        }
        int dimSize = dimInfoArray.length;
        HashSet rowMemberIdsStr = new HashSet(entryRow.size());
        ArrayList<String> membIdColKeys = new ArrayList<String>(dimSize);
        for (int i = 0; i < dimSize; ++i) {
            membIdColKeys.add(M_membIdKey + i);
        }
        StringBuilder sb = new StringBuilder();
        entryRow.forEach(row -> {
            for (String dimColKey : membIdColKeys) {
                sb.append(row.getLong(dimColKey)).append(',');
            }
            rowMemberIdsStr.add(sb.toString());
            sb.setLength(0);
        });
        ShowTypeEnum showType = this.getShowType(true);
        BooleanObj removed = new BooleanObj();
        BooleanObj repetitive = new BooleanObj();
        List<String> dimNums = this.getDimNums();
        DimMemberPermChecker permChecker = DimMembPermHelper.getPermChecker((Long)this.getModelId(), (Long)this.getBizModelId(), dimNums, (boolean)true, (Long)this.getUserId(), (DimMembPermType)DimMembPermType.GIVE);
        boolean filterGivePerm = !permChecker.hasAllPerm() || dimNums.size() > 0;
        HashMap memberItemMap = new HashMap(dimNums.size());
        ArrayList newRows = new ArrayList(16);
        CommonServiceHelper.buildDescartes(selMembers, membreGroup -> {
            sb.setLength(0);
            for (int index = 0; index < dimNums.size(); ++index) {
                Object member = membreGroup.get(index);
                if (member instanceof Member) {
                    sb.append(((Member)member).getId()).append(',');
                    if (!filterGivePerm) continue;
                    memberItemMap.put(dimNums.get(index), new MemberItem(true, ((Member)member).getId()));
                    continue;
                }
                if (!(member instanceof CustomPropertyValue)) continue;
                sb.append(((CustomPropertyValue)member).getId()).append(',');
                if (!filterGivePerm) continue;
                memberItemMap.put(dimNums.get(index), new MemberItem(false, ((CustomPropertyValue)member).getId()));
            }
            if (filterGivePerm && !permChecker.check(memberItemMap)) {
                removed.mark(true);
                return false;
            }
            if (!rowMemberIdsStr.contains(sb.toString())) {
                MemberItem[] row = new MemberItem[dimSize];
                for (int i = 0; i < dimSize; ++i) {
                    Object member = membreGroup.get(i);
                    String name = null;
                    boolean isMember = true;
                    Long id = null;
                    if (member instanceof Member) {
                        Member member1 = (Member)member;
                        name = CommonServiceHelper.buildShowText((String)member1.getShowNumber(), (String)member1.getName(), (ShowTypeEnum)showType);
                        id = member1.getId();
                    } else if (member instanceof CustomPropertyValue) {
                        CustomPropertyValue propertyValue = (CustomPropertyValue)member;
                        name = CommonServiceHelper.buildShowText((String)propertyValue.getNumber(), (String)propertyValue.getName(), (ShowTypeEnum)showType);
                        isMember = false;
                        id = propertyValue.getId();
                    }
                    row[i] = new MemberItem(isMember, id, name);
                }
                newRows.add(row);
                return newRows.size() >= leastSize;
            }
            repetitive.mark(true);
            return false;
        });
        if (newRows.size() > 0) {
            IDataModel dataModel = this.getModel();
            dataModel.beginInit();
            int[] newRowIndex = this.getModel().batchCreateNewEntryRow(M_entityKey, newRows.size());
            dataModel.endInit();
            for (int i = 0; i < newRowIndex.length && i < newRows.size(); ++i) {
                DynamicObject newRow = dataModel.getEntryRowEntity(M_entityKey, newRowIndex[i]);
                MemberItem[] rowMembers = (MemberItem[])newRows.get(i);
                for (int j = 0; j < dimSize; ++j) {
                    newRow.set(M_membTextKey + j, (Object)rowMembers[j].getMemberNum());
                    newRow.set(M_membTypeKey + j, (Object)rowMembers[j].isMember());
                    newRow.set(M_membIdKey + j, (Object)rowMembers[j].getMemberId());
                }
            }
            this.getView().updateView(M_entityKey);
        }
        if (removed.marked()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u8df3\u8fc7\u65e0\u6388\u6743\u6743\u7684\u6210\u5458/\u7ec4\u5408", (String)"MultiDimMemberF7Plugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (repetitive.marked()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ec4\u5408\u5b58\u5728\u91cd\u590d\u9009\u62e9\u8bb0\u5f55\uff0c\u5df2\u8df3\u8fc7\u3002", (String)"MultiDimMemberF7Plugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (newRows.size() >= leastSize) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6700\u5927\u7ef4\u5ea6\u7ec4\u5408\u6570\u4e3a%1\uff0c\u5df2\u8df3\u8fc7\u591a\u4f59\u7684\u7ef4\u5ea6\u7ec4\u5408\u3002", (String)"MultiDimMemberF7Plugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{10000}));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String itemKey = ((Control)evt.getSource()).getKey();
        if (this.isEmpty(itemKey)) {
            return;
        }
        if (BUTTONADDKEY.equals(itemKey)) {
            this.moveRight();
        } else if ("btn_sure".equals(itemKey)) {
            this.returnData();
        } else if ("allclearright".equals(itemKey)) {
            this.delAllEntryRow();
        } else if (itemKey.startsWith(T_searchBKey)) {
            this.searchMemberTreeUp(this.getDimIndexByItemKey(itemKey));
        } else if (itemKey.startsWith(T_searchNKey)) {
            this.searchMemberTreeDown(this.getDimIndexByItemKey(itemKey));
        } else if (itemKey.startsWith(M_searchNKey)) {
            this.searchEntryDown();
        } else if (itemKey.startsWith(M_searchBKey)) {
            this.searchEntryUp();
        } else if (itemKey.startsWith(T_allShrinkKey)) {
            this.handleTreeAction(this.getDimIndexByItemKey(itemKey), TreeActionType.CLOSEALL);
        } else if (itemKey.startsWith(T_allExpandKey)) {
            this.handleTreeAction(this.getDimIndexByItemKey(itemKey), TreeActionType.EXPALL);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if ("deleteentry".equals(operateKey) && (operationResult == null || operationResult.isSuccess())) {
            this.clearAllEntrySearchInfo();
        }
    }

    private void returnData() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity(M_entityKey);
        if (this.isEmpty(rows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u6570\u636e\u3002", (String)"MultiDimMemberF7Plugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList vals = new ArrayList(rows.size());
        List<String> dimNums = this.getDimNums();
        ArrayList<DimViewInfo> viewInfo = new ArrayList<DimViewInfo>(16);
        for (int i = 0; i < dimNums.size(); ++i) {
            Long viewId = this.getCDimViewId(i);
            if (this.notEmpty(viewId)) {
                viewInfo.add(new DimViewInfo(dimNums.get(i), viewId));
                continue;
            }
            viewInfo.add(new DimViewInfo(dimNums.get(i)));
        }
        for (DynamicObject row : rows) {
            ArrayList<MultiDimMemberVal> rowVal = new ArrayList<MultiDimMemberVal>(dimNums.size());
            for (int i = 0; i < dimNums.size(); ++i) {
                MultiDimMemberVal val = new MultiDimMemberVal();
                val.setMember(row.getBoolean(M_membTypeKey + i));
                val.setMemberId(row.getLong(M_membIdKey + i));
                rowVal.add(val);
            }
            vals.add(rowVal);
        }
        MultiDimMembResult result = new MultiDimMembResult();
        result.setMemberRows(vals);
        result.setDimViewInfos(viewInfo);
        this.getView().returnDataToParent((Object)result);
        this.getView().close();
    }

    private List<String> getDimNums() {
        BasedataPojo pojo;
        Map<Integer, BasedataPojo> dimInfo = this.getOrCacheDimInfo(null);
        ArrayList<String> dimNum = new ArrayList<String>(dimInfo.size());
        for (int i = 0; i < 6 && (pojo = dimInfo.get(i)) != null; ++i) {
            dimNum.add(pojo.getNumber());
        }
        return dimNum;
    }

    private void initLeftTree(BasedataPojo dimInfo, int itemIndex, boolean isProp) {
        TreeNode rootNode = isProp ? this.buildPropTree(dimInfo) : this.buildMemberTree(dimInfo, itemIndex);
        rootNode.iterate(20, child -> {
            List children = child.getChildren();
            if (children != null) {
                children.sort(Comparator.comparing(o -> (Integer)o.getData()));
                children.forEach(childNode -> childNode.setData(null));
            }
        });
        boolean hasDatasetNode = dimInfo.getNumber().equals(SysDimensionEnum.Account.getNumber()) && !ModelUtil.isEbOrBgModel((Long)this.getModelId());
        this.upTree2Form(itemIndex, rootNode, hasDatasetNode);
        this.getOrCacheTreeInfo(rootNode, itemIndex);
        this.getOrCacheTreeSearchInfo(new TreeSearchInfo(), itemIndex);
    }

    private void upTree2Form(int itemIndex, TreeNode treeNode, boolean hasDatasetNode) {
        TreeView treeView;
        if (treeNode != null && (treeView = (TreeView)this.getControl(T_memberTreeKey + itemIndex)) != null) {
            treeView.deleteAllNodes();
            treeView.addNode(treeNode);
            treeView.expand(treeNode.getId());
            if (treeNode.getChildren() != null) {
                for (TreeNode child1 : treeNode.getChildren()) {
                    if (child1.getChildren() == null) continue;
                    treeView.expand(child1.getId());
                    if (child1.getChildren().size() != 1 || !hasDatasetNode) continue;
                    treeView.expand(((TreeNode)child1.getChildren().get(0)).getId());
                }
            }
        }
    }

    private TreeNode buildPropTree(BasedataPojo dimInfo) {
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)this.getModelId());
        List propVals = memberPropCache.getPropertyValuesByDim(dimInfo.getId());
        HashMap<Long, TreeNode> propNodes = new HashMap<Long, TreeNode>();
        ShowTypeEnum showType = this.getShowType(false);
        TreeNode rootNode = SimpleTreeNodeUtil.getRootNode();
        Set<Long> propValFilters = this.getPropFilters().get(dimInfo.getNumber());
        for (CustomPropertyValue propVal : propVals) {
            if (propValFilters != null && !propValFilters.contains(propVal.getId())) continue;
            CustomProperty prop = propVal.getProp();
            TreeNode propNode = (TreeNode)propNodes.get(prop.getId());
            if (propNode == null) {
                propNode = new TreeNode("", prop.getId().toString(), CommonServiceHelper.buildShowText((String)prop.getNumber(), (String)prop.getName(), (ShowTypeEnum)showType));
                propNodes.put(prop.getId(), propNode);
                rootNode.addChild(propNode);
                propNode.setDisabled(true);
                propNode.setData((Object)prop.getDseq());
            }
            TreeNode propValNode = new TreeNode("", propVal.getId().toString(), CommonServiceHelper.buildShowText((String)propVal.getNumber(), (String)propVal.getName(), (ShowTypeEnum)showType));
            propValNode.setData((Object)propVal.getDseq());
            propNode.addChild(propValNode);
        }
        return rootNode;
    }

    private TreeNode buildMemberTree(BasedataPojo dimInfo, int dimIndex) {
        Long bizModelId = this.getBizModelId();
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Long viewId = this.getCDimViewId(dimIndex);
        Set<Long> existMembers = this.getMemberFilters().get(dimInfo.getNumber());
        Member rootMember = modelCacheHelper.getRootMember(dimInfo.getNumber(), viewId);
        List childMembers = rootMember.getChildren();
        ShowTypeEnum showType = this.getShowType(false);
        TreeNode rootMemberNode = this.buildTreeNode(rootMember, showType);
        if (existMembers != null && !existMembers.contains(rootMember.getId())) {
            rootMemberNode.setDisabled(true);
        }
        this.buildMemberTree(showType, rootMemberNode, existMembers, childMembers, bizModelId, dimInfo.getNumber());
        TreeNode root = SimpleTreeNodeUtil.getRootNode();
        root.addChild(rootMemberNode);
        return root;
    }

    private void buildMemberTree(ShowTypeEnum showType, TreeNode rootMemberNode, Set<Long> existMembers, List<Member> childMembers, Long bizModelId, String dimNum) {
        if (childMembers != null) {
            boolean showDisable = (Boolean)this.getValue("showdisable", null);
            Collection datasetObjs = null;
            if (SysDimensionEnum.Account.getNumber().equals(dimNum) && this.notEmpty(bizModelId) && !ModelUtil.isEbOrBgModel((Long)this.getModelId())) {
                datasetObjs = DatasetServiceHelper.getInstance().getDataSetObjByBizModelId(bizModelId);
                Set allDimIds = this.getOrCacheDimInfo(null).values().stream().filter(dim -> !dim.getNumber().equals(dimNum)).map(BasedataPojo::getId).collect(Collectors.toSet());
                HashSet filterDataSetIds = new HashSet(DatasetServiceHelper.getDatasetByDimFilter((Long)bizModelId, allDimIds));
                datasetObjs.removeIf(obj -> !filterDataSetIds.contains(obj.getId()));
            }
            if (datasetObjs == null) {
                LinkedList<Member> secondLevelMembers = new LinkedList<Member>(childMembers);
                while (!secondLevelMembers.isEmpty()) {
                    this.buildTree(showDisable, secondLevelMembers.pollFirst(), rootMemberNode, existMembers, secondLevelMembers, showType);
                }
            } else {
                HashMap<Long, LinkedList> datasetChildMap = new HashMap<Long, LinkedList>(16);
                Map<Long, Dataset> datasetMap = datasetObjs.stream().collect(Collectors.toMap(Dataset::getId, obj2 -> obj2));
                HashMap<Long, Integer> datasetSeq = new HashMap<Long, Integer>(datasetObjs.size());
                for (int seq = 0; seq < datasetObjs.size(); ++seq) {
                    datasetSeq.put(((Dataset)datasetObjs.get(seq)).getId(), seq);
                }
                for (Member child : childMembers) {
                    if (!datasetMap.containsKey(child.getDatasetId())) continue;
                    datasetChildMap.computeIfAbsent(child.getDatasetId(), key -> new LinkedList()).add(child);
                }
                datasetChildMap.forEach((datasetId, refMembers) -> {
                    Dataset dataset = (Dataset)datasetMap.get(datasetId);
                    TreeNode datasetNode = this.buildTreeNode(dataset.getId(), dataset.getNumber(), dataset.getName(), (Integer)datasetSeq.get(datasetId), showType);
                    datasetNode.setDisabled(true);
                    while (!refMembers.isEmpty()) {
                        this.buildTree(showDisable, (Member)refMembers.pollFirst(), datasetNode, existMembers, (LinkedList<Member>)refMembers, showType);
                    }
                    if (datasetNode.getChildren() != null) {
                        rootMemberNode.addChild(datasetNode);
                    }
                });
            }
        }
    }

    private void buildTree(boolean showDisable, Member member, TreeNode parentNode, Set<Long> existMembers, LinkedList<Member> secondLevelMembers, ShowTypeEnum showType) {
        if (member == null || !showDisable && member.isDisable()) {
            return;
        }
        if (existMembers != null && !existMembers.contains(member.getId()) || !member.isEnable()) {
            if (member.getChildren() != null) {
                secondLevelMembers.addAll(member.getChildren());
            }
        } else {
            TreeNode childNode = this.buildTreeNode(member, showType);
            parentNode.addChild(childNode);
            if (member.getChildren() != null) {
                for (Member child : member.getChildren()) {
                    this.buildTree(showDisable, child, childNode, existMembers, secondLevelMembers, showType);
                }
            }
        }
    }

    private TreeNode buildTreeNode(Member member, ShowTypeEnum showType) {
        return this.buildTreeNode(member.getId(), member.getShowNumber(), member.getName(), member.getSeq(), showType);
    }

    private TreeNode buildTreeNode(Long id, String number, String name, int seq, ShowTypeEnum showType) {
        TreeNode treeNode = new TreeNode();
        treeNode.setText(CommonServiceHelper.buildShowText((String)number, (String)name, (ShowTypeEnum)showType));
        treeNode.setId(String.valueOf(id));
        treeNode.setData((Object)seq);
        return treeNode;
    }

    private int getDimIndexByItemKey(String itemKey) {
        char c;
        int index = 0;
        if (itemKey != null && itemKey.length() > 0 && (c = itemKey.charAt(itemKey.length() - 1)) <= '9' && c >= '0') {
            index = c - 48;
        }
        return index;
    }

    private String getDimByIndex(int itemIndex) {
        BasedataPojo dimObj = this.getOrCacheDimInfo(null).get(itemIndex);
        return dimObj == null ? null : dimObj.getNumber();
    }

    public Long getBizModelId() {
        Long bizModelId = (Long)this.getFormCustomParam("KEY_BUSMODEL_ID");
        if (bizModelId == null) {
            return 0L;
        }
        return bizModelId;
    }

    @Override
    public Long getModelId() {
        return (Long)this.getFormCustomParam("KEY_MODEL_ID");
    }

    public BasedataPojo[] getDimInfoArray() {
        Map<Integer, BasedataPojo> dimInfo = this.getOrCacheDimInfo(null);
        BasedataPojo[] dimInfoArray = new BasedataPojo[dimInfo.size()];
        dimInfo.forEach((index, dimObj) -> {
            dimInfoArray[index.intValue()] = dimObj;
        });
        return dimInfoArray;
    }

    public Map<Integer, BasedataPojo> getOrCacheDimInfo(Map<Integer, BasedataPojo> dimIndexMap) {
        if (dimIndexMap == null) {
            if (this.dimIndexMap == null) {
                String cacheStr = this.getPageCache().get("dimIndexMap");
                this.dimIndexMap = this.isEmpty(cacheStr) ? new HashMap<Integer, BasedataPojo>(16) : (Map)SerializationUtils.deSerializeFromBase64((String)cacheStr);
            }
        } else {
            this.dimIndexMap = dimIndexMap;
            this.getPageCache().put("dimIndexMap", SerializationUtils.serializeToBase64(dimIndexMap));
        }
        return this.dimIndexMap;
    }

    private boolean showVrMember() {
        return (Boolean)this.getFormCustomParam("mutildimf7_showVr");
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        Control control = (Control)searchEnterEvent.getSource();
        String treeKey = control.getKey();
        String text = searchEnterEvent.getText();
        if (this.isEmpty(text)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u8981\u641c\u7d22\u7684\u5185\u5bb9", (String)"MultiDimMemberF7Plugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (treeKey.startsWith(T_searchKey)) {
            this.searchMemberTree(text, this.getDimIndexByItemKey(treeKey));
        } else if (treeKey.startsWith(M_searchKey)) {
            this.searchEntry(text);
        }
    }

    private void searchMemberTree(String text, int dimSeq) {
        SimpleTreeNode treeInfo = this.getOrCacheTreeInfo(null, dimSeq);
        TreeSearchInfo searchInfo = new TreeSearchInfo();
        if (treeInfo != null) {
            ShowTypeEnum showType = this.getShowType(false);
            Long modelId = this.getModelId();
            String dimNum = this.getDimByIndex(dimSeq);
            if (this.isMemberTree(dimSeq)) {
                IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
                Long viewId = this.getCDimViewId(dimSeq);
                treeInfo.iterate(memberNode -> {
                    Member member = modelCacheHelper.getMember(dimNum, viewId, Long.valueOf(memberNode.getId()));
                    if (member != null && this.match(member.getNumber(), member.getName(), showType, text)) {
                        searchInfo.getNodeIds().add(memberNode.getId());
                    }
                });
            } else {
                MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelId);
                treeInfo.iterate(prop -> {
                    CustomPropertyValue propertyValue = memberPropCache.getPropertyValue(dimNum, Long.valueOf(prop.getId()));
                    if (propertyValue != null && this.match(propertyValue.getNumber(), propertyValue.getName(), showType, text)) {
                        searchInfo.getNodeIds().add(prop.getId());
                    }
                });
            }
        }
        this.handleSearch(searchInfo, treeInfo, SearchType.ENT, dimSeq, true);
    }

    private void handleSearch(TreeSearchInfo searchInfo, SimpleTreeNode treeInfo, SearchType searchType, int dimSeq, boolean alwaysCache) {
        if (searchInfo == null) {
            searchInfo = this.getOrCacheTreeSearchInfo(null, dimSeq);
        }
        if (treeInfo == null) {
            treeInfo = this.getOrCacheTreeInfo(null, dimSeq);
        }
        if (searchInfo == null || searchInfo.getNodeIds().isEmpty()) {
            this.getView().showTipNotification(searchType.getEmptyTip());
            if (alwaysCache) {
                this.getOrCacheTreeSearchInfo(searchInfo, dimSeq);
            }
        } else {
            String targetNodeId = null;
            if (searchType == SearchType.ENT) {
                targetNodeId = searchInfo.getCurrentId();
            } else if (searchType == SearchType.PRE) {
                targetNodeId = searchInfo.getNodeId(true);
            } else if (searchType == SearchType.NEXT) {
                targetNodeId = searchInfo.getNodeId(false);
            }
            if (targetNodeId == null) {
                this.getView().showTipNotification(searchType.getErrorTip());
            } else if (treeInfo != null) {
                TreeView treeView = (TreeView)this.getControl(T_memberTreeKey + dimSeq);
                List<String> allParentNode = treeInfo.getAllAncestry(targetNodeId, false);
                for (String nodeId : allParentNode) {
                    treeView.expand(nodeId);
                }
                TreeNode targetNode = new TreeNode();
                targetNode.setId(targetNodeId);
                treeView.focusNode(targetNode);
                this.getOrCacheTreeSearchInfo(searchInfo, dimSeq);
            }
        }
    }

    private void handleEntrySearch(EntrySearchInfo entrySearchInfo, SearchType searchType, boolean alwaysCache) {
        if (entrySearchInfo == null) {
            entrySearchInfo = this.getOrCacheEntrySearchInfo(null, false);
        }
        if (entrySearchInfo == null || entrySearchInfo.getRowsIndex().isEmpty()) {
            this.getView().showTipNotification(searchType.getEmptyTip());
            if (alwaysCache) {
                this.getOrCacheEntrySearchInfo(entrySearchInfo, false);
            }
        } else {
            Integer targetRow = null;
            if (searchType == SearchType.ENT) {
                targetRow = entrySearchInfo.getCurrentRow();
            } else if (searchType == SearchType.PRE) {
                targetRow = entrySearchInfo.upCurrentRowIndex(true);
            } else if (searchType == SearchType.NEXT) {
                targetRow = entrySearchInfo.upCurrentRowIndex(false);
            }
            if (targetRow == null) {
                this.getView().showTipNotification(searchType.getErrorTip());
            } else {
                EntryGrid entryGrid = (EntryGrid)this.getControl(M_entityKey);
                entryGrid.selectRows(targetRow.intValue());
                this.getOrCacheEntrySearchInfo(entrySearchInfo, false);
            }
        }
    }

    private boolean match(String number, String name, ShowTypeEnum showType, String text) {
        if (showType == ShowTypeEnum.NUMBER) {
            return number != null && number.contains(text);
        }
        if (showType == ShowTypeEnum.NAME) {
            return name != null && name.contains(text);
        }
        return name != null && name.contains(text) || number != null && number.contains(text);
    }

    private void handleTreeAction(int dimSeq, TreeActionType actionType) {
        List checkedNodeIds;
        TreeView treeView = (TreeView)this.getControl(T_memberTreeKey + dimSeq);
        if (treeView != null && (checkedNodeIds = treeView.getTreeState().getCheckedNodeIds()).size() > 0) {
            switch (actionType) {
                case EXPALL: 
                case CLOSEALL: {
                    HashSet nodeIds = new HashSet(checkedNodeIds);
                    boolean close = actionType == TreeActionType.CLOSEALL;
                    SimpleTreeNode treeInfo = this.getOrCacheTreeInfo(null, dimSeq);
                    if (treeInfo == null) break;
                    treeInfo.iterate(node -> {
                        if (nodeIds.contains(node.getId()) && node.getChild() != null) {
                            node.iterate(childNode -> {
                                if (childNode.getChild() != null) {
                                    if (close) {
                                        treeView.collapse(childNode.getId());
                                    } else {
                                        treeView.expand(childNode.getId());
                                    }
                                }
                            });
                            return true;
                        }
                        return false;
                    });
                }
            }
        }
    }

    private void searchEntry(String text) {
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity(M_entityKey);
        Map<Integer, BasedataPojo> dimInfo = this.getOrCacheDimInfo(null);
        int dimCount = dimInfo.size();
        EntrySearchInfo entrySearchInfo = new EntrySearchInfo();
        int rowIndex = 0;
        for (DynamicObject row : entryRows) {
            for (int dimSeq = 0; dimSeq < dimCount; ++dimSeq) {
                String memberShowStr = row.getString(M_membTextKey + dimSeq);
                if (memberShowStr == null || !memberShowStr.contains(text)) continue;
                entrySearchInfo.getRowsIndex().add(rowIndex);
                break;
            }
            ++rowIndex;
        }
        this.handleEntrySearch(entrySearchInfo, SearchType.ENT, true);
    }

    private void searchMemberTreeUp(int dimSeq) {
        this.handleSearch(null, null, SearchType.PRE, dimSeq, false);
    }

    private void searchMemberTreeDown(int dimSeq) {
        this.handleSearch(null, null, SearchType.NEXT, dimSeq, false);
    }

    private void searchEntryUp() {
        this.handleEntrySearch(null, SearchType.PRE, false);
    }

    private void searchEntryDown() {
        this.handleEntrySearch(null, SearchType.NEXT, false);
    }

    private TreeSearchInfo getOrCacheTreeSearchInfo(TreeSearchInfo treeSearchInfo, int dimSeq) {
        if (treeSearchInfo != null) {
            this.getPageCache().putBigObject("TreeSearchInfo" + dimSeq, SerializationUtils.toJsonString((Object)treeSearchInfo));
        } else {
            String cacheStr = this.getPageCache().getBigObject("TreeSearchInfo" + dimSeq);
            if (this.notEmpty(cacheStr)) {
                treeSearchInfo = (TreeSearchInfo)SerializationUtils.fromJsonString((String)cacheStr, TreeSearchInfo.class);
            }
        }
        return treeSearchInfo;
    }

    private void clearAllEntrySearchInfo() {
        this.getOrCacheEntrySearchInfo(null, true);
    }

    private EntrySearchInfo getOrCacheEntrySearchInfo(EntrySearchInfo entrySearchInfo, boolean clearAll) {
        String cacheKey = "EntrySearchInfo";
        if (entrySearchInfo != null) {
            this.getPageCache().putBigObject(cacheKey, SerializationUtils.toJsonString((Object)entrySearchInfo));
        } else if (clearAll) {
            this.getPageCache().removeBigObject(cacheKey);
        } else {
            String cacheStr = this.getPageCache().getBigObject(cacheKey);
            if (this.notEmpty(cacheStr)) {
                entrySearchInfo = (EntrySearchInfo)SerializationUtils.fromJsonString((String)cacheStr, EntrySearchInfo.class);
            }
        }
        return entrySearchInfo;
    }

    private boolean isMemberTree(int dimSeq) {
        String type = (String)this.getValue(T_memberTypeKey + dimSeq, null);
        return RangeF7PropertyCataEnum.Member.getIndex().equals(type);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String f7Key = beforeF7SelectEvent.getProperty().getName();
        if (this.notEmpty(f7Key) && f7Key.startsWith(M_viewKey)) {
            this.addViewFilter(f7Key, beforeF7SelectEvent.getCustomQFilters());
        }
    }

    public void addViewFilter(String f7Key, List<QFilter> customQFilters) {
        Long bizModelId = this.getBizModelId();
        int dimIndex = Integer.parseInt(f7Key.substring(4));
        BasedataPojo dimObj = this.getOrCacheDimInfo(null).get(dimIndex);
        if (dimObj != null) {
            IModelCacheHelper iModelCacheHelper = this.getIModelCacheHelper();
            if (this.isEmpty(bizModelId)) {
                customQFilters.add(new QFilter("dimension", "=", (Object)dimObj.getId()));
            } else {
                ArrayList viewIds = iModelCacheHelper.getViewGroupViewsByBusModelAndDimNumber(bizModelId, dimObj.getNumber());
                if (viewIds == null) {
                    viewIds = new ArrayList(1);
                }
                customQFilters.add(new QFilter("id", "in", viewIds));
            }
        }
    }

    public Long getCDimViewId(int dimSeq) {
        return (Long)this.getValue(M_viewKey + dimSeq, "id");
    }
}

