/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.memberf7;

import java.util.LinkedList;
import java.util.Map;
import kd.bos.entity.tree.TreeNode;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.entity.property.CustomProperty;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.ShowTypeEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.memberf7.entity.SimpleTreeNode;

public class SimpleTreeNodeUtil {
    public static final String T_RootNodeId = "0";
    public static final String T_RootNodeTEXT = "root";

    public static SimpleTreeNode buildTree(TreeNode root) {
        SimpleTreeNode node = null;
        if (root != null) {
            node = new SimpleTreeNode(root.getId());
            node.setCheckAble(!root.isDisabled());
            if (root.getChildren() != null) {
                LinkedList<SimpleTreeNode> childNodeList = new LinkedList<SimpleTreeNode>();
                for (TreeNode childNode : root.getChildren()) {
                    SimpleTreeNode child = SimpleTreeNodeUtil.buildTree(childNode);
                    if (child == null) continue;
                    childNodeList.add(child);
                }
                if (childNodeList.size() > 0) {
                    node.setChild(childNodeList);
                }
            }
        }
        return node;
    }

    public static TreeNode buildTree(SimpleTreeNode root, Object cache, Long viewId, Map<String, Dataset> datasetMap, ShowTypeEnum showType) {
        TreeNode node = SimpleTreeNodeUtil.buildNode(root, cache, viewId, datasetMap, showType);
        if (node != null && root.getChild() != null) {
            for (SimpleTreeNode childNode : root.getChild()) {
                TreeNode child = SimpleTreeNodeUtil.buildTree(childNode, cache, viewId, datasetMap, showType);
                if (child == null) continue;
                node.addChild(child);
            }
        }
        return node;
    }

    private static TreeNode buildNode(SimpleTreeNode node, Object cache, Long viewId, Map<String, Dataset> datasetMap, ShowTypeEnum showType) {
        if (node != null) {
            Dataset dataset;
            if (node.getId().equals(T_RootNodeId)) {
                return SimpleTreeNodeUtil.getRootNode();
            }
            Dataset dataset2 = dataset = datasetMap == null ? null : datasetMap.get(node.getId());
            if (dataset != null) {
                return SimpleTreeNodeUtil.buildNode(false, node.getId(), dataset.getNumber(), dataset.getName(), showType);
            }
            if (cache instanceof Dimension) {
                Member member = ((Dimension)cache).getMember(viewId, IDUtils.toLong((Object)node.getId()));
                if (member != null) {
                    return SimpleTreeNodeUtil.buildNode(node.checkAble(), node.getId(), member.getNumber(), member.getName(), showType);
                }
            } else if (cache instanceof MemberPropCache) {
                MemberPropCache propCache = (MemberPropCache)cache;
                Long id = IDUtils.toLong((Object)node.getId());
                CustomProperty property = propCache.getProperty(id);
                if (property != null) {
                    return SimpleTreeNodeUtil.buildNode(node.checkAble(), node.getId(), property.getNumber(), property.getName(), showType);
                }
                CustomPropertyValue propertyValue = propCache.getPropertyValue(IDUtils.toLong((Object)node.getId()));
                if (propertyValue != null) {
                    return SimpleTreeNodeUtil.buildNode(node.checkAble(), node.getId(), propertyValue.getNumber(), propertyValue.getName(), showType);
                }
            }
        }
        return null;
    }

    private static TreeNode buildNode(boolean checkAble, String id, String number, String name, ShowTypeEnum showType) {
        TreeNode treeNode = new TreeNode();
        treeNode.setId(id);
        treeNode.setText(CommonServiceHelper.buildShowText((String)number, (String)name, (ShowTypeEnum)showType));
        treeNode.setCheckable(checkAble);
        treeNode.setDisabled(!checkAble);
        return treeNode;
    }

    public static TreeNode getRootNode() {
        TreeNode rootNode = new TreeNode();
        rootNode.setId(T_RootNodeId);
        rootNode.setText(T_RootNodeTEXT);
        rootNode.setDisabled(true);
        return rootNode;
    }
}

