/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.memberf7.entity;

import com.alibaba.fastjson.annotation.JSONField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public class SimpleTreeNode {
    private String id;
    private Character s;
    private List<SimpleTreeNode> child;

    public SimpleTreeNode() {
    }

    public SimpleTreeNode(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<SimpleTreeNode> getChild() {
        return this.child;
    }

    public void setChild(List<SimpleTreeNode> child) {
        this.child = child;
    }

    public void iterate(Consumer<SimpleTreeNode> callback) {
        callback.accept(this);
        if (this.getChild() != null) {
            for (SimpleTreeNode childNode : this.getChild()) {
                childNode.iterate(callback);
            }
        }
    }

    public boolean iterate(Function<SimpleTreeNode, Boolean> callback) {
        boolean breakIterate = callback.apply(this);
        if (!breakIterate && this.getChild() != null) {
            for (SimpleTreeNode childNode : this.getChild()) {
                childNode.iterate(callback);
            }
        }
        return breakIterate;
    }

    @JSONField(serialize=false, deserialize=false)
    public void setCheckAble(boolean checkAble) {
        this.s = checkAble ? Character.valueOf('1') : null;
    }

    @JSONField(serialize=false, deserialize=false)
    public boolean checkAble() {
        return this.s != null && this.s.charValue() == '1';
    }

    public Character getS() {
        return this.s;
    }

    public void setS(Character s) {
        this.s = s;
    }

    public boolean searchAncestry(SimpleTreeNode node, List<String> nodeIds, String targetNodeId, boolean includeSel) {
        for (SimpleTreeNode childNode : node.getChild()) {
            if (childNode.getId().equals(targetNodeId)) {
                if (includeSel) {
                    nodeIds.add(childNode.getId());
                }
                return true;
            }
            if (childNode.getChild() == null || !this.searchAncestry(childNode, nodeIds, targetNodeId, includeSel)) continue;
            nodeIds.add(childNode.getId());
            return true;
        }
        return false;
    }

    @JSONField(serialize=false, deserialize=false)
    public List<String> getAllAncestry(String targetNodeId, boolean includeSel) {
        ArrayList<String> ancestryIds = new ArrayList<String>(16);
        if (includeSel && this.getId().equals(targetNodeId)) {
            ancestryIds.add(this.getId());
        } else if (!this.getId().equals(targetNodeId) && this.getChild() != null) {
            if (this.searchAncestry(this, ancestryIds, targetNodeId, includeSel)) {
                ancestryIds.add(this.getId());
            }
            Collections.reverse(ancestryIds);
        }
        return ancestryIds;
    }
}

