/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.memberf7.newf7;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.member.f7.F7Constant;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.compress.CompressUtils;
import kd.epm.eb.formplugin.memberf7.newf7.SelectedMember;
import kd.epm.eb.formplugin.memberf7.newf7.face.ISelectedF7Cache;
import org.jetbrains.annotations.NotNull;

public class F7CommonUtils
implements ISelectedF7Cache {
    public static final Log log = LogFactory.getLog(F7CommonUtils.class);
    private static final HashMap<String, String> replaceArgs = new HashMap();

    public static F7CommonUtils get() {
        return new F7CommonUtils();
    }

    public static String getDataType(@NotNull Control control) {
        String controlKey = control.getKey();
        String dataType = "A";
        if ("lefttree".equals(controlKey)) {
            dataType = "A";
        } else if ("treeproperty".equals(controlKey)) {
            dataType = "C";
        } else if ("entryentity".equals(controlKey)) {
            dataType = "B";
        }
        return dataType;
    }

    public static boolean isVar(Map<String, Object> node) {
        if (node == null || node.isEmpty()) {
            return false;
        }
        Long parentId = IDUtils.toLong((Object)node.get("parentid"));
        if (F7Constant.VAR_TYPE_ID.compareTo(parentId) == 0 || F7Constant.MULTI_VAR_ID.compareTo(parentId) == 0 || F7Constant.SINGLE_VAR_ID.compareTo(parentId) == 0) {
            return true;
        }
        String text = (String)node.get("text");
        return StringUtils.isNotEmpty((String)text) && text.charAt(0) == '@';
    }

    public void clearMemberRange(@NotNull IFormView view, @NotNull IDataModel dataModel, @NotNull IPageCache pageCache) {
        LinkedHashMap<String, Map<String, String>> selectData = this.getSelectedIdsFromCache(pageCache);
        this.unClearTreeNode(view, new ArrayList<String>(selectData.keySet()), selectData);
        this.cacheSelectMember(pageCache, null);
        dataModel.deleteEntryData("entryentity");
    }

    public void unClearTreeNode(@NotNull IFormView view, List<String> nodes, Map<String, Map<String, String>> selectData) {
        TreeView propView;
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        ArrayList memberIds = Lists.newArrayListWithExpectedSize((int)nodes.size());
        ArrayList propIds = Lists.newArrayListWithExpectedSize((int)nodes.size());
        for (String nodeId : nodes) {
            Map<String, String> propValues = selectData.get(nodeId);
            if (propValues != null) {
                String type = propValues.get("ty");
                if ("C".equals(type)) {
                    propIds.add(nodeId);
                    continue;
                }
                memberIds.add(nodeId);
                continue;
            }
            memberIds.add(nodeId);
            propIds.add(nodeId);
        }
        TreeView treeView = (TreeView)view.getControl("lefttree");
        if (treeView != null && !memberIds.isEmpty()) {
            treeView.uncheckNodes((List)memberIds);
        }
        if ((propView = (TreeView)view.getControl("treeproperty")) != null && !propIds.isEmpty()) {
            propView.uncheckNodes((List)propIds);
        }
    }

    public void showSelectedSize(@NotNull IFormView view, @NotNull IPageCache pageCache, int selectedSize) {
        String cacheAllSize = pageCache.get("CACHE_TREE_ALL");
        int allSize = StringUtils.isNotEmpty((String)cacheAllSize) ? Integer.parseInt(cacheAllSize) : 0;
        Label labSelected = (Label)view.getControl("selected");
        if (labSelected != null) {
            labSelected.setText(ResManager.loadResFormat((String)"(%1/%2)", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[]{selectedSize, allSize}));
        }
    }

    public void addMember(@NotNull IFormView view, @NotNull IDataModel dataModel, @NotNull IPageCache pageCache, @NotNull Map<Long, Integer> members, @NotNull Long modelId, @NotNull Long dimensionId, Long viewId, @NotNull String controlKey, @NotNull MemberF7Parameter f7Param) {
        SelectedMember member;
        if (members == null || members.isEmpty()) {
            return;
        }
        boolean isLockRange = f7Param.isLockRangeSelect();
        boolean isShowLevel = f7Param.isShowLevel();
        int index = 0;
        ArrayList selMembers = Lists.newArrayListWithExpectedSize((int)members.size());
        LinkedHashMap selectedMembers = Maps.newLinkedHashMapWithExpectedSize((int)members.size());
        IModelCacheHelper modelCacheHelper = f7Param.getModelCacheHelper();
        Dimension dimension = modelCacheHelper.getDimension(dimensionId);
        View _view = dimension.getView(viewId);
        MemberPropCache propCache = f7Param.getPropCache();
        for (Map.Entry<Long, Integer> entry : members.entrySet()) {
            member = _view != null ? SelectedMember.of(entry.getKey(), entry.getValue(), _view, propCache) : SelectedMember.of(entry.getKey(), entry.getValue(), dimension, propCache);
            if (member == null) {
                log.warn("member or propertyValue not find." + JSON.toJSONString(entry));
                continue;
            }
            selMembers.add(member);
        }
        if (!selMembers.isEmpty()) {
            dataModel.beginInit();
            int[] rows = dataModel.batchCreateNewEntryRow(controlKey, selMembers.size());
            Iterator iterator = selMembers.iterator();
            while (iterator.hasNext()) {
                RangeF7PropertyCataEnum typeEnum;
                Integer rangeLevel;
                SelectedMember selMember;
                member = selMember = (SelectedMember)iterator.next();
                int rowIndex = rows[index++];
                dataModel.setValue("memberid", (Object)member.getId(), rowIndex);
                dataModel.setValue("name", (Object)member.getName(), rowIndex);
                if (f7Param.isEb()) {
                    dataModel.setValue("number", (Object)member.getNumber(), rowIndex);
                } else {
                    dataModel.setValue("number", (Object)member.getShowNumber(), rowIndex);
                }
                RangeEnum range = RangeEnum.getRangeByVal((int)member.getScope());
                if (range != null) {
                    if (F7CommonUtils.isFloatSetting(view) && CollectionUtils.isNotEmpty((Collection)f7Param.getCusRange()) && !f7Param.getCusRange().contains(String.valueOf(range.getIndex()))) {
                        dataModel.setValue("scope", (Object)RangeEnum.getRangeByVal((int)range.getIndex()).getName(), rowIndex);
                    } else {
                        dataModel.setValue("scope", (Object)String.valueOf(range.getIndex()), rowIndex);
                    }
                    if (isShowLevel) {
                        view.setEnable(Boolean.valueOf(range == RangeEnum.LEVEL || range == RangeEnum.LEVEL_EXCLUDE), new String[]{"level"});
                    }
                }
                if (isLockRange || "C".equals(member.getType())) {
                    view.setEnable(Boolean.FALSE, rowIndex, new String[]{"scope"});
                }
                if (f7Param.isShowLevel() && f7Param.getRangeLevel() != null && (rangeLevel = (Integer)f7Param.getRangeLevel().get(member.getId())) != null && rangeLevel > 0) {
                    member.setLevel(rangeLevel);
                    dataModel.setValue("level", (Object)member.getLevel(), rowIndex);
                }
                if (f7Param.isShowExclude() && f7Param.getExcludeMemberIds() != null && f7Param.getExcludeMemberIds().contains(member.getId())) {
                    member.setExclude(true);
                    dataModel.setValue("exclude", (Object)Boolean.TRUE, rowIndex);
                }
                if ((typeEnum = RangeF7PropertyCataEnum.of((String)member.getType())) != null) {
                    dataModel.setValue("type", (Object)typeEnum.getIndex(), rowIndex);
                }
                if (!f7Param.isEb()) {
                    dataModel.setValue("interior", (Object)member.getNumber(), rowIndex);
                }
                this.putSelectedMember(selectedMembers, member);
            }
            dataModel.endInit();
            view.updateView(controlKey);
        }
        this.cacheSelectMember(pageCache, selectedMembers);
        ModelCacheContext.remove();
        MemberPropCacheService.remove();
    }

    private static boolean isFloatSetting(IFormView formView) {
        IFormView view = CommonServiceHelper.getParentView((IFormView)formView);
        return "eb_floatsetting".equals(view.getEntityId());
    }

    public static QFilter getSearchFilter(String searchText, boolean isShowShowNumber) {
        if (StringUtils.isEmpty((String)searchText)) {
            return null;
        }
        String _searchText = searchText.trim();
        QFilter searchFilter = F7CommonUtils.getSearchFilter(_searchText = F7CommonUtils.filterIllegality(_searchText), " ", true, isShowShowNumber);
        if (searchFilter == null) {
            searchFilter = F7CommonUtils.getSearchFilter(_searchText, "&", false, isShowShowNumber);
        }
        if (searchFilter == null) {
            searchFilter = isShowShowNumber ? new QFilter("number", "like", (Object)("%" + _searchText + "%")).or("shownumber", "like", (Object)("%" + _searchText + "%")).or("name", "like", (Object)("%" + _searchText + "%")) : new QFilter("number", "like", (Object)("%" + _searchText + "%")).or("name", "like", (Object)("%" + _searchText + "%"));
        }
        return searchFilter;
    }

    public static String filterIllegality(String searchText) {
        if (StringUtils.isEmpty((String)searchText)) {
            return searchText;
        }
        searchText = StringUtils.replace((String)searchText, replaceArgs);
        return searchText;
    }

    private static QFilter getSearchFilter(String searchText, String SEP_MARK, boolean isOr, boolean isShowShowNumber) {
        QFilter searchFilter = null;
        if (searchText.indexOf(SEP_MARK) > 0) {
            String[] tmpStr = searchText.split(SEP_MARK);
            int in = tmpStr.length;
            for (int i = 0; i < in; ++i) {
                String _tmpStr = tmpStr[i].trim();
                QFilter tmpFilter = F7CommonUtils.getSearchFilter(_tmpStr, "&", false, isShowShowNumber);
                if (tmpFilter == null) {
                    tmpFilter = isShowShowNumber ? new QFilter("number", "like", (Object)("%" + _tmpStr + "%")).or("shownumber", "like", (Object)("%" + _tmpStr + "%")).or("name", "like", (Object)("%" + _tmpStr + "%")) : new QFilter("number", "like", (Object)("%" + _tmpStr + "%")).or("name", "like", (Object)("%" + _tmpStr + "%"));
                }
                if (searchFilter == null) {
                    searchFilter = tmpFilter;
                    continue;
                }
                if (isOr) {
                    searchFilter.or(tmpFilter);
                    continue;
                }
                searchFilter.and(tmpFilter);
            }
        }
        return searchFilter;
    }

    public static Map<String, List<String>> getSelectedDataByCurrPage(IPageCache pageCache, BillList billList, boolean isSelected, String memberType) {
        List pageData;
        if (pageCache == null || billList == null) {
            return Collections.emptyMap();
        }
        int[] rows = billList.getEntryState().getSelectedRows();
        if (isSelected && (rows == null || rows.length == 0)) {
            return Collections.emptyMap();
        }
        LinkedHashMap selectedData = Maps.newLinkedHashMap();
        String cacheData = pageCache.get("CACHE_VIRTUAL_PAGE_DATA");
        if (StringUtils.isNotEmpty((String)cacheData) && (pageData = (List)CompressUtils.get().unCompress(cacheData, List.class)) != null) {
            int i;
            HashSet<Integer> rowIndex = new HashSet<Integer>(rows.length);
            int in = rows.length;
            for (i = 0; i < in; ++i) {
                rowIndex.add(rows[i]);
            }
            in = pageData.size();
            for (i = 0; i < in; ++i) {
                Map data = (Map)pageData.get(i);
                String id = IDUtils.toString(data.get("id"));
                String number = (String)data.get("number");
                String name = (String)data.get("name");
                if (isSelected) {
                    if (!rowIndex.contains(i)) continue;
                    selectedData.put(id, CollectionUtils.asList((Object[])new String[]{id, number, name, null, memberType}));
                    continue;
                }
                if (rowIndex.contains(i)) continue;
                selectedData.put(id, CollectionUtils.asList((Object[])new String[]{id, number, name, null, memberType}));
            }
        }
        return selectedData;
    }

    static {
        replaceArgs.put("\u3000", " ");
        replaceArgs.put("\uff06", "&");
        replaceArgs.put("%", "");
        replaceArgs.put("(?i) and ", "");
        replaceArgs.put("(?i) or ", "");
    }
}

