/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.memberf7.newf7;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberParamsUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.controlParamsSetting.EbParamPlugin;

public class MemberParamSetBg029
extends EbParamPlugin
implements BeforeF7SelectListener {
    private static final String CONFIRM_CALLBACK_DIMS = "dimChangeConfirm";
    private boolean showMessage = true;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit dataEdit = (BasedataEdit)this.getControl("selecteddims");
        if (dataEdit != null) {
            dataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        this.beforeF7Select_dims(event);
    }

    protected void beforeF7Select_dims(BeforeF7SelectEvent event) {
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        ArrayList<QFilter> filters = ((BasedataEdit)event.getSource()).getQFilters();
        if (filters == null) {
            filters = new ArrayList<QFilter>();
        }
        DynamicObject model = this.getModelDyn();
        filters.add(new QFilter("model", "=", (Object)this.getModelId()));
        if (model != null) {
            ApplicationTypeEnum typeEnum = ApplicationTypeEnum.getEnumByIndex((String)model.getString("reportType"));
            HashSet<String> hideDims = new HashSet<String>();
            hideDims.add(SysDimensionEnum.Process.getNumber());
            hideDims.add(SysDimensionEnum.Scenario.getNumber());
            if (ApplicationTypeEnum.EB == typeEnum) {
                hideDims.add(SysDimensionEnum.DataType.getNumber());
            } else if (ApplicationTypeEnum.BG == typeEnum) {
                hideDims.add(SysDimensionEnum.InternalCompany.getNumber());
            }
            filters.add(new QFilter("number", "not in", hideDims));
        }
        showParameter.setListFilterParameter(new ListFilterParameter(filters, "dseq"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyKey;
        super.propertyChanged(e);
        switch (propertyKey = e.getProperty().getName()) {
            case "selecteddims": {
                this.propertyChanged_selectedDims(e);
            }
        }
    }

    public void propertyChanged_selectedDims(PropertyChangedArgs e) {
        DynamicObjectCollection values;
        if (e.getChangeSet() == null || e.getChangeSet().length == 0 || e.getChangeSet()[0].getNewValue() == null) {
            return;
        }
        if (this.showMessage && e.getChangeSet()[0].getNewValue() instanceof DynamicObjectCollection && !(values = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue()).isEmpty()) {
            String message = ResManager.loadKDString((String)"\u5982\u679c\u76f8\u5173\u7ef4\u5ea6\u6d89\u53ca\u52301\u4e07\u4ee5\u4e0a\u7684\u660e\u7ec6\u6210\u5458\u663e\u793a\uff0c\u8bbe\u7f6e\u4e3aF7\u5c55\u793a\u660e\u7ec6\u540e\uff0c\u5c06\u5f71\u54cd\u5230F7\u7684\u663e\u793a\u6027\u80fd\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4ecd\u8981\u7ee7\u7eed\u8bbe\u7f6e\uff1f", (String)"MemberParamSetPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(message, MessageBoxOptions.YesNo, new ConfirmCallBackListener(CONFIRM_CALLBACK_DIMS, (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        MessageBoxResult result = event.getResult();
        if (MessageBoxResult.Yes == result) {
            return;
        }
        String callBackId = event.getCallBackId();
        if (CONFIRM_CALLBACK_DIMS.equals(callBackId)) {
            this.getModel().setValue("selecteddims", null);
        }
    }

    private DynamicObject getModelDyn() {
        DynamicObject modelDyn = QueryServiceHelper.queryOne((String)"epm_model", (String)"id,reportType", (QFilter[])new QFilter("id", "=", (Object)this.getModelId()).toArray());
        return modelDyn;
    }

    protected void afterSave() {
        Long modelId = this.getModelId();
        if (IDUtils.isNotNull((Long)modelId)) {
            MemberParamsUtils.clearF7ParamsByCache((long)modelId);
        }
    }
}

