/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.memberf7.newf7;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberParamsUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.controlParamsSetting.EbParamPlugin;

public class MemberParamSetBg030
extends EbParamPlugin {
    @Override
    public void afterCreateNewData(EventObject e) {
        this.setLongNameNumDisplayEnable();
        super.afterCreateNewData(e);
    }

    private void setLongNameNumDisplayEnable() {
        Long modelId = this.getModelId();
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        if (modelCacheHelper.getModelobj() == null) {
            return;
        }
        if (modelCacheHelper.getModelobj().isModelByEB()) {
            this.getModel().setValue("longnamenumdisplay", null);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"longnamenumdisplay"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"longnamenumdisplay"});
            this.initLongNameNumDisplayCombo();
        }
    }

    private void initLongNameNumDisplayCombo() {
        Long modelId = this.getModelId();
        if (IDUtils.isNotEmptyLong((Long)modelId).booleanValue()) {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            List dimensionList = modelCacheHelper.getDimensionList();
            HashSet defaultDimNumSet = Sets.newHashSet((Object[])new String[]{SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Account.getNumber()});
            List userDefinedDimNums = dimensionList.stream().filter(d -> defaultDimNumSet.contains(d.getNumber()) || !d.isPreset()).collect(Collectors.toList());
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
            ComboItem item = null;
            for (Dimension userDefinedDimNum : userDefinedDimNums) {
                item = new ComboItem(new LocaleString(userDefinedDimNum.getName()), userDefinedDimNum.getNumber());
                items.add(item);
            }
            ComboEdit control = (ComboEdit)this.getControl("longnamenumdisplay");
            control.setComboItems(items);
        }
    }

    protected void afterSave() {
        Long modelId = this.getModelId();
        if (IDUtils.isNotNull((Long)modelId)) {
            MemberParamsUtils.clearLongNameNumDisplayParamsByCache((long)modelId);
        }
    }
}

