/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.memberf7.newf7;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.memberf7.newf7.F7CommonUtils;
import kd.epm.eb.formplugin.memberf7.newf7.base.AbstractRangeF7;
import kd.epm.eb.formplugin.memberf7.newf7.face.IF7Base;
import kd.epm.eb.formplugin.memberf7.newf7.face.IMemberF7Parameter;
import kd.epm.eb.formplugin.memberf7.newf7.face.ISelectedF7Cache;
import kd.epm.eb.formplugin.memberf7.newf7.face.ITreeCache;
import org.jetbrains.annotations.NotNull;

public class MemberRangeF7
extends AbstractRangeF7
implements IMemberF7Parameter,
ITreeCache,
IF7Base,
ISelectedF7Cache {
    private MemberF7Parameter f7Parameter = null;
    private IModelCacheHelper modelCacheHelper = null;

    protected MemberF7Parameter getF7Parameter() {
        String version;
        if (this.f7Parameter != null && (version = this.getF7ParamVersion(this.getPageCache())) != null && Long.valueOf(version).compareTo(this.f7Parameter.getVersion()) != 0) {
            this.f7Parameter = null;
        }
        if (this.f7Parameter == null) {
            this.f7Parameter = this.getF7FromCache(this.getPageCache());
            if (this.f7Parameter == null) {
                this.f7Parameter = new MemberF7Parameter();
            }
            this.f7Parameter.check();
            this.f7Parameter.loadData();
        }
        return this.f7Parameter;
    }

    @Override
    public IModelCacheHelper getModelCache(@NotNull Long modelId, boolean reBuilder) {
        if (this.modelCacheHelper == null || reBuilder) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        }
        return this.modelCacheHelper;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.f7Parameter = this.loadF7Parameter(this.getView(), this.getPageCache());
        Label caption = (Label)this.getControl("caption");
        if (caption != null && this.f7Parameter != null) {
            caption.setText(ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u6210\u5458", (String)"MemberListF7_3", (String)"epm-eb-formplugin", (Object[])new Object[]{this.f7Parameter.getDimensionName()}));
        }
    }

    @Override
    protected void initUI(EventObject e) {
        MemberF7Parameter f7Param = this.getF7Parameter();
        ComboEdit rangeEdit = (ComboEdit)this.getControl("scope");
        rangeEdit.setComboItems(f7Param.getRangeItems());
        this.getView().setVisible(Boolean.valueOf(f7Param.isShowLevel()), new String[]{"level"});
        this.getView().setVisible(Boolean.valueOf(f7Param.isShowExclude()), new String[]{"exclude"});
        if (f7Param.isEb()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"interior"});
        }
    }

    @Override
    protected void showUI() {
    }

    @Override
    protected void initData() {
        MemberF7Parameter f7Param = this.getF7Parameter();
        if (f7Param != null && CollectionUtils.isNotEmpty((Collection)f7Param.getSelectIds())) {
            F7CommonUtils.get().addMember(this.getView(), this.getModel(), this.getPageCache(), f7Param.getSelectedData(), f7Param.getModelId(), f7Param.getDimensionId(), f7Param.getViewId(), "entryentity", f7Param);
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
        MemberF7Parameter f7Param = this.getF7Parameter();
        boolean isLockRange = f7Param.isLockRangeSelect();
        boolean isShowLevel = f7Param.isShowLevel();
        if ((isLockRange || isShowLevel) && e.getRows() != null) {
            for (RowDataEntity entity : e.getRows()) {
                RangeEnum range;
                String scope;
                int rowIndex = entity.getRowIndex();
                DynamicObject selected = entity.getDataEntity();
                if (selected == null) continue;
                boolean lockScope = false;
                boolean lockLevel = false;
                if (isLockRange || RangeF7PropertyCataEnum.Property.getIndex().equals(selected.get("type"))) {
                    lockScope = true;
                }
                if (isShowLevel && (scope = (String)selected.get("scope")) != null && RangeEnum.LEVEL != (range = RangeEnum.getRangeByVal((String)scope)) && RangeEnum.LEVEL_EXCLUDE != range) {
                    lockLevel = true;
                }
                if (lockScope && lockLevel) {
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"scope", "level"});
                    continue;
                }
                if (lockScope) {
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"scope"});
                    continue;
                }
                if (!lockLevel) continue;
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"level"});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate) {
            AbstractOperate operate = (AbstractOperate)args.getSource();
            switch (operate.getOperateKey()) {
                case "donothing": {
                    this.beforeDoOperation_delete(args);
                }
            }
        }
    }

    private void beforeDoOperation_delete(BeforeDoOperationEventArgs args) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        if (entryGrid != null) {
            TreeView treeView;
            int rowIndex = entryGrid.getEntryState().getFocusRow();
            DynamicObject selMember = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            if (selMember != null && (treeView = (TreeView)this.getControl("lefttree")) != null) {
                String nodeId = selMember.getString("memberid");
                treeView.uncheckNode(nodeId);
                treeView.treeNodeCheck("", nodeId, Boolean.FALSE);
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propertyKey;
        super.propertyChanged(e);
        switch (propertyKey = e.getProperty().getName()) {
            case "scope": {
                this.propertyChanged_scope(e);
                break;
            }
            case "level": {
                this.propertyChanged_level(e);
                break;
            }
            case "exclude": {
                this.propertyChanged_exclude(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void propertyChanged_scope(PropertyChangedArgs e) {
        ChangeData[] changeDatas = e.getChangeSet();
        if (changeDatas == null || changeDatas.length == 0) {
            return;
        }
        MemberRangeF7 memberRangeF7 = this;
        synchronized (memberRangeF7) {
            LinkedHashMap selectedMembers = this.getSelectedIdsFromCache(this.getPageCache());
            for (ChangeData changeData : changeDatas) {
                DynamicObject member = changeData.getDataEntity();
                Map memberData = (Map)selectedMembers.get(member.getString("memberid"));
                if (memberData == null) continue;
                String scopeIndex = (String)changeData.getNewValue();
                memberData.put("sc", scopeIndex);
                if (!StringUtils.isNotEmpty((String)scopeIndex)) continue;
                Integer _rangeLevel = null;
                RangeEnum _range = RangeEnum.getRangeByVal((String)scopeIndex);
                if (RangeEnum.LEVEL == _range || RangeEnum.LEVEL_EXCLUDE == _range) {
                    this.getView().setEnable(Boolean.TRUE, changeData.getRowIndex(), new String[]{"level"});
                    _rangeLevel = 1;
                } else {
                    this.getView().setEnable(Boolean.FALSE, changeData.getRowIndex(), new String[]{"level"});
                }
                this.getModel().setValue("level", (Object)_rangeLevel, changeData.getRowIndex());
                memberData.put("le", _rangeLevel != null ? String.valueOf(_rangeLevel) : "0");
            }
            this.cacheSelectMember(this.getPageCache(), selectedMembers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void propertyChanged_level(PropertyChangedArgs e) {
        ChangeData[] changeDatas = e.getChangeSet();
        if (changeDatas == null || changeDatas.length == 0) {
            return;
        }
        MemberRangeF7 memberRangeF7 = this;
        synchronized (memberRangeF7) {
            LinkedHashMap selectedMembers = this.getSelectedIdsFromCache(this.getPageCache());
            for (ChangeData changeData : changeDatas) {
                DynamicObject member = changeData.getDataEntity();
                Map memberData = (Map)selectedMembers.get(member.getString("memberid"));
                if (memberData == null) continue;
                String scopeIndex = (String)changeData.getNewValue();
                memberData.put("le", scopeIndex);
            }
            this.cacheSelectMember(this.getPageCache(), selectedMembers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void propertyChanged_exclude(PropertyChangedArgs e) {
        ChangeData[] changeDatas = e.getChangeSet();
        if (changeDatas == null || changeDatas.length == 0) {
            return;
        }
        MemberRangeF7 memberRangeF7 = this;
        synchronized (memberRangeF7) {
            LinkedHashMap selectedMembers = this.getSelectedIdsFromCache(this.getPageCache());
            for (ChangeData changeData : changeDatas) {
                DynamicObject member = changeData.getDataEntity();
                Map memberData = (Map)selectedMembers.get(member.getString("memberid"));
                if (memberData == null) continue;
                Boolean exclude = (Boolean)changeData.getNewValue();
                memberData.put("ex", exclude != false ? "1" : "0");
            }
            this.cacheSelectMember(this.getPageCache(), selectedMembers);
        }
    }

    @Override
    protected void click_moveUp(EventObject evt) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        if (entryGrid != null) {
            int[] rows = entryGrid.getSelectRows();
            if (rows == null || rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u6210\u5458\u3002", (String)"MemberRangeF7_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                Arrays.stream(rows).forEach(rowIndex -> {
                    if (rowIndex == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u5904\u4e8e\u7b2c\u4e00\u884c\uff0c\u65e0\u6cd5\u7ee7\u7eed\u4e0a\u79fb\u3002", (String)"MultipleMemberF7BasePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                });
                this.getModel().moveEntryRowsUp("entryentity", rows);
            }
        }
    }

    @Override
    protected void click_moveDown(EventObject evt) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        if (entryGrid != null) {
            int[] rows = entryGrid.getSelectRows();
            if (rows == null || rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u6210\u5458\u3002", (String)"MemberRangeF7_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                int count = this.getModel().getEntryRowCount("entryentity");
                Arrays.stream(rows).forEach(rowIndex -> {
                    if (rowIndex == count - 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u5904\u4e8e\u6700\u540e\u4e00\u884c\uff0c\u65e0\u6cd5\u7ee7\u7eed\u4e0b\u79fb\u3002", (String)"MultipleMemberF7BasePlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                });
                this.getModel().moveEntryRowsDown("entryentity", rows);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void click_remove(EventObject evt) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        if (entryGrid != null) {
            int[] rows = entryGrid.getSelectRows();
            if (rows == null || rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u6210\u5458\u3002", (String)"MemberRangeF7_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                HashSet<String> unCheckedIds = new HashSet<String>(rows.length);
                for (int row : rows) {
                    DynamicObject member = this.getModel().getEntryRowEntity("entryentity", row);
                    if (member == null) continue;
                    unCheckedIds.add(member.getString("memberid"));
                }
                MemberRangeF7 memberRangeF7 = this;
                synchronized (memberRangeF7) {
                    LinkedHashMap selectData = this.getSelectedIdsFromCache(this.getPageCache());
                    F7CommonUtils.get().unClearTreeNode(this.getView(), new ArrayList<String>(unCheckedIds), selectData);
                    this.getModel().deleteEntryRows("entryentity", rows);
                    unCheckedIds.forEach(selectData::remove);
                    this.cacheSelectMember(this.getPageCache(), selectData);
                }
                MemberF7Parameter memberF7Parameter = this.getF7Parameter();
                List selectIds = memberF7Parameter.getSelectIds();
                if (selectIds != null) {
                    HashSet<String> removes = new HashSet<String>(selectIds.size());
                    block4: for (String selectId : selectIds) {
                        for (String unCheckedId : unCheckedIds) {
                            if (!selectId.startsWith(unCheckedId + '@')) continue;
                            removes.add(selectId);
                            continue block4;
                        }
                    }
                    if (!removes.isEmpty()) {
                        selectIds.removeAll(removes);
                        this.cacheF7Parameter(this.getPageCache(), memberF7Parameter);
                    }
                }
            }
        }
    }

    @Override
    protected void click_clearSelected(EventObject evt) {
        MemberF7Parameter f7Param = this.getF7Parameter();
        f7Param.setSelectIds(new ArrayList());
        this.cacheF7Parameter(this.getPageCache(), f7Param);
        F7CommonUtils utils = F7CommonUtils.get();
        utils.clearMemberRange(this.getView(), this.getModel(), this.getPageCache());
    }

    @Override
    protected void click_submit(EventObject evt) {
        MemberF7Parameter f7Param = this.getF7Parameter();
        Map<String, Map<String, String>> selectData = this.getSelectedData();
        this.returnSelectedData(this.getView(), f7Param, selectData, this.getDataParams());
    }

    protected Map<String, Map<String, String>> getSelectedData() {
        LinkedHashMap cacheSelected = this.getSelectedIdsFromCache(this.getPageCache());
        LinkedHashMap selectDatas = Maps.newLinkedHashMapWithExpectedSize((int)cacheSelected.size());
        DynamicObjectCollection selectedObj = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject selected : selectedObj) {
            String memberId = selected.getString("memberid");
            Map selectData = (Map)cacheSelected.get(memberId);
            if (selectData == null) continue;
            selectDatas.put(memberId, selectData);
        }
        return selectDatas;
    }

    protected Map<String, Object> getDataParams() {
        Object parent;
        Object isAddNew;
        Object isFloat;
        HashMap dataParams = Maps.newHashMap();
        IDataEntityProperty property = this.getModel().getProperty("chkfloat");
        if (property != null && (isFloat = this.getModel().getValue("chkfloat")) instanceof Boolean) {
            dataParams.put("chkfloat", isFloat);
        }
        if ((property = this.getModel().getProperty("chkaddnew")) != null && (isAddNew = this.getModel().getValue("chkaddnew")) instanceof Boolean) {
            dataParams.put("chkaddnew", isAddNew);
        }
        if ((property = this.getModel().getProperty("parent")) != null && (parent = this.getModel().getValue("parent")) instanceof DynamicObject) {
            dataParams.put("parent", parent);
        }
        return dataParams;
    }

    @Override
    protected void click_cancel(EventObject evt) {
        this.getView().returnDataToParent(null);
        this.getView().close();
    }

    @Override
    public void search(SearchEnterEvent evt) {
        super.search(evt);
        String searchTxt = evt.getText();
        if (StringUtils.isNotEmpty((String)searchTxt)) {
            this.searchList(searchTxt, true);
        }
    }

    protected void searchList(@NotNull String searchTxt, boolean isDown) {
        DynamicObjectCollection selMembers = this.getModel().getEntryEntity("entryentity");
        ArrayList<Integer> selectRows = new ArrayList<Integer>();
        if (selMembers != null && !selMembers.isEmpty()) {
            DynamicObject selMember;
            int rowIndex;
            int selRowIndex = -1;
            String _selRowIndex = this.getPageCache().get("CACHE_LIST_ROW_INDEX");
            if (StringUtils.isNotEmpty((String)_selRowIndex)) {
                try {
                    selRowIndex = Integer.parseInt(_selRowIndex);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (isDown) {
                int in = selMembers.size();
                for (int i = rowIndex = selRowIndex != -1 ? selRowIndex + 1 : 0; i < in; ++i) {
                    selMember = (DynamicObject)selMembers.get(i);
                    if (selMember == null || !this.equalsSearchText(selMember, searchTxt)) continue;
                    this.getPageCache().put("CACHE_LIST_ROW_INDEX", String.valueOf(i));
                    selectRows.add(i);
                    break;
                }
            } else {
                for (int i = rowIndex = selRowIndex != -1 ? selRowIndex - 1 : selMembers.size() - 1; i >= 0; --i) {
                    selMember = (DynamicObject)selMembers.get(i);
                    if (selMember == null || !this.equalsSearchText(selMember, searchTxt)) continue;
                    this.getPageCache().put("CACHE_LIST_ROW_INDEX", String.valueOf(i));
                    selectRows.add(i);
                    break;
                }
            }
        }
        if (selectRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u9879", (String)"MemberSingleTreeF7_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
        } else {
            EntryGrid entry = (EntryGrid)this.getControl("entryentity");
            if (entry != null) {
                int[] rows = selectRows.stream().mapToInt(x -> x).toArray();
                entry.selectRows(rows, 0);
            }
        }
    }

    private boolean equalsSearchText(@NotNull DynamicObject member, @NotNull String searchTxt) {
        String name = member.getString("name");
        String number = member.getString("number");
        String _searchTxt = searchTxt.toLowerCase();
        return StringUtils.isNotEmpty((String)name) && name.contains(searchTxt) || StringUtils.isNotEmpty((String)number) && number.toLowerCase().contains(_searchTxt);
    }

    @Override
    protected void click_searchUp(EventObject evt) {
        Search search = (Search)this.getControl("searchlist");
        if (search != null && StringUtils.isNotEmpty((String)search.getSearchKey())) {
            this.searchList(search.getSearchKey(), false);
        }
    }

    @Override
    protected void click_searchDown(EventObject evt) {
        Search search = (Search)this.getControl("searchlist");
        if (search != null && StringUtils.isNotEmpty((String)search.getSearchKey())) {
            this.searchList(search.getSearchKey(), true);
        }
    }

    @Override
    public void entryRowClick(RowClickEvent evt) {
        this.getPageCache().put("CACHE_LIST_ROW_INDEX", String.valueOf(evt.getRow()));
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent event) {
        super.hyperLinkClick(event);
        DynamicObject object = this.getModel().getEntryRowEntity("entryentity", event.getRowIndex());
        if (object != null) {
            RangeF7PropertyCataEnum cataEnum = RangeF7PropertyCataEnum.ofIndex((String)object.getString("type"));
            if (RangeF7PropertyCataEnum.Property == cataEnum) {
                Long propValueId = object.getLong("memberid");
                MemberF7Parameter f7Param = this.getF7Parameter();
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("eb_customproperty_member");
                HashMap<String, Object> customMap = new HashMap<String, Object>(4);
                customMap.put("model", f7Param.getModelId());
                customMap.put("propertyValueId", propValueId);
                customMap.put("dimId", f7Param.getDimensionId());
                customMap.put("dimNumber", f7Param.getDimensionNumber());
                customMap.put("needCheckPerm", f7Param.isVerifyPermission());
                customMap.put("bizModel", String.valueOf(f7Param.getBusModelId()));
                customMap.put("datasetIds", f7Param.getDatasetIds());
                customMap.put("viewId", String.valueOf(f7Param.getViewId()));
                formShowParameter.setCustomParams(customMap);
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(formShowParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5c5e\u6027\u652f\u6301\u67e5\u770b\u8be6\u60c5\u3002", (String)"MultiMemberRangeF7Plugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

