/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.memberf7.newf7;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.F7SelectedList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.tree.MemberTreeBuilder;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.ShowTypeEnum;
import kd.epm.eb.common.member.f7.F7Constant;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.viewgroup.ViewGroupServiceHelper;
import kd.epm.eb.formplugin.memberf7.newf7.F7CommonUtils;
import kd.epm.eb.formplugin.memberf7.newf7.base.AbstractTreeF7;
import kd.epm.eb.formplugin.memberf7.newf7.face.IF7Base;
import kd.epm.eb.formplugin.memberf7.newf7.face.IMemberF7Parameter;
import kd.epm.eb.formplugin.memberf7.newf7.face.ISelectedF7Cache;
import kd.epm.eb.formplugin.memberf7.newf7.face.ITreeCache;
import org.jetbrains.annotations.NotNull;

public class MemberTreeF7
extends AbstractTreeF7
implements IMemberF7Parameter,
ITreeCache,
IF7Base,
ISelectedF7Cache {
    private MemberF7Parameter f7Parameter = null;
    private IModelCacheHelper modelCacheHelper = null;

    protected MemberF7Parameter getF7Parameter() {
        String version;
        if (this.f7Parameter != null && (version = this.getF7ParamVersion(this.getPageCache())) != null && Long.valueOf(version).compareTo(this.f7Parameter.getVersion()) != 0) {
            this.f7Parameter = null;
        }
        if (this.f7Parameter == null) {
            this.f7Parameter = this.loadF7Parameter(this.getView(), this.getPageCache());
        }
        return this.f7Parameter;
    }

    @Override
    public IModelCacheHelper getModelCache(@NotNull Long modelId, boolean reBuilder) {
        if (this.modelCacheHelper == null || reBuilder) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        }
        return this.modelCacheHelper;
    }

    @Override
    public void initialize() {
        TreeView treeView;
        super.initialize();
        MemberF7Parameter _f7Param = this.getF7Parameter();
        if (_f7Param != null && _f7Param.stepLoad() && (treeView = (TreeView)this.getControl("lefttree")) != null) {
            MemberTreeBuilder.registerQueryListener((TreeView)treeView, (TreeNodeQueryListener)this);
        }
    }

    @Override
    protected void init_base() {
        MemberF7Parameter _f7Param = this.getF7Parameter();
        Control checkBox = this.getControl("cbshowdisable");
        if (checkBox != null) {
            this.getModel().setValue("cbshowdisable", (Object)_f7Param.isShowDisable());
        }
    }

    @Override
    protected void init_view() {
        MemberF7Parameter _f7Param = this.getF7Parameter();
        if (IDUtils.isNotNull((Long)_f7Param.getViewId())) {
            this.getModel().setValue("view", (Object)_f7Param.getViewId());
        }
    }

    @Override
    protected void init_leftTree(MemberF7Parameter f7Param) {
        if (f7Param == null) {
            f7Param = this.getF7Parameter();
        }
        MemberTreeBuilder.get((MemberF7Parameter)f7Param).buildTree((TreeView)this.getControl("lefttree"), this.getPageCache());
    }

    @Override
    protected void initUI() {
        MemberF7Parameter _f7Param = this.getF7Parameter();
        String dimensionNumber = _f7Param.getDimensionNumber();
        IModelCacheHelper modelCache = this.getModelCache(_f7Param.getModelId());
        Dimension dimension = modelCache.getDimension(dimensionNumber);
        this.getView().setEnable(Boolean.valueOf(_f7Param.isEnableView()), F7Constant.F7_VIEW_SHOW);
        boolean isShowView = !View.NoViewDimNums.contains(dimensionNumber) && !modelCache.getModelobj().isModelByEB();
        this.getView().setVisible(Boolean.valueOf(isShowView), F7Constant.F7_VIEW_SHOW);
        boolean isShowDisableVisible = _f7Param.isShowDisableVisible() && (Dimension.DISABLE_DIMS.contains(dimensionNumber) || dimension != null && !dimension.isPreset());
        this.getView().setEnable(Boolean.valueOf(isShowDisableVisible), new String[]{"cbshowdisable"});
        this.getView().setVisible(Boolean.valueOf(isShowDisableVisible), new String[]{"cbshowdisable"});
        this.getView().setVisible(Boolean.valueOf(_f7Param.isForDisable()), new String[]{"btn_disable"});
        this.getView().setEnable(Boolean.valueOf(_f7Param.isForDisable()), new String[]{"btn_disable"});
        this.getView().setVisible(Boolean.valueOf(_f7Param.isForEnable()), new String[]{"btn_enable"});
        this.getView().setEnable(Boolean.valueOf(_f7Param.isForEnable()), new String[]{"btn_enable"});
        if (_f7Param.isForDisable() || _f7Param.isForEnable()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_sure"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_sure"});
        }
    }

    @Override
    protected void beforeF7Select_view(BeforeF7SelectEvent evt) {
        MemberF7Parameter _f7Param = this.getF7Parameter();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        ArrayList<QFilter> filters = ((BasedataEdit)evt.getSource()).getQFilters();
        if (filters == null) {
            filters = new ArrayList<QFilter>();
        }
        filters.add(new QFilter("model", "=", (Object)_f7Param.getModelId()));
        filters.add(new QFilter("dimension", "=", (Object)_f7Param.getDimensionId()));
        if (IDUtils.isNotNull((Long)_f7Param.getViewGroupId())) {
            filters.add(new QFilter("id", "in", (Object)ViewGroupServiceHelper.getInstance().getAllViewByGroupId(Collections.singletonList(_f7Param.getViewGroupId()))));
        }
        if (CollectionUtils.isNotEmpty((Collection)_f7Param.getViewIds())) {
            filters.add(new QFilter("id", "in", (Object)_f7Param.getViewIds()));
        }
        showParameter.setListFilterParameter(new ListFilterParameter(filters, "createdate"));
    }

    @Override
    protected void propertyChanged_view(PropertyChangedArgs evt) {
        if (evt.getChangeSet() == null || evt.getChangeSet().length == 0) {
            return;
        }
        ChangeData changeData = evt.getChangeSet()[0];
        if (changeData.getNewValue() == null && changeData.getOldValue() != null) {
            this.getModel().getDataEntity().set("view", changeData.getOldValue());
            this.getView().updateView("view");
            return;
        }
        MemberF7Parameter _f7Param = this.getF7Parameter();
        if (evt.getChangeSet()[0].getNewValue() instanceof DynamicObject) {
            DynamicObject _view = (DynamicObject)evt.getChangeSet()[0].getNewValue();
            if (IDUtils.isNull((Long)_f7Param.getViewId()) || !_f7Param.getViewId().equals(_view.getLong("id"))) {
                _f7Param.setViewId(Long.valueOf(_view.getLong("id")));
                _f7Param.setView(_f7Param.queryView(_f7Param.getViewId()));
                _f7Param.setSelectIds((Set)null);
                this.cacheF7Parameter(this.getPageCache(), _f7Param);
                this.cacheParentView(_f7Param, _f7Param.getViewId());
                this.clearSelected();
                this.init_leftTree(_f7Param);
                this.sendTreeNodeClick();
            }
        }
    }

    protected void clearSelected() {
        this.cacheSelectMember(this.getPageCache(), null);
        this.getPageCache().remove("NODE_MEMBER_CACHE_SELECT");
        this.getPageCache().remove("NODE_MEMBER_CACHE_SELECT_DT");
        this.getPageCache().remove("TREE_CACHE_SEARCH");
        MemberF7Parameter _f7Param = this.getF7Parameter();
        if (_f7Param.isView()) {
            BillList viewList = (BillList)this.getControl("billlistap");
            if (viewList != null) {
                viewList.clearSelection();
            }
        } else {
            BillList baseList = (BillList)this.getControl("basemembers");
            if (baseList != null) {
                baseList.clearSelection();
            }
        }
        F7SelectedList selectedList = (F7SelectedList)this.getControl("rightselect");
        if (selectedList != null) {
            selectedList.removeAllItems();
        }
    }

    protected void cacheParentView(MemberF7Parameter f7Param, Long viewId) {
        if (f7Param == null || IDUtils.isNotNull((Long)viewId)) {
            return;
        }
        if (StringUtils.isNotEmpty((String)f7Param.getViewSign())) {
            this.getParentCache().put(f7Param.getViewSign() + "viewId", IDUtils.toString((Object)viewId));
        }
    }

    protected IPageCache getParentCache() {
        return (IPageCache)CommonServiceHelper.getParentView((IFormView)this.getView()).getService(IPageCache.class);
    }

    @Override
    protected void propertyChanged_showDisable(PropertyChangedArgs evt) {
        MemberF7Parameter f7Param = this.getF7Parameter();
        Boolean showDisable = (Boolean)this.getModel().getValue("cbshowdisable");
        f7Param.setShowDisable(showDisable.booleanValue());
        this.cacheF7Parameter(this.getPageCache(), f7Param);
        LinkedHashMap selectedIdsFromCache = this.getSelectedIdsFromCache(this.getPageCache());
        Set selectIds = selectedIdsFromCache.keySet().stream().map(Long::parseLong).collect(Collectors.toSet());
        MemberTreeBuilder.get((MemberF7Parameter)f7Param).buildTree((TreeView)this.getControl("lefttree"), this.getPageCache(), selectIds);
        this.sendTreeNodeClick();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void propertyChanged_comboShowType(PropertyChangedArgs evt) {
        ChangeData[] changeData = evt.getChangeSet();
        if (changeData == null || changeData.length == 0) {
            return;
        }
        MemberF7Parameter f7Param = this.getF7Parameter();
        f7Param.setShowType(ShowTypeEnum.getShowTypeByValue((String)((String)changeData[0].getNewValue())));
        LogStats stats = new LogStats("budget-log : ");
        stats.addInfo("begin-showType.");
        try {
            this.showTree(f7Param);
        }
        finally {
            this.cacheF7Parameter(this.getPageCache(), f7Param);
            stats.addInfo("end-showType.");
            log.info(stats.toString());
        }
    }

    protected void showTree(@NotNull MemberF7Parameter f7Param) {
        TreeView view = (TreeView)this.getControl("lefttree");
        MemberTreeBuilder.get((MemberF7Parameter)f7Param).buildTree(view, this.getPageCache());
    }

    @Override
    protected void click_TreeSearchUp(EventObject evt) {
        Search search = (Search)this.getControl("treesearch");
        if (search != null && StringUtils.isNotEmpty((String)search.getSearchKey())) {
            this.searchTree(search.getSearchKey(), false);
        }
    }

    @Override
    protected void click_TreeSearchDown(EventObject evt) {
        Search search = (Search)this.getControl("treesearch");
        if (search != null && StringUtils.isNotEmpty((String)search.getSearchKey())) {
            this.searchTree(search.getSearchKey(), true);
        }
    }

    protected void sendTreeNodeClick() {
        TreeView treeView = (TreeView)this.getControl("lefttree");
        if (treeView == null) {
            return;
        }
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        if (focusNodeId == null) {
            return;
        }
        treeView.treeNodeClick(null, focusNodeId);
    }

    @Override
    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        String nodeId = (String)evt.getNodeId();
        if (StringUtils.isNotEmpty((String)nodeId)) {
            Member curr = null;
            DynamicObject _do = BusinessDataServiceHelper.loadSingleFromCache((Object)IDUtils.toLong((Object)nodeId), (String)this.getF7Parameter().entityNumber(), (String)"id, name, number, longnumber");
            if (_do != null) {
                curr = new Member(Long.valueOf(_do.getLong("id")), _do.getString("name"), _do.getString("number"));
                curr.setLongNumber(_do.getString("longnumber"));
            } else {
                DynamicObject var = BusinessDataServiceHelper.loadSingleFromCache((Object)IDUtils.toLong((Object)nodeId), (String)"eb_periodvariable", (String)"id, name, number");
                if (var != null) {
                    curr = new Member(Long.valueOf(var.getLong("id")), var.getString("name"), var.getString("number"));
                    curr.setLongNumber(var.getString("number"));
                }
            }
            this.cacheSearchTree(this.getPageCache(), curr);
        }
    }

    @Override
    protected void treeNode_stepLoad(TreeNodeEvent evt) {
        TreeView treeView = (TreeView)evt.getSource();
        String nodeId = (String)evt.getNodeId();
        try {
            if (nodeId != null) {
                this.treeStepLoad(treeView, nodeId);
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    protected void treeStepLoad(@NotNull TreeView treeView, @NotNull String nodeId) throws Exception {
        if ("lefttree".equals(treeView.getKey())) {
            MemberTreeBuilder.get((MemberF7Parameter)this.getF7Parameter()).stepLoadTree(treeView, Collections.singletonList(nodeId), "CACHE_F7_TREE_MEMBER_NODE_DATA", null, null, this.getPageCache());
        }
    }

    @Override
    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        super.treeNodeCheck(evt);
        String cacheSelected = this.getPageCache().get("CACHE_TREE_SELECTED");
        int selected = StringUtils.isNotEmpty((String)cacheSelected) ? Integer.parseInt(cacheSelected) : 0;
        selected = evt.getChecked() != false ? selected + 1 : selected - 1;
        this.getPageCache().put("CACHE_TREE_SELECTED", String.valueOf(selected));
        F7CommonUtils.get().showSelectedSize(this.getView(), this.getPageCache(), selected);
    }

    @Override
    protected void searchTree(Search search, String searchText) {
        this.searchTree(searchText, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchTree(String searchText, boolean hasDown) {
        LogStats stats = new LogStats("budget-log : ");
        stats.addInfo("begin-searchTree");
        MemberF7Parameter _f7Param = this.getF7Parameter();
        try {
            Member next;
            SearchQuery query = this.getSearchFilter(searchText, hasDown, _f7Param, stats);
            stats.addInfo(query.toString());
            Member currMember = query.currMember;
            if (currMember != null && this.hasVarType(currMember.getId())) {
                next = this.searchVar(_f7Param, query);
                if (next == null && !hasDown) {
                    query.currMember = null;
                    query.direction = null;
                    next = this.searchMember(_f7Param, query);
                }
            } else {
                next = this.searchMember(_f7Param, query);
                if (next == null) {
                    query.currMember = null;
                    query.direction = null;
                    next = this.searchVar(_f7Param, query);
                    if (next == null) {
                        next = this.searchMember(_f7Param, query);
                    }
                }
            }
            if (next == null && hasDown) {
                query.currMember = null;
                query.direction = null;
                next = this.searchMember(_f7Param, query);
                if (next == null) {
                    next = this.searchVar(_f7Param, query);
                }
            }
            if (next == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u9879", (String)"MemberSingleTreeF7_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
                return;
            }
            this.cacheSearchTree(this.getPageCache(), next);
            stats.addInfo(JSON.toJSONString((Object)next));
            String[] parents = next.getLongNumber().split("!");
            ArrayList<String> _parents = new ArrayList<String>(parents.length);
            int in = parents.length - 1;
            for (int i = 0; i < in; ++i) {
                _parents.add(parents[i]);
            }
            ArrayList expandIds = Lists.newArrayListWithExpectedSize((int)_parents.size());
            if (this.hasVarType(next.getId())) {
                expandIds.add(next.getId().toString());
            } else {
                QFBuilder builder = new QFBuilder();
                builder.add(_f7Param.filters().toList());
                builder.add("number", "in", _parents);
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)"searchTree", (String)_f7Param.entityNumber(), (String)query.fields, (QFilter[])builder.toArray(), (String)"longnumber");){
                    if (ds != null) {
                        for (Row row : ds) {
                            expandIds.add(row.getString("id"));
                        }
                    }
                }
            }
            TreeView treeView = (TreeView)this.getControl("lefttree");
            MemberTreeBuilder.get((MemberF7Parameter)_f7Param, (LogStats)stats).stepLoadTree(treeView, (List)expandIds, "CACHE_F7_TREE_MEMBER_NODE_DATA", next.getId().toString(), null, this.getPageCache());
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
        }
        finally {
            stats.addInfo("end-searchTree");
            log.info(stats.toString());
        }
    }

    protected Member searchMember(@NotNull MemberF7Parameter f7Param, @NotNull SearchQuery query) {
        Member next = null;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(query.filters);
        if (query.direction != null) {
            filters.add(query.direction);
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"searchTree", (String)f7Param.entityNumber(), (String)query.fields, (QFilter[])filters.toArray(new QFilter[0]), (String)query.orderBy, (int)1);){
            if (ds != null && ds.hasNext()) {
                Row row = ds.next();
                next = new Member(row.getLong("id"), row.getString("name"), row.getString("number"));
                next.setLongNumber(row.getString("longnumber"));
            }
        }
        return next;
    }

    protected Member searchVar(@NotNull MemberF7Parameter f7Param, @NotNull SearchQuery query) {
        Member next = null;
        QFBuilder _builder = new QFBuilder();
        _builder.add("model", "=", (Object)f7Param.getModelId());
        _builder.add("dimension", "=", (Object)f7Param.getDimensionId());
        _builder.add("dimension", "=", (Object)f7Param.getDimensionId());
        _builder.add(new QFilter("number", "like", (Object)("%" + query.searchText + "%")).or("name", "like", (Object)("%" + query.searchText + "%")));
        String _order = "number";
        if (query.currMember != null && StringUtils.isNotEmpty((String)query.currMember.getNumber())) {
            if (query.hasDown) {
                _builder.add("number", ">", (Object)query.currMember.getNumber());
            } else {
                _builder.add("number", "<", (Object)query.currMember.getNumber());
                _order = "number desc";
            }
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"searchTree", (String)"eb_periodvariable", (String)"id,number,name", (QFilter[])_builder.toArray(), (String)_order, (int)1);){
            if (ds != null && ds.hasNext()) {
                Row row = ds.next();
                next = new Member(row.getLong("id"), row.getString("name"), row.getString("number"));
                next.setLongNumber(row.getString("number"));
            }
        }
        return next;
    }

    protected SearchQuery getSearchFilter(String searchText, boolean hasDown, MemberF7Parameter f7Param, LogStats stats) {
        Set _permissionIds;
        String fields = "id,name,number,longnumber";
        if (f7Param.isView()) {
            fields = "memberid as id,name,number,longnumber";
        }
        QFBuilder builder = new QFBuilder();
        builder.add(f7Param.filters().toList());
        if (f7Param.isVerifyPermission() && (_permissionIds = f7Param.getPermissionIds()) != null) {
            if (f7Param.isView()) {
                if (_permissionIds.isEmpty()) {
                    builder.add("memberid", "=", (Object)0L);
                } else {
                    builder.add("memberid", "in", (Object)_permissionIds);
                }
            } else if (_permissionIds.isEmpty()) {
                builder.add("id", "=", (Object)0L);
            } else {
                builder.add("id", "in", (Object)_permissionIds);
            }
        }
        builder.add(new QFilter("number", "like", (Object)("%" + searchText + "%")).or("name", "like", (Object)("%" + searchText + "%")));
        if (!f7Param.isShowLeaf()) {
            builder.add("isleaf", "=", (Object)"0");
        }
        QFilter direction = null;
        Member _member = this.getSearchTreeByCache(this.getPageCache());
        String _order = "longnumber";
        if (_member != null && StringUtils.isNotEmpty((String)_member.getLongNumber())) {
            if (hasDown) {
                direction = new QFilter("longnumber", ">", (Object)_member.getLongNumber());
            } else {
                direction = new QFilter("longnumber", "<", (Object)_member.getLongNumber());
                _order = "longnumber desc";
            }
        }
        return new SearchQuery(_member, fields, builder.toList(), direction, _order, searchText, hasDown);
    }

    private static class SearchQuery {
        public Member currMember;
        public String fields;
        public List<QFilter> filters;
        public QFilter direction;
        public String orderBy;
        public String searchText;
        public boolean hasDown;

        public SearchQuery(Member currMember, String fields, List<QFilter> filters, QFilter direction, String orderBy, String searchText, boolean hasDown) {
            this.currMember = currMember;
            this.fields = fields;
            this.filters = filters;
            this.direction = direction;
            this.orderBy = orderBy;
            this.searchText = searchText;
            this.hasDown = hasDown;
        }
    }
}

