/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.memberf7.newf7;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.tree.CusPropertyTreeBuilder;
import kd.epm.eb.business.tree.MemberTreeBuilder;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.memberf7.newf7.F7CommonUtils;
import kd.epm.eb.formplugin.memberf7.newf7.MemberTreeF7;
import kd.epm.eb.formplugin.memberf7.newf7.SelectedMember;
import org.jetbrains.annotations.NotNull;

public class MemberTreeRangeF7
extends MemberTreeF7 {
    @Override
    public void initialize() {
        TreeView propertyTree;
        super.initialize();
        Search search = (Search)this.getControl("propertysearch");
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
        this.addClickListeners(new String[]{"propertyup", "propretydown"});
        MemberF7Parameter _f7Param = this.getF7Parameter();
        TreeView treeView = (TreeView)this.getControl("lefttree");
        if (treeView != null) {
            Map properties = treeView.getCustomProperties();
            properties.put("cpn", Boolean.FALSE);
            this.getView().updateControlMetadata("lefttree", properties);
            if (!_f7Param.isMultiSelect()) {
                treeView.setMulti(_f7Param.isMultiSelect());
            }
        }
        if (_f7Param.isShowCustomProperty() && _f7Param.canShowCustomProperty() && (propertyTree = (TreeView)this.getControl("treeproperty")) != null) {
            Map properties = propertyTree.getCustomProperties();
            properties.put("cpn", Boolean.FALSE);
            this.getView().updateControlMetadata("treeproperty", properties);
            if (!_f7Param.isMultiSelect()) {
                propertyTree.setMulti(_f7Param.isMultiSelect());
                MemberTreeBuilder.registerNodeListener((TreeView)propertyTree, (TreeNodeClickListener)this);
            }
            MemberTreeBuilder.registerNodeCheckListener((TreeView)propertyTree, (TreeNodeCheckListener)this);
            MemberTreeBuilder.registerQueryListener((TreeView)propertyTree, (TreeNodeQueryListener)this);
        }
    }

    @Override
    protected void initUI() {
        super.initUI();
        MemberF7Parameter f7Param = this.getF7Parameter();
        if (!f7Param.isShowCustomProperty() || !f7Param.canShowCustomProperty()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"treeproperty", "tabproperty"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"treeproperty", "tabproperty"});
        }
        ComboEdit showScope = (ComboEdit)this.getControl("showscope");
        showScope.setComboItems(f7Param.getRangeItems());
        this.setDefaultValue(f7Param, "showscope");
        if (f7Param.isLockRangeSelect()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"showscope"});
        }
    }

    protected void setDefaultValue(MemberF7Parameter f7Param, String controlKey) {
        if (f7Param.getDefRangeValue() != null) {
            this.getModel().setValue(controlKey, (Object)String.valueOf(f7Param.getDefRangeValue().getIndex()));
        } else {
            this.getModel().setValue(controlKey, (Object)String.valueOf(RangeEnum.ONLY.getIndex()));
        }
    }

    @Override
    protected void initData() {
        super.initData();
    }

    @Override
    protected void init_base() {
        super.init_base();
        MemberF7Parameter _f7Param = this.getF7Parameter();
        this.getModel().setValue("cbshowdisable", (Object)_f7Param.isShowDisable());
    }

    @Override
    protected void init_leftTree(MemberF7Parameter f7Param) {
        if (f7Param == null) {
            f7Param = this.getF7Parameter();
        }
        super.init_leftTree(f7Param);
        if (f7Param.isShowCustomProperty() && f7Param.canShowCustomProperty()) {
            CusPropertyTreeBuilder.get((MemberF7Parameter)f7Param).buildTree((TreeView)this.getControl("treeproperty"), this.getPageCache());
        }
    }

    @Override
    protected void propertyChanged_view(PropertyChangedArgs evt) {
        super.propertyChanged_view(evt);
        F7CommonUtils utils = F7CommonUtils.get();
        utils.clearMemberRange(this.getView(), this.getModel(), this.getPageCache());
    }

    @Override
    protected void clearSelected() {
        super.clearSelected();
        MemberF7Parameter f7Param = this.getF7Parameter();
        f7Param.setSelectIds(Collections.EMPTY_MAP);
        this.cacheF7Parameter(this.getPageCache(), f7Param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        super.treeNodeCheck(evt);
        boolean checked = evt.getChecked();
        Object nodeId = evt.getNodeId();
        if (nodeId == null) {
            return;
        }
        if (evt.getSource() instanceof TreeView) {
            String type = F7CommonUtils.getDataType((Control)((TreeView)evt.getSource()));
            MemberTreeRangeF7 memberTreeRangeF7 = this;
            synchronized (memberTreeRangeF7) {
                LinkedHashMap selectedMembers = this.getSelectedIdsFromCache(this.getPageCache());
                if (checked) {
                    MemberF7Parameter f7Param = this.getF7Parameter();
                    if (!f7Param.isMultiSelect() && selectedMembers.size() >= 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u591a\u9009\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"MemberTreeRangeF7_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(500));
                        return;
                    }
                    if (!selectedMembers.containsKey(nodeId)) {
                        TreeView treeView = (TreeView)evt.getSource();
                        List nodes = treeView.getTreeState().getCheckedNodes();
                        Map node = null;
                        for (Map _node : nodes) {
                            if (!nodeId.equals(_node.get("id"))) continue;
                            node = _node;
                            break;
                        }
                        if (node != null) {
                            if (F7CommonUtils.isVar(node)) {
                                type = "B";
                            }
                            this.selectedNode(node, selectedMembers, type);
                        }
                    }
                } else {
                    this.unSelectedNode(nodeId, selectedMembers);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId;
        super.treeNodeClick(evt);
        MemberF7Parameter f7Param = this.getF7Parameter();
        if (!f7Param.isMultiSelect() && StringUtils.isNotEmpty((String)(nodeId = (String)evt.getNodeId()))) {
            String type = F7CommonUtils.getDataType((Control)((TreeView)evt.getSource()));
            MemberTreeRangeF7 memberTreeRangeF7 = this;
            synchronized (memberTreeRangeF7) {
                LinkedHashMap selectedMembers = this.getSelectedIdsFromCache(this.getPageCache());
                selectedMembers.clear();
                HashMap<String, Object> node = new HashMap<String, Object>();
                node.put("id", nodeId);
                node.put("parentid", evt.getParentNodeId());
                if (F7CommonUtils.isVar(node)) {
                    type = "B";
                }
                this.selectedNode(node, selectedMembers, type);
            }
        }
    }

    private void selectedNode(@NotNull Map<String, Object> node, @NotNull LinkedHashMap<String, Map<String, String>> selectedMembers, @NotNull String type) {
        switch (type) {
            case "A": {
                Member member = this.getMember(node);
                if (member == null) break;
                SelectedMember selectedMember = SelectedMember.of(member);
                selectedMember.setScope(this.getShowRange().getIndex());
                this.selectedMember(selectedMember, selectedMembers);
                break;
            }
            case "B": {
                DynamicObject var = this.getVar(node);
                if (var == null) break;
                SelectedMember selectedMember = SelectedMember.of(var, "B");
                selectedMember.setScope(this.getShowRange().getIndex());
                this.selectedMember(selectedMember, selectedMembers);
                break;
            }
            case "C": {
                DynamicObject propertyValue = this.getPropertyValue(node);
                if (propertyValue == null) break;
                SelectedMember selectedMember = SelectedMember.of(propertyValue, "C");
                selectedMember.setScope(RangeEnum.ONLY.getIndex());
                this.selectedMember(selectedMember, selectedMembers);
            }
        }
    }

    private RangeEnum getShowRange() {
        String showScope = (String)this.getModel().getValue("showscope");
        if (showScope != null) {
            return RangeEnum.getRangeByVal((int)Integer.parseInt(showScope));
        }
        return RangeEnum.ONLY;
    }

    private Member getMember(@NotNull Map<String, Object> node) {
        IModelCacheHelper modelCacheHelper = this.getModelCache(this.getModelIdByCache(this.getPageCache()));
        Dimension dimension = modelCacheHelper.getDimension(this.getDimensionIdByCache(this.getPageCache()));
        Member member = dimension.getMember(this.getF7Parameter().getViewId(), IDUtils.toLong((Object)node.get("id")));
        if (member == null) {
            member = dimension.getMember(IDUtils.toLong((Object)node.get("id")));
        }
        return member;
    }

    private DynamicObject getVar(@NotNull Map<String, Object> node) {
        Long nodeId = IDUtils.toLong((Object)node.get("id"));
        return BusinessDataServiceHelper.loadSingleFromCache((Object)nodeId, (String)"eb_periodvariable", (String)"id,name,number");
    }

    private DynamicObject getPropertyValue(@NotNull Map<String, Object> node) {
        Long nodeId = IDUtils.toLong((Object)node.get("id"));
        return BusinessDataServiceHelper.loadSingleFromCache((Object)nodeId, (String)"eb_custompropertyvalue", (String)"id,name,number,property.id,property.number");
    }

    private void selectedMember(@NotNull SelectedMember selectedMember, @NotNull LinkedHashMap<String, Map<String, String>> selectedMembers) {
        MemberF7Parameter f7Param = this.getF7Parameter();
        if (!f7Param.isMultiSelect()) {
            this.getModel().deleteEntryData("entryentity");
        }
        int rowIndex = this.getModel().createNewEntryRow("entryentity");
        this.getModel().setValue("memberid", (Object)selectedMember.getId(), rowIndex);
        this.getModel().setValue("name", (Object)selectedMember.getName(), rowIndex);
        if (f7Param.isEb()) {
            this.getModel().setValue("number", (Object)selectedMember.getNumber(), rowIndex);
        } else {
            this.getModel().setValue("number", (Object)selectedMember.getShowNumber(), rowIndex);
        }
        this.getModel().setValue("scope", (Object)String.valueOf(selectedMember.getScope()), rowIndex);
        RangeF7PropertyCataEnum typeEnum = RangeF7PropertyCataEnum.of((String)selectedMember.getType());
        if (typeEnum != null) {
            this.getModel().setValue("type", (Object)typeEnum.getIndex(), rowIndex);
        }
        if ("C".equals(selectedMember.getType()) || this.getF7Parameter().isLockRangeSelect()) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"scope"});
        }
        RangeEnum range = RangeEnum.getRangeByVal((int)selectedMember.getScope());
        this.getView().setEnable(Boolean.valueOf(range == RangeEnum.LEVEL || range == RangeEnum.LEVEL_EXCLUDE), rowIndex, new String[]{"level"});
        if (!f7Param.isEb()) {
            this.getModel().setValue("interior", (Object)selectedMember.getNumber(), rowIndex);
        }
        this.putSelectedMember(selectedMembers, selectedMember);
        this.cacheSelectMember(this.getPageCache(), selectedMembers);
    }

    private void unSelectedNode(@NotNull Object nodeId, @NotNull LinkedHashMap<String, Map<String, String>> selectedMembers) {
        DynamicObject parent;
        IDataEntityProperty property;
        Long memberId = IDUtils.toLong((Object)nodeId);
        HashSet rowIndex = Sets.newHashSetWithExpectedSize((int)selectedMembers.size());
        DynamicObjectCollection selMembers = this.getModel().getEntryEntity("entryentity");
        int in = selMembers.size();
        for (int i = 0; i < in; ++i) {
            DynamicObject selMember = (DynamicObject)selMembers.get(i);
            if (selMember.getLong("memberId") != memberId.longValue()) continue;
            rowIndex.add(i);
            selectedMembers.remove(IDUtils.toString((Object)nodeId));
        }
        if (!rowIndex.isEmpty()) {
            int[] _rowIndex = rowIndex.stream().mapToInt(x -> x).toArray();
            this.getModel().deleteEntryRows("entryentity", _rowIndex);
        }
        if ((property = this.getModel().getProperty("parent")) != null && (parent = (DynamicObject)this.getModel().getValue("parent")) != null && parent.getLong("id") == IDUtils.toLong((Object)nodeId).longValue()) {
            this.getModel().setValue("parent", null);
        }
        this.cacheSelectMember(this.getPageCache(), selectedMembers);
    }

    @Override
    protected void treeStepLoad(@NotNull TreeView treeView, @NotNull String nodeId) throws Exception {
        super.treeStepLoad(treeView, nodeId);
        if ("treeproperty".equals(treeView.getKey())) {
            LinkedHashMap selectedMembers = this.getSelectedIdsFromCache(this.getPageCache());
            CusPropertyTreeBuilder.get((MemberF7Parameter)this.getF7Parameter()).stepLoadTree(treeView, Collections.singletonList(nodeId), "CACHE_TREE_PROPERTY_NODE_DATA", null, IDUtils.toLongs(selectedMembers.keySet()), this.getPageCache());
        }
    }

    @Override
    protected void showTree(@NotNull MemberF7Parameter f7Param) {
        LinkedHashMap selectedMembers = this.getSelectedIdsFromCache(this.getPageCache());
        Set selectedMemberIds = IDUtils.toLongs(selectedMembers.keySet());
        TreeView view = (TreeView)this.getControl("lefttree");
        MemberTreeBuilder.get((MemberF7Parameter)f7Param).buildTree(view, this.getPageCache(), selectedMemberIds);
        TreeView propTree = (TreeView)this.getControl("treeproperty");
        CusPropertyTreeBuilder.get((MemberF7Parameter)f7Param).buildTree(propTree, this.getPageCache(), selectedMemberIds);
    }

    @Override
    protected void searchProperty(Search search, String searchText) {
        this.searchProperty(searchText, true);
    }

    @Override
    protected void click_PropertySearchDown(EventObject evt) {
        Search search = (Search)this.getControl("propertysearch");
        if (search != null && StringUtils.isNotEmpty((String)search.getSearchKey())) {
            this.searchProperty(search.getSearchKey(), true);
        }
    }

    @Override
    protected void click_PropertySearchUp(EventObject evt) {
        Search search = (Search)this.getControl("propertysearch");
        if (search != null && StringUtils.isNotEmpty((String)search.getSearchKey())) {
            this.searchProperty(search.getSearchKey(), false);
        }
    }

    private void searchProperty(String searchText, boolean hasDown) {
        LogStats stats = new LogStats("budget-log : ");
        stats.addInfo("begin-searchProperty.");
        MemberF7Parameter _f7Param = this.getF7Parameter();
        Map currPropertyValue = this.getSearchPropertyByCache(this.getPageCache());
        List<Object> propertyIds = this.queryProperty(_f7Param);
        DynamicObject propValue = this.queryPropertyValue(propertyIds, currPropertyValue, searchText, hasDown);
        if (propValue == null && currPropertyValue != null) {
            propValue = this.queryPropertyValue(propertyIds, null, searchText, hasDown);
        }
        if (propValue != null) {
            String propertyId = propValue.getString("property.id");
            String propValueId = propValue.getString("id");
            this.cacheSearchPropertyTree(this.getPageCache(), propValue);
            TreeView propView = (TreeView)this.getControl("treeproperty");
            if (propView != null) {
                LinkedHashMap selectedMembers = this.getSelectedIdsFromCache(this.getPageCache());
                try {
                    CusPropertyTreeBuilder.get((MemberF7Parameter)this.getF7Parameter()).stepLoadTree(propView, CollectionUtils.asList((Object[])new String[]{propertyId, propValueId}), "CACHE_TREE_PROPERTY_NODE_DATA", propValueId, IDUtils.toLongs(selectedMembers.keySet()), this.getPageCache());
                }
                catch (Exception e) {
                    log.error("stepLoadTree-error", (Throwable)e);
                }
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u9879", (String)"MemberSingleTreeF7_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
            this.clearSearchPropertyCache(this.getPageCache());
        }
        stats.addInfo("end-searchProperty.");
        log.info(stats.toString());
    }

    private List<Object> queryProperty(MemberF7Parameter f7Param) {
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)f7Param.getModelId());
        builder.add("dimension", "=", (Object)f7Param.getDimensionId());
        return QueryServiceHelper.queryPrimaryKeys((String)"eb_customproperty", (QFilter[])builder.toArray(), (String)"number", (int)100);
    }

    private DynamicObject queryPropertyValue(List<Object> propertyIds, Map<String, Object> currPropertyValue, String searchText, boolean hasDown) {
        if (propertyIds == null || propertyIds.isEmpty()) {
            return null;
        }
        QFBuilder builder = new QFBuilder();
        builder.add("property", "in", propertyIds);
        if (currPropertyValue != null) {
            int propertySeq = (Integer)currPropertyValue.get("property.dseq");
            String propValNumber = (String)currPropertyValue.get("number");
            if (hasDown) {
                QFilter equalsFilter = new QFilter("property.dseq", "=", (Object)propertySeq).and("number", ">", (Object)propValNumber);
                QFilter largeFilter = new QFilter("property.dseq", ">", (Object)propertySeq);
                equalsFilter.or(largeFilter);
                builder.add(equalsFilter);
            } else {
                QFilter equalsFilter = new QFilter("property.dseq", "=", (Object)propertySeq).and("number", "<", (Object)propValNumber);
                QFilter lessFilter = new QFilter("property.dseq", "<", (Object)propertySeq);
                equalsFilter.or(lessFilter);
                builder.add(equalsFilter);
            }
        }
        builder.add(new QFilter("number", "like", (Object)("%" + searchText + "%")).or("name", "like", (Object)("%" + searchText + "%")));
        String order = hasDown ? "property.dseq,number" : "property.dseq desc,number desc";
        DynamicObjectCollection values = QueryServiceHelper.query((String)"eb_custompropertyvalue", (String)"id,number,name,property.id,property.number,property.dseq", (QFilter[])builder.toArray(), (String)order, (int)1);
        return values == null || values.isEmpty() ? null : (DynamicObject)values.get(0);
    }
}

