/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.memberf7.newf7;

import java.io.Serializable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.RangeEnum;
import org.jetbrains.annotations.NotNull;

public class SelectedMember
implements Serializable {
    private Long id = null;
    private String name = null;
    private String number = null;
    private String showNumber = null;
    private boolean isLeaf = true;
    private int scope = RangeEnum.ONLY.getIndex();
    private String longNumber = null;
    private String type = "A";
    private int level = 0;
    private boolean exclude = false;

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getNumber() {
        return this.number;
    }

    public void setShowNumber(String showNumber) {
        this.showNumber = showNumber;
    }

    public String getShowNumber() {
        return this.showNumber;
    }

    public void setLeaf(boolean leaf) {
        this.isLeaf = leaf;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    public int getScope() {
        return this.scope;
    }

    public String scope() {
        if (this.getScope() != RangeEnum.ONLY.getIndex()) {
            return String.valueOf(this.getScope());
        }
        return null;
    }

    public void setLongNumber(String longNumber) {
        this.longNumber = longNumber;
    }

    public String getLongNumber() {
        return this.longNumber;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public void setExclude(boolean exclude) {
        this.exclude = exclude;
    }

    public boolean isExclude() {
        return this.exclude;
    }

    public static SelectedMember of(@NotNull Member member) {
        SelectedMember _selected = new SelectedMember();
        _selected.setId(member.getId());
        _selected.setName(member.getName());
        _selected.setNumber(member.getNumber());
        _selected.setLeaf(member.isLeaf());
        _selected.setShowNumber(member.getShowNumber());
        _selected.setType("A");
        return _selected;
    }

    public static SelectedMember of(@NotNull CustomPropertyValue propValue) {
        SelectedMember _selected = new SelectedMember();
        _selected.setId(propValue.getId());
        _selected.setName(propValue.getName());
        _selected.setNumber(propValue.getNumber());
        _selected.setShowNumber(_selected.getNumber());
        if (propValue.getProp() == null) {
            throw new NullPointerException("property is null.");
        }
        _selected.setLongNumber(propValue.getProp().getNumber() + '!' + propValue.getNumber());
        _selected.setType("C");
        return _selected;
    }

    public static SelectedMember of(@NotNull DynamicObject object, @NotNull String type) {
        SelectedMember _selected = new SelectedMember();
        _selected.setId(object.getLong("id"));
        _selected.setName(object.getString("name"));
        _selected.setNumber(object.getString("number"));
        if (object.getDataEntityType() != null && object.getDataEntityType().getProperties().containsKey((Object)"shownumber")) {
            _selected.setShowNumber(object.getString("shownumber"));
        } else {
            _selected.setShowNumber(_selected.getNumber());
        }
        if ("C".equals(type)) {
            _selected.setLongNumber(object.getString("property.number") + '!' + _selected.getNumber());
        }
        _selected.setType(type);
        return _selected;
    }

    public static SelectedMember of(@NotNull Long memberId, Integer scope, @NotNull Dimension dimension, @NotNull MemberPropCache propCache) {
        SelectedMember selected;
        Member member = dimension.getMember(memberId);
        if (member != null) {
            selected = SelectedMember.of(member);
            if (scope != null) {
                selected.setScope(scope);
            }
        } else {
            selected = SelectedMember.of(memberId, scope, propCache);
        }
        return selected;
    }

    public static SelectedMember of(@NotNull Long memberId, Integer scope, @NotNull View view, @NotNull MemberPropCache propCache) {
        SelectedMember selected;
        Member member = view.getMember(memberId);
        if (member != null) {
            selected = SelectedMember.of(member);
            if (scope != null) {
                selected.setScope(scope);
            }
        } else {
            selected = SelectedMember.of(memberId, scope, propCache);
        }
        return selected;
    }

    private static SelectedMember of(@NotNull Long memberId, Integer scope, @NotNull MemberPropCache propCache) {
        SelectedMember selected = null;
        CustomPropertyValue propValue = propCache.getPropertyValue(memberId);
        if (propValue != null) {
            selected = SelectedMember.of(propValue);
        } else {
            DynamicObject var = BusinessDataServiceHelper.loadSingleFromCache((Object)memberId, (String)"eb_periodvariable", (String)"id,name,number");
            if (var != null) {
                selected = SelectedMember.of(var, "B");
                if (scope != null) {
                    selected.setScope(scope);
                }
            }
        }
        return selected;
    }
}

