/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.memberf7.newf7;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.common.member.f7.F7TreeUtils;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.compress.CompressUtils;
import kd.epm.eb.common.utils.control.ConditionUtils;
import kd.epm.eb.formplugin.memberf7.newf7.face.ISelectedF7Cache;
import kd.epm.eb.formplugin.utils.PluginUtils;
import org.jetbrains.annotations.NotNull;

public class VirtualDataProvider
extends ListDataProvider
implements ISelectedF7Cache {
    private final IFormView formView;
    private final IDataModel dataModel;
    private final IPageCache pageCache;
    private final String currNodeId;
    private List<Map<String, Object>> collection = null;
    private static final String DESC = "desc";
    private static final Set<String> FILTER_FIELDS = new HashSet<String>();
    private ConditionUtils utils = null;
    private ConditionUtils.QFilterEvaluator evaluator = null;

    protected IFormView getFormView() {
        return this.formView;
    }

    protected IDataModel getDataModel() {
        return this.dataModel;
    }

    protected IPageCache getPageCache() {
        return this.pageCache;
    }

    protected String getCurrNodeId() {
        return this.currNodeId;
    }

    protected List<Map<String, Object>> getCollection() {
        return this.collection;
    }

    protected void setCollection(List<Map<String, Object>> collection) {
        this.collection = collection;
    }

    public VirtualDataProvider(IFormView formView, IDataModel dataModel, IPageCache pageCache, String currNodeId) {
        this.formView = formView;
        this.dataModel = dataModel;
        this.pageCache = pageCache;
        this.currNodeId = currNodeId;
    }

    public DynamicObjectCollection getData(int start, int limit) {
        List<Map<String, Object>> collection = this.filterData(this.orderData(this.getVirtualDataCollection()));
        DynamicObjectCollection result = this.getStartToEnd(start, limit, collection);
        if (limit != this.getMaxReturnData()) {
            int[] selectedRows = this.getBySelectedRowsIndex(result);
            this.getQueryResult().setCollection(result);
            this.getQueryResult().setBillDataCount(result.size());
            this.getPageCache().put("LIST_CACHE_SELECT_INDEX", JSONUtils.toString((Object)selectedRows));
        }
        return result;
    }

    protected List<Map<String, Object>> getVirtualDataCollection() {
        if (this.getCollection() == null) {
            List<Map<String, Object>> result = (List<Map<String, Object>>)F7TreeUtils.getCacheObjectData((IPageCache)this.getPageCache(), (String)"VIRTUAL_F7_DATA");
            if (result == null) {
                result = Collections.emptyList();
            }
            this.setCollection(result);
        }
        return this.getCollection();
    }

    protected List<Map<String, Object>> orderData(List<Map<String, Object>> data) {
        if (StringUtils.isEmpty((String)this.getOrderByExpr())) {
            return data;
        }
        String[] orderBy = this.getOrderByExpr().split(",");
        if (orderBy.length > 0) {
            Comparator<Map> comparator = null;
            for (String _orderBy : orderBy) {
                String[] orderInfo = _orderBy.split(" ");
                if (comparator == null) {
                    if (orderInfo.length > 1 && StringUtils.equals((String)DESC, (String)orderInfo[1])) {
                        comparator = Comparator.comparing(d -> (String)d.get(orderInfo[0].trim()), Comparator.reverseOrder());
                        continue;
                    }
                    comparator = Comparator.comparing(d -> (String)d.get(orderInfo[0].trim()));
                    continue;
                }
                if (orderInfo.length > 1 && StringUtils.equals((String)DESC, (String)orderInfo[1])) {
                    comparator.thenComparing(d -> (String)d.get(orderInfo[0].trim()), Comparator.reverseOrder());
                    continue;
                }
                comparator.thenComparing(d -> (String)d.get(orderInfo[0].trim()));
            }
            if (comparator != null) {
                data.sort(comparator);
            }
        }
        return data;
    }

    protected List<Map<String, Object>> filterData(List<Map<String, Object>> data) {
        if (data == null) {
            return Collections.emptyList();
        }
        return data;
    }

    protected int[] getBySelectedRowsIndex(DynamicObjectCollection result) {
        LinkedHashMap cacheSelectData = this.getSelectedIdsFromCache(this.getPageCache());
        if (CollectionUtils.isEmpty((Map)cacheSelectData)) {
            return null;
        }
        LinkedHashSet selectedIds = new LinkedHashSet();
        LinkedHashSet selectedNumbers = new LinkedHashSet();
        if (CollectionUtils.isNotEmpty((Map)cacheSelectData)) {
            selectedIds.addAll(IDUtils.toLongs(cacheSelectData.keySet()));
            selectedNumbers.addAll(cacheSelectData.values().stream().filter(d -> d != null && d.size() > 1).map(d -> (String)d.get("nu")).collect(Collectors.toSet()));
        }
        int index = 0;
        ArrayList<Integer> selectedRows = new ArrayList<Integer>(selectedIds.size());
        for (DynamicObject _object : result) {
            if (selectedIds.contains(_object.getLong("id")) || selectedNumbers.contains(_object.getString("number"))) {
                selectedRows.add(index);
            }
            ++index;
        }
        return CollectionUtils.getBase(selectedRows);
    }

    protected Set<String> getAllChildNodeIds(String nodeId, @NotNull Map<String, Set<String>> treeChildMap) {
        LinkedHashSet<String> nodeIds = new LinkedHashSet<String>();
        nodeIds.add(nodeId);
        this.getChildNodeIds(nodeId, nodeIds, treeChildMap);
        return nodeIds;
    }

    private void getChildNodeIds(String nodeId, @NotNull Set<String> nodeIds, @NotNull Map<String, Set<String>> treeChildMap) {
        if (StringUtils.isEmpty((String)nodeId) || treeChildMap.isEmpty()) {
            return;
        }
        Set<String> childIds = treeChildMap.get(nodeId);
        if (childIds != null && !childIds.isEmpty()) {
            childIds.forEach(childId -> {
                if (treeChildMap.containsKey(childId)) {
                    nodeIds.add((String)childId);
                }
                this.getChildNodeIds((String)childId, nodeIds, treeChildMap);
            });
        }
    }

    protected DynamicObjectCollection getStartToEnd(int start, int limit, List<Map<String, Object>> collection) {
        if (collection == null) {
            return new DynamicObjectCollection();
        }
        DynamicObjectCollection result = new DynamicObjectCollection(this.getDT(), null);
        Set tmpNodeIds = null;
        String[] tmpOr = null;
        Map treeChildMap = (Map)F7TreeUtils.getCacheObjectData((IPageCache)this.getPageCache(), (String)"CACHE_VIRTUAL_TREE_CHILD_DATA");
        if (treeChildMap != null) {
            tmpNodeIds = PluginUtils.getCheckBoxValue(this.getDataModel(), "cbchildren") ? this.getAllChildNodeIds(this.getCurrNodeId(), treeChildMap) : CollectionUtils.asSet((Object[])new String[]{this.getCurrNodeId()});
        }
        Set allNodeIds = tmpNodeIds;
        String _searchText = this.getPageCache().get("LIST_CACHE_SEARCH");
        if (StringUtils.isNotEmpty((String)_searchText)) {
            tmpOr = _searchText.contains(" ") ? _searchText.split(" ") : new String[]{_searchText};
        }
        String[] orFilters = tmpOr;
        List filter = collection.stream().filter(d -> this.filterNodeId((Map<String, Object>)d, allNodeIds)).filter(d -> this.filterObject((Map<String, Object>)d, orFilters)).filter(d -> this.filterCustomFilter((Map<String, Object>)d, this.getQFilters())).skip(start).limit(limit).collect(Collectors.toList());
        for (Map data : filter) {
            DynamicObject clone = result.addNew();
            this.transDynamicObject(clone, data);
        }
        CompressUtils utils = CompressUtils.get();
        this.getPageCache().put("CACHE_VIRTUAL_PAGE_DATA", utils.compress(filter, null));
        return result;
    }

    private DynamicObjectType getDT() {
        DynamicObjectType dt = new DynamicObjectType("PlainObject");
        DynamicSimpleProperty pk = new DynamicSimpleProperty("id", Long.class, (Object)0L);
        pk.setPrimaryKey(true);
        dt.registerSimpleProperty(pk);
        dt.registerSimpleProperty(new DynamicSimpleProperty("number", String.class, (Object)""));
        dt.registerSimpleProperty(new DynamicSimpleProperty("name", String.class, (Object)""));
        dt.registerSimpleProperty(new DynamicSimpleProperty("level", Integer.class, (Object)1));
        dt.registerSimpleProperty(new DynamicSimpleProperty("isleaf", Boolean.class, (Object)Boolean.TRUE));
        return dt;
    }

    private void transDynamicObject(DynamicObject object, Map<String, Object> data) {
        if (object == null || data == null) {
            return;
        }
        object.set("id", data.get("id"));
        object.set("number", data.get("number"));
        object.set("name", data.get("name"));
        object.set("level", data.get("level"));
        object.set("isleaf", data.get("isleaf"));
    }

    private boolean filterNodeId(Map<String, Object> object, Set<String> filterNodeIds) {
        if (object == null) {
            return false;
        }
        if (filterNodeIds == null) {
            return true;
        }
        return filterNodeIds.contains(IDUtils.toString((Object)object.get("parent.id"))) || filterNodeIds.contains(IDUtils.toString((Object)object.get("id")));
    }

    private boolean filterObject(Map<String, Object> object, String[] filters) {
        if (object == null) {
            return false;
        }
        if (filters == null || filters.length == 0) {
            return true;
        }
        String number = (String)object.get("number");
        String name = (String)object.get("name");
        boolean re = false;
        for (String filter : filters) {
            if (filter == null) continue;
            if (filter.contains("&")) {
                String[] andFilters;
                for (String and : andFilters = filter.split("&")) {
                    boolean bl = re = StringUtils.include((String)number, (String)and) || StringUtils.include((String)name, (String)and);
                    if (re) {
                        continue;
                    }
                    break;
                }
            } else {
                boolean bl = re = StringUtils.include((String)number, (String)filter) || StringUtils.include((String)name, (String)filter);
            }
            if (!re) continue;
            return re;
        }
        return re;
    }

    private boolean filterCustomFilter(Map<String, Object> object, List<QFilter> filters) {
        if (filters == null || filters.isEmpty()) {
            return true;
        }
        boolean re = true;
        this.getEvaluator().setValues(object);
        for (QFilter filter : filters) {
            if (!FILTER_FIELDS.contains(filter.getProperty()) || (re = this.getUtils().run(filter, this.getEvaluator()))) continue;
            return false;
        }
        return re;
    }

    public ConditionUtils getUtils() {
        if (this.utils == null) {
            this.utils = ConditionUtils.get();
        }
        return this.utils;
    }

    public ConditionUtils.QFilterEvaluator getEvaluator() {
        if (this.evaluator == null) {
            this.evaluator = new ConditionUtils.QFilterEvaluator();
        }
        return this.evaluator;
    }

    static {
        FILTER_FIELDS.add("number");
        FILTER_FIELDS.add("name");
        FILTER_FIELDS.add("level");
        FILTER_FIELDS.add("isleaf");
    }
}

