/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.memberf7.newf7;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.memberf7.newf7.F7CommonUtils;
import kd.epm.eb.formplugin.memberf7.newf7.VirtualDataProvider;
import kd.epm.eb.formplugin.memberf7.newf7.base.AbstractVirtualListF7;
import org.jetbrains.annotations.NotNull;

public class VirtualListF7
extends AbstractVirtualListF7 {
    private MemberF7Parameter f7Parameter = null;
    private ListDataProvider provider = null;

    @Override
    protected MemberF7Parameter getF7Parameter() {
        String version;
        if (this.f7Parameter != null && (version = this.getF7ParamVersion(this.getPageCache())) != null && Long.valueOf(version).compareTo(this.f7Parameter.getVersion()) != 0) {
            this.f7Parameter = null;
        }
        if (this.f7Parameter == null) {
            this.f7Parameter = this.getF7FromCache(this.getPageCache());
            if (this.f7Parameter == null) {
                this.f7Parameter = new MemberF7Parameter();
            }
            this.f7Parameter.check();
            this.f7Parameter.loadData();
        }
        return this.f7Parameter;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.f7Parameter = this.loadF7Parameter(this.getView(), this.getPageCache());
    }

    @Override
    protected ListDataProvider getVirtualDataProvider(IFormView formView, IDataModel dataModel, IPageCache pageCache, MemberF7Parameter f7Param) {
        if (formView == null || dataModel == null || pageCache == null || f7Param == null) {
            return null;
        }
        TreeView leftTree = (TreeView)formView.getControl("lefttree");
        if (leftTree == null) {
            return null;
        }
        String currNodeId = leftTree.getTreeState().getFocusNodeId();
        if (StringUtils.isEmpty((String)currNodeId)) {
            return null;
        }
        if (this.provider == null) {
            this.provider = this.createProvider(formView, dataModel, pageCache, currNodeId);
        }
        return this.provider;
    }

    protected ListDataProvider createProvider(IFormView formView, IDataModel dataModel, IPageCache pageCache, String currNodeId) {
        return new VirtualDataProvider(formView, dataModel, pageCache, currNodeId);
    }

    @Override
    protected List<Map<String, Object>> getVirtualData() {
        return super.getVirtualData();
    }

    @Override
    protected boolean isCacheVirtualData() {
        return false;
    }

    public void afterBindData(EventObject e) {
        List rows;
        String cacheRowIndex;
        super.afterBindData(e);
        if (e.getSource() instanceof ListView) {
            Label caption = (Label)this.getControl("caption");
            if (caption != null && this.f7Parameter != null) {
                if (StringUtils.isNotEmpty((String)this.f7Parameter.getTitle())) {
                    caption.setText(this.f7Parameter.getTitle());
                } else {
                    caption.setText(ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u6210\u5458", (String)"MemberListF7_3", (String)"epm-eb-formplugin", (Object[])new Object[]{this.f7Parameter.getDimensionName()}));
                }
            }
        } else if (e.getSource() instanceof BillList && StringUtils.isNotEmpty((String)(cacheRowIndex = this.getPageCache().get("LIST_CACHE_SELECT_INDEX"))) && (rows = (List)JSONUtils.parse((String)cacheRowIndex, List.class)) != null && !rows.isEmpty()) {
            rows = rows.stream().sorted().collect(Collectors.toList());
            BillList billList = (BillList)e.getSource();
            billList.selectRows(CollectionUtils.getBase(rows));
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getCustomQFilters().add(new QFilter("model", "=", (Object)0L).and("dimension", "=", (Object)0L));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "cbchildren": {
                this.propertyChanged_children(e);
                break;
            }
        }
    }

    protected void propertyChanged_children(PropertyChangedArgs evt) {
        this.refreshList();
    }

    @Override
    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        this.refreshList();
    }

    public void refreshList() {
        BillList _billList = (BillList)this.getControl("billlistap");
        if (_billList != null) {
            _billList.refresh();
        }
    }

    public void search(SearchEnterEvent evt) {
        Search _search = (Search)evt.getSource();
        String _text = evt.getText();
        if (_search == null || StringUtils.isEmpty((String)_text)) {
            this.getPageCache().remove("LIST_CACHE_SEARCH");
        } else {
            this.getPageCache().put("LIST_CACHE_SEARCH", F7CommonUtils.filterIllegality(_text));
        }
        this.refreshList();
    }

    @Override
    protected void click_submit(EventObject evt) {
        this.returnSelectedData(this.getView(), this.getF7Parameter(), this.getSelectedIdsFromCache(this.getPageCache()));
    }

    protected void returnSelectedData(@NotNull IFormView view, @NotNull MemberF7Parameter f7Param, Map<String, Map<String, String>> selectData) {
        if (f7Param.isMustSelected() && (selectData == null || selectData.isEmpty())) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"MemberListF7_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        view.returnDataToParent(NewF7Utils.returnVirtualData((MemberF7Parameter)f7Param, selectData));
        view.close();
    }

    @Override
    protected void click_cancel(EventObject evt) {
        this.getView().returnDataToParent(null);
        this.getView().close();
    }
}

