/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.memberf7.newf7;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.tree.MemberTreeBuilder;
import kd.epm.eb.business.tree.VirtualTreeBuilder;
import kd.epm.eb.common.member.f7.F7TreeUtils;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.memberf7.newf7.base.AbstractVirtualTreeF7;
import kd.epm.eb.formplugin.memberf7.newf7.face.IVirtualF7Param;
import org.jetbrains.annotations.NotNull;

public class VirtualTreeF7
extends AbstractVirtualTreeF7
implements IVirtualF7Param {
    public static final Log log = LogFactory.getLog(VirtualTreeF7.class);
    private MemberF7Parameter f7Parameter = null;

    protected MemberF7Parameter getF7Parameter() {
        if (this.f7Parameter == null) {
            this.f7Parameter = this.getF7FromCache(this.getPageCache());
            if (this.f7Parameter == null) {
                this.f7Parameter = new MemberF7Parameter();
            }
        }
        return this.f7Parameter;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        TreeView treeView;
        super.registerListener(e);
        this.f7Parameter = this.loadF7Parameter(this.getView(), this.getPageCache());
        if (this.f7Parameter != null && this.f7Parameter.stepLoad() && (treeView = (TreeView)this.getControl("lefttree")) != null) {
            MemberTreeBuilder.registerQueryListener((TreeView)treeView, (TreeNodeQueryListener)this);
        }
    }

    @Override
    protected void init_base() {
    }

    @Override
    protected void init_leftTree(MemberF7Parameter f7Param) {
        if (f7Param == null) {
            f7Param = this.getF7Parameter();
        }
        this.buildLeafTree(f7Param);
    }

    protected void buildLeafTree(MemberF7Parameter f7Param) {
        VirtualTreeBuilder.get((MemberF7Parameter)f7Param).buildTree((TreeView)this.getControl("lefttree"), this.getPageCache());
    }

    @Override
    protected void treeNode_stepLoad(TreeNodeEvent evt) {
        TreeView treeView = (TreeView)evt.getSource();
        String nodeId = (String)evt.getNodeId();
        try {
            if (nodeId != null) {
                this.treeStepLoad(treeView, nodeId);
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    protected void treeStepLoad(@NotNull TreeView treeView, @NotNull String nodeId) throws Exception {
        if ("lefttree".equals(treeView.getKey())) {
            VirtualTreeBuilder builder = VirtualTreeBuilder.get((MemberF7Parameter)this.getF7Parameter());
            builder.stepLoadTree(treeView, Collections.singletonList(nodeId), builder.getCacheTreeKey(), null, null, this.getPageCache());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void searchTree(String searchText, boolean hasDown) {
        String searchData;
        LogStats stats = new LogStats("budget-log : ");
        stats.addInfo("begin-searchTree");
        LinkedList expandIds = Lists.newLinkedList();
        String nextNodeId = null;
        int index = 0;
        TreeView view = (TreeView)this.getControl("lefttree");
        String focusNodeId = view.getTreeState().getFocusNodeId();
        String _indexStr = this.getPageCache().get("CACHE_LIST_ROW_INDEX");
        if (_indexStr != null) {
            index = Integer.parseInt(_indexStr);
        }
        if (StringUtils.isNotEmpty((String)(searchData = F7TreeUtils.getCacheData((IPageCache)this.getPageCache(), (String)"CACHE_SEARCH_DATA")))) {
            List _searchData = (List)SerializationUtils.deSerializeFromBase64((String)searchData);
            if (focusNodeId != null && _searchData != null && !_searchData.isEmpty()) {
                int i;
                if (hasDown) {
                    int in = _searchData.size();
                    for (i = index; i < in; ++i) {
                        if (!StringUtils.equals((String)((String)_searchData.get(i)), (String)focusNodeId)) continue;
                        index = i < in - 1 ? i + 1 : 0;
                        nextNodeId = (String)_searchData.get(index);
                        this.getPageCache().put("CACHE_LIST_ROW_INDEX", String.valueOf(index));
                        break;
                    }
                } else {
                    for (i = index; i >= 0; --i) {
                        if (!StringUtils.equals((String)((String)_searchData.get(i)), (String)focusNodeId)) continue;
                        index = i > 0 ? i - 1 : _searchData.size() - 1;
                        nextNodeId = (String)_searchData.get(index);
                        this.getPageCache().put("CACHE_LIST_ROW_INDEX", String.valueOf(index));
                        break;
                    }
                }
            }
        } else {
            VirtualTreeBuilder builder = VirtualTreeBuilder.get((MemberF7Parameter)this.getF7Parameter());
            List allNodes = (List)F7TreeUtils.getCacheObjectData((IPageCache)this.getPageCache(), (String)builder.getCacheTreeDataKey());
            if (allNodes != null) {
                LinkedList filterNodeIds = Lists.newLinkedList();
                allNodes.forEach(n -> {
                    if (n != null && n.getText() != null && n.getText().contains(searchText)) {
                        filterNodeIds.add(n.getId());
                    }
                });
                if (filterNodeIds.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u9879", (String)"MemberSingleTreeF7_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
                    return;
                }
                nextNodeId = (String)filterNodeIds.get(0);
                this.getPageCache().put("CACHE_SEARCH_TEXT", searchText);
                this.getPageCache().put("CACHE_LIST_ROW_INDEX", String.valueOf(index));
                F7TreeUtils.cacheData((IPageCache)this.getPageCache(), (String)"CACHE_SEARCH_DATA", (Object)filterNodeIds);
            }
        }
        if (StringUtils.isNotEmpty(nextNodeId)) {
            try {
                MemberF7Parameter _f7Param = this.getF7Parameter();
                TreeView treeView = (TreeView)this.getControl("lefttree");
                VirtualTreeBuilder builder = VirtualTreeBuilder.get((MemberF7Parameter)_f7Param);
                Map treeParentMap = (Map)F7TreeUtils.getCacheObjectData((IPageCache)this.getPageCache(), (String)builder.getCacheTreeParentDataKey());
                this.queryParent(nextNodeId, expandIds, treeParentMap);
                Collections.reverse(expandIds);
                builder.stepLoadTree(treeView, (List)expandIds, builder.getCacheTreeKey(), nextNodeId, null, this.getPageCache());
            }
            catch (Exception ex) {
                log.error("", (Throwable)ex);
                this.getView().showErrorNotification(ex.getMessage());
            }
            finally {
                stats.addInfo("end-searchTree");
                log.info(stats.toString());
            }
        }
    }

    private void queryParent(String selectNodeId, List<String> expandIds, Map<String, String> treeParentMap) {
        if (StringUtils.isEmpty((String)selectNodeId)) {
            return;
        }
        String parentId = treeParentMap.get(selectNodeId);
        if (StringUtils.isNotEmpty((String)parentId)) {
            expandIds.add(parentId);
            this.queryParent(parentId, expandIds, treeParentMap);
        }
    }
}

