/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.memberf7.newf7.base;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.events.QueryExceedMaxCountEvent;
import kd.bos.list.events.QueryExceedMaxCountListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.epm.eb.business.tree.MemberTreeBuilder;
import kd.epm.eb.common.member.f7.F7TreeUtils;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.memberf7.newf7.face.ISelectedF7Cache;
import kd.epm.eb.formplugin.memberf7.newf7.face.ITreeCache;
import kd.epm.eb.formplugin.memberf7.newf7.face.IVirtualF7Param;

public abstract class AbstractVirtualListF7
extends AbstractListPlugin
implements CreateListDataProviderListener,
QueryExceedMaxCountListener,
TreeNodeClickListener,
ITreeCache,
SearchEnterListener,
IVirtualF7Param,
ISelectedF7Cache {
    protected static final Log log = LogFactory.getLog(AbstractVirtualListF7.class);

    public void initialize() {
        TreeView treeView;
        BillList billList;
        super.initialize();
        this.addClickListeners(new String[]{"btn_sure", "btncancel"});
        Search search = (Search)this.getControl("searchlist");
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
        if ((billList = (BillList)this.getControl("billlistap")) != null) {
            billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
            billList.addQueryExceedMaxCountListener((QueryExceedMaxCountListener)this);
        }
        if ((treeView = (TreeView)this.getControl("lefttree")) != null) {
            MemberTreeBuilder.registerNodeListener((TreeView)treeView, (TreeNodeClickListener)this);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        List<Map<String, Object>> virtualData = this.getVirtualData();
        if (this.isCacheVirtualData()) {
            F7TreeUtils.cacheData((IPageCache)this.getPageCache(), (String)"VIRTUAL_F7_DATA", virtualData);
            this.getPageCache().put("VIRTUAL_F7_DATA_COUNT", String.valueOf(virtualData != null ? virtualData.size() : 0));
        }
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs args) {
        if (args.getSource() instanceof BillList) {
            args.setListDataProvider((IListDataProvider)this.getVirtualDataProvider(this.getView(), this.getModel(), this.getPageCache(), this.getF7Parameter()));
        }
    }

    protected abstract ListDataProvider getVirtualDataProvider(IFormView var1, IDataModel var2, IPageCache var3, MemberF7Parameter var4);

    protected abstract MemberF7Parameter getF7Parameter();

    public void queryExceedMaxCount(QueryExceedMaxCountEvent event) {
        event.setCancel(true);
        event.setDataCount(this.getVirtualDataCount());
    }

    protected int getVirtualDataCount() {
        int count = 0;
        String _count = this.getPageCache().get("VIRTUAL_F7_DATA_COUNT");
        if (StringUtils.isNotEmpty((String)_count)) {
            try {
                count = Integer.parseInt(_count);
            }
            catch (Exception ex) {
                log.warn("getVirtualDataCount", (Throwable)ex);
            }
        }
        return count;
    }

    protected List<Map<String, Object>> getVirtualData() {
        return Collections.emptyList();
    }

    protected boolean isCacheVirtualData() {
        return true;
    }

    public void click(EventObject evt) {
        String clickKey;
        super.click(evt);
        switch (clickKey = ((Control)evt.getSource()).getKey()) {
            case "btn_sure": {
                this.click_submit(evt);
                break;
            }
            case "btncancel": {
                this.click_cancel(evt);
                break;
            }
        }
    }

    protected abstract void click_submit(EventObject var1);

    protected abstract void click_cancel(EventObject var1);

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        this.cacheNodeId(this.getPageCache(), nodeId);
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
    }
}

