/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.memberf7.newf7.base;

import java.util.EventObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.epm.eb.business.tree.MemberTreeBuilder;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.memberf7.newf7.face.ISearchTreeCache;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractVirtualTreeF7
extends AbstractFormPlugin
implements SearchEnterListener,
TreeNodeClickListener,
TreeNodeQueryListener,
TreeNodeCheckListener,
ISearchTreeCache {
    public void initialize() {
        super.initialize();
        TreeView treeView = (TreeView)this.getControl("lefttree");
        if (treeView != null) {
            MemberTreeBuilder.registerNodeListener((TreeView)treeView, (TreeNodeClickListener)this);
            MemberTreeBuilder.registerNodeCheckListener((TreeView)treeView, (TreeNodeCheckListener)this);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getControl("treesearch");
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
        this.addClickListeners(new String[]{"treeup", "treedown"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
    }

    protected void initData() {
        this.init_base();
        this.init_leftTree(null);
    }

    protected abstract void init_base();

    protected abstract void init_leftTree(MemberF7Parameter var1);

    public void click(EventObject evt) {
        String clickKey;
        super.click(evt);
        switch (clickKey = ((Control)evt.getSource()).getKey()) {
            case "treeup": {
                this.click_TreeSearchUp(evt);
                break;
            }
            case "treedown": {
                this.click_TreeSearchDown(evt);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        this.treeNode_stepLoad(evt);
    }

    protected abstract void treeNode_stepLoad(TreeNodeEvent var1);

    public void search(SearchEnterEvent evt) {
        Search _search = (Search)evt.getSource();
        String _text = evt.getText();
        if (_search == null || StringUtils.isEmpty((String)_text)) {
            this.clearSearchTreeCache(this.getPageCache());
            return;
        }
        String oldSearchText = this.getPageCache().get("CACHE_SEARCH_TEXT");
        if (!StringUtils.equals((String)oldSearchText, (String)_search.getKey())) {
            this.clearSearchTreeCache(this.getPageCache());
        }
        if ("treesearch".equals(_search.getKey())) {
            this.searchTree(_text.trim(), true);
        }
    }

    @Override
    public void clearSearchTreeCache(@NotNull IPageCache pageCache) {
        ISearchTreeCache.super.clearSearchTreeCache(pageCache);
        this.getPageCache().remove("CACHE_SEARCH_TEXT");
        this.getPageCache().remove("CACHE_SEARCH_DATA");
        this.getPageCache().remove("CACHE_LIST_ROW_INDEX");
    }

    protected void click_TreeSearchUp(EventObject evt) {
        Search search = (Search)this.getControl("treesearch");
        if (search != null && StringUtils.isNotEmpty((String)search.getSearchKey())) {
            this.searchTree(search.getSearchKey(), false);
        }
    }

    protected void click_TreeSearchDown(EventObject evt) {
        Search search = (Search)this.getControl("treesearch");
        if (search != null && StringUtils.isNotEmpty((String)search.getSearchKey())) {
            this.searchTree(search.getSearchKey(), true);
        }
    }

    protected abstract void searchTree(String var1, boolean var2);
}

