/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.memberf7.newf7.face;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.tree.CusPropertyTreeBuilder;
import kd.epm.eb.business.tree.MemberTreeBuilder;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.dimension.EntityAdjustPlugin;
import kd.epm.eb.formplugin.memberf7.newf7.base.SearchControlPojo;
import kd.epm.eb.formplugin.memberf7.newf7.face.ISearchTreeCache;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;
import org.jetbrains.annotations.NotNull;

public interface ISearchTree
extends SearchEnterListener,
ISearchTreeCache,
TreeNodeQueryListener {
    public static final Log logTree = LogFactory.getLog(EntityAdjustPlugin.class);

    default public SearchControlPojo getMemberTreePojo() {
        return new SearchControlPojo("lefttree", "treesearch", "treedown", "treeup");
    }

    default public SearchControlPojo getPropertyTreePojo() {
        return new SearchControlPojo("treeproperty", "propertysearch", "propretydown", "propertyup");
    }

    default public SearchControlPojo getRightTreePojo() {
        return new SearchControlPojo("righttree", "searchlist", "listdown", "listup");
    }

    default public void innerInitialize() {
        this.innerInitializeProperty();
        this.innerInitializeSearch(this.getMemberTreePojo());
        this.innerInitializeSearch(this.getPropertyTreePojo());
        this.innerInitializeSearch(this.getRightTreePojo());
    }

    default public void innerInitializeProperty() {
        TreeView propertyTree;
        MemberF7Parameter _f7Param = this.getF7Parameter();
        if (this.getPropertyTreePojo() != null && _f7Param != null && _f7Param.isShowCustomProperty() && _f7Param.canShowCustomProperty() && (propertyTree = (TreeView)this.getPlugin().getControl(this.getPropertyTreePojo().getTreeKey())) != null) {
            Map properties = propertyTree.getCustomProperties();
            properties.put("cpn", Boolean.FALSE);
            this.getPlugin().getView().updateControlMetadata(this.getPropertyTreePojo().getTreeKey(), properties);
            if (!_f7Param.isMultiSelect()) {
                propertyTree.setMulti(_f7Param.isMultiSelect());
            }
            MemberTreeBuilder.registerQueryListener((TreeView)propertyTree, (TreeNodeQueryListener)this);
        }
    }

    default public void initPropertyTree() {
        MemberF7Parameter f7Param = this.getF7Parameter();
        if (this.getPropertyTreePojo() != null && f7Param != null && f7Param.isShowCustomProperty() && f7Param.canShowCustomProperty()) {
            CusPropertyTreeBuilder.get((MemberF7Parameter)f7Param).buildTree((TreeView)this.getPlugin().getControl(this.getPropertyTreePojo().getTreeKey()), this.getPlugin().getPageCache());
        }
    }

    default public void queryTreeNodeChildren(TreeNodeEvent evt) {
        this.treeNode_stepLoad(evt);
    }

    default public void treeNode_stepLoad(TreeNodeEvent evt) {
        TreeView treeView = (TreeView)evt.getSource();
        String nodeId = (String)evt.getNodeId();
        try {
            if (nodeId != null) {
                this.treeStepLoad(treeView, nodeId);
            }
        }
        catch (Exception e) {
            this.getPlugin().getView().showErrorNotification(e.getMessage());
        }
    }

    default public void treeStepLoad(@NotNull TreeView treeView, @NotNull String nodeId) throws Exception {
        if ("treeproperty".equals(treeView.getKey())) {
            CusPropertyTreeBuilder.get((MemberF7Parameter)this.getF7Parameter()).stepLoadTree(treeView, Collections.singletonList(nodeId), "CACHE_TREE_PROPERTY_NODE_DATA", null, null, this.getPlugin().getPageCache());
        }
    }

    default public AbstractFormPlugin getPlugin() {
        return (AbstractFormPlugin)this;
    }

    default public List<String> queryOrgIdByProperty(List<String> selectedNodes, Long viewId) {
        if (selectedNodes == null || selectedNodes.isEmpty()) {
            return selectedNodes;
        }
        Long modelId = IDUtils.toLong(PluginUtils.getCustomParams(this.getPlugin().getView(), "model"));
        Long dimensionId = IDUtils.toLong(PluginUtils.getCustomParams(this.getPlugin().getView(), "dimensionId"));
        List members = MemberPropCacheService.getOrCreate((Long)modelId).getMembersByPropValues(dimensionId, viewId, IDUtils.toLongs(selectedNodes));
        if (members == null || members.isEmpty()) {
            return new ArrayList<String>(1);
        }
        members.sort((m1, m2) -> Integer.compare(m1.getLevel(), m2.getLevel()));
        ArrayList<String> ids = new ArrayList<String>(members.size());
        members.forEach(f -> ids.add(String.valueOf(f.getId())));
        return ids;
    }

    public MemberF7Parameter getF7Parameter();

    default public void innerInitializeSearch(SearchControlPojo pojo) {
        Search search;
        if (pojo == null || StringUtils.isEmpty((String)pojo.getTreeKey())) {
            return;
        }
        if (StringUtils.isNotEmpty((String)pojo.getSearchKey()) && (search = (Search)this.getPlugin().getControl(pojo.getSearchKey())) != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
        if (StringUtils.isNotEmpty((String)pojo.getDownKey())) {
            this.getPlugin().addClickListeners(new String[]{pojo.getDownKey()});
        }
        if (StringUtils.isNotEmpty((String)pojo.getUpKey())) {
            this.getPlugin().addClickListeners(new String[]{pojo.getUpKey()});
        }
    }

    default public void click_search(EventObject evt) {
        String clickKey = ((Control)evt.getSource()).getKey();
        SearchControlPojo pojo = this.getMemberTreePojo();
        if (pojo != null) {
            if (clickKey.equals(pojo.getUpKey())) {
                this.click_TreeSearchUp(evt, pojo);
            } else if (clickKey.equals(pojo.getDownKey())) {
                this.click_TreeSearchDown(evt, pojo);
            }
        }
        if ((pojo = this.getPropertyTreePojo()) != null) {
            if (clickKey.equals(pojo.getUpKey())) {
                this.click_PropertySearchUp(evt);
            } else if (clickKey.equals(pojo.getDownKey())) {
                this.click_PropertySearchDown(evt);
            }
        }
        if ((pojo = this.getRightTreePojo()) != null) {
            if (clickKey.equals(pojo.getUpKey())) {
                this.click_TreeSearchUp(evt, pojo);
            } else if (clickKey.equals(pojo.getDownKey())) {
                this.click_TreeSearchDown(evt, pojo);
            }
        }
    }

    default public void removeLeftSearchText() {
        this.getPlugin().getPageCache().remove("lefttreesearchtext");
    }

    default public void removeRightSearchText() {
        this.getPlugin().getPageCache().remove("righttreesearchtext");
    }

    default public void search(SearchEnterEvent evt) {
        Search _search = (Search)evt.getSource();
        String _text = evt.getText();
        if (_search == null || StringUtils.isEmpty((String)_text)) {
            this.clearSearchTreeCache(this.getPlugin().getPageCache());
            if (this.getMemberTreePojo() != null && this.getMemberTreePojo().getSearchKey() != null && this.getMemberTreePojo().getSearchKey().equals(_search == null ? null : _search.getKey())) {
                this.getPlugin().getPageCache().remove("lefttreesearchtext");
            } else if (this.getRightTreePojo() != null && this.getRightTreePojo().getSearchKey() != null && this.getRightTreePojo().getSearchKey().equals(_search == null ? null : _search.getKey())) {
                this.getPlugin().getPageCache().remove("righttreesearchtext");
            }
            return;
        }
        if (this.getMemberTreePojo() != null && this.getMemberTreePojo().getSearchKey() != null && this.getMemberTreePojo().getSearchKey().equals(_search.getKey())) {
            String oldtext = this.getPlugin().getPageCache().get("lefttreesearchtext");
            this.getPlugin().getPageCache().put("lefttreesearchtext", _text);
            if (StringUtils.equals((String)oldtext, (String)_text)) {
                this.click_TreeSearchDown((EventObject)evt, this.getMemberTreePojo());
            } else {
                this.searchTree(_search, _text.trim(), this.getMemberTreePojo());
            }
        } else if (this.getPropertyTreePojo() != null && this.getPropertyTreePojo().getSearchKey() != null && this.getPropertyTreePojo().getSearchKey().equals(_search.getKey())) {
            this.searchProperty(_search, _text.trim());
        } else if (this.getRightTreePojo() != null && this.getRightTreePojo().getSearchKey() != null && this.getRightTreePojo().getSearchKey().equals(_search.getKey())) {
            String oldtext = this.getPlugin().getPageCache().get("righttreesearchtext");
            this.getPlugin().getPageCache().put("righttreesearchtext", _text);
            if (StringUtils.equals((String)oldtext, (String)_text)) {
                this.click_TreeSearchDown((EventObject)evt, this.getRightTreePojo());
            } else {
                this.searchTree(_search, _text.trim(), this.getRightTreePojo());
            }
        }
    }

    default public void searchTree(Search search, String searchText, SearchControlPojo pojo) {
        this.searchTree(searchText, true, pojo);
    }

    default public void click_TreeSearchUp(EventObject evt, SearchControlPojo pojo) {
        Search search = (Search)this.getPlugin().getControl(pojo.getSearchKey());
        if (search != null && StringUtils.isNotEmpty((String)search.getSearchKey())) {
            TreeSearchUtil.getLeftOrRight(this.getPlugin().getPageCache(), this.getPlugin().getView(), new TreeSearchUtil.TreeSearchParam(pojo.getTreeKey(), pojo.getTreeCacheKey(), pojo.getTreeKey(), TreeSearchUtil.SearchBtnStatus.LEFT));
        }
    }

    default public void click_TreeSearchDown(EventObject evt, SearchControlPojo pojo) {
        Search search = (Search)this.getPlugin().getControl(pojo.getSearchKey());
        if (search != null && StringUtils.isNotEmpty((String)search.getSearchKey())) {
            TreeSearchUtil.getLeftOrRight(this.getPlugin().getPageCache(), this.getPlugin().getView(), new TreeSearchUtil.TreeSearchParam(pojo.getTreeKey(), pojo.getTreeCacheKey(), pojo.getTreeKey(), TreeSearchUtil.SearchBtnStatus.RIGHT));
        }
    }

    default public void searchTree(String searchText, boolean hasDown, SearchControlPojo pojo) {
        TreeSearchUtil.TreeSearchParam param = new TreeSearchUtil.TreeSearchParam(pojo.getTreeKey(), pojo.getTreeCacheKey(), pojo.getTreeKey(), hasDown ? TreeSearchUtil.SearchBtnStatus.RIGHT : TreeSearchUtil.SearchBtnStatus.LEFT);
        TreeSearchUtil.searchMember(searchText, this.getPlugin().getView(), this.getPlugin().getPageCache(), param);
    }

    default public void searchProperty(Search search, String searchText) {
        this.searchProperty(searchText, true);
    }

    default public void click_PropertySearchDown(EventObject evt) {
        Search search;
        if (this.getPropertyTreePojo() != null && StringUtils.isNotEmpty((String)this.getPropertyTreePojo().getDownKey()) && (search = (Search)this.getPlugin().getControl(this.getPropertyTreePojo().getSearchKey())) != null && StringUtils.isNotEmpty((String)search.getSearchKey())) {
            this.searchProperty(search.getSearchKey(), true);
        }
    }

    default public void click_PropertySearchUp(EventObject evt) {
        Search search;
        if (this.getPropertyTreePojo() != null && StringUtils.isNotEmpty((String)this.getPropertyTreePojo().getDownKey()) && (search = (Search)this.getPlugin().getControl(this.getPropertyTreePojo().getSearchKey())) != null && StringUtils.isNotEmpty((String)search.getSearchKey())) {
            this.searchProperty(search.getSearchKey(), false);
        }
    }

    default public void searchProperty(String searchText, boolean hasDown) {
        LogStats stats = new LogStats("budget-log : ");
        stats.addInfo("begin-searchProperty.");
        Map currPropertyValue = this.getSearchPropertyByCache(this.getPlugin().getPageCache());
        List<Object> propertyIds = this.queryProperty();
        DynamicObject propValue = this.queryPropertyValue(propertyIds, currPropertyValue, searchText, hasDown);
        if (propValue == null && currPropertyValue != null) {
            propValue = this.queryPropertyValue(propertyIds, null, searchText, hasDown);
        }
        if (propValue != null) {
            String propertyId = propValue.getString("property.id");
            String propValueId = propValue.getString("id");
            this.cacheSearchPropertyTree(this.getPlugin().getPageCache(), propValue);
            TreeView propView = (TreeView)this.getPlugin().getControl("treeproperty");
            if (propView != null) {
                try {
                    CusPropertyTreeBuilder.get((MemberF7Parameter)this.getF7Parameter()).stepLoadTree(propView, CollectionUtils.asList((Object[])new String[]{propertyId, propValueId}), "CACHE_TREE_PROPERTY_NODE_DATA", propValueId, null, this.getPlugin().getPageCache());
                }
                catch (Exception e) {
                    logTree.error("stepLoadTree-error", (Throwable)e);
                }
            }
        } else {
            this.getPlugin().getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u9879", (String)"MemberSingleTreeF7_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
            this.clearSearchPropertyCache(this.getPlugin().getPageCache());
        }
        stats.addInfo("end-searchProperty.");
        logTree.info(stats.toString());
    }

    default public TreeSearchUtil.TreeSearchParam getPropertySearchParam(boolean hasDown) {
        return new TreeSearchUtil.TreeSearchParam(this.getPropertyTreePojo().getTreeKey(), this.getPropertyTreePojo().getTreeCacheKey(), "_property", hasDown ? TreeSearchUtil.SearchBtnStatus.RIGHT : TreeSearchUtil.SearchBtnStatus.LEFT);
    }

    default public DynamicObject queryPropertyValue(List<Object> propertyIds, Map<String, Object> currPropertyValue, String searchText, boolean hasDown) {
        if (propertyIds == null || propertyIds.isEmpty()) {
            return null;
        }
        QFBuilder builder = new QFBuilder();
        builder.add("property", "in", propertyIds);
        if (currPropertyValue != null) {
            int propertySeq = (Integer)currPropertyValue.get("property.dseq");
            String propValNumber = (String)currPropertyValue.get("number");
            if (hasDown) {
                QFilter equalsFilter = new QFilter("property.dseq", "=", (Object)propertySeq).and("number", ">", (Object)propValNumber);
                QFilter largeFilter = new QFilter("property.dseq", ">", (Object)propertySeq);
                equalsFilter.or(largeFilter);
                builder.add(equalsFilter);
            } else {
                QFilter equalsFilter = new QFilter("property.dseq", "=", (Object)propertySeq).and("number", "<", (Object)propValNumber);
                QFilter lessFilter = new QFilter("property.dseq", "<", (Object)propertySeq);
                equalsFilter.or(lessFilter);
                builder.add(equalsFilter);
            }
        }
        builder.add(new QFilter("number", "like", (Object)("%" + searchText + "%")).or("name", "like", (Object)("%" + searchText + "%")));
        String order = hasDown ? "property.dseq,number" : "property.dseq desc,number desc";
        DynamicObjectCollection values = QueryServiceHelper.query((String)"eb_custompropertyvalue", (String)"id,number,name,property.id,property.number,property.dseq", (QFilter[])builder.toArray(), (String)order, (int)1);
        return values == null || values.isEmpty() ? null : (DynamicObject)values.get(0);
    }

    default public List<Object> queryProperty() {
        return QueryServiceHelper.queryPrimaryKeys((String)"eb_customproperty", (QFilter[])this.getPropertyQFBuilder().toArray(), (String)"number", (int)100);
    }

    default public QFBuilder getPropertyQFBuilder() {
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)this.getModelId());
        builder.add("dimension", "=", (Object)this.getDimensionId());
        return builder;
    }

    default public Long getModelId() {
        return IDUtils.toLong(PluginUtils.getCustomParams(this.getPlugin().getView(), "model"));
    }

    default public Long getDimensionId() {
        return IDUtils.toLong(PluginUtils.getCustomParams(this.getPlugin().getView(), "dimensionId"));
    }

    public static class SearchQuery {
        public Member currMember;
        public String fields;
        public List<QFilter> filters;
        public QFilter direction;
        public String orderBy;
        public String searchText;
        public boolean hasDown;

        public SearchQuery(Member currMember, String fields, List<QFilter> filters, QFilter direction, String orderBy, String searchText, boolean hasDown) {
            this.currMember = currMember;
            this.fields = fields;
            this.filters = filters;
            this.direction = direction;
            this.orderBy = orderBy;
            this.searchText = searchText;
            this.hasDown = hasDown;
        }
    }
}

