/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.memberf7.newf7.face;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.list.F7SelectedList;
import kd.epm.eb.common.spread.util.GZIPUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.memberf7.newf7.SelectedMember;
import org.jetbrains.annotations.NotNull;

public interface ISelectedF7Cache {
    default public void cacheSelectMember(@NotNull IPageCache pageCache, Map<String, Map<String, String>> selectMembers) {
        if (selectMembers == null || selectMembers.isEmpty()) {
            pageCache.remove("LIST_MEMBER_CACHE_SELECT");
        } else {
            pageCache.put("LIST_MEMBER_CACHE_SELECT", SerializationUtils.serializeToBase64((Object)GZIPUtils.compress((String)JSON.toJSONString(selectMembers))));
        }
    }

    default public LinkedHashMap<String, Map<String, String>> getSelectedIdsFromCache(@NotNull IPageCache pageCache) {
        LinkedHashMap selectMembers;
        String _cacheStr = pageCache.get("LIST_MEMBER_CACHE_SELECT");
        if (StringUtils.isNotEmpty((String)_cacheStr)) {
            _cacheStr = GZIPUtils.uncompressToString((byte[])((byte[])SerializationUtils.deSerializeFromBase64((String)_cacheStr)));
            selectMembers = (LinkedHashMap)JSON.parseObject((String)_cacheStr, LinkedHashMap.class);
        } else {
            selectMembers = new LinkedHashMap();
        }
        return selectMembers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public void putSelectedMember(@NotNull Map<String, Map<String, String>> selectMembers, Collection<?> objects, @NotNull String memberType) {
        if (objects == null || objects.isEmpty()) {
            return;
        }
        String showNumber = null;
        Boolean isShowNumber = null;
        for (Object _object : objects) {
            String name;
            String number;
            String pk;
            if (_object == null) continue;
            if (_object instanceof DynamicObject) {
                pk = StringUtils.equals((String)((DynamicObject)_object).getDataEntityType().getName(), (String)"eb_viewmember") ? ((DynamicObject)_object).getString("memberid") : ((DynamicObject)_object).getString("id");
                number = ((DynamicObject)_object).getString("number");
                name = ((DynamicObject)_object).getString("name");
                if (isShowNumber == null) {
                    isShowNumber = ((DynamicObject)_object).getDataEntityType().getProperties().containsKey((Object)"shownumber");
                }
                showNumber = isShowNumber != false ? ((DynamicObject)_object).getString("shownumber") : null;
            } else {
                if (!_object.getClass().isArray()) throw new IllegalStateException();
                Object[] arrays = (Object[])_object;
                if (arrays.length < 3) throw new IllegalStateException();
                pk = (String)arrays[0];
                number = (String)arrays[1];
                name = (String)arrays[2];
            }
            HashMap<String, String> _memberData = new HashMap<String, String>(16);
            _memberData.put("id", pk);
            _memberData.put("nu", number);
            _memberData.put("na", name);
            _memberData.put("ty", memberType);
            _memberData.put("snu", showNumber);
            selectMembers.put(pk, _memberData);
        }
    }

    default public void putSelectedMember(@NotNull Map<String, Map<String, String>> selectMembers, SelectedMember member) {
        if (member == null) {
            return;
        }
        String pk = IDUtils.toString((Object)member.getId());
        HashMap<String, String> _memberData = new HashMap<String, String>(16);
        _memberData.put("id", pk);
        _memberData.put("nu", member.getNumber());
        _memberData.put("snu", member.getShowNumber());
        _memberData.put("na", member.getName());
        _memberData.put("sc", member.scope());
        _memberData.put("ty", member.getType());
        _memberData.put("ln", member.getLongNumber());
        _memberData.put("le", String.valueOf(member.getLevel()));
        _memberData.put("ex", member.isExclude() ? "1" : "0");
        selectMembers.put(pk, _memberData);
    }

    default public void updateSelected(IFormView formView, IPageCache pageCache) {
        if (formView == null || pageCache == null) {
            return;
        }
        F7SelectedList selectedF7 = (F7SelectedList)formView.getControl("rightselect");
        LinkedHashMap<String, Map<String, String>> selectedMembers = this.getSelectedIdsFromCache(pageCache);
        ArrayList<ValueTextItem> valueTextItems = new ArrayList<ValueTextItem>(selectedMembers.size());
        for (Map member : selectedMembers.values()) {
            if (member.containsKey("snu")) {
                valueTextItems.add(new ValueTextItem((String)member.get("id"), (String)member.get("na") + "(" + (String)member.get("snu") + ")"));
                continue;
            }
            valueTextItems.add(new ValueTextItem((String)member.get("id"), (String)member.get("na") + "(" + (String)member.get("nu") + ")"));
        }
        selectedF7.addItems(valueTextItems);
    }
}

