/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.memberf7.rangef7;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CustomPropertyMemberPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (customParams != null) {
            Object datasetIds;
            Long modelId = IDUtils.toLong(customParams.get("model"));
            Long dimensionId = IDUtils.toLong(customParams.get("dimId"));
            Long propertyValueId = IDUtils.toLong(customParams.get("propertyValueId"));
            String dimNumber = (String)customParams.get("dimNumber");
            Boolean needCheckPerm = (Boolean)customParams.get("needCheckPerm");
            long bizModel = 0L;
            if (StringUtils.isNotEmpty((CharSequence)(customParams.get("bizModel") + ""))) {
                bizModel = IDUtils.toLong(customParams.get("bizModel"));
            }
            long datasetId = (datasetIds = customParams.get("datasetIds")) != null ? IDUtils.toLong(((List)datasetIds).get(0)) : 0L;
            Object viewIdStr = customParams.get("viewId");
            long viewId = 0L;
            if (viewIdStr != null && !"null".equals(viewIdStr)) {
                viewId = Long.parseLong(String.valueOf(viewIdStr));
                if (viewId == 0L) {
                    viewId = BusinessModelServiceHelper.getInstance().getViewId(Long.valueOf(bizModel), dimNumber, modelId);
                }
            } else {
                viewId = BusinessModelServiceHelper.getInstance().getViewId(Long.valueOf(bizModel), dimNumber, modelId);
            }
            MemberPropCache propCache = MemberPropCacheService.getOrCreate((Long)modelId);
            List propertyMemberSort = propCache.getMembersByPropValues(dimensionId, Long.valueOf(viewId), propertyValueId);
            Set permMembIds = null;
            if (needCheckPerm.booleanValue()) {
                permMembIds = DimMembPermHelper.getReadPermMembIds((String)dimNumber, (Long)modelId, (Long)bizModel, (Long)viewId, (boolean)true);
            }
            if (SysDimensionEnum.Account.getNumber().equals(dimNumber) && datasetId > 0L) {
                propertyMemberSort = propertyMemberSort.stream().filter(m -> m.getDatasetId() == datasetId).collect(Collectors.toList());
            }
            this.refreshEntity(propertyMemberSort, permMembIds);
        }
    }

    private void refreshEntity(List<Member> propertyMemberSort, Set<Long> permMembIds) {
        if (CollectionUtils.isNotEmpty(propertyMemberSort)) {
            Dimension dimension = null;
            if (permMembIds == null) {
                this.getModel().beginInit();
                this.getModel().batchCreateNewEntryRow("entryentity", propertyMemberSort.size());
                this.getModel().endInit();
                for (int i = 0; i < propertyMemberSort.size(); ++i) {
                    Member member2 = propertyMemberSort.get(i);
                    if (dimension == null) {
                        dimension = member2.getDimension();
                    }
                    DynamicObject dynamicObject = this.getModel().getEntryRowEntity("entryentity", i);
                    dynamicObject.set("dimnumber", (Object)dimension.getNumber());
                    dynamicObject.set("dimname", (Object)dimension.getName());
                    dynamicObject.set("membernumber", (Object)member2.getNumber());
                    dynamicObject.set("membername", (Object)member2.getName());
                }
            } else {
                List collect = propertyMemberSort.stream().filter(member -> permMembIds.contains(member.getId())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(collect)) {
                    return;
                }
                this.getModel().beginInit();
                this.getModel().batchCreateNewEntryRow("entryentity", collect.size());
                this.getModel().endInit();
                for (int i = 0; i < collect.size(); ++i) {
                    Member member3 = (Member)collect.get(i);
                    if (dimension == null) {
                        dimension = member3.getDimension();
                    }
                    DynamicObject dynamicObject = this.getModel().getEntryRowEntity("entryentity", i);
                    dynamicObject.set("dimnumber", (Object)dimension.getNumber());
                    dynamicObject.set("dimname", (Object)dimension.getName());
                    dynamicObject.set("membernumber", (Object)member3.getNumber());
                    dynamicObject.set("membername", (Object)member3.getName());
                }
            }
            this.getModel().endInit();
        }
    }
}

