/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.model;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.base.BaseView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.FyEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.model.ModelValidatorUtils;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.FormUtils;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.cube.model.DetailedPeriodEnum;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.epbs.business.bd.model.ModelSyncHelper;

public class BgmdModelEdit
extends AbstractBasePlugin
implements ClickListener {
    private static Log log = LogFactory.getLog(BgmdModelEdit.class);
    private static String SYSPERIOD = "sysperiod";
    private static Boolean aTrue = Boolean.TRUE;
    private static Boolean aFalse = Boolean.FALSE;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_edit"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        LocalDate today = LocalDate.now();
        int curYear = today.getYear();
        int firstYear = 1997;
        int index = curYear - firstYear + 1;
        this.getView().setVisible(aFalse, new String[]{"userdimension", "sysperiod"});
        IDataModel iDataModel = this.getModel();
        iDataModel.setValue("startfy", (Object)String.valueOf(index - 1));
        iDataModel.setValue("reporttype", (Object)(this.isEb() != false ? "4" : "7"));
        if (this.isEb().booleanValue()) {
            iDataModel.setValue("datasource", (Object)this.getDataSource());
            this.buildPeriodComboEdit();
            this.getModel().setValue("containperiod", (Object)DetailedPeriodEnum.PulldownValue.PHalfYearAndSeason.getKey());
            this.getModel().setValue("mincludeqrt", (Object)aTrue);
            this.getModel().setValue("mincludeyear", (Object)aTrue);
        }
        if (this.isNewEbForm()) {
            this.getModel().setValue("reporttype", (Object)"6");
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        IDataModel iDataModel = this.getModel();
        IFormView iFormView = this.getView();
        int preYear = (Integer)iDataModel.getValue("presetyear");
        if (preYear == 0) {
            iDataModel.setValue("presetyear", (Object)1);
        }
        iFormView.setVisible(aTrue, new String[]{"btn_edit"});
        iFormView.setVisible(aFalse, new String[]{"btn_save"});
        if (((Boolean)this.getModel().getValue("monthinclude13")).booleanValue()) {
            iFormView.setEnable(aFalse, new String[]{"monthinclude13"});
        }
        IPageCache iPageCache = this.getPageCache();
        iPageCache.put("startfy", iDataModel.getValue("startfy").toString());
        Object startdatasource = iDataModel.getValue("datasource");
        if (startdatasource != null) {
            iPageCache.put("startdatasource", ((DynamicObject)startdatasource).getString("id"));
        }
        int firstYear = Integer.parseInt(iDataModel.getValue("startfy").toString()) + 1997 - 1;
        String firstMonth = iDataModel.getValue("beginperiod").toString();
        String beginYearType = iDataModel.getValue("beginyearofmonth").toString();
        if (FyEnum.PRE.getIndex().equals(beginYearType)) {
            --firstYear;
        }
        this.getPageCache().put("firstYearBeforeEdit", String.valueOf(firstYear));
        this.getPageCache().put("firstMonthBeforeEdit", firstMonth);
        iFormView.setEnable(aFalse, new String[]{this.isEb() != false ? "fp_preperiod" : "sysperiod"});
        iFormView.setEnable(aFalse, new String[]{"presetyear"});
        this.initUserDimValue();
        if (this.isEb().booleanValue()) {
            this.buildPeriodComboEdit();
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"startfy"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.buildStartYears();
        this.hideItems();
        this.getModel().setDataChanged(false);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String key = ((Control)e.getSource()).getKey();
        Object value = e.getValue();
        IDataModel iDataModel = this.getModel();
        IFormView iFormView = this.getView();
        if (this.isEdit() && "startfy".equals(key)) {
            int diff = Integer.parseInt(this.getPageCache().get("startfy")) - Integer.parseInt(value.toString());
            if (diff < 0) {
                iFormView.showTipNotification(ResManager.loadKDString((String)"\u8d22\u5e74\u9009\u62e9\u4e0d\u5f97\u665a\u4e8e\u539f\u59cb\u8bbe\u7f6e\u3002", (String)"BgmdModelEdit_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                iFormView.updateView("startfy");
            } else {
                iDataModel.setValue("presetyear", (Object)(Integer.parseInt(iDataModel.getValue("presetyear").toString()) + diff));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IFormView iFormView = this.getView();
        IDataModel iDataModel = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        Object propValue = changeData.getNewValue();
        switch (propName) {
            case "isdetailtomonth": {
                if (((Boolean)propValue).booleanValue()) {
                    iFormView.setEnable(aTrue, new String[]{"mincludeqrt", "mincludeyear", "monthinclude13"});
                    iDataModel.setValue("isdetailtoqrt", (Object)aFalse);
                    iDataModel.setValue("isdetailtohalfyear", (Object)aFalse);
                    break;
                }
                iFormView.setEnable(aFalse, new String[]{"mincludeqrt", "mincludeyear", "monthinclude13"});
                iDataModel.setValue("mincludeqrt", (Object)aFalse);
                iDataModel.setValue("mincludeyear", (Object)aFalse);
                iDataModel.setValue("monthinclude13", (Object)aFalse);
                break;
            }
            case "isdetailtoqrt": {
                if (((Boolean)propValue).booleanValue()) {
                    iFormView.setEnable(aTrue, new String[]{"qrtincludeyear"});
                    iDataModel.setValue("isdetailtomonth", (Object)aFalse);
                    iDataModel.setValue("isdetailtohalfyear", (Object)aFalse);
                    break;
                }
                iFormView.setEnable(aFalse, new String[]{"qrtincludeyear"});
                iDataModel.setValue("qrtincludeyear", (Object)aFalse);
                break;
            }
            case "isdetailtohalfyear": {
                if (!((Boolean)propValue).booleanValue()) break;
                iDataModel.setValue("isdetailtoqrt", (Object)aFalse);
                iDataModel.setValue("isdetailtomonth", (Object)aFalse);
                break;
            }
            case "beginyearofmonth": {
                ArrayList<String[]> months = new ArrayList<String[]>(12);
                int startM = 1;
                if (FyEnum.PRE.getIndex().equals(iDataModel.getValue("beginyearofmonth"))) {
                    startM = 2;
                }
                for (int i = startM; i < 13; ++i) {
                    months.add(new String[]{ResManager.loadResFormat((String)"%1\u6708", (String)"BgmdModelEdit_1", (String)"epm-eb-formplugin", (Object[])new Object[]{i}), i + ""});
                }
                ComboEdit monthcom = (ComboEdit)iFormView.getControl("beginperiod");
                FormUtils.customDynamicEnum(months, (ComboEdit)monthcom);
                iDataModel.setValue("beginperiod", (Object)((String[])months.get(0))[1]);
                break;
            }
            case "detailedto": {
                String key = propValue.toString();
                this.getModel().setValue(key, (Object)aTrue);
                this.buildSubPeriodComboEdit(key);
                break;
            }
            case "containperiod": {
                String newValue = propValue.toString();
                if (newValue.contains("+")) {
                    this.getModel().setValue("mincludeqrt", (Object)aTrue);
                    this.getModel().setValue("mincludeyear", (Object)aTrue);
                    break;
                }
                List legalKeys = DetailedPeriodEnum.getSubEnumLegalKeys((String)this.getModel().getValue("detailedto").toString());
                if (!DetailedPeriodEnum.PulldownValue.No.getKey().equals(newValue)) {
                    this.getModel().setValue(newValue, (Object)aTrue);
                    legalKeys.remove(newValue);
                }
                for (String legalKey : legalKeys) {
                    this.getModel().setValue(legalKey, (Object)aFalse);
                }
                break;
            }
        }
    }

    private void updateBeginDateReference(Object modelID) {
        IDataModel iDataModel = this.getModel();
        int firstYear = Integer.parseInt((String)iDataModel.getValue("startfy")) + 1997 - 1;
        int firstMonth = Integer.parseInt((String)iDataModel.getValue("beginperiod"));
        String beginYearType = (String)iDataModel.getValue("beginyearofmonth");
        if (FyEnum.PRE.getIndex().equals(beginYearType)) {
            --firstYear;
        }
        String dateStr = String.valueOf(firstYear).concat("-").concat(String.valueOf(firstMonth)).concat("-01");
        String dateStr2 = this.getPageCache().get("firstYearBeforeEdit").concat("-").concat(this.getPageCache().get("firstMonthBeforeEdit")).concat("-01");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-M-dd");
        Object[] parms = new Object[3];
        try {
            parms[0] = dateFormat.parse(dateStr);
            parms[1] = dateFormat.parse(dateStr2);
        }
        catch (ParseException e) {
            log.error(e.getMessage());
        }
        parms[2] = modelID;
        DBRoute route = new DBRoute("epm");
        try {
            DB.execute((DBRoute)route, (String)"update t_eb_entitynamerecord set feffdate = ? where feffdate = ? and fid in ( SELECT fid from t_eb_structofent WHERE fmodelid = ?)", (Object[])parms);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4fee\u6539\u5931\u8d25\uff1a\u66f4\u65b0\u7ec4\u7ec7\u7684\u53d8\u66f4\u8bb0\u5f55\u7684\u751f\u6548\u65e5\u671f\u5f15\u7528\u5931\u8d25\u3002", (String)"BgmdModelEdit_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void initUserDimValue() {
        Boolean ismonth = (Boolean)this.getModel().getValue("isdetailtomonth");
        Boolean isqrt = (Boolean)this.getModel().getValue("isdetailtoqrt");
        int value = ismonth != false ? 2 : (isqrt != false ? 1 : 0);
        this.getModel().setValue("sysperiod", (Object)value);
        Object modelid = ((BaseShowParameter)this.getView().getFormShowParameter()).getPkId();
        if (modelid != null) {
            IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)Long.parseLong(modelid.toString()));
            if (orCreate != null) {
                List userDimNames = orCreate.getDimensionList().stream().filter(d -> !d.isPreset()).map(d -> d.getName()).collect(Collectors.toList());
                this.getModel().setValue("userdimension", (Object)String.join((CharSequence)",", userDimNames));
            }
            ModelCacheContext.remove();
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        ApplicationTypeEnum application = ModelUtil.queryApp((IFormView)this.getView());
        IDataModel iDataModel = this.getModel();
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("save".equals(operateKey)) {
            switch (application) {
                case BGMD: {
                    String sysperiod;
                    switch (sysperiod = (String)iDataModel.getValue(SYSPERIOD)) {
                        case "2": {
                            iDataModel.setValue("isdetailtomonth", (Object)1);
                            break;
                        }
                        case "1": {
                            iDataModel.setValue("isdetailtoqrt", (Object)1);
                            iDataModel.setValue("isdetailtomonth", (Object)0);
                            break;
                        }
                        case "0": {
                            iDataModel.setValue("isdetailtohalfyear", (Object)1);
                            iDataModel.setValue("isdetailtomonth", (Object)0);
                        }
                    }
                    break;
                }
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("save".equals(key)) {
            boolean issuccess;
            boolean bl = issuccess = e.getOperationResult().getValidateResult().isSuccess() && e.getOperationResult().isSuccess();
            if (issuccess) {
                ModelSyncHelper.saveEpbsModel((Long)((Long)e.getOperationResult().getSuccessPkIds().get(0)), (String)((String)this.getModel().getValue("reporttype")));
                this.getView().returnDataToParent(e.getOperationResult().getSuccessPkIds().get(0));
                this.getView().close();
            } else {
                List errorInfos = e.getOperationResult().getAllErrorOrValidateInfo();
                if (errorInfos == null || errorInfos.isEmpty()) {
                    this.getView().showTipNotification(e.getOperationResult().getMessage());
                }
            }
        }
    }

    private void hideItems() {
        IFormView iFormView = this.getView();
        Boolean isEb = this.isEb();
        iFormView.setVisible(isEb, new String[]{"sysperiodtag"});
        iFormView.setVisible(aFalse, new String[]{"sysperiod"});
        if (isEb.booleanValue()) {
            this.setControlWidth("startfy", iFormView);
            this.setControlWidth("presetyear", iFormView);
        } else {
            iFormView.setVisible(Boolean.valueOf(ShrekOlapServiceHelper.isStartShrek()), new String[]{"moretag"});
        }
    }

    private void setControlWidth(String key, IFormView iFormView) {
        HashMap<String, String> dataMap = new HashMap<String, String>(4);
        dataMap.put("w", "230px");
        iFormView.updateControlMetadata(key, dataMap);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_edit".equals(key)) {
            Object datasource = this.getModel().getValue("datasource");
            if (datasource == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u6e90", (String)"DataModelImportBillPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.saveModel();
        }
    }

    private void saveModel() {
        String orify = this.getPageCache().get("startfy");
        String fy = this.getModel().getValue("startfy").toString();
        Object datasource = this.getModel().getValue("datasource");
        Object modelId = ((BaseShowParameter)this.getView().getFormShowParameter()).getPkId();
        DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"epm_model");
        if (!fy.equals(orify)) {
            this.insertYear(orify, fy, model);
            model.set("startfy", (Object)fy);
            model.set("presetyear", this.getModel().getValue("presetyear"));
            this.updateBeginDateReference(modelId);
        }
        String description = this.getModel().getValue("description").toString();
        model.set("description", (Object)description);
        model.set("modifier", (Object)UserUtils.getUserId());
        model.set("modifytime", (Object)TimeServiceHelper.now());
        model.set("name", this.getModel().getValue("name"));
        model.set("datasource", datasource);
        String checkStr = ModelValidatorUtils.exitsName((DynamicObject)model);
        if (StringUtils.isNotEmpty((String)checkStr)) {
            this.getView().showTipNotification(checkStr);
            return;
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{model});
        ModelUtils.updateDataSourceState();
        CacheServiceHelper.clearCacheByScenVer();
        CubeUtils.updateCubeVersion((Long)model.getLong("id"));
        ModelCacheContext.removeModel((Long)model.getLong("id"));
        ModelSyncHelper.saveEpbsModel((Long)model.getLong("id"), (String)((String)this.getModel().getValue("reporttype")));
        this.getView().returnDataToParent((Object)model);
        this.getModel().setDataChanged(false);
        this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f", (String)"BgmdModelEdit_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().close();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if ("epm_modelview".equals(((BaseView)e.getSource()).getFormShowParameter().getParentFormId())) {
            this.getView().returnDataToParent((Object)"success");
        }
    }

    private void insertYear(String orify, String fy, DynamicObject model) {
        int oldfy = 1997 + Integer.parseInt(orify) - 1;
        int newfy = 1997 + Integer.parseInt(fy) - 1;
        int num = oldfy - newfy;
        Object[] memTree = new DynamicObject[num];
        QFilter qfdim = new QFilter("parent.number", "=", (Object)"AllYear");
        QFilter qfmodel = new QFilter("model", "=", model.get("id"));
        Object[] olds = BusinessDataServiceHelper.load((String)"epm_yearmembertree", (String)"id,name,number,model,dimension,dseq,parent,parent.longnumber,level", (QFilter[])new QFilter[]{qfdim, qfmodel}, (String)"dseq desc");
        if (olds == null || olds.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u5e74\u7ef4\u5ea6\u6570\u636e\u9519\u8bef\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"BgmdModelEdit_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        for (int i = 0; i < num; ++i) {
            String number = "FY" + (newfy + i);
            String name = ResManager.loadResFormat((String)"%1\u5e74", (String)"BgmdModelEdit_5", (String)"epm-eb-formplugin", (Object[])new Object[]{newfy + i});
            Object object = olds[0];
            DynamicObject fymemtree = BusinessDataServiceHelper.newDynamicObject((String)"epm_yearmembertree");
            fymemtree.set("model", (Object)model);
            fymemtree.set("dimension", object.get("dimension"));
            fymemtree.set("aggoprt", (Object)AggOprtEnum.ADD.getSign());
            fymemtree.set("level", object.get("level"));
            fymemtree.set("isleaf", (Object)aTrue);
            fymemtree.set("number", (Object)number);
            fymemtree.set("name", (Object)name);
            fymemtree.set("membersource", (Object)MemberSourceEnum.ADD.getIndex());
            fymemtree.set("dseq", (Object)(i + 1));
            fymemtree.set("parent", object.get("parent"));
            fymemtree.set("longnumber", (Object)(object.getString("parent.longnumber") + "!" + number));
            fymemtree.set("status", (Object)"C");
            fymemtree.set("enable", (Object)1);
            fymemtree.set("modifier", (Object)UserUtils.getUserId());
            fymemtree.set("modifytime", (Object)TimeServiceHelper.now());
            memTree[i] = fymemtree;
        }
        BusinessDataWriter.save((IDataEntityType)memTree[0].getDataEntityType(), (Object[])memTree);
        for (DynamicObject dynamicObject : olds) {
            dynamicObject.set("dseq", (Object)(dynamicObject.getInt("dseq") + num));
        }
        BusinessDataWriter.save((IDataEntityType)olds[0].getDataEntityType(), (Object[])olds);
    }

    private void buildStartYears() {
        ComboEdit edit = (ComboEdit)this.getView().getControl("startfy");
        LocalDate today = LocalDate.now();
        int curYear = today.getYear();
        int firstYear = 1997;
        int index = curYear - firstYear + 1;
        int startTitle = curYear - 20;
        int startValue = index - 20;
        ArrayList<String[]> keysAndValues = new ArrayList<String[]>(10);
        boolean language = !Lang.get().equals((Object)Lang.zh_CN) && !Lang.get().equals((Object)Lang.zh_TW);
        for (int i = 0; i < 26; ++i) {
            String[] keysAndValue = new String[]{language ? String.valueOf(startTitle) : ResManager.loadResFormat((String)"%1\u5e74", (String)"BgmdModelEdit_5", (String)"epm-eb-formplugin", (Object[])new Object[]{startTitle}), String.valueOf(startValue)};
            keysAndValues.add(keysAndValue);
            ++startTitle;
            ++startValue;
        }
        FormUtils.customDynamicEnum(keysAndValues, (ComboEdit)edit);
    }

    private boolean isEdit() {
        return OperationStatus.EDIT == this.getView().getFormShowParameter().getStatus();
    }

    private Boolean isEb() {
        return "eb".equalsIgnoreCase(this.getView().getFormShowParameter().getAppId()) && !this.isNewEbForm();
    }

    private long getDataSource() {
        DynamicObjectCollection dataSources = QueryServiceHelper.query((String)"epbs_datasource", (String)"id", (QFilter[])new QFilter[0]);
        if (!dataSources.isEmpty()) {
            return ((DynamicObject)dataSources.get(0)).getLong("id");
        }
        String olapConfig = System.getProperty("olap.config");
        if (StringUtils.isEmpty((String)olapConfig)) {
            return 0L;
        }
        return 0L;
    }

    private void buildPeriodComboEdit() {
        IDataModel iDataModel = this.getModel();
        ComboEdit detailedto = (ComboEdit)this.getControl("detailedto");
        DetailedPeriodEnum[] values = DetailedPeriodEnum.values();
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(values.length);
        boolean isSelect = false;
        for (DetailedPeriodEnum value : values) {
            String peirod = value.getKey();
            list.add(new ComboItem(new LocaleString(value.getName()), peirod));
            if (isSelect || !((Boolean)iDataModel.getValue(peirod)).booleanValue()) continue;
            isSelect = true;
            List pulldownValues = value.getPulldownValues();
            if (pulldownValues == null) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"containperiod"});
                continue;
            }
            ComboEdit containperiod = (ComboEdit)this.getControl("containperiod");
            ArrayList<ComboItem> subList = new ArrayList<ComboItem>(pulldownValues.size());
            int count = 0;
            for (DetailedPeriodEnum.PulldownValue pValue : pulldownValues) {
                String subKey = pValue.getKey();
                subList.add(new ComboItem(new LocaleString(pValue.getName()), subKey));
                boolean isTrue = pValue != DetailedPeriodEnum.PulldownValue.No && pValue != DetailedPeriodEnum.PulldownValue.PHalfYearAndSeason && (Boolean)iDataModel.getValue(subKey) != false;
                if (!isTrue) continue;
                iDataModel.setValue("containperiod", (Object)subKey);
                ++count;
            }
            containperiod.setComboItems(subList);
            if (count == 0) {
                iDataModel.setValue("containperiod", (Object)DetailedPeriodEnum.PulldownValue.No.getKey());
            } else if (count == 2) {
                iDataModel.setValue("containperiod", (Object)DetailedPeriodEnum.PulldownValue.PHalfYearAndSeason.getKey());
            }
            iDataModel.setValue("detailedto", (Object)peirod);
        }
        detailedto.setComboItems(list);
    }

    private void buildSubPeriodComboEdit(String value) {
        List pulldownValues = DetailedPeriodEnum.getEnumByKey((String)value).getPulldownValues();
        if (pulldownValues == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"containperiod"});
            return;
        }
        this.getView().setVisible(aTrue, new String[]{"containperiod"});
        ComboEdit containperiod = (ComboEdit)this.getControl("containperiod");
        ArrayList<ComboItem> subList = new ArrayList<ComboItem>(pulldownValues.size());
        for (DetailedPeriodEnum.PulldownValue pValue : pulldownValues) {
            subList.add(new ComboItem(new LocaleString(pValue.getName()), pValue.getKey()));
        }
        containperiod.setComboItems(subList);
        if (DetailedPeriodEnum.Month.getKey().equals(value)) {
            this.getModel().setValue("containperiod", (Object)DetailedPeriodEnum.PulldownValue.PHalfYearAndSeason.getKey());
        } else {
            this.getModel().setValue("containperiod", (Object)DetailedPeriodEnum.PulldownValue.SHalfYear.getKey());
        }
    }

    @Override
    public boolean isCheckModel() {
        return false;
    }
}

