/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.model;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.dataModelTrans.config.DataModelTransEnum;
import kd.epm.eb.formplugin.utils.OpenMenuPageUtil;
import kd.epm.eb.formplugin.utils.PageParamModel;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.model.utils.ModelUtil;

public class BgmdModelIndexPlugin
extends AbstractFormPlugin {
    private QFilter mfilter = null;
    private static final List<String> filter = Arrays.asList(SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.Scenario.getNumber(), SysDimensionEnum.Process.getNumber());

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"model", "dimension", "template", "flexpanelap6", "taskconfig", "flexpanelap61", "taskconfig1"});
        this.addClickListeners(new String[]{"dsum", "msum", "ldsum", "tsize", "bsize", "labelc21", "labelc11", "tcsize", "confsize", "labelc211", "labelc111", "tcsize1", "confsize1", "confsize11"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        if (map == null) {
            return;
        }
        String modelid = map.get("KEY_MODEL_ID").toString();
        Long _modelId = Long.valueOf(modelid);
        this.getPageCache().put("KEY_MODEL_ID", modelid);
        this.mfilter = new QFilter("model", "=", (Object)_modelId);
        this.setEbData(_modelId);
        String parentPage = this.getView().getParentView().getPageId();
        String mainPageId = (String)map.get("mainPageId");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)mainPageId)) {
            parentPage = mainPageId;
        }
        this.getPageCache().put("appPageId", parentPage);
        if (ModelUtil.isBGModel((Long)_modelId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"taskconfig"});
        }
    }

    private DynamicObject queryModelData(Long modelid) {
        String selectFields = "id,number,name,presetyear,startfy,modifier.name,modifytime,beginperiodtext,shownumber,isspptproject,enable";
        QFilter fmodelid = new QFilter("id", "=", (Object)modelid);
        QFilter[] filters = new QFilter[]{fmodelid};
        return QueryServiceHelper.queryOne((String)"epm_model", (String)selectFields, (QFilter[])filters);
    }

    private DynamicObjectCollection queryDimensionData(QFilter mfilter) {
        String selectFields = "id,name,number,issysdimension,membermodel,membertable";
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"epm_dimension", (String)selectFields, (QFilter[])mfilter.toArray());
        if (doc.size() > 0) {
            return doc;
        }
        return null;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        if (!this.isModelHasDelete()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"BgmdModelIndexPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "dimension": 
            case "dsum": 
            case "msum": 
            case "ldsum": {
                String formId;
                FormShowParameter parm = new FormShowParameter();
                parm.setCaption(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ba1\u7406", (String)"BgmdModelIndexPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                if (this.isEb()) {
                    formId = "eb_dimensionmanagerlist";
                } else {
                    formId = "epm_dimensionmanager";
                    if (NewEbAppUtil.isNewEbModel((Long)this.getModelId())) {
                        formId = "epm_dimensionmanager_nbg";
                    }
                }
                this.checkViewPerm(formId);
                this.showListView(formId, parm, null);
                break;
            }
            case "template": 
            case "tsize": 
            case "bsize": {
                this.showTemplateList();
                break;
            }
            case "flexpanelap6": 
            case "labelc21": 
            case "labelc11": {
                if (!this.isEb()) break;
                break;
            }
            case "taskconfig": 
            case "tcsize": 
            case "confsize": {
                if (this.isEb()) break;
                this.checkViewPerm("eb_taskhome");
                this.showListView("eb_taskhome", new FormShowParameter(), "eb_tasklist");
                break;
            }
            case "model": {
                this.showBaseView(ShowType.Modal, "epm_model", this.getPageCache().get("KEY_MODEL_ID"));
                break;
            }
        }
    }

    private void showBizRuleList() {
        String formId = this.isEb() ? "eb_bizrulelist" : "eb_bizrulegrouplist2";
        String billFormId = this.isEb() ? "eb_bizruleentity" : "eb_bizrulegrouplist2";
        this.showListView(formId, (FormShowParameter)new ListShowParameter(), billFormId);
    }

    private void showTemplateList() {
        String billFormId;
        String formId = this.isEb() ? "eb_templatelist_bg" : "eb_templatelist";
        String string = billFormId = this.isEb() ? "eb_templateentity_bg" : "eb_templateentity";
        if (this.isNewEbForm()) {
            formId = "eb_templatelist_nbg";
        }
        this.checkViewPerm(formId);
        this.showListView(formId, (FormShowParameter)new ListShowParameter(), billFormId);
    }

    private boolean isModelHasDelete() {
        return QueryServiceHelper.exists((String)"epm_model", (Object)this.getPageCache().get("KEY_MODEL_ID"));
    }

    private void setEbData(Long modelId) {
        this.setEbModelData(modelId);
        this.setTemplateData();
        this.setEbComputeRule();
        this.setEbTaskInfo();
        this.setEbTaskState();
        this.setEbUserInfo();
        this.setDimensionData();
    }

    private void setEbComputeRule() {
        this.setVisible(false, "labelc21", "labelc22", "labelc11", "labelc12");
    }

    private void setEbTaskInfo() {
        this.setVisible(false, "labeltc", "tcsize", "confsize", "labelconf");
    }

    private void setEbTaskState() {
        this.setVisible(false, "tcsize1", "labeltc3", "confsize1", "labelconf1", "confsize11", "labelconf11");
    }

    private void setEbUserInfo() {
        this.setVisible(false, "labelc211", "labelc221", "labelc111", "labelc121");
    }

    private void setLableText(String pname, String text) {
        Label countLabel = (Label)this.getControl(pname);
        countLabel.setText(text);
    }

    private void setEbModelData(Long modelId) {
        DynamicObject dt = this.queryModelData(modelId);
        if (dt == null) {
            return;
        }
        IDataModel model = this.getModel();
        model.setValue("isspptproject", dt.get("isspptproject"));
        model.setValue("enable", dt.get("enable"));
        this.setLableText("mnumber", dt.getString("shownumber") + " " + dt.getString("name"));
        this.setLableText("startfy", ResManager.loadResFormat((String)"%1\u5e74", (String)"BgmdModelIndexPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{dt.getInt("startfy") + 1997 - 1}));
    }

    private void setDimensionData() {
        DynamicObjectCollection doc = this.queryDimensionData(this.mfilter);
        if (doc == null) {
            return;
        }
        int dsum = 0;
        int msum = 0;
        int ldsum = 0;
        QFilter[] filters = null;
        for (DynamicObject d : doc) {
            if (Boolean.parseBoolean(d.getString("issysdimension"))) {
                ++dsum;
            }
            if (!filter.contains(d.getString("number"))) {
                ++ldsum;
            }
            if ("epm_entitymembertree".equals(d.getString("membermodel"))) {
                QFilter filter = new QFilter("isexchangerate", "=", (Object)false);
                filters = new QFilter[]{this.mfilter, filter};
            } else {
                filters = new QFilter[]{this.mfilter};
            }
            if (DataModelTransEnum.userdefine.getFormID().equalsIgnoreCase(d.getString("membermodel"))) {
                filters = new QFilter[]{new QFilter("dimension", "=", (Object)d.getLong("id")), this.mfilter};
            }
            msum += this.querySizeFromModel(d.getString("membermodel"), filters);
        }
        this.setLableText("dsum", ldsum + "");
        this.setLableText("ldsum", doc.size() - dsum + "");
        if (doc.size() - dsum == 0) {
            this.setVisible(false, "ldsum", "labeld");
            this.setVisible(true, "imaged1", "labeld1");
        } else {
            this.setVisible(true, "ldsum", "labeld");
            this.setVisible(false, "imaged1", "labeld1");
        }
        this.setLableText("msum", msum + "");
    }

    private void setVisible(boolean value, String ... ctlKeys) {
        this.getView().setVisible(Boolean.valueOf(value), ctlKeys);
    }

    private int querySizeFromModel(String entityName, QFilter[] qFilters) {
        String selectFields = "id";
        DynamicObjectCollection doc = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])qFilters);
        return doc.size();
    }

    private void setTemplateData() {
        int tsize = this.querySizeFromModel(this.isEb() ? "eb_templateentity_bg" : "eb_templateentity", new QFilter[]{this.mfilter});
        this.setLableText("tsize", tsize + "");
        if (tsize == 0) {
            this.setVisible(false, "tsize", "labeltsize");
            this.setVisible(true, "imaget1", "labelt1");
        } else {
            this.setVisible(true, "tsize", "labeltsize");
            this.setVisible(false, "imaget1", "labelt1");
        }
        this.setVisible(false, "bsize", "labelbsize");
        this.setVisible(true, "imaget2", "labelt2");
    }

    private void showBaseView(ShowType showtype, String formid, Object pkid) {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(showtype);
        param.setFormId(formid);
        param.setPkId(pkid);
        param.setStatus(OperationStatus.EDIT);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "model"));
        this.getView().showForm((FormShowParameter)param);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        String actionid;
        super.closedCallBack(event);
        switch (actionid = event.getActionId()) {
            case "model": {
                if (!(event.getReturnData() instanceof DynamicObject)) break;
                DynamicObject model = (DynamicObject)event.getReturnData();
                this.setLableText("mnumber", model.getString("shownumber") + " " + model.getString("name"));
                break;
            }
        }
    }

    private void showListView(String formid, FormShowParameter param, String billFormId) {
        if (param instanceof ListShowParameter) {
            ((ListShowParameter)param).setBillFormId(billFormId);
        }
        PageParamModel pageModel = new PageParamModel(this.getView(), true, this.getPageCache().get("KEY_MODEL_ID"), this.getPageCache().get("appPageId"), formid, param);
        OpenMenuPageUtil.showFormViewByParam(pageModel);
    }

    private boolean isEb() {
        return "4".equals(this.getView().getFormShowParameter().getCustomParam("reporttype"));
    }

    @Override
    public Long getModelId() {
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            return 0L;
        }
        return Long.valueOf(modelId);
    }

    public String getModelFieldKey() {
        return "KEY_MODEL_ID";
    }

    private void checkViewPerm(String formId) {
        Long userId = this.getUserId();
        Long modelId = this.getModelId();
        int is = this.checkItemPermission(this.getUserId(), modelId, this.getBizAppId(), formId, "47150e89000000ac");
        if (is == 0) {
            if (MemberPermHelper.ifUserHasRootPermByModel((Long)userId, (Long)modelId)) {
                return;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u83dc\u5355\u67e5\u8be2\u6743\u9650\u3002", (String)"BgmdModelIndexPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }
}

