/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.epm.eb.business.ebupgrades.utils.UpgradeProgressUtil;
import kd.epm.eb.business.ebupgrades.utils.UpgradesHelper;
import kd.epm.eb.business.ebupgrades.utils.UpgradesRecordHelper;
import kd.epm.eb.business.ebupgrades.utils.UpgradesServiceImpl;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.threadpool.EBThreadPoolExecutor;
import kd.epm.eb.formplugin.model.BgmdModelList;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;

public class EbModelList
extends BgmdModelList {
    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("btn_cleardata".equals(key)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.size() != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"EbModelList_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            ListSelectedRow listSelectedRow = selectedRows.get(0);
            Long modelId = (Long)listSelectedRow.getPrimaryKeyValue();
            if (!MemberPermHelper.getLimitedModelListByUser().contains(modelId)) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u4f53\u7cfb\u201c%1\u201d\u7684\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u8fdb\u884c\u6570\u636e\u67e5\u8be2\u3002", (String)"EbModelList_4", (String)"epm-eb-formplugin", (Object[])new Object[]{listSelectedRow.getName()}));
                return;
            }
            this.openEpmClearData(modelId);
        } else if ("upgrade".equals(key)) {
            this.upgradeModel();
        } else if ("testrollback".equals(key)) {
            if (UpgradeProgressUtil.rollBack()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u56de\u6eda\u6210\u529f", (String)"EbModelList_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u56de\u6eda\u6570\u636e", (String)"EbModelList_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void upgradeModel() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"EbModelList_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> needUpgradeModel = new ArrayList<Long>(16);
        ArrayList<Long> oldEbModelList = new ArrayList<Long>(16);
        Long userId = UserUtils.getUserId();
        Set modelIds = ModelUtil.getModelIds((IFormView)this.getView(), (boolean)true);
        for (ListSelectedRow selectedRow : selectedRows) {
            Long modelId = (Long)selectedRow.getPrimaryKeyValue();
            if (!modelIds.contains(modelId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u975e\u6240\u6709\u5f85\u5347\u7ea7\u4f53\u7cfb\u7684\u7ba1\u7406\u5458\uff0c\u65e0\u6cd5\u6267\u884c\u5347\u7ea7\u3002", (String)"EbModelList_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            needUpgradeModel.add(modelId);
            boolean oldEbModel = ModelServiceHelper.isOldEbModel((Long)modelId);
            if (!oldEbModel) continue;
            oldEbModelList.add(modelId);
        }
        if (UpgradesHelper.isUpLocked()) {
            this.showUpgradeProgress();
        } else if (UpgradeProgressUtil.reUpgradeTest(needUpgradeModel)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u8d39\u7528\u9884\u7b97\u4f53\u7cfb\u5df2\u5347\u7ea7\u3002", (String)"EbModelList_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (UpgradeProgressUtil.upgradeFailed()) {
            this.openUpgradeConfirm(needUpgradeModel);
        } else if (UpgradeProgressUtil.upgradeRollFailed()) {
            boolean success = UpgradeProgressUtil.rollBack();
            if (success) {
                this.openUpgradeConfirm(needUpgradeModel);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u52a8\u56de\u6eda\u5931\u8d25\u3002", (String)"EbModelList_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else if (UpgradeProgressUtil.doPreUpgrades(needUpgradeModel)) {
            EBThreadPoolExecutor.executeOnce(() -> UpgradesServiceImpl.getInstance().doPreUpgrades(UpgradesRecordHelper.getMainRecordNew(null)), (String)"doPreUpgrades");
            this.showUpgradeProgress();
        } else if (CollectionUtils.isNotEmpty(oldEbModelList)) {
            this.openUpgradeConfirm(needUpgradeModel);
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u4e2d\u6ca1\u6709\u9700\u8981\u5347\u7ea7\u7684\u8d39\u7528\u9884\u7b97\u4f53\u7cfb\u3002", (String)"EbModelList_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void openUpgradeConfirm(List<Long> needUpgradeModel) {
        boolean upLocked = UpgradesHelper.isUpLocked();
        if (upLocked) {
            this.showUpgradeProgress();
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("modelIds", SerializationUtils.serializeToBase64(needUpgradeModel));
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("eb_upgradeconfirm");
        parameter.setCustomParams(params);
        parameter.setCaption(ResManager.loadKDString((String)"\u8d39\u7528\u9884\u7b97\u5347\u7ea7\u63d0\u793a", (String)"EbModelList_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "upgradeConfirm");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void openEpmClearData(Object primaryKeyValue) {
        FormShowParameter formShow = new FormShowParameter();
        if (this.isNewEbForm()) {
            formShow.setFormId("epm_dataanalyse");
            formShow.setCustomParam("MODELID", primaryKeyValue);
        } else {
            formShow.setFormId("epm_olapdataclear");
            formShow.setCustomParam("model", primaryKeyValue);
        }
        formShow.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShow.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2", (String)"EbModelList_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().showForm(formShow);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData;
        boolean success;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (actionId.equals("upgradeConfirm")) {
            this.showUpgradeCheck(e);
        } else if ("showUpgradeCheck".equals(actionId) && (success = Objects.equals("success", returnData = e.getReturnData()))) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void showUpgradeCheck(ClosedCallBackEvent e) {
        List models;
        Object returnData = e.getReturnData();
        if (!ObjectUtils.isEmpty((Object)returnData) && CollectionUtils.isNotEmpty((Collection)(models = (List)SerializationUtils.deSerializeFromBase64((String)((String)returnData))))) {
            this.doShowUpgradeCheck(models);
        }
    }

    private void doShowUpgradeCheck(List<Long> models) {
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("modelIds", SerializationUtils.serializeToBase64(models));
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("eb_upgradecheck");
        parameter.setCustomParams(params);
        parameter.setCaption(ResManager.loadKDString((String)"\u8d39\u7528\u9884\u7b97\u5347\u7ea7\u68c0\u67e5", (String)"EbModelList_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "showUpgradeCheck");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void showUpgradeProgress() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_upgradeprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u8d39\u7528\u9884\u7b97\u5347\u7ea7", (String)"EbModelList_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        showParameter.setCustomParam("msg", (Object)ResManager.loadKDString((String)"\u8d39\u7528\u9884\u7b97\u5347\u7ea7\u6b63\u5728\u8fdb\u884c\u4e2d\u3002", (String)"EbModelList_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "ebModelUpgrade");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setShowTitle(true);
        this.getView().showForm(showParameter);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        boolean newEbForm = this.isNewEbForm();
        if (newEbForm) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"upgrade", "testrollback"});
        }
    }
}

