/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.model;

import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Save;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.DataSourceUtils;
import kd.epm.eb.common.utils.EncryptUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import org.apache.commons.lang3.StringUtils;

public class EpmDataSourceEditPlugin
extends AbstractBasePlugin {
    private static final Boolean aFalse = Boolean.FALSE;
    private static final Boolean aTrue = Boolean.TRUE;

    public void initialize() {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterLoadData(EventObject e) {
        boolean quote = (Boolean)this.getModel().getValue("quote");
        if (quote) {
            this.getView().setEnable(aFalse, new String[]{"serveraddress", "port", "username", "password"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("baritemtest".equals(itemKey)) {
            boolean isSuccess = this.testConn();
            if (isSuccess) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u6210\u529f\u3002", (String)"EpmDataSourceEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u5931\u8d25\u3002", (String)"EpmDataSourceEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    protected boolean testConn() {
        boolean re;
        String connect = (String)this.getModel().getValue("dataconnect");
        String address = this.getModel().getValue("serveraddress") != null ? this.getModel().getValue("serveraddress").toString().trim() : "";
        String port = this.getModel().getValue("port") != null ? this.getModel().getValue("port").toString().trim() : "";
        String username = this.getModel().getValue("username") != null ? this.getModel().getValue("username").toString().trim() : "";
        String password = this.getModel().getValue("password") != null ? this.getModel().getValue("password").toString().trim() : "";
        String accountId = (String)this.getModel().getValue("accountid");
        if (!DataSourceUtils.verifyAccount((Long)((Long)this.getModel().getValue("id")), (String)accountId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u6e90\u4e0d\u662f\u8be5\u6570\u636e\u4e2d\u5fc3\u521b\u5efa\uff0c\u8bf7\u91cd\u65b0\u521b\u5efa\u6570\u636e\u6e90\u3002", (String)"ConnectionManager_1", (String)"epm-eb-common", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)connect)) {
            StringBuilder dataConnect = new StringBuilder("http://");
            dataConnect.append(address).append(':').append(port).append("/bos-olap-webserver/services/httpolap");
            connect = dataConnect.toString();
        }
        if (re = ShrekOlapServiceHelper.olapConnectTest((String)connect, (String)username, (String)password)) {
            re = ShrekOlapServiceHelper.olapConnectTest((String)address, (String)port, (String)username, (String)password);
        }
        return re;
    }

    @Override
    public void beforeBindData(EventObject e) {
        IDataModel iDataModel = this.getModel();
        if (StringUtils.isNotBlank((CharSequence)iDataModel.getValue("username").toString())) {
            iDataModel.setValue("username", (Object)EncryptUtils.aesDecrypt((String)iDataModel.getValue("username").toString()));
        }
        if (StringUtils.isNotBlank((CharSequence)iDataModel.getValue("password").toString())) {
            iDataModel.setValue("password", (Object)EncryptUtils.aesDecrypt((String)iDataModel.getValue("password").toString()));
        }
        if (this.getModel().getDataEntity().getBoolean("quote")) {
            this.getView().setEnable(aFalse, new String[]{"baritemsave", "number", "name", "discription", "serveraddress", "port", "username", "password"});
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("save".equals(operate.getOperateKey())) {
            boolean isSuccess;
            String number;
            QFBuilder qfBuilder;
            if (args.getSource() instanceof Save && "0".equals(this.getModel().getValue("id").toString()) && QueryServiceHelper.exists((String)"epm_datasource", (QFilter[])(qfBuilder = new QFBuilder("number", "=", (Object)(number = this.getModel().getValue("number").toString().toLowerCase()))).toArrays())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"EpmDataSourceEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            String serveraddress = this.getModel().getValue("serveraddress").toString().trim();
            String port = this.getModel().getValue("port").toString().trim();
            StringBuilder dataconnect = new StringBuilder("http://");
            dataconnect.append(serveraddress).append(':').append(port).append("/bos-olap-webserver/services/httpolap");
            this.getModel().setValue("dataconnect", (Object)dataconnect.toString());
            this.getModel().setValue("username", (Object)EncryptUtils.aesEncrypt((String)this.getModel().getValue("username").toString()));
            this.getModel().setValue("password", (Object)EncryptUtils.aesEncrypt((String)this.getModel().getValue("password").toString()));
            String accountId = (String)this.getModel().getValue("accountid");
            if (StringUtils.isEmpty((CharSequence)accountId)) {
                this.getModel().setValue("accountid", (Object)RequestContext.get().getAccountId());
            }
            if (!(isSuccess = this.testConn())) {
                this.getModel().setValue("username", (Object)EncryptUtils.aesDecrypt((String)this.getModel().getValue("username").toString()));
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u5931\u8d25\u3002", (String)"EpmDataSourceEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (!args.getOperationResult().isSuccess()) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        if ("save".equals(operate.getOperateKey())) {
            CacheServiceHelper.clearEntityCache((String)"epm_datasource");
        }
    }

    public Boolean needCheckViewPerm() {
        return Boolean.FALSE;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }
}

