/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapDataReader;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.epm.eb.business.servicehelper.EbOlapServiceHelper;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class ModelOlapDataMessage
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(ModelOlapDataMessage.class);

    @Override
    public void registerListener(EventObject e) {
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("model");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"getolapdata"});
    }

    public void afterCreateNewData(EventObject e) {
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals("model")) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl("model")).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>(16);
            }
            QFilter qFilter = new QFilter("reporttype", "=", (Object)"4");
            qFilterList.add(qFilter);
            this.getView().getFormShowParameter().setAppId("eb");
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String clickKey = ((Control)evt.getSource()).getKey();
        if (clickKey.equals("getolapdata")) {
            this.saveToDb();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"BizRuleGroupList2_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void saveToDb() {
        HashMap<String, String> cubeAndNumber = new HashMap<String, String>(8);
        HashMap<String, Boolean> isneedLeaf = new HashMap<String, Boolean>(16);
        Map<String, String> modelMessage = this.queryModel(cubeAndNumber, isneedLeaf);
        HashMap<String, String> tableNameMessage = new HashMap<String, String>(8);
        if (modelMessage.size() == 0) {
            return;
        }
        Map<String, List<String>> dimensionMap = this.getDimension(modelMessage);
        this.creatTaable_new(dimensionMap, modelMessage, tableNameMessage);
        Map<String, List<String>> likeModelOrgDimMem = this.getLikeModelOrgDimMem(modelMessage, isneedLeaf);
        Map<String, Map<String, List<String>>> leafByModel_new = this.getLeafByModel_new(modelMessage, isneedLeaf);
        this.getOlapData_new(likeModelOrgDimMem, dimensionMap, modelMessage, leafByModel_new, tableNameMessage);
    }

    private void creatTaable_new(Map<String, List<String>> dimensionMessage, Map<String, String> modelMessage, Map<String, String> tableNamemessage) {
        try {
            DBRoute epm = DBRoute.of((String)"epm");
            for (Map.Entry<String, List<String>> mapEntry : dimensionMessage.entrySet()) {
                String modelId = modelMessage.get(mapEntry.getKey());
                String tablename_new = "t_eb_olap" + modelId;
                StringBuilder str = this.creatSql_new(mapEntry.getValue(), tablename_new);
                if (DB.exitsTable((DBRoute)epm, (String)tablename_new)) {
                    DB.execute((DBRoute)epm, (String)("truncate table " + tablename_new));
                    DB.execute((DBRoute)epm, (String)("drop table " + tablename_new));
                }
                DB.execute((DBRoute)epm, (String)str.toString());
                tableNamemessage.put(mapEntry.getKey(), tablename_new);
            }
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
            throw new KDBizException(exception.getMessage());
        }
    }

    private Map<String, Map<String, List<String>>> getLeafByModel_new(Map<String, String> modelMessage, Map<String, Boolean> isneedLeaf) {
        HashMap<String, Map<String, List<String>>> modelcommonAndAccount = new HashMap<String, Map<String, List<String>>>(modelMessage.size());
        String selectFiled = "id,name,number,issysdimension,membermodel";
        String selectFiled_mem = "id,name,number";
        for (Map.Entry<String, String> mapEntry : modelMessage.entrySet()) {
            HashMap commonAndAccount = new HashMap(modelMessage.size());
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add(new QFilter("model", "=", (Object)Long.parseLong(mapEntry.getValue())));
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"epm_dimension", (String)selectFiled, (QFilter[])qfBuilder.toArrays());
            if (dynamicObjects == null) {
                log.info("ProjectDispatch\u67e5\u51fa\u7684\u7ef4\u5ea6\u4e3a\u7a7a");
                return modelcommonAndAccount;
            }
            for (DynamicObject dynamicObject : dynamicObjects) {
                qfBuilder.clear();
                ArrayList<String> commonList = new ArrayList<String>(16);
                Long id = dynamicObject.getLong("id");
                qfBuilder.add(new QFilter("model", "=", (Object)Long.parseLong(mapEntry.getValue())));
                if (!isneedLeaf.get(mapEntry.getKey()).booleanValue()) {
                    qfBuilder.add(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
                }
                qfBuilder.add(new QFilter("dimension", "=", (Object)id));
                try {
                    DataSet rows = QueryServiceHelper.queryDataSet((String)"epm", (String)dynamicObject.getString("membermodel"), (String)selectFiled_mem, (QFilter[])qfBuilder.toArrays(), null);
                    Throwable throwable = null;
                    try {
                        if (rows != null) {
                            while (rows.hasNext()) {
                                Row row = rows.next();
                                commonList.add(row.getString("number"));
                            }
                        }
                        commonAndAccount.put(dynamicObject.getString("number"), commonList);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (rows == null) continue;
                        if (throwable != null) {
                            try {
                                rows.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        rows.close();
                    }
                }
                catch (Exception ex) {
                    log.error((Throwable)ex);
                    throw new KDBizException(ex.getMessage());
                }
            }
            modelcommonAndAccount.put(mapEntry.getKey(), commonAndAccount);
        }
        return modelcommonAndAccount;
    }

    private void getOlapData_new(Map<String, List<String>> likeModelOrgDimMem, Map<String, List<String>> dimensionMap, Map<String, String> modelMessage, Map<String, Map<String, List<String>>> modelcommonAndAccount, Map<String, String> tableNameMessage) {
        RequestContext context = RequestContextCreator.createForThreadPool();
        ThreadPoolExecutor poolExecutor = new ThreadPoolExecutor(3, Runtime.getRuntime().availableProcessors() + 1, 50L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        ExecutorService es = ThreadLifeCycleManager.wrapExecutorService((ExecutorService)poolExecutor);
        Timestamp date = new Timestamp(System.currentTimeMillis());
        int size = 0;
        for (Map.Entry<String, List<String>> entry : likeModelOrgDimMem.entrySet()) {
            size = entry.getValue().size() + size;
        }
        CountDownLatch count = new CountDownLatch(size);
        try {
            for (Map.Entry<String, List<String>> entry : likeModelOrgDimMem.entrySet()) {
                List<String> dimMemValue = entry.getValue();
                String tableName = tableNameMessage.get(entry.getKey());
                String cube = entry.getKey();
                List<String> dimValue = dimensionMap.get(cube);
                String[] dimArray = this.getDimArray(dimValue);
                String insertSql = this.getInsertSql_new(dimValue, tableName);
                Map<String, List<String>> commonAndAccount = modelcommonAndAccount.get(entry.getKey());
                for (String org : dimMemValue) {
                    es.execute(new BuildData(count, context, org, dimArray, cube, insertSql, modelMessage, commonAndAccount, date));
                }
            }
            count.await();
        }
        catch (Exception exception) {
            log.error("budget-data-log : ", (Throwable)exception);
            throw new KDBizException(exception.getMessage());
        }
    }

    private String[] getDimArray(List<String> dimValue) {
        String[] dim = new String[dimValue.size()];
        int i = 0;
        for (String value : dimValue) {
            if (value.equals(SysDimensionEnum.Period.getNumber())) {
                dim[dimValue.size() - 1] = value;
                continue;
            }
            dim[i] = value;
            ++i;
        }
        return dim;
    }

    private String getInsertSql_new(List<String> dimensionList, String tableName) {
        StringBuilder str = new StringBuilder();
        StringBuilder strValue = new StringBuilder();
        StringBuilder str_New = new StringBuilder();
        str.append("(fid,fmodelid,fvalue,");
        strValue.append(" values (?,?,?");
        dimensionList.remove("Period");
        dimensionList.add("Period");
        for (String s : dimensionList) {
            str.append("f").append(s).append(",");
            strValue.append(",?");
        }
        strValue.append(",?");
        str.append("f").append("creattime").append(",");
        str.replace(str.length() - 1, str.length(), ")");
        strValue.append(")");
        return str_New.append("insert into ").append(tableName).append((CharSequence)str).append((CharSequence)strValue).toString();
    }

    private Map<String, List<String>> getLikeModelOrgDimMem(Map<String, String> modelMessage, Map<String, Boolean> isneedLeaf) {
        String selectFiled = "id,name,number";
        HashMap<String, List<String>> cubeAndDimmem = new HashMap<String, List<String>>(8);
        for (Map.Entry<String, String> mapEntry : modelMessage.entrySet()) {
            QFBuilder qfBuilder = new QFBuilder();
            ArrayList<String> dim = new ArrayList<String>(16);
            qfBuilder.add(new QFilter("model", "=", (Object)Long.parseLong(mapEntry.getValue())));
            if (!isneedLeaf.get(mapEntry.getKey()).booleanValue()) {
                qfBuilder.add(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
            }
            try {
                DataSet rows = QueryServiceHelper.queryDataSet((String)"epm", (String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)selectFiled, (QFilter[])qfBuilder.toArrays(), null);
                Throwable throwable = null;
                try {
                    if (rows != null) {
                        while (rows.hasNext()) {
                            Row row = rows.next();
                            dim.add(row.getString("number"));
                        }
                    }
                    cubeAndDimmem.put(mapEntry.getKey(), dim);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rows == null) continue;
                    if (throwable != null) {
                        try {
                            rows.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    rows.close();
                }
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
                throw new KDBizException(ex.getMessage());
            }
        }
        log.info("getKikeModelOrgDimMem:" + ((Object)cubeAndDimmem).toString());
        return cubeAndDimmem;
    }

    private Map<String, List<String>> getDimension(Map<String, String> modelMessage) {
        HashMap<String, List<String>> dimensionList = new HashMap<String, List<String>>(16);
        String selectFiled = "id,name,number";
        for (Map.Entry<String, String> mapEntry : modelMessage.entrySet()) {
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add(new QFilter("model", "=", (Object)Long.parseLong(mapEntry.getValue())));
            try {
                DataSet rows = QueryServiceHelper.queryDataSet((String)"epm", (String)"epm_dimension", (String)selectFiled, (QFilter[])qfBuilder.toArrays(), null);
                Throwable throwable = null;
                try {
                    LinkedList<String> dimension = new LinkedList<String>();
                    if (rows != null) {
                        while (rows.hasNext()) {
                            Row row = rows.next();
                            dimension.add(row.getString("number"));
                        }
                    }
                    dimensionList.put(mapEntry.getKey(), dimension);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rows == null) continue;
                    if (throwable != null) {
                        try {
                            rows.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    rows.close();
                }
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
                throw new KDBizException(ex.getMessage());
            }
        }
        return dimensionList;
    }

    private StringBuilder creatSql_new(List<String> dimmessage, String tablename_new) {
        StringBuilder str = new StringBuilder();
        str.append("create table ").append(tablename_new).append("(").append("fid bigint default 0 not null, ").append("fmodelid bigint default 0 not null, ").append("fvalue decimal(60,13) default 0 not null, ");
        for (String s : dimmessage) {
            str.append("f").append(s).append(" NVARCHAR(50)  default ' ' not null, ");
        }
        str.append("f").append("creattime").append(" datetime, ");
        str.append("constraint pk_").append(tablename_new.substring(tablename_new.length() - 19)).append(" primary key (fid))");
        return str;
    }

    private Map<String, String> queryModel(Map<String, String> cubeAndNumber, Map<String, Boolean> isneedLeaf) {
        HashMap<String, String> modelMessage = new HashMap<String, String>(8);
        QFBuilder qfBuilder = new QFBuilder();
        DynamicObjectCollection eb_getolapdata = QueryServiceHelper.query((String)"eb_getolapdata", (String)"model.shownumber,model.number,isneedcollect", (QFilter[])new QFilter[]{new QFilter("1", "=", (Object)1)});
        ArrayList<String> modelNumber = new ArrayList<String>(16);
        for (DynamicObject dynamicObject : eb_getolapdata) {
            modelNumber.add(dynamicObject.getString("model.shownumber"));
            isneedLeaf.put(dynamicObject.getString("model.number"), dynamicObject.getBoolean("isneedcollect"));
        }
        qfBuilder.add(new QFilter("shownumber", "in", modelNumber));
        try (DataSet rows = QueryServiceHelper.queryDataSet((String)"epm", (String)"epm_model", (String)"id,name,number,shownumber", (QFilter[])qfBuilder.toArrays(), null);){
            if (rows != null) {
                while (rows.hasNext()) {
                    Row row = rows.next();
                    modelMessage.put(row.getString("number"), row.getString("id"));
                    cubeAndNumber.put(row.getString("number"), row.getString("shownumber"));
                }
            }
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
        return modelMessage;
    }

    private static void setDimensionValue(Object[] values, Object[] dimValue, Date date) {
        for (int i = 0; i < values.length; ++i) {
            String value = values[i].toString();
            dimValue[i + 2] = value;
            if (i != 0) continue;
            dimValue[i + 2] = new BigDecimal(value);
        }
        dimValue[values.length + 2] = date;
    }

    static class BuildData
    implements Runnable {
        private CountDownLatch count;
        private RequestContext context;
        private String org;
        private String cube;
        private String[] dimArray;
        private String insertSql;
        private Map<String, String> modelMessage;
        private Map<String, List<String>> commonAndAccount;
        private Timestamp date;

        public BuildData(CountDownLatch count, RequestContext context, String org, String[] dimArray, String cube, String insertSql, Map<String, String> modelMessage, Map<String, List<String>> commonAndAccount, Timestamp date) {
            this.count = count;
            this.context = context;
            this.org = org;
            this.dimArray = dimArray;
            this.cube = cube;
            this.insertSql = insertSql;
            this.modelMessage = modelMessage;
            this.commonAndAccount = commonAndAccount;
            this.date = date;
        }

        @Override
        public void run() {
            try {
                this.build();
            }
            catch (Throwable ex) {
                log.error("buildData error:", ex);
                throw ex;
            }
            finally {
                this.count.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void build() {
            HashMap<String, Object[]> maps;
            ArrayList<Object[]> insertParamsList;
            OlapConnection conn;
            OlapDataReader olapData_new;
            block7: {
                SelectCommandInfo commadInfo;
                block6: {
                    RequestContextCreator.restoreForThreadPool((RequestContext)this.context);
                    commadInfo = new SelectCommandInfo();
                    commadInfo.addFilter(SysDimensionEnum.Entity.getNumber(), new String[]{this.org});
                    for (Map.Entry<String, List<String>> mapEnry : this.commonAndAccount.entrySet()) {
                        if (mapEnry.getKey().equals(SysDimensionEnum.Entity.getNumber())) continue;
                        commadInfo.addFilter(mapEnry.getKey(), mapEnry.getValue().toArray(new String[1]));
                    }
                    commadInfo.addDims(this.dimArray);
                    commadInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
                    commadInfo.setExcludeNull(true);
                    Map map = EbOlapServiceHelper.queryDataReByConn((SelectCommandInfo)commadInfo, (String)this.cube);
                    olapData_new = (OlapDataReader)map.get("cs");
                    conn = (OlapConnection)map.get("conn");
                    insertParamsList = new ArrayList<Object[]>(16);
                    maps = new HashMap<String, Object[]>(256);
                    if (olapData_new != null) break block6;
                    ShrekOlapUtils.close((Object[])new Object[]{olapData_new});
                    ShrekOlapUtils.close((Object[])new Object[]{conn});
                    return;
                }
                try {
                    List list = commadInfo.getMeasures();
                    Object[] values = new Object[commadInfo.getDimensions().size() + list.size()];
                    StringBuilder mapValue = new StringBuilder();
                    while (olapData_new.next()) {
                        olapData_new.getValues(values);
                        if (values[0] == null || values[0] instanceof String) continue;
                        String mapsKey = this.getMapsKey(values, mapValue);
                        Object[] dimValue = (Object[])maps.get(mapsKey);
                        if (dimValue == null) {
                            dimValue = new Object[this.dimArray.length + 4];
                            ModelOlapDataMessage.setDimensionValue(values, dimValue, this.date);
                        }
                        maps.put(mapsKey, dimValue);
                        mapValue.setLength(0);
                    }
                    if (maps.size() != 0) break block7;
                }
                catch (Throwable throwable) {
                    ShrekOlapUtils.close((Object[])new Object[]{olapData_new});
                    ShrekOlapUtils.close((Object[])new Object[]{conn});
                    throw throwable;
                }
                ShrekOlapUtils.close((Object[])new Object[]{olapData_new});
                ShrekOlapUtils.close((Object[])new Object[]{conn});
                return;
            }
            ShrekOlapUtils.close((Object[])new Object[]{olapData_new});
            ShrekOlapUtils.close((Object[])new Object[]{conn});
            this.addToInsertParamsList(insertParamsList, maps);
            this.insertData(insertParamsList);
        }

        private void insertData(List<Object[]> insertParamsList) {
            DBRoute epm = DBRoute.of((String)"epm");
            for (Object[] objects : insertParamsList) {
                for (int i = 0; i < objects.length; ++i) {
                    if (objects[i] != null) continue;
                    objects[i] = 0;
                }
            }
            DB.executeBatch((DBRoute)epm, (String)this.insertSql, insertParamsList);
        }

        private void addToInsertParamsList(List<Object[]> insertParamsList, Map<String, Object[]> maps) {
            for (Map.Entry<String, Object[]> mapEntry : maps.entrySet()) {
                Object[] value = mapEntry.getValue();
                value[0] = DBServiceHelper.genGlobalLongId();
                value[1] = Long.parseLong(this.modelMessage.get(this.cube));
                insertParamsList.add(value);
            }
        }

        private String getMapsKey(Object[] values, StringBuilder mapValue) {
            for (int i = 1; i < values.length; ++i) {
                if (i == values.length - 1) {
                    mapValue.append(values[i].toString());
                    continue;
                }
                mapValue.append(values[i].toString()).append("!!");
            }
            return mapValue.toString();
        }
    }
}

