/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.model.permission;

import java.util.EventObject;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.enums.ManageTypeEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class CreaterTransUserSelectPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String TARUSER = "taruser";
    private static final String BTN_SURE = "sure";
    private static final Log log = LogFactory.getLog(CreaterTransUserSelectPlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{TARUSER});
        this.addClickListeners(new String[]{BTN_SURE});
    }

    public void afterCreateNewData(EventObject e) {
        Label labelap = (Label)this.getControl("labelap");
        String createrStr = (String)this.getView().getFormShowParameter().getCustomParam("creater");
        if (StringUtils.isNotEmpty((String)createrStr)) {
            DynamicObject creater = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)createrStr);
            String userName = creater.getString("name");
            labelap.setText(ResManager.loadResFormat((String)"%1\u4e3a\u4f53\u7cfb\u521b\u5efa\u4eba ,\u5c06\u8be5\u4f53\u7cfb\u521b\u5efa\u4eba\u6743\u9650\u8f6c\u79fb\u81f3:", (String)"CreaterTransUserSelectPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{userName}));
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (TARUSER.equals(name)) {
            String idsStr = (String)this.getView().getFormShowParameter().getCustomParam("ids");
            Set ids = (Set)SerializationUtils.deSerializeFromBase64((String)idsStr);
            QFilter qf = new QFilter("id", "in", (Object)ids);
            ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            param.getListFilterParameter().setFilter(qf);
            param.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.equals(BTN_SURE)) {
            DynamicObject dynamicObject;
            String createrStr = (String)this.getView().getFormShowParameter().getCustomParam("creater");
            String userName = "";
            if (StringUtils.isNotEmpty((String)createrStr)) {
                DynamicObject creater = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)createrStr);
                userName = creater.getString("name");
            }
            if ((dynamicObject = (DynamicObject)this.getModel().getValue(TARUSER)) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u8f6c\u79fb\u6743\u9650\u7684\u76ee\u6807\u7528\u6237\u3002", (String)"CreaterTransUserSelectPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            String tarName = dynamicObject.getString("name");
            this.getView().showConfirm(ResManager.loadResFormat((String)"\u662f\u5426\u5c06\u4f53\u7cfb:%1 \u7684\u521b\u5efa\u4eba\u6743\u9650\u7531\uff1a%2 \u8f6c\u4ea4\u7ed9\uff1a%3\uff1f", (String)"CreaterTransUserSelectPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getView().getFormShowParameter().getCustomParam("modelName"), userName, tarName}), MessageBoxOptions.YesNo, new ConfirmCallBackListener("transfer", (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("transfer".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            DynamicObject users = (DynamicObject)this.getModel().getValue(TARUSER);
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"epm_modelperm");
            dynamicObject.set("id", (Object)this.getModelId());
            dynamicObject.set("creator", (Object)users.getLong("id"));
            dynamicObject.set("modifier", (Object)UserUtils.getUserId());
            dynamicObject.set("modifytime", (Object)TimeServiceHelper.now());
            SaveServiceHelper.update((DynamicObject)dynamicObject);
            this.getView().returnDataToParent((Object)users.getLong("id"));
            String sqlStr = "update t_eb_modelpermentry set fmanagetype  = case  when fusers = ? then ? else ? end where fid  =  ?";
            try {
                DB.update((DBRoute)DBRoute.of((String)"epm"), (String)sqlStr, (Object[])new Object[]{users.getLong("id"), ManageTypeEnum.CREATER.getType(), ManageTypeEnum.MANAGER.getType(), this.getModelId()});
            }
            catch (Exception e) {
                log.error((Throwable)e);
                throw new KDBizException(e.getMessage());
            }
            String tarName = users.getString("name");
            this.writeLog(null, "save", new MultiLangEnumBridge("\u4fee\u6539\u4fdd\u5b58", "CreaterTransUserSelectPlugin_1", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4f53\u7cfb\uff1a%1$s ,\u4f53\u7cfb\u521b\u5efa\u4eba\u8f6c\u4ea4\u81f3\uff1a%2$s \u6210\u529f", "CreaterTransUserSelectPlugin_2", "epm-eb-formplugin"), new String[]{(String)this.getView().getFormShowParameter().getCustomParam("modelName"), tarName});
            this.getView().close();
        }
    }

    @Override
    public Long getModelId() {
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("modelId");
        if (StringUtils.isNotEmpty((String)modelId)) {
            return Long.valueOf(modelId);
        }
        return 0L;
    }
}

