/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.model.permission;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.formplugin.model.permission.FunPermPlugin;

public class EBFunPermPlugin
extends FunPermPlugin
implements RowClickEventListener {
    @Override
    public void initialize() {
        super.initialize();
        EntryGrid eg = (EntryGrid)this.getControl("orglist");
        eg.addRowClickListener((RowClickEventListener)this);
    }

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        e.getFormShowParameter().setCustomParam("FormShowParam_appNum", (Object)"eb,bgmd,bgc,bgm,bgbd,bgrp");
        e.getFormShowParameter().setCustomParam("FormShowParam_dimension", (Object)"DIM_EPM_MODEL");
        FormShowParameter fs = (FormShowParameter)e.getSource();
        fs.setHasRight(true);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"dim_num", "dim_name"});
    }

    @Override
    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("orglist");
        int[] rows = entryGrid.getSelectRows();
        if (evt.getRow() < 0 || rows.length == 0) {
            return;
        }
        DynamicObject model = this.getModel().getEntryRowEntity("orglist", rows[0]);
        Long modelId = model.getLong("org_id");
        String appNums = this.getAppNum(modelId);
        this.getPageCache().put("FormShowParam_appNum", appNums);
        DynamicObject user = (DynamicObject)this.getModel().getValue("user");
        boolean canSave = user == null || !ModelServiceHelper.isUserHasRootPermByModel((long)user.getLong("id"), (Long)modelId);
        this.getView().setVisible(Boolean.valueOf(canSave), new String[]{"baritem_save"});
        this.getView().setVisible(Boolean.valueOf(canSave), new String[]{"btn_addnode", "btn_delnode"});
    }

    public String getAppNum(Long org_id) {
        DynamicObject doc = QueryServiceHelper.queryOne((String)"epm_model", (String)"reporttype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)org_id)});
        if (doc != null) {
            if (ApplicationTypeEnum.BGMD.getIndex().equals(doc.getString("reporttype"))) {
                return ApplicationTypeEnum.BGMD.getAppnum() + "," + ApplicationTypeEnum.BGM.getAppnum() + "," + ApplicationTypeEnum.BGC.getAppnum() + "," + ApplicationTypeEnum.BGBD.getAppnum() + "," + ApplicationTypeEnum.BGRP.getAppnum();
            }
            if (ApplicationTypeEnum.EB.getIndex().equals(doc.getString("reporttype"))) {
                return ApplicationTypeEnum.EB.getAppnum() + "," + ApplicationTypeEnum.BGC.getAppnum();
            }
            if (ApplicationTypeEnum.BGBD.getIndex().equals(doc.getString("reporttype"))) {
                return ApplicationTypeEnum.BGBD.getAppnum();
            }
            if (ApplicationTypeEnum.BG.getIndex().equals(doc.getString("reporttype"))) {
                return ApplicationTypeEnum.EB.getAppnum() + "," + ApplicationTypeEnum.BGC.getAppnum() + "," + ApplicationTypeEnum.BGRP.getAppnum();
            }
        }
        return ApplicationTypeEnum.EB.getAppnum();
    }
}

