/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.model.permission;

import com.google.common.collect.Sets;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.permission.formplugin.plugin.RoleEditNewPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.formplugin.model.permission.EpmAllFuncPermTreeUtil;

public class EpmRoleEditNewPlugin
extends RoleEditNewPlugin {
    public void initialize() {
        this.initialVariable();
        Boolean isNewEb = this.isNewEb();
        String showAppNumbers = this.get2ShowAppNumbers();
        this.permPageCacheUtil.put("FormShowParam_appNum", showAppNumbers);
        this.allFuncPermTreeUtil = new EpmAllFuncPermTreeUtil(this.allFuncPermTreeView, showAppNumbers, this.getPermDimType(), true, isNewEb);
        this.addListener();
        this.initializeDataPermCache();
    }

    private String get2ShowAppNumbers() {
        IFormView view = this.getView();
        String appNumbers = view.getPageCache().get("toShowAppNumbers");
        if (StringUtils.isEmpty((String)appNumbers)) {
            appNumbers = this.permPageCacheUtil.get("FormShowParam_appNum");
            if (StringUtils.isNotEmpty((String)appNumbers)) {
                HashSet numberSet = Sets.newHashSet((Object[])appNumbers.split(","));
                boolean hasNewEb = false;
                boolean hasMd = false;
                for (DynamicObject model : QueryServiceHelper.query((String)"epm_model", (String)"reporttype", null)) {
                    String modelType = model.getString("reporttype");
                    if (ApplicationTypeEnum.BG.getIndex().equals(modelType)) {
                        hasNewEb = true;
                        continue;
                    }
                    if (!ApplicationTypeEnum.BGMD.getIndex().equals(modelType)) continue;
                    hasMd = true;
                }
                if (!hasMd && !hasNewEb) {
                    numberSet.remove(ApplicationTypeEnum.BGM.getAppnum());
                    numberSet.remove(ApplicationTypeEnum.BGMD.getAppnum());
                    numberSet.remove(ApplicationTypeEnum.BGRP.getAppnum());
                } else if (!hasMd) {
                    numberSet.remove(ApplicationTypeEnum.BGM.getAppnum());
                    numberSet.remove(ApplicationTypeEnum.BGMD.getAppnum());
                }
                appNumbers = String.join((CharSequence)",", numberSet);
            }
            view.getPageCache().put("toShowAppNumbers", appNumbers);
        }
        return appNumbers;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_addnode"});
    }

    private String getPermDimType() {
        String permDimType = this.permPageCacheUtil.get("FormShowParam_dimension");
        if (StringUtils.isEmpty((String)permDimType) && StringUtils.isEmpty((String)(permDimType = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_dimension_edit")))) {
            IFormView parentView;
            permDimType = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_dimension");
            if (StringUtils.isEmpty((String)permDimType) && (parentView = this.getView().getParentView()) != null) {
                permDimType = (String)parentView.getFormShowParameter().getCustomParam("FormShowParam_dimension");
            }
            if (StringUtils.isEmpty((String)permDimType)) {
                permDimType = "bos_org";
            }
        }
        return permDimType;
    }

    private Boolean isNewEb() {
        IFormView view = this.getView();
        if (view == null) {
            return false;
        }
        String newEbCache = this.getPageCache().get("newEbForm");
        if ("true".equals(newEbCache)) {
            return true;
        }
        IFormView parentView = view.getParentView();
        if (parentView == null) {
            return false;
        }
        String newEb = (String)parentView.getFormShowParameter().getCustomParam("newEbForm");
        boolean isNewEb = "true".equals(newEb);
        if (isNewEb) {
            this.getPageCache().put("newEbForm", "true");
        }
        return isNewEb;
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String clickKey = control.getKey();
        if (!"btn_addnode".equals(clickKey)) {
            return;
        }
        List selectedNodeId = this.allFuncPermTreeView.getTreeState().getSelectedNodeId();
        String ebAppId = AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.EB.getAppnum()).getId();
        String ebAppNodeId = ebAppId + "#app";
        String cloudNodeId = "";
        boolean containEbAppNode = false;
        boolean containCloudNode = false;
        for (String nodeId : selectedNodeId) {
            if (nodeId.indexOf("#cloud") > 0) {
                containCloudNode = true;
                cloudNodeId = nodeId;
                continue;
            }
            if (!ebAppNodeId.equals(nodeId)) continue;
            containEbAppNode = true;
            break;
        }
        if (containEbAppNode) {
            this.allFuncPermTreeView.uncheckNode(ebAppNodeId);
            if (containCloudNode) {
                this.allFuncPermTreeView.uncheckNode(cloudNodeId);
                this.allFuncPermTreeView.uncheckNode("root#FIRST");
            }
        }
    }
}

