/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.model.permission;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.formplugin.plugin.UserDirectAssignPermPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.formplugin.model.permission.EpmAllFuncPermTreeUtil;
import kd.epm.eb.model.permission.MemberPermHelper;

public class EpmUserDirectAssignPermPlugin
extends UserDirectAssignPermPlugin {
    private static final String rootNodeIdStr = "root#FIRST";

    public void initialize() {
        this.initialVariable();
        String queryString = RequestContext.get().getQueryString();
        boolean isRowClick = queryString != null && queryString.contains("entryRowClick");
        Long curSelDimObjId = this.getCurSelDimObjId();
        String appNumsStr = isRowClick ? "eb,bgmd,bgc,bgm,bgbd,bgrp" : this.permPageCacheUtil.get("FormShowParam_appNum");
        this.allFuncPermTreeUtil = new EpmAllFuncPermTreeUtil(this.allFuncPermTreeView, appNumsStr, this.getPermDimType(), curSelDimObjId);
        this.dataRuleTreeUtil = new EpmAllFuncPermTreeUtil(this.dataRuleTreeView, appNumsStr, this.getPermDimType(), curSelDimObjId, false);
        Set<String> appIds = this.getAppIds(appNumsStr);
        this.allFuncPermTreeUtil.setFilterAppIds(appIds);
        this.dataRuleTreeUtil.setFilterAppIds(appIds);
        this.addListener();
        this.initializeDataPermCache();
    }

    private Set<String> getAppIds(String appNumsStr) {
        HashSet<String> appIds = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((String)appNumsStr)) {
            for (String appNum : appNumsStr.split(",")) {
                AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNum);
                if (appInfo == null) continue;
                appIds.add(appInfo.getId());
            }
        }
        return appIds;
    }

    private String getPermDimType() {
        String permDimType = this.permPageCacheUtil.get("FormShowParam_dimension");
        if (StringUtils.isEmpty((String)permDimType) && StringUtils.isEmpty((String)(permDimType = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_dimension_edit")))) {
            IFormView parentView;
            permDimType = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_dimension");
            if (StringUtils.isEmpty((String)permDimType) && (parentView = this.getView().getParentView()) != null) {
                permDimType = (String)parentView.getFormShowParameter().getCustomParam("FormShowParam_dimension");
            }
            if (StringUtils.isEmpty((String)permDimType)) {
                permDimType = "bos_org";
            }
        }
        return permDimType;
    }

    private Long getCurSelDimObjId() {
        Long dimObjId = null;
        int focusRow = this.getModel().getEntryCurrentRowIndex("orglist");
        if (focusRow == -1) {
            return -1L;
        }
        String strDimObjId = (String)this.getModel().getValue("org_id", focusRow);
        if (StringUtils.isNotEmpty((String)strDimObjId)) {
            dimObjId = Long.parseLong(strDimObjId);
            return dimObjId;
        }
        return -1L;
    }

    protected void initialAllFuncPermTree() {
        TreeNode allFuncTree;
        boolean containsBgrp;
        Long userId = ((DynamicObject)this.getModel().getValue("user")).getLong("id");
        if (userId != null) {
            this.permPageCacheUtil.put("to_be_assigned_user_id", String.valueOf(userId));
        }
        String allFuncTreeCache = this.permPageCacheUtil.get("PGCache_hasInitialAllFuncPermTree");
        String appNumsStr = this.permPageCacheUtil.get("FormShowParam_appNum");
        boolean bl = containsBgrp = appNumsStr != null && appNumsStr.contains(ApplicationTypeEnum.BGRP.getAppnum());
        if (StringUtils.isEmpty((String)allFuncTreeCache)) {
            if (!containsBgrp) {
                this.permPageCacheUtil.put("FormShowParam_appNum", appNumsStr + ",bgrp");
            }
            allFuncTree = this.allFuncPermTreeUtil.initTree(false);
            this.permPageCacheUtil.put("FormShowParam_appNum", appNumsStr);
            String json = SerializationUtils.toJsonString((Object)allFuncTree);
            this.permPageCacheUtil.put("PGCache_hasInitialAllFuncPermTree", json);
        } else {
            allFuncTree = (TreeNode)SerializationUtils.fromJsonString((String)allFuncTreeCache, TreeNode.class);
        }
        if (!containsBgrp) {
            AppInfo bgrpInfo = AppMetadataCache.getAppInfoByNumber((String)ApplicationTypeEnum.BGRP.getAppnum());
            allFuncTree.getChildren().removeIf(node -> node.getId().startsWith(bgrpInfo.getCloudId()));
        }
        this.showTreeView("tree_allfunctionperm", allFuncTree);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String clickKey = control.getKey();
        if (!"btn_addnode".equals(clickKey)) {
            return;
        }
        Long curSelDimObjId = this.getCurSelDimObjId();
        DynamicObject modelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)curSelDimObjId, (String)"epm_model", (String)"reporttype");
        if (modelObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u4f53\u7cfb\u4fe1\u606f\u3002", (String)"EpmAllFuncPermTreeUtil_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String reportType = modelObj.getString("reporttype");
        ApplicationTypeEnum applicationType = ApplicationTypeEnum.getEnumByIndex((String)reportType);
        AppInfo ebAppInfo = AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.EB.getAppnum());
        AppInfo bgrpAppInfo = AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.BGRP.getAppnum());
        HashSet<String> filterAppIds = new HashSet<String>(2);
        HashSet<String> filterCloudIds = new HashSet<String>(2);
        if (applicationType == ApplicationTypeEnum.EB) {
            filterAppIds.add(ebAppInfo.getId() + "#app");
            filterCloudIds.add(ebAppInfo.getCloudId() + "#cloud");
        } else if (applicationType == ApplicationTypeEnum.BG) {
            filterAppIds.add(ebAppInfo.getId() + "#app");
            filterAppIds.add(bgrpAppInfo.getId() + "#app");
            filterCloudIds.add(ebAppInfo.getCloudId() + "#cloud");
            filterCloudIds.add(bgrpAppInfo.getCloudId() + "#cloud");
        } else if (applicationType == ApplicationTypeEnum.BGMD) {
            filterAppIds.add(bgrpAppInfo.getId() + "#app");
            filterCloudIds.add(bgrpAppInfo.getCloudId() + "#cloud");
        }
        if (filterAppIds.isEmpty()) {
            return;
        }
        List selectedNodes = this.allFuncPermTreeView.getTreeState().getSelectedNodes();
        HashSet<String> needUnCheckCloudIds = new HashSet<String>(16);
        HashSet<String> needUnCheckAppIds = new HashSet<String>(16);
        HashSet<String> parentNodeIds = new HashSet<String>(16);
        for (Map node : selectedNodes) {
            String nodeId = node.get("id").toString();
            if (filterCloudIds.contains(nodeId)) {
                needUnCheckCloudIds.add(nodeId);
            } else if (filterAppIds.contains(nodeId)) {
                needUnCheckAppIds.add(nodeId);
            }
            String parentId = node.get("parentid").toString();
            parentNodeIds.add(parentId);
        }
        if (needUnCheckCloudIds.size() > 0) {
            this.allFuncPermTreeView.uncheckNode(rootNodeIdStr);
            for (String cloudNodeId : needUnCheckCloudIds) {
                this.allFuncPermTreeView.uncheckNode(cloudNodeId);
                if (parentNodeIds.contains(cloudNodeId)) continue;
                this.allFuncPermTreeUtil.queryTreeNodeChildren(new TreeNodeEvent((Object)this, (Object)rootNodeIdStr, (Object)cloudNodeId));
                this.allFuncPermTreeView.expand(cloudNodeId);
                if (cloudNodeId.startsWith(bgrpAppInfo.getCloudId())) {
                    this.expAppNode(bgrpAppInfo, cloudNodeId, null);
                    continue;
                }
                if (!cloudNodeId.startsWith(ebAppInfo.getCloudId())) continue;
                this.expAppNode(ebAppInfo, cloudNodeId, null);
                ArrayList<TreeNode> appNodes = new ArrayList<TreeNode>(16);
                appNodes.add(new TreeNode(cloudNodeId, this.getAppId(ApplicationTypeEnum.BGC), ResManager.loadKDString((String)"\u9884\u7b97\u63a7\u5236", (String)"EpmAllFuncPermTreeUtil_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), true));
                this.allFuncPermTreeView.checkNodes(appNodes);
            }
        }
        if (needUnCheckAppIds.size() > 0) {
            for (String appNodeId : needUnCheckAppIds) {
                this.allFuncPermTreeView.uncheckNode(appNodeId);
                if (parentNodeIds.contains(appNodeId)) continue;
                if (appNodeId.startsWith(bgrpAppInfo.getId())) {
                    this.expAppNode(bgrpAppInfo, null, appNodeId);
                    continue;
                }
                if (!appNodeId.startsWith(ebAppInfo.getId())) continue;
                this.expAppNode(ebAppInfo, null, appNodeId);
            }
        }
    }

    private void uncheckCloudNode(Set<String> parentNodeIds, String cloudNodeId) {
        this.allFuncPermTreeView.uncheckNode(cloudNodeId);
        if (!parentNodeIds.contains(cloudNodeId)) {
            this.allFuncPermTreeUtil.queryTreeNodeChildren(new TreeNodeEvent((Object)this, (Object)rootNodeIdStr, (Object)cloudNodeId));
            this.allFuncPermTreeView.expand(cloudNodeId);
        }
    }

    private void expAppNode(AppInfo appInfo, String cloudNodeId, String appNodeId) {
        if (cloudNodeId == null) {
            cloudNodeId = appInfo.getCloudId() + "#cloud";
        }
        if (appNodeId == null) {
            appNodeId = appInfo.getId() + "#app";
        }
        ((EpmAllFuncPermTreeUtil)this.allFuncPermTreeUtil).queryTreeNodeChildren(new TreeNodeEvent((Object)this, (Object)cloudNodeId, (Object)appNodeId), true);
        this.allFuncPermTreeView.collapse(appNodeId);
    }

    private String getAppId(ApplicationTypeEnum applicationType) {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)applicationType.getAppnum());
        return appInfo.getId() + "#app";
    }

    protected List<QFilter> getLeftEntryFilter() {
        Set modelIds;
        DynamicObject user;
        ArrayList<QFilter> leftEntryFilter = super.getLeftEntryFilter();
        if (leftEntryFilter == null) {
            leftEntryFilter = new ArrayList<QFilter>(16);
        }
        if ((user = (DynamicObject)this.getModel().getValue("user")) != null && CollectionUtils.isNotEmpty((Collection)(modelIds = MemberPermHelper.getLimitedModelListByUser(null, (long)user.getLong("id"))))) {
            leftEntryFilter.add(new QFilter("id", "not in", (Object)modelIds));
        }
        return leftEntryFilter;
    }
}

