/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.model.permission;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.model.permission.ModelPermCommon;
import kd.epm.eb.model.permission.MemberPermHelper;

public class FunPermPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
BeforeF7SelectListener {
    public void initialize() {
        super.initialize();
        EntryGrid eg = (EntryGrid)this.getControl("orglist");
        eg.addRowClickListener((RowClickEventListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
        this.addClickListeners(new String[]{"btn_addnode"});
        BasedataEdit user = (BasedataEdit)this.getControl("user");
        user.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String appId = e.getFormShowParameter().getAppId();
        String entity = e.getFormShowParameter().getFormId();
        String sb = ModelPermCommon.getModelScopWithoutRole(appId, entity);
        e.getFormShowParameter().getCustomParams().put("FormShowParam_dimensionObjIds", sb);
        e.setCancel(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        long uid;
        DynamicObject user;
        super.propertyChanged(e);
        if ("user".equals(e.getProperty().getName()) && (user = (DynamicObject)this.getModel().getValue("user")) != null && (uid = user.getLong("id")) != this.getUserId()) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"baritem_save"});
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        if (evt.getRow() < 0) {
            return;
        }
        DynamicObjectCollection dyc = this.getModel().getEntryEntity("orglist");
        DynamicObject selectDynamicObject = (DynamicObject)dyc.get(evt.getRow());
        String modelId = selectDynamicObject.getString("org_id");
        this.getPageCache().put("KEY_MODEL_ID", modelId);
        if (!MemberPermHelper.ifUserHasRootPermByModel((Long)UserUtils.getUserId(), (Long)Long.valueOf(modelId))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_addnode", "btn_delnode", "delete_org"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"btn_addnode", "btn_delnode", "delete_org"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Button && "btn_addnode".equals(((Button)evt.getSource()).getKey())) {
            TreeView treeView = (TreeView)this.getControl("tree_allfunctionperm");
            List checkedNodes = treeView.getTreeState().getCheckedNodes();
            for (Map map : checkedNodes) {
                if (map.get("id").toString().contains("bcm_mergecontrol")) {
                    this.getPageCache().put("isMergeControl", "true");
                    return;
                }
                if (!map.get("parentid").toString().contains("bcm_mergecontrol") || !map.get("parentid").toString().contains("/=NAJMRI3LY0") && !map.get("parentid").toString().contains("/=NALZ=PRF4B")) continue;
                this.getPageCache().put("isMergeControl", "true");
                return;
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        arg0.getFormShowParameter().setHasRight(true);
    }
}

