/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.model.permission;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.epm.eb.common.enums.ManageTypeEnum;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.utils.AppUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.model.serviceHelper.UserDistributeServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class ModelDistributeEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String disEntry_ID = "modelpermentry";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        BasedataEdit user = (BasedataEdit)this.getControl("baseuser");
        user.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit usergroup = (BasedataEdit)this.getControl("baseusergroup");
        usergroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection oldmember = (DynamicObjectCollection)this.getModel().getValue(disEntry_ID);
        this.getPageCache().put("oldEntry", SerializationUtils.serializeToBase64((Object)oldmember));
        Set<Long> omids = this.getAllUserId();
        this.getPageCache().put("old", SerializationUtils.toJsonString(omids));
        this.getModel().setDataChanged(false);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "addusergroup": {
                MulBasedataEdit userGroup = (MulBasedataEdit)this.getControl("baseusergroup");
                userGroup.click();
                break;
            }
            case "adduser": {
                MulBasedataEdit user = (MulBasedataEdit)this.getControl("baseuser");
                user.click();
                break;
            }
            case "delentry": {
                this.deleteEntryRow(disEntry_ID);
                break;
            }
            case "transfer": {
                this.showUserSelect();
                break;
            }
        }
    }

    private void showUserSelect() {
        EntryGrid eg = (EntryGrid)this.getControl(disEntry_ID);
        int[] rows = eg.getSelectRows();
        if (rows.length > 0) {
            if (rows.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u4f53\u7cfb\u521b\u5efa\u4eba\u7684\u6743\u9650\u53ef\u88ab\u8f6c\u4ea4\u3002", (String)"ModelDistributeEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject entry = this.getModel().getEntryRowEntity(disEntry_ID, rows[0]);
            if (entry != null) {
                String type = entry.getString("etype");
                if ("bos_user".equalsIgnoreCase(type)) {
                    DynamicObject user = entry.getDynamicObject("eusers");
                    Long createrId = (Long)this.getModel().getValue("creator_id");
                    if (user != null && !createrId.equals(user.getLong("id"))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u4f53\u7cfb\u521b\u5efa\u4eba\u7684\u6743\u9650\u53ef\u88ab\u8f6c\u4ea4\u3002", (String)"ModelDistributeEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                } else if ("bos_usergroup".equalsIgnoreCase(type)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u4f53\u7cfb\u521b\u5efa\u4eba\u7684\u6743\u9650\u53ef\u88ab\u8f6c\u4ea4\u3002", (String)"ModelDistributeEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            HashMap<String, String> openParameter = new HashMap<String, String>();
            openParameter.put("formId", "epm_transferselect");
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(openParameter);
            showParameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"ModelDistributeEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("ids", (Object)this.getPageCache().get("managerids"));
            showParameter.setCustomParam("modelName", this.getView().getFormShowParameter().getCustomParam("modelName"));
            showParameter.setCustomParam("creater", (Object)this.getPageCache().get("creater"));
            showParameter.setCustomParam("modelId", this.getView().getFormShowParameter().getCustomParam("modelId"));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "transfer");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7528\u6237", (String)"ModelDistributeEditPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            DynamicObject moelobj = (DynamicObject)this.getModel().getValue("model");
            Long modelId = moelobj.getLong("id");
            Set modelIds = MemberPermHelper.getLimitedModelListByUser();
            if (!modelIds.contains(modelId)) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5f53\u524d\u7528\u6237\u975e%1\u4f53\u7cfb\u7684\u7ba1\u7406\u5458\uff0c\u4e0d\u5141\u8bb8\u6307\u5b9a\u8be5\u4f53\u7cfb\u7684\u7ba1\u7406\u5458\u3002", (String)"ModelDistributeEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{moelobj.getString("name")}));
                args.setCancel(true);
                return;
            }
        }
    }

    private void deleteEntryRow(String entryId) {
        EntryGrid eg = (EntryGrid)this.getControl(entryId);
        int[] rows = eg.getSelectRows();
        if (rows.length > 0) {
            Long createrId = (Long)this.getModel().getValue("creator_id");
            boolean check = true;
            String oldEntryStr = this.getPageCache().get("oldEntry");
            DynamicObjectCollection oldEntry = new DynamicObjectCollection();
            if (StringUtils.isNotEmpty((String)oldEntryStr)) {
                oldEntry = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)oldEntryStr);
            }
            for (int row : rows) {
                DynamicObject entry = this.getModel().getEntryRowEntity(disEntry_ID, row);
                if (entry != null) {
                    String type = entry.getString("etype");
                    if ("bos_user".equalsIgnoreCase(type)) {
                        DynamicObject user = entry.getDynamicObject("eusers");
                        if (user != null && user.getLong("id") == createrId.longValue()) {
                            check = false;
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7528\u6237\u662f\u4f53\u7cfb\u521b\u5efa\u4eba\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"ModelDistributeEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            break;
                        }
                    } else if ("bos_usergroup".equalsIgnoreCase(type)) {
                        // empty if block
                    }
                }
                if (!CollectionUtils.isNotEmpty((Collection)oldEntry)) continue;
                String deleteEntryStr = this.getPageCache().get("deleteEntry");
                DynamicObjectCollection dynamicObjectCollection = StringUtils.isEmpty((String)deleteEntryStr) ? new DynamicObjectCollection() : (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)deleteEntryStr);
                if (entry != null) {
                    for (DynamicObject dynamicObject : oldEntry) {
                        DynamicObject user = entry.getDynamicObject("eusers");
                        DynamicObject oldUser = dynamicObject.getDynamicObject("eusers");
                        if (user.getLong("id") != oldUser.getLong("id")) continue;
                        dynamicObjectCollection.add((Object)entry);
                    }
                }
                this.getPageCache().put("deleteEntry", SerializationUtils.serializeToBase64((Object)dynamicObjectCollection));
            }
            if (check) {
                this.getModel().deleteEntryRows(entryId, rows);
                eg.clearEntryState();
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ModelDistributeEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        Object returnData = evt.getReturnData();
        String actionId = evt.getActionId();
        if (returnData == null) {
            return;
        }
        ArrayList<Object> oids = this.getOldDisIds();
        switch (actionId) {
            case "baseuser": {
                this.setData2Entry((ListSelectedRowCollection)returnData, oids, "bos_user");
                break;
            }
            case "baseusergroup": {
                this.setData2Entry((ListSelectedRowCollection)returnData, oids, "bos_usergroup");
                break;
            }
            case "transfer": {
                this.getModel().setValue("creator_id", returnData);
                this.getAllUserId();
                break;
            }
        }
    }

    private void setData2Entry(ListSelectedRowCollection rows, ArrayList<Object> oids, String baseType) {
        Long createrId = (Long)this.getModel().getValue("creator_id");
        rows.forEach(p -> {
            if (!oids.contains(p.getPrimaryKeyValue())) {
                int rowIndex = this.getModel().createNewEntryRow(disEntry_ID);
                this.getModel().setValue("etype", (Object)baseType, rowIndex);
                if ("bos_user".equalsIgnoreCase(baseType)) {
                    if (p.getPrimaryKeyValue().equals(createrId)) {
                        this.getModel().setValue("managetype", (Object)ManageTypeEnum.CREATER.getType(), rowIndex);
                    } else {
                        this.getModel().setValue("managetype", (Object)ManageTypeEnum.MANAGER.getType(), rowIndex);
                    }
                } else {
                    this.getModel().setValue("managetype", (Object)ManageTypeEnum.MANAGER.getType(), rowIndex);
                }
                this.getModel().setValue("eusers", p.getPrimaryKeyValue(), rowIndex);
            }
        });
    }

    private ArrayList<Object> getOldDisIds() {
        ArrayList<Object> ids = new ArrayList<Object>(16);
        this.getModel().getEntryEntity(disEntry_ID).forEach(p -> ids.add(p.getDynamicObject("eusers").getPkValue()));
        return ids;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, evt.getProperty().getName());
        evt.getFormShowParameter().setCloseCallBack(closeCallBack);
        evt.getFormShowParameter().setHasRight(true);
        if ("baseuser".equals(evt.getProperty().getName())) {
            this.beforeF7Select_adduser(evt);
        }
    }

    protected void beforeF7Select_adduser(BeforeF7SelectEvent evt) {
        evt.getCustomQFilters().add(new QFilter("id", "<>", (Object)UserUtils.getUserId()));
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean issuccess = e.getOperationResult().getValidateResult().isSuccess();
        if ("deleteentry".equals(e.getOperateKey())) {
            return;
        }
        if ("save".equals(e.getOperateKey()) && issuccess && this.getPageCache().get("old") != null) {
            DynamicObjectCollection deletedEntry;
            Long modelId = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
            List omids = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("old"), List.class);
            FunPermissionHelper.delPermByUser((Long)modelId, (List)omids);
            Set<Long> newIds = this.getAllUserId();
            if (AppUtil.isEpmAppId((String)this.getBizAppId())) {
                DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"EPMPermissionService", (String)"addEPMPermByUsers", (Object[])new Object[]{modelId, new ArrayList<Long>(newIds)});
            } else {
                for (Long id : newIds) {
                    FunPermissionHelper.addRootPermByUser((Long)modelId, (Long)id);
                }
            }
            String oldEntryStr = this.getPageCache().get("oldEntry");
            DynamicObjectCollection oldEntry = new DynamicObjectCollection();
            if (StringUtils.isNotEmpty((String)oldEntryStr)) {
                oldEntry = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)oldEntryStr);
            }
            DynamicObjectCollection addEntry = new DynamicObjectCollection();
            if (CollectionUtils.isNotEmpty((Collection)oldEntry)) {
                DynamicObjectCollection newMember = (DynamicObjectCollection)this.getModel().getValue(disEntry_ID);
                for (DynamicObject dynamicObject : newMember) {
                    boolean isNew = false;
                    for (DynamicObject object : oldEntry) {
                        DynamicObject user = dynamicObject.getDynamicObject("eusers");
                        DynamicObject oldUser = object.getDynamicObject("eusers");
                        if (user.getLong("id") != oldUser.getLong("id")) continue;
                        isNew = true;
                        break;
                    }
                    if (isNew) continue;
                    addEntry.add((Object)dynamicObject);
                }
            }
            String deletedEntryStr = this.getPageCache().get("deleteEntry");
            String modelName = (String)this.getView().getFormShowParameter().getCustomParam("modelName");
            if (StringUtils.isNotEmpty((String)deletedEntryStr) && CollectionUtils.isNotEmpty((Collection)(deletedEntry = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)deletedEntryStr)))) {
                this.writeLog(null, "save", new MultiLangEnumBridge("\u4fee\u6539\u4fdd\u5b58", "CreaterTransUserSelectPlugin_1", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4f53\u7cfb\uff1a%1$s ,\u4f53\u7cfb\u7ba1\u7406\u5458\u79fb\u9664\uff1a%2$s \u6210\u529f", "CreaterTransUserSelectPlugin_4", "epm-eb-formplugin"), new String[]{modelName, this.getUserNameString(deletedEntry)});
            }
            if (CollectionUtils.isNotEmpty((Collection)addEntry)) {
                this.writeLog(null, "save", new MultiLangEnumBridge("\u4fee\u6539\u4fdd\u5b58", "CreaterTransUserSelectPlugin_1", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4f53\u7cfb\uff1a%1$s ,\u4f53\u7cfb\u7ba1\u7406\u5458\u65b0\u589e\uff1a%2$s \u6210\u529f", "CreaterTransUserSelectPlugin_3", "epm-eb-formplugin"), new String[]{modelName, this.getUserNameString(addEntry)});
            }
        }
        if (issuccess && e.getSource() instanceof Save) {
            this.getView().returnDataToParent((Object)new LocaleString(ResManager.loadKDString((String)"\u5206\u914d\u5b8c\u6210\u3002", (String)"ModelDistributeEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0])));
            this.getView().close();
        }
    }

    private String getUserNameString(DynamicObjectCollection list) {
        if (CollectionUtils.isEmpty((Collection)list)) {
            return "";
        }
        ArrayList temp = new ArrayList(list.size());
        list.forEach(users -> temp.add(users.getString("eusers.name")));
        return String.join((CharSequence)",", temp);
    }

    private Set<Long> getAllUserId() {
        HashSet<Long> ids = new HashSet<Long>(16);
        DynamicObjectCollection oldmember = (DynamicObjectCollection)this.getModel().getValue(disEntry_ID);
        Long createrId = (Long)this.getModel().getValue("creator_id");
        HashSet<Long> managerids = new HashSet<Long>(16);
        for (int i = 0; i < oldmember.size(); ++i) {
            DynamicObject mem = (DynamicObject)oldmember.get(i);
            String type = mem.getString("etype");
            Long usid = mem.getLong("eusers.id");
            boolean isCreate = false;
            if ("bos_user".equals(type)) {
                ids.add(usid);
                managerids.add(usid);
                DynamicObject user = mem.getDynamicObject("eusers");
                if (user != null && user.getLong("id") == createrId.longValue()) {
                    isCreate = true;
                    this.getPageCache().put("creater", SerializationUtils.serializeToBase64((Object)user));
                    managerids.remove(usid);
                }
            } else {
                DynamicObjectCollection us = UserDistributeServiceHelper.queryAllUsersByGroupId((Object)usid);
                for (DynamicObject dynamicObject : us) {
                    ids.add(dynamicObject.getLong("user"));
                }
            }
            this.getModel().setValue("managetype", (Object)(isCreate ? ManageTypeEnum.CREATER.getType() : ManageTypeEnum.MANAGER.getType()), i);
        }
        this.getPageCache().put("managerids", SerializationUtils.serializeToBase64(managerids));
        return ids;
    }

    @Override
    public Long getModelId() {
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("modelId");
        if (StringUtils.isNotEmpty((String)modelId)) {
            return Long.valueOf(modelId);
        }
        return 0L;
    }

    @Override
    public boolean isCheckModel() {
        return false;
    }
}

