/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.model.permission;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.formplugin.AbstractBaseListPlugin;
import kd.epm.eb.formplugin.model.permission.ModelPermCommon;

public class ModelPermChronologicalBook
extends AbstractBaseListPlugin {
    private static final String FSP_FORMNAME_ASSIGNROLE = "formShowParam_formName_assignRole";
    private static final String FSP_FORMNAME_ASSIGNPERM = "formShowParam_formName_assignPerm";

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        boolean bSYS = ModelPermCommon.isSysAdmin();
        String tip = bSYS ? null : ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"ModelPermChronologicalBook_0", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String sSYS = bSYS ? "true" : "false";
        e.getFormShowParameter().setCustomParam("FormShowParam_ShowForSpecialUser", (Object)sSYS);
        e.getFormShowParameter().setCustomParam("formShowParm_show_unableInfo", (Object)tip);
        e.getFormShowParameter().setCustomParam("FormShowParam_ShowForSpecialUser", (Object)"true");
        e.getFormShowParameter().setCustomParam("FormShowParam_dimension", (Object)"DIM_EPM_MODEL");
        e.getFormShowParameter().setCustomParam("FormShowParam_appNum", (Object)"eb,bgmd,bgm,bgc,bgrp");
        e.getFormShowParameter().setCustomParam(FSP_FORMNAME_ASSIGNROLE, (Object)"eb_perm_user_assignrole");
        e.getFormShowParameter().setCustomParam(FSP_FORMNAME_ASSIGNPERM, (Object)"epm_user_assignperm");
        this.setNewFormSign(e.getFormShowParameter());
        super.preOpenForm(e);
    }

    @Override
    public Long getModelId() {
        return 0L;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_clearperm", "baritem_assignpermmulti", "btn_directdisfunmulti"});
    }

    public void itemClick(ItemClickEvent evt) {
        Map customParamsFromFsp;
        super.itemClick(evt);
        String key = evt.getItemKey();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        HashMap<String, String> params = new HashMap<String, String>(16);
        if (rows != null && rows.size() > 0) {
            String userId = String.valueOf(rows.get(0).getPrimaryKeyValue());
            params.put("paramUserId", userId);
        }
        if ((customParamsFromFsp = this.getView().getFormShowParameter().getCustomParams()).get("FormShowParam_dimension") == null) {
            params.put("FormShowParam_dimension", "DIM_ORG");
        }
        if ("upperm".equals(key)) {
            this.updataPerm();
        }
    }

    private void updataPerm() {
        UpgradeResult result = new UpgradeResult();
        List<Long> modelIds = this.queryModelId();
        try (TXHandle tx = TX.required((String)"EbBcmPermUpServiceImpl");){
            try {
                this.updataPermByUserRole(modelIds);
                this.updataPermByUserPerm(modelIds);
                result.setSuccess(true);
            }
            catch (Exception e) {
                tx.markRollback();
                result.setSuccess(false);
                result.setLog(e.getMessage());
            }
        }
    }

    private void updataPermByUserPerm(List<Long> modelIds) {
        if (modelIds == null || modelIds.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("UPDATE t_perm_userperm SET FDIMTYPE = 'DIM_EPM_MODEL' where forgid =? and FDIMTYPE = 'DIM_BCM_MODEL'");
        ArrayList sqlParams = new ArrayList(modelIds.size());
        modelIds.forEach(d -> sqlParams.add(new Long[]{d}));
        DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)stringBuilder.toString(), sqlParams);
    }

    private void updataPermByUserRole(List<Long> modelIds) {
        if (modelIds == null || modelIds.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("UPDATE T_PERM_USERROLE SET FDIMTYPE = 'epm_model' where forgid =? and FDIMTYPE = 'bcm_model'");
        ArrayList sqlParams = new ArrayList(modelIds.size());
        modelIds.forEach(d -> sqlParams.add(new Long[]{d}));
        DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)stringBuilder.toString(), sqlParams);
    }

    private List<Long> queryModelId() {
        ArrayList<Long> modelIds = new ArrayList<Long>(10);
        String sql = "select fid from t_bcm_model where freporttype = ?";
        DB.query((DBRoute)DBRoute.of((String)"bcm"), (String)sql, (Object[])new Object[]{Character.valueOf('4')}, rs -> {
            while (rs.next()) {
                Long modelId = rs.getLong("fid");
                modelIds.add(modelId);
            }
            return modelIds;
        });
        return modelIds;
    }

    @Override
    public boolean isCheckModel() {
        return false;
    }

    private void setNewFormSign(FormShowParameter formShowParameter) {
        String formId = formShowParameter.getFormId();
        String type = (String)formShowParameter.getCustomParam("modelType");
        if ("old".equals(type)) {
            return;
        }
        if ("new".equals(type)) {
            formShowParameter.setCustomParam("newEbForm", (Object)"true");
            return;
        }
        if (!"bos_usergroup_treelist".equals(formId)) {
            return;
        }
        QFilter qFilter = new QFilter("ReportType", "=", (Object)ApplicationTypeEnum.EB.getIndex());
        qFilter.or("ReportType", "=", (Object)ApplicationTypeEnum.BG.getIndex());
        DynamicObjectCollection models = QueryServiceHelper.query((String)"epm_model", (String)"ReportType", (QFilter[])new QFilter[]{qFilter});
        if (models.size() == 0) {
            formShowParameter.setCustomParam("newEbForm", (Object)"true");
            return;
        }
        boolean isNewEb = false;
        for (DynamicObject model : models) {
            String reportType = model.getString("ReportType");
            if (!ApplicationTypeEnum.BG.getIndex().equals(reportType)) continue;
            isNewEb = true;
            break;
        }
        if (isNewEb) {
            formShowParameter.setCustomParam("newEbForm", (Object)"true");
        }
    }
}

