/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.multiSelOne;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.IFormPlugin;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class MultiSelOneFormPlugin
extends AbstractFormPlugin {
    public static final String CloseCallBack_Sign = "multiSelOne";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"label1", "label2", "label3", "label4", "label5", "label6", "label7", "label8", "label9", "label10"});
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map<String, String> items = this.getItems();
        HashMap<String, String> labelToItemMap = new HashMap<String, String>(this.getItems().size());
        ArrayList<String> visibleLabelKeys = new ArrayList<String>(10);
        int i = 1;
        for (Map.Entry<String, String> entry : items.entrySet()) {
            if (i >= 10) break;
            Label label = (Label)this.getControl("label" + i);
            label.setText(entry.getValue());
            labelToItemMap.put(label.getKey(), entry.getKey());
            visibleLabelKeys.add(label.getKey());
            ++i;
        }
        this.getPageCache().put("labelToItemMap", SerializationUtils.serializeToBase64(labelToItemMap));
        this.getView().setVisible(Boolean.TRUE, visibleLabelKeys.toArray(new String[0]));
    }

    private String getLabelToItemMap(String labelKey) {
        String cache_labelToItemMap = this.getPageCache().get("labelToItemMap");
        if (cache_labelToItemMap != null) {
            Map labelToItemMap = (Map)SerializationUtils.deSerializeFromBase64((String)cache_labelToItemMap);
            return (String)labelToItemMap.get(labelKey);
        }
        return null;
    }

    public void click(EventObject evt) {
        super.click(evt);
        String actionKey = ((Control)evt.getSource()).getKey();
        if (actionKey.startsWith("label")) {
            this.getView().returnDataToParent((Object)this.getLabelToItemMap(actionKey));
            this.getView().close();
        }
    }

    private Map<String, String> getItems() {
        return (Map)SerializationUtils.deSerializeFromBase64((String)((String)this.getFormCustomParam("items")));
    }

    public static FormShowParameter getMultiSelOneFormShowPram(IFormPlugin plugin, Map<String, String> items, String caption) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_multiselectone");
        showParameter.setCustomParam("items", (Object)SerializationUtils.serializeToBase64(items));
        StyleCss css = new StyleCss();
        css.setWidth(200 * items.size() + "px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (plugin != null) {
            showParameter.setCloseCallBack(new CloseCallBack(plugin, CloseCallBack_Sign));
        }
        showParameter.setCaption(caption);
        return showParameter;
    }
}

