/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.others;

import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.convert.Convert;

public class EpmHelperUtils {
    private static final Log log = LogFactory.getLog(EpmHelperUtils.class);

    public static List<Manifest> getJarManifestList(Class<?> clazz) {
        ArrayList<Manifest> manifestList = new ArrayList<Manifest>(1);
        try {
            ClassLoader classLoader = clazz.getClassLoader();
            String resourceString = clazz.getName().replace('.', '/').concat(".class");
            Enumeration<URL> enumeration = classLoader.getResources(resourceString);
            while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                URLConnection urlConnection = url.openConnection();
                if (!(urlConnection instanceof JarURLConnection)) continue;
                JarURLConnection jarURLConnection = (JarURLConnection)urlConnection;
                JarFile jarFile = jarURLConnection.getJarFile();
                Manifest manifest = jarFile.getManifest();
                jarFile.close();
                manifestList.add(manifest);
            }
        }
        catch (Throwable throwable) {
            log.error("EpmHelperUtils.getJarManifestList", throwable);
        }
        return manifestList;
    }

    public static List<Manifest> getJarManifestList(String clazzString) throws ClassNotFoundException {
        return EpmHelperUtils.getJarManifestList(Class.forName(clazzString));
    }

    public static String getManifestString(String clazzString) {
        ArrayList<String> lineStringList = new ArrayList<String>(20);
        try {
            lineStringList.add(LocalDateTime.now().toString());
            List<Manifest> jarManifestList = EpmHelperUtils.getJarManifestList(clazzString);
            for (Manifest manifest : jarManifestList) {
                Attributes attributes = manifest.getMainAttributes();
                for (Map.Entry<Object, Object> objectEntry : attributes.entrySet()) {
                    lineStringList.add(Convert.toStr((Object)objectEntry.getKey()) + ": " + Convert.toStr((Object)objectEntry.getValue()));
                }
            }
        }
        catch (Throwable throwable) {
            log.error("EpmHelperUtils.getManifestString", throwable);
        }
        return String.join((CharSequence)"\n", lineStringList);
    }
}

