/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.paramter;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.billlist.BillListUtil;
import kd.epm.eb.common.control.domain.BillDao;
import kd.epm.eb.common.lazytree.ILazyTreeHandler;
import kd.epm.eb.common.lazytree.ITreeNode;
import kd.epm.eb.common.lazytree.LazyTreeContainer;
import kd.epm.eb.common.lazytree.paramterControl.ParamterControlLazyTreeHandler;
import kd.epm.eb.common.tree.model.AuthorOrgTreeNode;
import kd.epm.eb.common.tree.model.AuthorOrgTreeNodeBuilder;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.EpmTreeUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.CommonMethod;
import kd.epm.eb.formplugin.paramter.ControlParameterModel;
import kd.epm.eb.formplugin.templateImport.ExportTemplatePlugin;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;
import org.apache.commons.collections4.CollectionUtils;

public class ParamterControlPlugin
extends AbstractFormPlugin
implements CommonMethod,
ClickListener,
TreeNodeQueryListener,
TreeNodeClickListener {
    public static final String TREEVIEW = "treeviewap";
    public static final String TREENTRYENTITY = "treeentryentity";
    private static final Log log = LogFactory.getLog(ExportTemplatePlugin.class);
    private List<String> permItems = Lists.newArrayList((Object[])new String[]{"47150e89000000ac", "47156aff000000ac", "4715a0df000000ac"});
    public static final String SHOW_CHECK_MEM_PERMISSION = "showcheckmempermission";
    public static final String SHOW_BEYOND_MESSAGE = "showbeyondmessage";
    public static final String CONTROL_MESSAGE = "controlmessage";

    @Override
    public void registerListener(EventObject e) {
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEW);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(TREENTRYENTITY);
        treeEntry.addCellClickListener((TreeNodeQueryListener)this);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"imageup", "imagedown", "orgimageup", "orgimagedown"});
        Search search = (Search)this.getView().getControl("searchap");
        search.addEnterListener(event -> TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), this.getView(), this.getPageCache(), new TreeSearchUtil.TreeSearchParam(TREEVIEW, "tree"), true));
        Search search1 = (Search)this.getView().getControl("searchap1");
        search1.addEnterListener(event -> {
            AuthorOrgTreeNode root = (AuthorOrgTreeNode)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("entry"));
            DynamicObjectCollection dynamicObjectCollection = this.getControlParamByBillId();
            HashMap<String, Boolean> ebBalanceMap = new HashMap<String, Boolean>(dynamicObjectCollection.size());
            HashMap<String, Boolean> checkMemPermissionMap = new HashMap<String, Boolean>(dynamicObjectCollection.size());
            HashMap<String, Boolean> beyondMessageMap = new HashMap<String, Boolean>(dynamicObjectCollection.size());
            this.buildParamMap(dynamicObjectCollection, ebBalanceMap, checkMemPermissionMap, beyondMessageMap);
            new LazyTreeContainer(this.getModel(), this.getView(), (ILazyTreeHandler)new ParamterControlLazyTreeHandler(this.getBillFromCache().getName()).setBalanceMap(ebBalanceMap).setCheckMemPermissionMap(checkMemPermissionMap).setBeyondMessageMap(beyondMessageMap), (ITreeNode)root).search(event);
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{SHOW_BEYOND_MESSAGE});
        TreeNode treeNode = this.initTree();
        TreeNode firstNode = BillListUtil.getFirstBillNode((TreeNode)treeNode);
        if (firstNode == null) {
            return;
        }
        String bill = firstNode.getId();
        String entityNumber = null;
        if (firstNode.getData() instanceof Map) {
            entityNumber = (String)((Map)firstNode.getData()).get("number");
        }
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
        treeView.focusNode(firstNode);
        BillDao billDao = new BillDao(Convert.toLong((Object)bill), firstNode.getText(), entityNumber);
        this.getPageCache().put("billCache", JSON.toJSONString((Object)billDao));
        AuthorOrgTreeNode root = new AuthorOrgTreeNode(Long.valueOf(0L), ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"ParamterControlPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), null);
        DynamicObjectCollection docs = AuthorOrgTreeNodeBuilder.getAuthorOrgDynaexcute();
        root = AuthorOrgTreeNodeBuilder.getAuthorOrgTreeNodeexcutebrance((AuthorOrgTreeNode)root, (IFormView)this.getView(), (String)"eb_parametercontrolset", this.permItems, (DynamicObjectCollection)docs);
        root.setParent(null);
        this.isPermission(root);
    }

    public BillDao getBillFromCache() {
        String billCache = this.getPageCache().get("billCache");
        if (StringUtils.isNotEmpty((String)billCache)) {
            return (BillDao)JSON.parseObject((String)billCache, BillDao.class);
        }
        return null;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEW);
        BillDao bill = this.getBillFromCache();
        if (bill != null && !evt.getNodeId().equals(bill)) {
            this.getPageCache().remove("expendIds");
            this.getPageCache().remove("expandid");
            this.treeOnClick(tree);
        }
    }

    public void isPermission(AuthorOrgTreeNode root) {
        this.getPageCache().put("entry", SerializationUtils.serializeToBase64((Object)root));
        if (root != null) {
            BillDao bill = this.getBillFromCache();
            DynamicObjectCollection dynamicObjectCollection = this.getControlParamByBillId();
            HashMap<String, Boolean> ebBalanceMap = new HashMap<String, Boolean>(dynamicObjectCollection.size());
            HashMap<String, Boolean> checkMemPermissionMap = new HashMap<String, Boolean>(dynamicObjectCollection.size());
            HashMap<String, Boolean> beyondMessageMap = new HashMap<String, Boolean>(dynamicObjectCollection.size());
            this.buildParamMap(dynamicObjectCollection, ebBalanceMap, checkMemPermissionMap, beyondMessageMap);
            new LazyTreeContainer(this.getModel(), this.getView(), (ILazyTreeHandler)new ParamterControlLazyTreeHandler(bill.getName()).setBalanceMap(ebBalanceMap).setCheckMemPermissionMap(checkMemPermissionMap).setBeyondMessageMap(beyondMessageMap), (ITreeNode)root).initTree();
            this.showEntryData2();
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6ca1\u6709\u6388\u6743\uff0c\u8bf7\u5207\u6362\u7ec4\u7ec7\u3002", (String)"ParamterControlPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("close", (IFormPlugin)this));
        }
    }

    private TreeNode initTree() {
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
        TreeNode tree = new BillListUtil().getUserBillTree();
        treeView.addNode(tree);
        EpmTreeUtils.spreadAllNode((TreeNode)tree);
        this.getPageCache().put("tree", SerializationUtils.toJsonString((Object)tree));
        return tree;
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "close": {
                this.getView().close();
                break;
            }
            case "refresh": {
                TreeNode treeNode = this.initTree();
                TreeView treeView = (TreeView)this.getView().getControl(TREEVIEW);
                BillDao bill = this.getBillFromCache();
                TreeNode focusNode = treeNode.getTreeNode(bill.getId().toString(), 15);
                treeView.updateNode(treeNode);
                if (focusNode == null) {
                    focusNode = BillListUtil.getFirstBillNode((TreeNode)treeNode);
                    treeView.focusNode(focusNode);
                    this.treeOnClick(treeView);
                    break;
                }
                treeView.focusNode(focusNode);
                break;
            }
            case "showparamter": {
                FormShowParameter param = new FormShowParameter();
                param.setFormId("eb_customparamset");
                param.getOpenStyle().setShowType(ShowType.Modal);
                param.setCustomParam("bill", (Object)this.getBillFromCache().getId());
                this.getView().showForm(param);
                break;
            }
            case "controlmessage": {
                this.openControlMessagePage();
                break;
            }
        }
    }

    private void openControlMessagePage() {
        BillDao bill;
        TreeNode treeNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("tree"), TreeNode.class);
        TreeNode focusNode = treeNode.getTreeNode((bill = this.getBillFromCache()).getId().toString(), 15);
        if (focusNode == null || CollectionUtils.isNotEmpty((Collection)focusNode.getChildren())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5355\u636e\u8bbe\u7f6e\u63d0\u793a\u6d88\u606f", (String)"ParamterControlPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter controlMessageParam = new FormShowParameter();
        controlMessageParam.setFormId("bgc_controlmessage_set");
        controlMessageParam.getOpenStyle().setShowType(ShowType.Modal);
        controlMessageParam.setCustomParam("bill", (Object)bill.getId());
        controlMessageParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CONTROL_MESSAGE));
        this.getView().showForm(controlMessageParam);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (CONTROL_MESSAGE.equals(actionId) && "success".equals(returnData = (String)closedCallBackEvent.getReturnData())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ControlMessageSetPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void treeOnClick(TreeView tree) {
        TreeNode treeNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("tree"), TreeNode.class);
        TreeView.TreeState state = tree.getTreeState();
        String billId = state.getFocusNode().get("id").toString();
        String entityNumber = null;
        TreeNode billNode = treeNode.getTreeNode(billId, 15);
        if (billNode != null && billNode.getData() instanceof Map) {
            entityNumber = (String)((Map)billNode.getData()).get("number");
        }
        this.treeNodeQueryClick(billId, entityNumber, treeNode);
    }

    public void treeNodeQueryClick(String billId, String entityNumber, TreeNode treeNode) {
        TreeNode currentNode = treeNode.getTreeNode(billId, 5);
        if (currentNode == null) {
            currentNode = treeNode;
        }
        TreeNode firstNode = BillListUtil.getFirstBillNode((TreeNode)currentNode);
        this.getModel().deleteEntryData(TREENTRYENTITY);
        if (firstNode != null) {
            BillDao bill = new BillDao(Convert.toLong((Object)billId), firstNode.getText(), entityNumber);
            this.getPageCache().put("billCache", JSON.toJSONString((Object)bill));
            this.showParamterControl();
        }
    }

    public void showParamterControl() {
        AuthorOrgTreeNode root = (AuthorOrgTreeNode)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("entry"));
        BillDao bill = this.getBillFromCache();
        DynamicObjectCollection dynamicObjectCollection = this.getControlParamByBillId();
        HashMap<String, Boolean> ebBalanceMap = new HashMap<String, Boolean>(dynamicObjectCollection.size());
        HashMap<String, Boolean> checkMemPermissionMap = new HashMap<String, Boolean>(dynamicObjectCollection.size());
        HashMap<String, Boolean> beyondMessageMap = new HashMap<String, Boolean>(dynamicObjectCollection.size());
        this.buildParamMap(dynamicObjectCollection, ebBalanceMap, checkMemPermissionMap, beyondMessageMap);
        new LazyTreeContainer(this.getModel(), this.getView(), (ILazyTreeHandler)new ParamterControlLazyTreeHandler(bill.getName()).setBalanceMap(ebBalanceMap).setCheckMemPermissionMap(checkMemPermissionMap).setBeyondMessageMap(beyondMessageMap), (ITreeNode)root).initTree();
        this.showEntryData2();
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        switch (callBackId = e.getCallBackId()) {
            case "close": {
                this.getView().close();
                break;
            }
            case "exit": {
                if (!e.getResult().equals((Object)MessageBoxResult.Yes)) break;
                this.getView().close();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        DynamicObjectCollection entity = this.getModel().getEntryEntity(TREENTRYENTITY);
        EntryGrid entry = (EntryGrid)this.getControl(TREENTRYENTITY);
        int[] selectRows = entry.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            int row = selectRows[0];
            this.getPageCache().put("changeEntry", "1");
            DynamicObject rowObj1 = this.getModel().getEntryRowEntity(TREENTRYENTITY, row);
            if ("showebbalance".equals(e.getProperty().getName()) || SHOW_CHECK_MEM_PERMISSION.equals(e.getProperty().getName()) || SHOW_BEYOND_MESSAGE.equals(e.getProperty().getName())) {
                this.setChildValue(row, entity, e.getProperty().getName(), rowObj1);
            }
        }
    }

    public void setChildValue(int row, DynamicObjectCollection entity, String propertyName, DynamicObject rowObj1) {
        BillDao bill = this.getBillFromCache();
        String fieldName = "";
        String paramKey = "";
        if ("showebbalance".equals(propertyName)) {
            fieldName = "fshowebbalance";
            paramKey = "IS_SHOWBALANCE";
        } else if (SHOW_CHECK_MEM_PERMISSION.equals(propertyName)) {
            fieldName = "fshowcheckmempermission";
            paramKey = "IS_SHOWCHECKMEMPERMISSION";
        } else if (SHOW_BEYOND_MESSAGE.equals(propertyName)) {
            fieldName = "fshowbeyondmessage";
            paramKey = "IS_SHOWBEYONDMESSAGE";
        }
        CacheServiceHelper.clearShowControlParamByEntityAndParamKey((String)bill.getNumber(), (String)paramKey);
        if (rowObj1 == null) {
            return;
        }
        String startlongNumber = rowObj1.getString("longnumber") + "!";
        String longNumber = rowObj1.getString("longnumber");
        for (int i = row + 1; i < entity.size(); ++i) {
            DynamicObject rowObj = (DynamicObject)entity.get(i);
            if (!rowObj.getString("longnumber").startsWith(startlongNumber)) continue;
            rowObj.set(propertyName, (Object)rowObj1.getBoolean(propertyName));
        }
        this.getView().updateView(TREENTRYENTITY);
        boolean aBoolean = rowObj1.getBoolean(propertyName);
        ControlParameterModel cpm = new ControlParameterModel(rowObj1.getLong("orgid"), rowObj1.getBoolean("showebbalance"), rowObj1.getBoolean(SHOW_CHECK_MEM_PERMISSION), rowObj1.getBoolean(SHOW_BEYOND_MESSAGE), rowObj1.getLong("parent"), rowObj1.getBoolean("isinfluential"), rowObj1.getString("longnumber"), rowObj1.getString("administrativeorg"), rowObj1.getString("orgnumber"));
        if (!QueryServiceHelper.exists((String)"eb_controlparameter", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)rowObj1.getLong("orgid")).and("bill", "=", (Object)bill.getId())})) {
            DynamicObject detp = BusinessDataServiceHelper.newDynamicObject((String)"eb_controlparameter");
            detp.set("orgnumber", (Object)cpm.getOrgnumber());
            detp.set("isinfluential", (Object)cpm.isIsinfluential());
            detp.set("creator", (Object)UserUtils.getUserId());
            detp.set("longnumber", (Object)cpm.getLongnumber());
            detp.set("bill", (Object)bill.getId());
            detp.set("showebbalance", (Object)cpm.isShowebbalance());
            detp.set(SHOW_CHECK_MEM_PERMISSION, (Object)cpm.isShowcheckmempermission());
            detp.set(SHOW_BEYOND_MESSAGE, (Object)cpm.isShowbeyondmessage());
            detp.set("org", (Object)cpm.getOrgid());
            detp.set("name", (Object)cpm.getName());
            detp.set("parent", (Object)cpm.getParent());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{detp});
            this.writeLog("save", new MultiLangEnumBridge("\u4fdd\u5b58", "ParamterControlPlugin_3", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f", "ParamterControlPlugin_4", "epm-eb-formplugin"));
        }
        try {
            String sql = "update t_eb_startparamter set " + fieldName + " = ? where fbillid = ? and (flongnumber like ? or flongnumber = ? or forgid = ?)";
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql, (Object[])new Object[]{aBoolean, bill.getId(), startlongNumber + "%", longNumber, cpm.getOrgid()});
            sql = "update t_eb_startparamter set forgnumber = ?, flongnumber = ?  where fbillid = ? and forgid = ?";
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql, (Object[])new Object[]{rowObj1.getString("orgnumber"), longNumber, bill.getId(), cpm.getOrgid()});
            this.writeLog("update", new MultiLangEnumBridge("\u542f\u7528\u63a7\u5236\u53c2\u6570\u66f4\u65b0\u7ec4\u7ec7\u76f8\u5173\u503c\u6210\u529f", "ParamterControlPlugin_12", "epm-eb-formplugin"), null);
        }
        catch (Exception ex) {
            this.writeLog("update", new MultiLangEnumBridge("\u542f\u7528\u63a7\u5236\u53c2\u6570\u66f4\u65b0\u7ec4\u7ec7\u76f8\u5173\u503c\u5931\u8d25", "ParamterControlPlugin_13", "epm-eb-formplugin"), null, false);
            log.error((Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
    }

    private void showEntryData2() {
        long st = System.currentTimeMillis();
        DynamicObject rowObj = null;
        DynamicObjectCollection dynamicObjectCollection = this.getControlParamByBillId();
        HashMap<String, Boolean> ebBalanceMap = new HashMap<String, Boolean>(dynamicObjectCollection.size());
        HashMap<String, Boolean> checkMemPermissionMap = new HashMap<String, Boolean>(dynamicObjectCollection.size());
        HashMap<String, Boolean> beyondMessageMap = new HashMap<String, Boolean>(dynamicObjectCollection.size());
        this.buildParamMap(dynamicObjectCollection, ebBalanceMap, checkMemPermissionMap, beyondMessageMap);
        int size = this.getModel().getEntryEntity(TREENTRYENTITY).size();
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            rowObj = this.getModel().getEntryRowEntity(TREENTRYENTITY, rowIndex);
            this.setControlParamTreeNodeValue(rowObj, ebBalanceMap, "showebbalance");
            this.setControlParamTreeNodeValue(rowObj, checkMemPermissionMap, SHOW_CHECK_MEM_PERMISSION);
            this.setControlParamTreeNodeValue(rowObj, beyondMessageMap, SHOW_BEYOND_MESSAGE);
        }
        this.getView().updateView(TREENTRYENTITY);
        log.error("showEntryData2 use(ms) " + (System.currentTimeMillis() - st));
    }

    protected void buildParamMap(DynamicObjectCollection dynamicObjectCollection, Map<String, Boolean> ebBalanceMap, Map<String, Boolean> checkMemPermissionMap, Map<String, Boolean> beyondMessageMap) {
        for (DynamicObject dyobj : dynamicObjectCollection) {
            ebBalanceMap.put(dyobj.getString("orgnumber"), dyobj.getBoolean("showebbalance"));
            checkMemPermissionMap.put(dyobj.getString("orgnumber"), dyobj.getBoolean(SHOW_CHECK_MEM_PERMISSION));
            beyondMessageMap.put(dyobj.getString("orgnumber"), dyobj.getBoolean(SHOW_BEYOND_MESSAGE));
        }
    }

    private void setControlParamTreeNodeValue(DynamicObject rowObj, Map<String, Boolean> controlParamMap, String controlParam) {
        if (controlParamMap.containsKey(rowObj.getString("orgnumber"))) {
            rowObj.set(controlParam, (Object)controlParamMap.get(rowObj.getString("orgnumber")));
        } else {
            String longnumber = rowObj.getString("longnumber");
            String[] split = longnumber.split("!");
            if (split.length >= 2) {
                for (int k = split.length - 2; k >= 0; --k) {
                    if (controlParamMap.containsKey(split[k])) {
                        rowObj.set(controlParam, (Object)controlParamMap.get(split[k]));
                        break;
                    }
                    rowObj.set(controlParam, (Object)this.getModel().getEntryRowEntity(TREENTRYENTITY, 0).getBoolean(controlParam));
                }
            }
        }
    }

    private DynamicObjectCollection getControlParamByBillId() {
        BillDao bill = this.getBillFromCache();
        QFilter qcf = new QFilter("bill", "=", (Object)bill.getId());
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"eb_controlparameter", (String)"isinfluential,showebbalance,showcheckmempermission,showbeyondmessage,orgnumber,org", (QFilter[])new QFilter[]{qcf});
        return dynamicObjectCollection;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        String key = Control2.getKey();
        if (evt.getSource() instanceof Button) {
            DynamicObjectCollection dynamicObjectCollection = this.getControlParamByBillId();
            HashMap<String, Boolean> ebBalanceMap = new HashMap<String, Boolean>(dynamicObjectCollection.size());
            HashMap<String, Boolean> checkMemPermissionMap = new HashMap<String, Boolean>(dynamicObjectCollection.size());
            HashMap<String, Boolean> beyondMessageMap = new HashMap<String, Boolean>(dynamicObjectCollection.size());
            this.buildParamMap(dynamicObjectCollection, ebBalanceMap, checkMemPermissionMap, beyondMessageMap);
            switch (key) {
                case "imageup": {
                    TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(TREEVIEW, "tree", TreeSearchUtil.SearchBtnStatus.LEFT));
                    break;
                }
                case "imagedown": {
                    TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(TREEVIEW, "tree", TreeSearchUtil.SearchBtnStatus.RIGHT));
                    break;
                }
                case "orgimageup": {
                    AuthorOrgTreeNode root = (AuthorOrgTreeNode)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("entry"));
                    new LazyTreeContainer(this.getModel(), this.getView(), (ILazyTreeHandler)new ParamterControlLazyTreeHandler(this.getBillFromCache().getName()).setBalanceMap(ebBalanceMap).setCheckMemPermissionMap(checkMemPermissionMap).setBeyondMessageMap(beyondMessageMap), (ITreeNode)root).searchBefore();
                    break;
                }
                case "orgimagedown": {
                    AuthorOrgTreeNode root2 = (AuthorOrgTreeNode)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("entry"));
                    new LazyTreeContainer(this.getModel(), this.getView(), (ILazyTreeHandler)new ParamterControlLazyTreeHandler(this.getBillFromCache().getName()).setBalanceMap(ebBalanceMap).setCheckMemPermissionMap(checkMemPermissionMap).setBeyondMessageMap(beyondMessageMap), (ITreeNode)root2).searchNext();
                }
            }
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        AuthorOrgTreeNode root2 = (AuthorOrgTreeNode)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("entry"));
        DynamicObjectCollection dynamicObjectCollection = this.getControlParamByBillId();
        HashMap<String, Boolean> ebBalanceMap = new HashMap<String, Boolean>(dynamicObjectCollection.size());
        HashMap<String, Boolean> checkMemPermissionMap = new HashMap<String, Boolean>(dynamicObjectCollection.size());
        HashMap<String, Boolean> beyondMessageMap = new HashMap<String, Boolean>(dynamicObjectCollection.size());
        this.buildParamMap(dynamicObjectCollection, ebBalanceMap, checkMemPermissionMap, beyondMessageMap);
        new LazyTreeContainer(this.getModel(), this.getView(), (ILazyTreeHandler)new ParamterControlLazyTreeHandler(this.getBillFromCache().getName()).setBalanceMap(ebBalanceMap).setCheckMemPermissionMap(checkMemPermissionMap).setBeyondMessageMap(beyondMessageMap), (ITreeNode)root2).queryTreeNodeChildren(evt);
    }
}

