/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.perioddistribution;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.epm.eb.business.bizrule.RuleExecutionService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.perioddistribution.domain.PeriodDisPageDomain;
import kd.epm.eb.common.perioddistribution.domain.PeriodDisPeriodInfo;
import kd.epm.eb.common.rule.execute.RuleExecuteTypeEnum;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.task.command.PeriodDistributionCommand;
import kd.epm.eb.olap.impl.bizrule.entity.RuleTemplateInfo;
import kd.epm.eb.olap.service.OlapCommService;
import kd.epm.eb.olap.service.request.QueryRequest;
import kd.epm.eb.olap.service.request.SaveRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class PeriodDistributionPlugin
extends AbstractListPlugin {
    private static final String PAGE_ENTRYS = "pageEntrys";
    private static final String ALLYEAR = "allyear";
    private PeriodDisPageDomain pageDomain;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        PeriodDisPageDomain pageDomain = this.getPageDomain();
        this.hideRateEntity(pageDomain.getType());
        this.hidePeriodCell(pageDomain.getPeriodInfos());
        Map<String, Set<String>> selectCells = this.getSelectCells(pageDomain.getCells());
        this.doFillPageDim(selectCells);
        Map<MembersKey, Object> cellSets = this.fillEntryEntity(pageDomain, selectCells);
        this.doInsertRow(pageDomain, cellSets);
        this.setPeriodEnable(pageDomain);
    }

    private void setPeriodEnable(PeriodDisPageDomain pageDomain, int rowIndex) {
        if (PeriodDistributionCommand.TypeEnum.rate.getDescription().equals(pageDomain.getType())) {
            String[] strings = new String[pageDomain.getPeriodInfos().size()];
            for (int i = 0; i < pageDomain.getPeriodInfos().size(); ++i) {
                PeriodDisPeriodInfo periodInfo = (PeriodDisPeriodInfo)pageDomain.getPeriodInfos().get(i);
                Integer suff = periodInfo.getSuff();
                strings[i] = "period" + suff;
            }
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, strings);
        }
    }

    private void setPeriodEnable(PeriodDisPageDomain pageDomain) {
        if (PeriodDistributionCommand.TypeEnum.rate.getDescription().equals(pageDomain.getType())) {
            int i;
            int rowCount = this.getModel().getEntryRowCount("entryentity");
            String[] strings = new String[pageDomain.getPeriodInfos().size()];
            for (i = 0; i < pageDomain.getPeriodInfos().size(); ++i) {
                PeriodDisPeriodInfo periodInfo = (PeriodDisPeriodInfo)pageDomain.getPeriodInfos().get(i);
                Integer suff = periodInfo.getSuff();
                strings[i] = "period" + suff;
            }
            for (i = 0; i < rowCount; ++i) {
                this.getView().setEnable(Boolean.valueOf(false), i, strings);
            }
        }
    }

    private void hideRateEntity(String type) {
        if (!PeriodDistributionCommand.TypeEnum.rate.getDescription().equals(type)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"ratepage"});
        } else {
            DynamicObjectCollection rateentity = this.getModel().getEntryEntity("rateentity");
            DynamicObject doj1 = (DynamicObject)rateentity.get(0);
            doj1.set("description", (Object)ResManager.loadKDString((String)"\u5360\u6bd4%", (String)"PeriodDistributionPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            DynamicObject doj2 = (DynamicObject)rateentity.get(1);
            doj2.set("description", (Object)ResManager.loadKDString((String)"\u53c2\u8003\u503c", (String)"PeriodDistributionPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.getView().updateView("rateentity");
        }
    }

    private void hidePeriodCell(List<PeriodDisPeriodInfo> periodInfos) {
        Set collect = periodInfos.stream().map(PeriodDisPeriodInfo::getSuff).collect(Collectors.toSet());
        for (int i = 1; i < 13; ++i) {
            if (collect.contains(i)) continue;
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"rate" + i});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"period" + i});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propKey = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        BigDecimal newValue = (BigDecimal)changeData.getNewValue();
        BigDecimal oldValue = (BigDecimal)changeData.getOldValue();
        int rowIndex = changeData.getRowIndex();
        if (ALLYEAR.equals(propKey)) {
            this.changeCurrRow(rowIndex, newValue);
        } else if (propKey.startsWith("period")) {
            this.changeCurrRow(rowIndex, propKey, newValue, oldValue);
        } else if (propKey.startsWith("rate")) {
            this.changeRate(rowIndex, propKey);
        }
    }

    private void changeRate(int rowIndex, String propKey) {
        PeriodDisPageDomain pageDomain = this.getPageDomain();
        List periodInfos = pageDomain.getPeriodInfos();
        BigDecimal oneHe = new BigDecimal("100");
        if (rowIndex == 0) {
            DynamicObject rateRow = this.getModel().getEntryRowEntity("rateentity", 0);
            BigDecimal allcount = new BigDecimal("0");
            BigDecimal allcount2 = new BigDecimal("0");
            for (PeriodDisPeriodInfo periodInfo : periodInfos) {
                String propertyName = "rate" + periodInfo.getSuff();
                if (!propKey.equals(propertyName)) {
                    allcount2 = allcount2.add(rateRow.getBigDecimal(propertyName));
                }
                allcount = allcount.add(rateRow.getBigDecimal(propertyName));
            }
            rateRow.set("count", (Object)allcount);
            rateRow.set("count1", (Object)(allcount.intValue() + "%"));
            if (allcount.compareTo(oneHe) == 0) {
                BigDecimal count;
                for (PeriodDisPeriodInfo periodInfo : periodInfos) {
                    periodInfo.setRate(rateRow.getBigDecimal("rate" + periodInfo.getSuff()).divide(oneHe, 4));
                }
                this.getPageCache().put("pageDomain", JSON.toJSONString((Object)pageDomain));
                DynamicObject amountRow = this.getModel().getEntryRowEntity("rateentity", 1);
                String count1 = amountRow.getString("count1");
                if (StringUtils.isBlank((CharSequence)count1) || new BigDecimal(count1).compareTo(BigDecimal.ZERO) == 0) {
                    count = new BigDecimal("1000");
                    amountRow.set("count", (Object)count);
                    amountRow.set("count1", (Object)"1000");
                } else {
                    count = new BigDecimal(count1);
                }
                for (PeriodDisPeriodInfo periodInfo : periodInfos) {
                    BigDecimal rate = periodInfo.getRate();
                    if (rate == null) continue;
                    amountRow.set("rate" + periodInfo.getSuff(), (Object)count.multiply(rate));
                }
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows.length == 0) {
                    selectRows = null;
                }
                this.refreshPeriodEntity(selectRows);
            } else if (allcount.compareTo(oneHe) > 0) {
                BigDecimal realRate = oneHe.subtract(allcount2);
                this.getModel().setValue(propKey, (Object)realRate, rowIndex);
            }
            this.getView().updateView("rateentity");
        } else {
            DynamicObject rateRow = this.getModel().getEntryRowEntity("rateentity", 0);
            DynamicObject amountRow = this.getModel().getEntryRowEntity("rateentity", 1);
            BigDecimal allcount = new BigDecimal("0");
            for (PeriodDisPeriodInfo periodInfo : periodInfos) {
                allcount = allcount.add(amountRow.getBigDecimal("rate" + periodInfo.getSuff()));
            }
            BigDecimal allRate = new BigDecimal("0");
            int lastIndex = this.getLastIndex(amountRow, periodInfos, "rate");
            for (int i = 0; i < periodInfos.size(); ++i) {
                BigDecimal divide;
                if (i == lastIndex) continue;
                PeriodDisPeriodInfo periodInfo = (PeriodDisPeriodInfo)periodInfos.get(i);
                String propertyName = "rate" + periodInfo.getSuff();
                if (allcount.compareTo(BigDecimal.ZERO) == 0) {
                    divide = BigDecimal.ZERO;
                } else {
                    BigDecimal bigDecimal = amountRow.getBigDecimal(propertyName);
                    divide = bigDecimal.divide(allcount, 4, 4);
                }
                rateRow.set(propertyName, (Object)divide.multiply(oneHe));
                periodInfo.setRate(divide);
                allRate = allRate.add(divide);
            }
            if (lastIndex > -1) {
                PeriodDisPeriodInfo periodInfo = (PeriodDisPeriodInfo)periodInfos.get(lastIndex);
                BigDecimal subtract = BigDecimal.ONE.subtract(allRate);
                periodInfo.setRate(subtract);
                rateRow.set("rate" + periodInfo.getSuff(), (Object)subtract.multiply(oneHe));
                rateRow.set("count", (Object)oneHe);
                rateRow.set("count1", (Object)(oneHe.intValue() + "%"));
            } else {
                rateRow.set("count", (Object)BigDecimal.ZERO);
                rateRow.set("count1", (Object)(BigDecimal.ZERO.intValue() + "%"));
            }
            this.getPageCache().put("pageDomain", JSON.toJSONString((Object)pageDomain));
            amountRow.set("count", (Object)allcount);
            amountRow.set("count1", (Object)allcount.intValue());
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                selectRows = null;
            }
            this.refreshPeriodEntity(selectRows);
            this.getView().updateView("rateentity");
        }
    }

    private void refreshPeriodEntity(int[] selectRows) {
        PeriodDisPageDomain pageDomain = this.getPageDomain();
        List periodInfos = pageDomain.getPeriodInfos();
        DynamicObjectCollection entryentitys = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryentitys.size(); ++i) {
            if (selectRows != null && !Ints.contains((int[])selectRows, (int)i)) continue;
            DynamicObject entryentity = (DynamicObject)entryentitys.get(i);
            int scale = entryentity.getInt("scale");
            BigDecimal allyear = entryentity.getBigDecimal(ALLYEAR);
            if (allyear.compareTo(BigDecimal.ZERO) == 0) continue;
            this.putIntoEntity(periodInfos, scale, allyear, entryentity);
        }
        this.setPeriodEnable(pageDomain);
        this.getView().updateView("entryentity");
        if (selectRows != null) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            entryGrid.selectRows(selectRows, 0);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "ok": {
                this.saveReportData();
                break;
            }
            case "refresh": {
                break;
            }
            case "exit": {
                this.getView().close();
                break;
            }
        }
    }

    private void saveReportData() {
        PeriodDisPageDomain pageDomain = this.getPageDomain();
        Long modelId = pageDomain.getModelId();
        Long dataSetId = pageDomain.getDataSetId();
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        List cells = pageDomain.getCells();
        Integer periodIndex = pageDomain.getPeriodIndex();
        List periodInfos = pageDomain.getPeriodInfos();
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        LinkedList bgCellList = Lists.newLinkedList();
        String[] dimensionNumberStringArray = modelCacheHelper.getDimensionNums(dataSetId);
        for (int i = 0; i < cells.size(); ++i) {
            String[] metaData = (String[])cells.get(i);
            DynamicObject doj = (DynamicObject)entryentity.get(i);
            for (PeriodDisPeriodInfo periodInfo : periodInfos) {
                metaData = (String[])metaData.clone();
                metaData[periodIndex.intValue()] = periodInfo.getNumber();
                if (dimensionNumberStringArray.length != metaData.length) continue;
                LinkedHashMap memberMap = Maps.newLinkedHashMap();
                for (int j = 0; j < metaData.length; ++j) {
                    memberMap.put(dimensionNumberStringArray[j], metaData[j]);
                }
                BGCell bgCell = new BGCell();
                bgCell.setMemberMap((Map)memberMap);
                BigDecimal bigDecimal = doj.getBigDecimal("period" + periodInfo.getSuff());
                if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
                    bgCell.setValue(null);
                } else {
                    bgCell.setValue((Object)bigDecimal);
                }
                bgCellList.add(bgCell);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)bgCellList)) {
            SaveRequest saveRequest = new SaveRequest();
            saveRequest.setModelId(modelId);
            saveRequest.setDatasetId(dataSetId);
            saveRequest.setDatas((List)bgCellList);
            saveRequest.setViewMap(pageDomain.getDimensionView());
            OlapCommService.getInstance().save(saveRequest);
            RuleExecutionService.getInstance().executeRuleChain(new RuleTemplateInfo(modelId, this.getTemplateId()), dataSetId, modelId, (List)bgCellList, RuleExecuteTypeEnum.PERIOD_DISTRIBUTION.getType());
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                FormViewPluginProxy proxy = (FormViewPluginProxy)parentView.getService(FormViewPluginProxy.class);
                Optional<IFormPlugin> optional = proxy.getPlugIns().stream().filter(AbstractListPlugin.class::isInstance).findFirst();
                if (optional.isPresent()) {
                    IFormPlugin plugin = optional.get();
                    plugin.itemClick(new ItemClickEvent((Object)plugin, "refresh", ""));
                    this.getView().sendFormAction(parentView);
                }
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DynamicTemplateProcess_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void changeCurrRow(int rowIndex, String propKey, BigDecimal newValue, BigDecimal oldValue) {
        BigDecimal rate;
        List periodInfos;
        DynamicObject entryentity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        String periodinfo = entryentity.getString("periodinfo");
        if (periodinfo == null || periodinfo.isEmpty()) {
            PeriodDisPageDomain pageDomain = this.getPageDomain();
            periodInfos = pageDomain.getPeriodInfos();
        } else {
            periodInfos = JSON.parseArray((String)periodinfo, PeriodDisPeriodInfo.class);
        }
        BigDecimal allyear = entryentity.getBigDecimal(ALLYEAR);
        int scale = entryentity.getInt("scale");
        newValue = newValue.setScale(scale, 4);
        int rateScale = Math.max(scale * 4, 16);
        allyear = allyear.add(newValue).subtract(oldValue);
        while (newValue.compareTo(allyear.multiply(rate = newValue.divide(allyear, rateScale, 4)).setScale(scale, 4)) != 0) {
            rateScale += 2;
        }
        if (allyear.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal allRate = new BigDecimal("0");
            int lastIndex = this.getLastIndex(entryentity, periodInfos, "period");
            for (int i = 0; i < periodInfos.size(); ++i) {
                if (i == lastIndex) continue;
                PeriodDisPeriodInfo periodInfo = (PeriodDisPeriodInfo)periodInfos.get(i);
                Integer suff = periodInfo.getSuff();
                BigDecimal bigDecimal = entryentity.getBigDecimal("period" + suff);
                BigDecimal rate2 = bigDecimal.divide(allyear, rateScale, 4);
                periodInfo.setRate(rate2);
                allRate = allRate.add(rate2);
            }
            if (lastIndex > -1) {
                ((PeriodDisPeriodInfo)periodInfos.get(lastIndex)).setRate(BigDecimal.ONE.subtract(allRate));
            }
            entryentity.set("periodinfo", (Object)JSON.toJSONString((Object)periodInfos));
        } else {
            entryentity.set("periodinfo", null);
        }
        entryentity.set(ALLYEAR, (Object)allyear);
        this.putIntoEntity(periodInfos, scale, allyear, entryentity);
        this.getView().updateView("entryentity");
    }

    private int getLastIndex(DynamicObject entryentity, List<PeriodDisPeriodInfo> periodInfos, String pre) {
        int lastIndex = -1;
        for (int i = periodInfos.size() - 1; i >= 0; --i) {
            PeriodDisPeriodInfo periodInfo = periodInfos.get(i);
            Integer suff = periodInfo.getSuff();
            BigDecimal bigDecimal = entryentity.getBigDecimal(pre + suff);
            if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) continue;
            lastIndex = i;
            break;
        }
        return lastIndex;
    }

    private void changeCurrRow(int rowIndex, BigDecimal newValue) {
        PeriodDisPageDomain pageDomain = this.getPageDomain();
        DynamicObject entryentity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        List periodInfos = null;
        String periodinfo = entryentity.getString("periodinfo");
        int scale = entryentity.getInt("scale");
        periodInfos = periodinfo == null || periodinfo.isEmpty() ? pageDomain.getPeriodInfos() : JSON.parseArray((String)periodinfo, PeriodDisPeriodInfo.class);
        this.getModel().beginInit();
        this.putIntoEntity(periodInfos, scale, newValue, entryentity);
        this.getModel().endInit();
        if (newValue.compareTo(BigDecimal.ZERO) == 0) {
            entryentity.set("periodinfo", null);
        }
        this.setPeriodEnable(pageDomain);
        this.getView().updateView("entryentity");
    }

    private void doFillPageDim(Map<String, Set<String>> selectCells) {
        HashMap pageEntrys = new HashMap(16);
        selectCells.forEach((k, v) -> {
            if (!(SysDimensionEnum.Account.getNumber().equals(k) || SysDimensionEnum.Metric.getNumber().equals(k) || SysDimensionEnum.BudgetPeriod.getNumber().equals(k) || SysDimensionEnum.Entity.getNumber().equals(k) || v.size() >= 2)) {
                pageEntrys.put(k, v.iterator().next());
            }
        });
        this.getPageCache().put(PAGE_ENTRYS, JSONObject.toJSONString(pageEntrys));
    }

    private Map<String, Set<String>> getSelectCells(List<String[]> cells) {
        IModelCacheHelper modelCache = this.getIModelCacheHelper();
        String[] dimensionNums = modelCache.getDimensionNums(this.getDataSetId());
        return this.cell2Map(dimensionNums, cells);
    }

    private Map<MembersKey, Object> fillEntryEntity(PeriodDisPageDomain pageDomain, Map<String, Set<String>> selectCells) {
        IModelCacheHelper modelCache = this.getIModelCacheHelper();
        String[] dimensionNums = modelCache.getDimensionNums(pageDomain.getDataSetId());
        QueryRequest request = new QueryRequest(this.getModelId(), this.getDataSetId(), selectCells);
        List bgCells = OlapCommService.getInstance().queryList(request);
        String[] cells = new String[dimensionNums.length];
        HashMap cellSets = Maps.newHashMapWithExpectedSize((int)bgCells.size());
        for (BGCell bgCell : bgCells) {
            if (!(bgCell.getValue() instanceof Number)) continue;
            Map memberMap = bgCell.getMemberMap();
            for (int i = 0; i < dimensionNums.length; ++i) {
                cells[i] = (String)memberMap.get(dimensionNums[i]);
            }
            cellSets.put(MembersKey.of((String[])cells), ConvertUtils.toDecimal((Object)bgCell.getValue()));
        }
        return cellSets;
    }

    private SelectCommandInfo doCreateSelectCommand(String[] dimensionNums, Map<String, Set<String>> cells) {
        SelectCommandInfo selectCommandInfo = new SelectCommandInfo();
        selectCommandInfo.addDims(dimensionNums);
        cells.forEach((k, v) -> selectCommandInfo.addFilter(k, v.toArray(new String[0])));
        return selectCommandInfo;
    }

    private Map<String, Set<String>> cell2Map(String[] dimensionNums, List<String[]> cells) {
        HashMap<String, Set<String>> selectCells = new HashMap<String, Set<String>>(16);
        IModelCacheHelper modelCache = this.getIModelCacheHelper();
        for (String[] cell : cells) {
            for (int i = 0; i < dimensionNums.length; ++i) {
                String dimensionNum = dimensionNums[i];
                String memberNumber = cell[i];
                selectCells.computeIfAbsent(dimensionNum, v -> new HashSet(16)).add(memberNumber);
            }
        }
        return selectCells;
    }

    private void doInsertRow(PeriodDisPageDomain pageDomain, Map<MembersKey, Object> results) {
        List cells = pageDomain.getCells();
        this.getModel().deleteEntryData("entryentity");
        this.getModel().batchCreateNewEntryRow("entryentity", cells.size());
        Map<String, String> pageEntitys = this.getPageEntitys();
        Map<String, Integer> dimIndexMapping = this.getDimIndexMapping();
        Set<String> pageDims = pageEntitys.keySet();
        Integer metricIndex = pageDomain.getMetricIndex();
        Map metricScale = pageDomain.getMetricScale();
        Map dimensionView = pageDomain.getDimensionView();
        for (int i = 0; i < cells.size(); ++i) {
            String[] cell = (String[])cells.get(i);
            DynamicObject entryentity = this.getModel().getEntryRowEntity("entryentity", i);
            this.insertIntoEntityFieldCell(entryentity, cell, pageDims, dimIndexMapping, dimensionView);
            MembersKey membersKey = MembersKey.of((String[])cell);
            String metricNumber = cell[metricIndex];
            Integer scale = metricScale.getOrDefault(metricNumber, 2);
            BigDecimal value = (BigDecimal)results.get(membersKey);
            if (value == null) continue;
            entryentity.set(ALLYEAR, (Object)value);
            this.putIntoEntity(pageDomain.getPeriodInfos(), scale, value, entryentity);
        }
        this.getView().updateView("entryentity");
    }

    private void putIntoEntity(List<PeriodDisPeriodInfo> periodInfos, Integer scale, BigDecimal value, DynamicObject entryentity) {
        BigDecimal[] decimals = this.partValue(periodInfos, scale, value);
        for (int j = 0; j < periodInfos.size(); ++j) {
            BigDecimal decimal;
            PeriodDisPeriodInfo periodInfo = periodInfos.get(j);
            Integer suff = periodInfo.getSuff();
            BigDecimal bigDecimal = decimal = decimals != null && decimals.length > j ? decimals[j] : null;
            if (decimal == null) continue;
            entryentity.set("period" + suff, (Object)decimal);
        }
        entryentity.set("scale", (Object)scale);
    }

    private BigDecimal[] partValue(List<PeriodDisPeriodInfo> periodInfos, Integer scale, BigDecimal value) {
        if (value == null || periodInfos == null || periodInfos.isEmpty()) {
            return null;
        }
        BigDecimal[] bigDecimals = new BigDecimal[periodInfos.size()];
        BigDecimal multiply = value.divide(new BigDecimal(String.valueOf(periodInfos.size())), (int)scale, 4);
        BigDecimal allCount = new BigDecimal("0");
        BigDecimal currencyCell = null;
        int lastIndex = this.getLastIndex(periodInfos);
        for (int i = 0; i < periodInfos.size(); ++i) {
            if (i == lastIndex) continue;
            PeriodDisPeriodInfo periodInfo = periodInfos.get(i);
            BigDecimal rate = periodInfo.getRate();
            currencyCell = rate != null ? value.multiply(rate).setScale((int)scale, 4) : multiply;
            allCount = allCount.add(currencyCell);
            bigDecimals[i] = currencyCell;
        }
        if (lastIndex > -1) {
            bigDecimals[lastIndex] = value.subtract(allCount);
        }
        return bigDecimals;
    }

    private int getLastIndex(List<PeriodDisPeriodInfo> periodInfos) {
        PeriodDisPageDomain pageDomain = this.getPageDomain();
        if (PeriodDistributionCommand.TypeEnum.average.getDescription().equals(pageDomain.getType())) {
            return periodInfos.size() - 1;
        }
        int lastIndex = -1;
        for (int i = periodInfos.size() - 1; i >= 0; --i) {
            PeriodDisPeriodInfo periodInfo = periodInfos.get(i);
            if (periodInfo.getRate() == null || periodInfo.getRate().compareTo(BigDecimal.ZERO) == 0) continue;
            lastIndex = i;
            break;
        }
        if (lastIndex == -1) {
            return periodInfos.size() - 1;
        }
        return lastIndex;
    }

    private void insertIntoEntityFieldCell(DynamicObject entryentity, String[] cell, Set<String> pageDims, Map<String, Integer> dimIndexMapping, Map<String, Long> dimensionView) {
        StringBuilder sb = new StringBuilder();
        IModelCacheHelper modelCache = this.getIModelCacheHelper();
        for (Map.Entry<String, Integer> entry : dimIndexMapping.entrySet()) {
            String dimNum = entry.getKey();
            if (pageDims.contains(entry.getKey()) || SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNum)) continue;
            String memNum = cell[entry.getValue()];
            if (SysDimensionEnum.Account.getNumber().equals(dimNum)) {
                entryentity.set("account", (Object)modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, memNum).getName());
                continue;
            }
            if (SysDimensionEnum.Metric.getNumber().equals(dimNum)) {
                entryentity.set("metric", (Object)modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, memNum).getName());
                continue;
            }
            if (sb.length() != 0) {
                sb.append("\r\n");
            }
            Dimension dimension = modelCache.getDimension(dimNum);
            Member member = modelCache.getMember(dimNum, dimensionView.get(dimNum), memNum);
            sb.append(dimension.getName()).append(':').append(member.getName());
        }
        entryentity.set("otherdim", (Object)sb.toString());
    }

    private Integer getDimIndex(String number) {
        return this.getDimIndexMapping().get(number);
    }

    private Map<String, Integer> getDimIndexMapping() {
        IModelCacheHelper modelCache = this.getIModelCacheHelper();
        return modelCache.getDimIndexMap(this.getDataSetId(), false);
    }

    public Map<String, String> getPageEntitys() {
        return (Map)JSONObject.parseObject((String)this.getPageCache().get(PAGE_ENTRYS), Map.class);
    }

    private PeriodDisPageDomain getPageDomain() {
        if (this.pageDomain == null) {
            String seriz = this.getPageCache().get("pageDomain");
            if (StringUtils.isEmpty((CharSequence)seriz)) {
                seriz = (String)this.getFormCustomParam("pageDomain");
                this.getPageCache().put("pageDomain", seriz);
            }
            this.pageDomain = (PeriodDisPageDomain)JSON.parseObject((String)seriz, PeriodDisPageDomain.class);
        }
        return this.pageDomain;
    }

    @Override
    public Long getModelId() {
        return this.getPageDomain().getModelId();
    }

    public Long getTemplateId() {
        return this.getPageDomain().getTemplateId();
    }

    public Long getDataSetId() {
        return this.getPageDomain().getDataSetId();
    }
}

