/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.perm;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.applybill.Count;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.perm.ContainResult;
import kd.epm.eb.common.cache.impl.perm.MemberRecord;
import kd.epm.eb.common.cache.impl.perm.RowRecord;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.entity.property.CustomPropertyUtils;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.MembPermRecordUtil;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.enums.PermGroupEnum;
import kd.epm.eb.common.permission.pojo.DimMembPermDetailRecord;
import kd.epm.eb.common.permission.pojo.DimMembPermRecord;
import kd.epm.eb.common.permission.pojo.PermDimGroup;
import kd.epm.eb.common.permission.pojo.UserInfo;
import kd.epm.eb.common.pojo.serch.SearchType;
import kd.epm.eb.common.pojo.serch.TreeSearchInfo;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class DataPermByMemberPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
TreeNodeClickListener,
SearchEnterListener {
    private static final String modelKey = "model";
    private static final String bizModelKey = "bizmodel";
    private static final String dimensionKey = "dimension";
    private static final String dimViewKey = "dimview";
    private static final String treeViewKey = "treeviewap";
    private static final String entryEntityKey = "entryentity";
    private static final byte allPermVal = 13;

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{modelKey, bizModelKey, dimensionKey, dimViewKey});
        this.addTreeNodeClickListener(this, treeViewKey);
        Search search = (Search)this.getControl("treesearch");
        search.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{"treeup", "treedown"});
        this.addItemClickListeners(new String[]{"toolbar_main"});
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryEntityKey);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultVal();
    }

    private void setDefaultVal() {
        String modelId = (String)this.getCustomFormParam("modelId");
        String bizModelId = (String)this.getCustomFormParam("bizModelId");
        if (this.notEmpty(modelId)) {
            this.getModel().setValue(modelKey, (Object)Long.valueOf(modelId));
            if (!ModelServiceHelper.isBGMDModel((Long)Long.valueOf(modelId))) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{bizModelKey});
            }
        }
        if (this.notEmpty(bizModelId)) {
            this.getModel().setValue(bizModelKey, (Object)Long.valueOf(bizModelId));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("btn_refresh".equals(itemKey)) {
            this.refresh();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String itemKey = ((Control)evt.getSource()).getKey();
        if ("treedown".equals(itemKey)) {
            this.handleSearch(null, SearchType.NEXT);
        } else if ("treeup".equals(itemKey)) {
            this.handleSearch(null, SearchType.PRE);
        }
    }

    public void refresh() {
        String dimensionNumber = this.getDimensionNumber();
        Long dimViewId = this.getDimViewId();
        if (this.notEmpty(dimensionNumber) && (!this.needDimView() || this.notEmpty(dimViewId))) {
            TreeView treeView = this.getTreeView();
            String focusNodeId = treeView.getTreeState().getFocusNodeId();
            this.initData(focusNodeId);
        }
    }

    private TreeSearchInfo getOrCacheTreeSearchInfo(TreeSearchInfo treeSearchInfo) {
        if (treeSearchInfo != null) {
            this.getPageCache().putBigObject("TreeSearchInfo", SerializationUtils.toJsonString((Object)treeSearchInfo));
        } else {
            String cacheStr = this.getPageCache().getBigObject("TreeSearchInfo");
            treeSearchInfo = this.notEmpty(cacheStr) ? (TreeSearchInfo)SerializationUtils.fromJsonString((String)cacheStr, TreeSearchInfo.class) : new TreeSearchInfo();
        }
        return treeSearchInfo;
    }

    private void handleSearch(TreeSearchInfo searchInfo, SearchType searchType) {
        if (searchInfo == null) {
            searchInfo = this.getOrCacheTreeSearchInfo(null);
        }
        if (searchInfo == null || searchInfo.getNodeIds().isEmpty()) {
            this.getView().showTipNotification(searchType.getEmptyTip());
        } else {
            String targetNodeId = null;
            if (searchType == SearchType.ENT) {
                targetNodeId = searchInfo.getCurrentId();
            } else if (searchType == SearchType.PRE) {
                targetNodeId = searchInfo.getNodeId(true);
            } else if (searchType == SearchType.NEXT) {
                targetNodeId = searchInfo.getNodeId(false);
            }
            if (targetNodeId == null) {
                this.getView().showTipNotification(searchType.getErrorTip());
            } else {
                TreeView treeView = (TreeView)this.getControl(treeViewKey);
                List<Long> allParentNode = this.getAllParentIds(targetNodeId);
                for (Long nodeId : allParentNode) {
                    treeView.expand(String.valueOf(nodeId));
                }
                TreeNode targetNode = new TreeNode();
                targetNode.setId(targetNodeId);
                treeView.focusNode(targetNode);
                this.getOrCacheTreeSearchInfo(searchInfo);
            }
        }
    }

    private List<Long> getAllParentIds(String focusId) {
        String dimensionNumber = this.getDimensionNumber();
        Long dimViewId = this.getDimViewId();
        Long memberId = IDUtils.toLong((Object)focusId);
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        return this.getAllParentIds(memberId, dimensionNumber, dimViewId, modelCacheHelper, false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (dimensionKey.equals(propName)) {
            this.dealDimChange();
        } else if (dimViewKey.equals(propName)) {
            this.dealDimViewChange();
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName = beforeF7SelectEvent.getProperty().getName();
        List customQFilters = beforeF7SelectEvent.getCustomQFilters();
        if (dimensionKey.equals(propName)) {
            customQFilters.add(this.getDimFilter());
        } else if (dimViewKey.equals(propName)) {
            customQFilters.add(this.getDimViewFilter());
        }
    }

    private QFilter getDimFilter() {
        List permControlDim = DimMembPermUtil.getPermControlDim((Long)this.getModelId());
        List dimIds = permControlDim.stream().map(BaseCache::getId).collect(Collectors.toList());
        return new QFilter("id", "in", dimIds);
    }

    private QFilter getDimViewFilter() {
        Long bizModelId = this.getBizModelId();
        String dimNum = this.getDimensionNumber();
        QFilter viewFilter = null;
        List viewIds = null;
        if (this.notEmpty(bizModelId) && this.notEmpty(dimNum)) {
            viewIds = this.getIModelCacheHelper().getViewGroupViewsByBusModelAndDimNumber(this.getBizModelId(), dimNum);
        }
        viewFilter = this.notEmpty(viewIds) ? new QFilter("id", "in", viewIds) : new QFilter("id", "=", (Object)-1L);
        return viewFilter;
    }

    private void dealDimChange() {
        String dimensionNumber = this.getDimensionNumber();
        Long refViewId = this.getIModelCacheHelper().getViewByBusModelAndDimNumber(this.getBizModelId(), dimensionNumber);
        if (this.notEmpty(refViewId)) {
            this.getModel().setValue(dimViewKey, (Object)refViewId);
        } else {
            Long dimViewId = this.getDimViewId();
            if (this.isEmpty(dimViewId)) {
                this.initData(null);
            } else {
                this.getModel().setValue(dimViewKey, null);
            }
        }
        this.getView().setVisible(Boolean.valueOf(this.needDimView()), new String[]{dimViewKey});
    }

    private boolean needDimView() {
        String dimNumber;
        return ModelServiceHelper.isBGMDModel((Long)this.getModelId()) && (dimNumber = this.getDimensionNumber()) != null && DimensionViewServiceHelper.hasView((String)dimNumber);
    }

    private void dealDimViewChange() {
        this.initData(null);
    }

    public Long getDimViewId() {
        return (Long)this.getValue(dimViewKey, "id");
    }

    public String getDimensionNumber() {
        return (String)this.getValue(dimensionKey, "number");
    }

    public Long getDimensionId() {
        return (Long)this.getValue(dimensionKey, "id");
    }

    public Long getBizModelId() {
        Long bizModelId = (Long)this.getValue(bizModelKey, "id");
        if (bizModelId == null) {
            bizModelId = 0L;
        }
        return bizModelId;
    }

    @Override
    public Long getModelId() {
        return (Long)this.getValue(modelKey, "id");
    }

    private void initData(String focusMember) {
        this.initLeftTree(focusMember);
        this.initEntry(focusMember);
    }

    private void initLeftTree(String focusMember) {
        TreeView treeView = this.getTreeView();
        treeView.deleteAllNodes();
        TreeNode root = new TreeNode();
        String dimensionNumber = this.getDimensionNumber();
        this.getOrCacheTreeSearchInfo(new TreeSearchInfo());
        LinkedList<String> expendNodeIds = new LinkedList<String>();
        if (this.notEmpty(dimensionNumber)) {
            IModelCacheHelper modelCacheHelper;
            Member rootMember;
            Long dimViewId = this.getDimViewId();
            if ((!this.needDimView() || this.notEmpty(dimViewId)) && (rootMember = (modelCacheHelper = this.getIModelCacheHelper()).getRootMember(dimensionNumber, dimViewId)) != null) {
                TreeNode rootMemberNode = this.buildNode(rootMember);
                root.addChild(rootMemberNode);
                List children = rootMember.getChildrenNotWithCosmic();
                if (this.notEmpty(children)) {
                    children.sort(Comparator.comparingInt(BaseCache::getSeq));
                    HashSet dataSetIds = null;
                    if (SysDimensionEnum.Account.getNumber().equals(dimensionNumber) && ModelServiceHelper.isBGMDModel((Long)this.getModelId())) {
                        dataSetIds = new HashSet(DatasetServiceHelper.getInstance().getDataSetIdByBizModelId(this.getBizModelId()));
                    }
                    for (Member child : children) {
                        if (dataSetIds != null && !dataSetIds.contains(child.getDatasetId())) continue;
                        this.buildTree(child, rootMemberNode);
                    }
                }
                if (focusMember != null) {
                    for (Long memberId : this.getAllParentIds(Long.valueOf(focusMember), dimensionNumber, dimViewId, modelCacheHelper, false)) {
                        expendNodeIds.add(String.valueOf(memberId));
                    }
                } else {
                    expendNodeIds.add(rootMemberNode.getId());
                }
            }
        }
        treeView.addNode(root);
        if (this.notEmpty(expendNodeIds)) {
            expendNodeIds.forEach(arg_0 -> ((TreeView)treeView).expand(arg_0));
        }
        if (focusMember != null) {
            TreeNode targetNode = new TreeNode();
            targetNode.setId(focusMember);
            treeView.focusNode(targetNode);
        }
    }

    private void buildTree(Member member, TreeNode parentNode) {
        TreeNode treeNode = this.buildNode(member);
        parentNode.addChild(treeNode);
        List children = member.getChildrenNotWithCosmic();
        if (children != null) {
            children.sort(Comparator.comparingInt(BaseCache::getSeq));
            for (Member child : children) {
                this.buildTree(child, treeNode);
            }
        }
    }

    private TreeNode buildNode(Member member) {
        TreeNode treeNode = new TreeNode();
        treeNode.setId(member.getId().toString());
        treeNode.setText(member.getNumber() + " " + member.getName());
        return treeNode;
    }

    private void initEntry(String focusNodeId) {
        this.getModel().deleteEntryData(entryEntityKey);
        TreeView treeView = this.getTreeView();
        if (this.isEmpty(focusNodeId)) {
            focusNodeId = treeView.getTreeState().getFocusNodeId();
        }
        if (this.isEmpty(focusNodeId)) {
            return;
        }
        Long focusMemberId = IDUtils.toLong((Object)focusNodeId);
        Long dimViewId = this.getDimViewId();
        Long dimensionId = this.getDimensionId();
        IModelCacheHelper iModelCacheHelper = this.getIModelCacheHelper();
        if (iModelCacheHelper == null || this.isEmpty(dimensionId)) {
            return;
        }
        Long modelId = iModelCacheHelper.getModelobj().getId();
        Dimension dimension = iModelCacheHelper.getDimension(dimensionId);
        String dimNumber = dimension.getNumber();
        if (this.needDimView() && this.isEmpty(dimViewId)) {
            return;
        }
        Long bizModelId = this.getBizModelId();
        List<Long> allParentIds = this.getAllParentIds(focusMemberId, dimNumber, dimViewId, iModelCacheHelper, true);
        if (allParentIds.isEmpty()) {
            return;
        }
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelId);
        Map memberPropValMap = CustomPropertyUtils.queryPropertyValue(allParentIds);
        HashSet<Long> toSearchMemberIds = new HashSet<Long>(allParentIds);
        memberPropValMap.values().forEach(toSearchMemberIds::addAll);
        List permRecordByMemberIds = MembPermRecordUtil.getPermRecordByMemberIds((IModelCacheHelper)iModelCacheHelper, (Long)bizModelId, toSearchMemberIds);
        this.parsePermRecord(permRecordByMemberIds, allParentIds, this.getIModelCacheHelper(), memberPropCache, bizModelId, dimension, focusMemberId, memberPropValMap);
    }

    private void parsePermRecord(List<DimMembPermRecord> permRecordByMemberIds, List<Long> allParentIds, IModelCacheHelper modelCacheHelper, MemberPropCache memberPropCache, Long bizModelId, Dimension dimension, Long focusMemberId, Map<Long, Set<Long>> memberPropValMap) {
        List permTypeList = DimMembPermType.getPermTypeListByGroup((PermGroupEnum)PermGroupEnum.DATA);
        List permTypeNoExtendsList = DimMembPermType.getPermTypeListByGroup((PermGroupEnum)PermGroupEnum.DATA);
        permTypeNoExtendsList.remove(DimMembPermType.DATAPERMEXTENDS);
        HashMap<String, Map> permRecordGroup = new HashMap<String, Map>(16);
        HashSet<Long> userIds = new HashSet<Long>(16);
        permRecordByMemberIds.forEach(record -> {
            userIds.add(record.getUid());
            permRecordGroup.computeIfAbsent(record.getDimNumsStr(), key -> new HashMap(16)).put(record.getUid(), record);
        });
        HashMap<Long, UserInfo> userInfoMap = new HashMap<Long, UserInfo>(16);
        HashMap<Long, UserInfo> userGroupInfoMap = new HashMap<Long, UserInfo>(16);
        HashMap<Long, Set<Long>> userGroupRefUser = new HashMap<Long, Set<Long>>(16);
        this.selUserInfo(userInfoMap, userGroupInfoMap, userGroupRefUser, userIds);
        Long modelId = modelCacheHelper.getModelobj().getId();
        Map<String, PermDimGroup> permControlDimGroup = DimMembPermUtil.getPermControlDimGroup((Long)modelId).stream().collect(Collectors.toMap(PermDimGroup::getDimShortNumStr, group -> group));
        Set<Long> refPropValIds = memberPropValMap.get(focusMemberId);
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity(entryEntityKey);
        permRecordGroup.forEach((dimShortStr, userPermRecord) -> {
            PermDimGroup dimGroup = (PermDimGroup)permControlDimGroup.get(dimShortStr);
            HashMap<Long, List<Object>> allMatchPermRecords = new HashMap<Long, List<Object>>(16);
            List dimNums = DimMembPermUtil.getDimNumsByShortStr((String)dimShortStr, (IModelCacheHelper)modelCacheHelper);
            ArrayList dimensionList = new ArrayList(dimNums.size());
            dimNums.forEach(dimNum -> dimensionList.add(modelCacheHelper.getDimension(dimNum)));
            if (dimNums.size() == 1) {
                this.parseSingleDimPermRecord((Map<Long, List<Object>>)allMatchPermRecords, permTypeNoExtendsList, (Map<Long, DimMembPermRecord>)userPermRecord, allParentIds, focusMemberId, refPropValIds);
            } else {
                this.parseMultiDimPermRecord(dimGroup, (Map<Long, List<Object>>)allMatchPermRecords, permTypeNoExtendsList, (Map<Long, DimMembPermRecord>)userPermRecord, modelCacheHelper, memberPropCache, bizModelId, focusMemberId, dimension.getDimNum());
            }
            if (allMatchPermRecords.size() > 0) {
                allMatchPermRecords.forEach((userId, matchPermInfo) -> {
                    UserInfo userInfo = (UserInfo)userGroupInfoMap.get(userId);
                    if (userInfo != null) {
                        Set refUserIds = (Set)userGroupRefUser.get(userId);
                        if (refUserIds != null) {
                            for (Long uId : refUserIds) {
                                UserInfo uInfo = (UserInfo)userInfoMap.get(uId);
                                if (uInfo == null) continue;
                                this.addPermInfo2Entry(permTypeList, dimGroup, entryRows, userInfo, uInfo, (List<Object>)matchPermInfo, dimensionList, memberPropCache);
                            }
                        }
                    } else {
                        userInfo = (UserInfo)userInfoMap.get(userId);
                        if (userInfo != null) {
                            this.addPermInfo2Entry(permTypeList, dimGroup, entryRows, null, userInfo, (List<Object>)matchPermInfo, dimensionList, memberPropCache);
                        }
                    }
                });
            }
        });
        if (entryRows.size() > 0) {
            this.getModel().updateEntryCache(entryRows);
            this.getView().updateView(entryEntityKey);
        }
    }

    private void addPermInfo2Entry(List<DimMembPermType> permTypeList, PermDimGroup dimPermGroup, DynamicObjectCollection entryRows, UserInfo userGroupInfo, UserInfo userInfo, List<Object> permInfo, List<Dimension> dimensionList, MemberPropCache memberPropCache) {
        StringBuilder sb = new StringBuilder();
        String source = userGroupInfo == null ? ResManager.loadKDString((String)"\u7528\u6237", (String)"DataPermByMemberPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]) : userGroupInfo.getName();
        Long sourceId = userGroupInfo == null ? userInfo.getId() : userGroupInfo.getId();
        String permWay = dimPermGroup == null ? ResManager.loadResFormat((String)"\u7ef4\u5ea6:%1", (String)"DataPermByMemberPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{dimensionList.get(0).getName()}) : ResManager.loadResFormat((String)"\u7ef4\u5ea6\u7ec4\u5408:%1", (String)"DataPermByMemberPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{dimPermGroup.getName()});
        String permWayNum = dimPermGroup == null ? dimensionList.get(0).getDimNum() : dimPermGroup.getDimShortNumStr();
        permInfo.forEach(permRowRecord -> {
            byte permVal;
            DimMembPermDetailRecord[] permRow;
            DynamicObject newRow = entryRows.addNew();
            newRow.set("source", (Object)source);
            newRow.set("sourceid", (Object)sourceId);
            newRow.set("permway", (Object)permWay);
            newRow.set("permwaynum", (Object)permWayNum);
            newRow.set("user", (Object)userInfo.getName());
            if (permRowRecord instanceof RowRecord) {
                permRow = (DimMembPermDetailRecord[])permRowRecord;
                permVal = permRow.getPermVal();
                List memberRecords = permRow.getMemberRecords();
                for (int i = 0; i < memberRecords.size(); ++i) {
                    MemberRecord memberRecord = (MemberRecord)memberRecords.get(i);
                    sb.append(this.selMemberName(memberRecord.isMember(), memberRecord.getId(), memberRecord.getViewId(), dimensionList, i, memberPropCache)).append(',');
                }
            } else {
                permRow = (DimMembPermDetailRecord[])permRowRecord;
                for (int i = 0; i < permRow.length; ++i) {
                    sb.append(this.selMemberName(permRow[i].isMember(), permRow[i].getMemberId(), permRow[i].getViewId(), dimensionList, i, memberPropCache)).append(',');
                }
                permVal = permRow[0].getPermVal();
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            newRow.set("member", (Object)sb.toString());
            sb.setLength(0);
            for (DimMembPermType permType : permTypeList) {
                newRow.set(permType.getBoxKey(), (Object)permType.hasPerm(permVal));
            }
        });
    }

    private String selMemberName(boolean isMember, Long memberId, Long viewId, List<Dimension> dimensionList, int dimIndex, MemberPropCache memberPropCache) {
        String name = null;
        Dimension dimension = dimensionList.get(dimIndex);
        if (!isMember) {
            CustomPropertyValue propertyValue = memberPropCache.getPropertyValue(dimension.getNumber(), memberId);
            if (propertyValue != null) {
                name = propertyValue.getName();
            }
        } else {
            Member member = dimension.getMember(viewId, memberId);
            if (member != null) {
                name = member.getName();
            }
        }
        if (name == null) {
            name = memberId.toString();
        }
        return name;
    }

    private void selUserInfo(Map<Long, UserInfo> userInfoMap, Map<Long, UserInfo> userGroupInfoMap, Map<Long, Set<Long>> userGroupRefUser, Set<Long> userIds) {
        List allUserInfo = UserUtils.getUserInfo(userIds, (boolean)false);
        allUserInfo.forEach(uInfo -> {
            if (uInfo.isUserGroup()) {
                userGroupInfoMap.put(uInfo.getId(), (UserInfo)uInfo);
            } else {
                userInfoMap.put(uInfo.getId(), (UserInfo)uInfo);
            }
        });
        if (userGroupInfoMap.size() > 0) {
            Map allUserGroupMap = UserUtils.queryAllUserGroupMap(userGroupInfoMap.keySet());
            HashSet toSearchUserIds = new HashSet(16);
            allUserGroupMap.forEach((groupId, refUserIds) -> {
                userGroupRefUser.put((Long)groupId, (Set<Long>)refUserIds);
                toSearchUserIds.addAll(refUserIds);
            });
            toSearchUserIds.removeAll(userInfoMap.keySet());
            if (toSearchUserIds.size() > 0) {
                UserUtils.getUserInfo(toSearchUserIds, (boolean)true).forEach(userInfo -> userInfoMap.put(userInfo.getId(), (UserInfo)userInfo));
            }
        }
    }

    private void parseMultiDimPermRecord(PermDimGroup dimGroup, Map<Long, List<Object>> allMatchPermRecords, List<DimMembPermType> permTypeList, Map<Long, DimMembPermRecord> userPermRecord, IModelCacheHelper modelCacheHelper, MemberPropCache memberPropCache, Long bizModelId, Long focusMemberId, String targetDimNum) {
        List dimTrees = DimMembPermUtil.getDimViews((Collection)dimGroup.getDimNums(), (IModelCacheHelper)modelCacheHelper, (Long)bizModelId);
        HashMap<String, HashSet> memberFilter = new HashMap<String, HashSet>(1);
        memberFilter.put(targetDimNum, Sets.newHashSet((Object[])new Long[]{focusMemberId}));
        userPermRecord.forEach((userId, mainPermRecord) -> {
            List rowRecords = MembPermRecordUtil.switchPermRecord(mainPermRecord.getAllDetailRecords().values(), (List)dimTrees, (boolean)true, (MemberPropCache)memberPropCache, (boolean)true);
            ArrayList<DimMembPermType> toCheckPermTypes = new ArrayList<DimMembPermType>(16);
            HashSet<DimMembPermType> ignoreTypes = new HashSet<DimMembPermType>(16);
            LinkedList<RowRecord> matchRows = new LinkedList<RowRecord>();
            for (int i = rowRecords.size() - 1; i > -1; --i) {
                byte permVal = 0;
                RowRecord rowRecord = (RowRecord)rowRecords.get(i);
                for (DimMembPermType permType : permTypeList) {
                    if (!permType.hasPerm(rowRecord.getPermVal()) || ignoreTypes.contains(permType)) continue;
                    toCheckPermTypes.add(permType);
                    permVal = permType.setPermValue(permVal, true);
                }
                if (toCheckPermTypes.isEmpty()) continue;
                boolean containsChild = DimMembPermType.DATAPERMEXTENDS.hasPerm(rowRecord.getPermVal());
                boolean containNotDataPerm = DimMembPermType.GIVE.hasPerm(rowRecord.getPermVal());
                Count descartesCount = new Count(1);
                ArrayList allMember = new ArrayList(16);
                Count jCount = new Count(i + 1);
                byte rowPermVal = permVal;
                if (jCount.getCount() < rowRecords.size()) {
                    if (DimMembPermUtil.selAllDimMember((List)rowRecord.getMemberRecords(), (List)dimTrees, (boolean)containsChild, (boolean)containNotDataPerm, (MemberPropCache)memberPropCache, (Count)descartesCount, allMember, null, (Map)memberFilter)) {
                        Count matchPerm = new Count(0);
                        DimMembPermUtil.parseMemberDKRJ((int)descartesCount.getCount(), (List)dimTrees, allMember, memberContext -> {
                            Map groupMembers = memberContext.getGroupMembers();
                            byte pVal = rowPermVal;
                            for (int j = jCount.getCount(); j < rowRecords.size(); ++j) {
                                RowRecord compRow = (RowRecord)rowRecords.get(j);
                                ContainResult containResult = DimMembPermUtil.checkRowAndGroupContains((RowRecord)compRow, (List)dimTrees, (Map)groupMembers, (MemberPropCache)memberPropCache, (boolean)true);
                                if (!containResult.isMatchMembPerm()) continue;
                                for (DimMembPermType permType : toCheckPermTypes) {
                                    if (!permType.isDataPerm()) continue;
                                    pVal = permType.setPermValue(pVal, false);
                                }
                                break;
                            }
                            byte matchPermVal = (byte)matchPerm.getCount();
                            if (pVal > 0) {
                                for (DimMembPermType permType : toCheckPermTypes) {
                                    if (!permType.hasPerm(pVal)) continue;
                                    matchPermVal = permType.setPermValue(matchPermVal, true);
                                }
                            }
                            matchPerm.setCount((int)matchPermVal);
                            if (matchPermVal == rowPermVal) {
                                return false;
                            }
                            return true;
                        });
                        byte matchPermVal = (byte)matchPerm.getCount();
                        if (matchPermVal > 0) {
                            matchRows.add(rowRecord);
                            for (DimMembPermType permType : toCheckPermTypes) {
                                if (!permType.hasPerm(matchPermVal)) continue;
                                ignoreTypes.add(permType);
                            }
                        }
                        if (ignoreTypes.size() == permTypeList.size()) {
                            break;
                        }
                    }
                } else {
                    if (permVal > 0) {
                        matchRows.add(rowRecord);
                        for (DimMembPermType permType : toCheckPermTypes) {
                            if (!permType.hasPerm(permVal)) continue;
                            ignoreTypes.add(permType);
                        }
                    }
                    if (ignoreTypes.size() == permTypeList.size()) break;
                }
                toCheckPermTypes.clear();
            }
            if (matchRows.size() > 0) {
                allMatchPermRecords.put((Long)userId, (List<Object>)matchRows);
            }
        });
    }

    private void parseSingleDimPermRecord(Map<Long, List<Object>> allMatchPermRecords, List<DimMembPermType> permTypeList, Map<Long, DimMembPermRecord> userPermRecord, List<Long> allParentIds, Long focusMemberId, Set<Long> refPropValIds) {
        userPermRecord.forEach((userId, mainPermRecord) -> {
            byte permVal;
            Map allDetailRecords = mainPermRecord.getAllDetailRecords();
            HashMap permRecordMap = new HashMap(allDetailRecords.size());
            ArrayList<DimMembPermDetailRecord[]> propValRefRecords = new ArrayList<DimMembPermDetailRecord[]>(16);
            allDetailRecords.values().forEach(record -> {
                DimMembPermDetailRecord memberRecord = record[0];
                if (!memberRecord.isMember()) {
                    propValRefRecords.add((DimMembPermDetailRecord[])record);
                }
                permRecordMap.put(memberRecord.getMemberId(), record);
            });
            propValRefRecords.sort(Comparator.comparingInt(row -> row[0].getSeq()));
            HashSet<Long> matchMemberIds = new HashSet<Long>(permTypeList.size());
            HashSet<DimMembPermType> breakPermTypes = new HashSet<DimMembPermType>(permTypeList.size());
            if (propValRefRecords.size() > 0) {
                int end;
                boolean checkedDataPerm = false;
                for (int index = end = propValRefRecords.size() - 1; index > -1; --index) {
                    DimMembPermDetailRecord[] rowRecord = (DimMembPermDetailRecord[])propValRefRecords.get(index);
                    permVal = rowRecord[0].getPermVal();
                    if (DimMembPermType.GIVE.hasPerm(permVal) && breakPermTypes.add(DimMembPermType.GIVE)) {
                        matchMemberIds.add(rowRecord[0].getMemberId());
                    }
                    if (checkedDataPerm || refPropValIds == null || !refPropValIds.contains(rowRecord[0].getMemberId())) continue;
                    checkedDataPerm = true;
                    for (DimMembPermType permType : permTypeList) {
                        if (!permType.isDataPerm()) continue;
                        if (permType.hasPerm(permVal)) {
                            matchMemberIds.add(rowRecord[0].getMemberId());
                        }
                        breakPermTypes.add(permType);
                    }
                }
            }
            block2: for (Long memberId : allParentIds) {
                DimMembPermDetailRecord[] detailRecord = (DimMembPermDetailRecord[])permRecordMap.get(memberId);
                if (detailRecord == null) continue;
                permVal = detailRecord[0].getPermVal();
                for (DimMembPermType permType : permTypeList) {
                    if (breakPermTypes.contains(permType)) continue;
                    boolean hasPerm = permType.hasPerm(permVal);
                    boolean isGivePerm = permType == DimMembPermType.GIVE;
                    boolean containsChild = DimMembPermType.DATAPERMEXTENDS.hasPerm(permVal);
                    boolean isFocusMember = memberId.equals(focusMemberId);
                    if (hasPerm && (isGivePerm || isFocusMember || containsChild)) {
                        breakPermTypes.add(permType);
                        matchMemberIds.add(memberId);
                    } else if (!hasPerm && !isGivePerm && (isFocusMember || containsChild)) {
                        breakPermTypes.add(permType);
                    }
                    if (breakPermTypes.size() != permTypeList.size()) continue;
                    break block2;
                }
            }
            if (matchMemberIds.size() > 0) {
                ArrayList permRecordRows = new ArrayList(matchMemberIds.size());
                matchMemberIds.forEach(mId -> permRecordRows.add(permRecordMap.get(mId)));
                allMatchPermRecords.put((Long)userId, permRecordRows);
            }
        });
    }

    private List<Long> getAllParentIds(Long memberId, String dimensionNum, Long viewId, IModelCacheHelper modelCacheHelper, boolean needAllView) {
        ArrayList<Long> parentIds = new ArrayList<Long>(16);
        Set refViewIds = DimensionViewServiceHelper.getViewsByViewId((Long)viewId);
        if (this.isEmpty(refViewIds) || !needAllView) {
            while (this.notEmpty(memberId)) {
                Member member = modelCacheHelper.getMember(dimensionNum, viewId, memberId);
                if (member != null) {
                    parentIds.add(member.getId());
                    memberId = member.getParentId();
                    continue;
                }
                memberId = null;
            }
        } else {
            QFBuilder qb = new QFBuilder("memberid", "=", (Object)memberId);
            qb.add("view", "in", (Object)refViewIds);
            DynamicObjectCollection viewMemberObjs = QueryServiceHelper.query((String)"eb_viewmember", (String)"longnumber", (QFilter[])qb.toArrays());
            if (this.notEmpty(viewMemberObjs)) {
                HashSet allParentMember = new HashSet(16);
                viewMemberObjs.forEach(obj -> allParentMember.addAll(Arrays.asList(obj.getString("longnumber").split("!"))));
                if (this.notEmpty(allParentMember)) {
                    Long dimensionId = this.getDimensionId();
                    qb = new QFBuilder(dimensionKey, "=", (Object)dimensionId);
                    qb.add("number", "in", allParentMember);
                    DynamicObjectCollection pMemberObjs = QueryServiceHelper.query((String)SysDimensionEnum.getMemberTreemodelByNumber((String)dimensionNum), (String)"id", (QFilter[])qb.toArrays());
                    pMemberObjs.forEach(obj -> parentIds.add(obj.getLong("id")));
                }
            }
        }
        return parentIds;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        this.initEntry(null);
    }

    private TreeView getTreeView() {
        return (TreeView)this.getControl(treeViewKey);
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        IModelCacheHelper modelCacheHelper;
        Member rootMember;
        String text = searchEnterEvent.getText();
        if (this.isEmpty(text)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u8981\u641c\u7d22\u7684\u5185\u5bb9", (String)"MultiDimMemberF7Plugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String dimensionNumber = this.getDimensionNumber();
        Long dimViewId = this.getDimViewId();
        TreeSearchInfo searchInfo = new TreeSearchInfo();
        if (this.notEmpty(dimensionNumber) && (!this.needDimView() || this.notEmpty(dimViewId)) && (rootMember = (modelCacheHelper = this.getIModelCacheHelper()).getRootMember(dimensionNumber, dimViewId)) != null) {
            ArrayList<String> nodeIds = new ArrayList<String>(16);
            if (rootMember.getNumber().contains(text) || rootMember.getName().contains(text)) {
                nodeIds.add(rootMember.getId().toString());
            }
            if (rootMember.getChildrenNotWithCosmic() != null) {
                HashSet dataSetIds = null;
                if (SysDimensionEnum.Account.getNumber().equals(dimensionNumber) && ModelServiceHelper.isBGMDModel((Long)this.getModelId())) {
                    dataSetIds = new HashSet(DatasetServiceHelper.getInstance().getDataSetIdByBizModelId(this.getBizModelId()));
                }
                for (Member child : rootMember.getChildrenNotWithCosmic()) {
                    if (dataSetIds != null && !dataSetIds.contains(child.getDatasetId())) continue;
                    child.iterate(member -> {
                        if (member.getNumber().contains(text) || member.getName().contains(text)) {
                            nodeIds.add(member.getId().toString());
                        }
                    });
                }
            }
            searchInfo.setNodeIds(nodeIds);
        }
        this.getOrCacheTreeSearchInfo(searchInfo);
        this.handleSearch(searchInfo, SearchType.ENT);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if ("permway".equals(fieldName)) {
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            this.openPermSettingForm(rowIndex);
        }
    }

    private void openPermSettingForm(int rowIndex) {
        DynamicObject row = this.getModel().getEntryRowEntity(entryEntityKey, rowIndex);
        String sourceUserId = row.getString("sourceid");
        String dimShortNumStr = row.getString("permwaynum");
        if (dimShortNumStr.startsWith("!")) {
            List dimNumsByShortStr = DimMembPermUtil.getDimNumsByShortStr((String)dimShortNumStr, (IModelCacheHelper)this.getIModelCacheHelper());
            dimShortNumStr = String.join((CharSequence)",", dimNumsByShortStr);
        }
        Long modelId = this.getModelId();
        Long bizModelId = this.getBizModelId();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_dimmembdataperm");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("modelId", (Object)String.valueOf(modelId));
        formShowParameter.setCustomParam("bizModelId", (Object)String.valueOf(bizModelId));
        formShowParameter.setCustomParam("userId", (Object)sourceUserId);
        formShowParameter.setCustomParam("dimNumStr", (Object)dimShortNumStr);
        this.getView().showForm(formShowParameter);
    }
}

