/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.perm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.control.EntryGrid;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.enums.PermGroupEnum;
import kd.epm.eb.common.permission.policyUtils.IMembPermSaveCheck;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.pojo.MultiDim.DimViewInfo;
import kd.epm.eb.formplugin.perm.DimMembPermBasePlugin;

public class DimManagerPermPlugin
extends DimMembPermBasePlugin {
    private final Map<Long, BasedataPojo> viewIdMapGroupName = new HashMap<Long, BasedataPojo>();

    @Override
    public List<DimMembPermType> getPermTypeList() {
        return DimMembPermType.getPermTypeListByGroup((PermGroupEnum)PermGroupEnum.MANAGER);
    }

    @Override
    protected void dealModelChange() {
        super.dealModelChange();
    }

    @Override
    protected List<BasedataPojo> getDimListToShow() {
        List<BasedataPojo> dimListToShow = super.getDimListToShow();
        dimListToShow.removeIf(dimensionInfo -> DimMembPermHelper.noCheckDimsOnManPerm.contains(dimensionInfo.getNumber()));
        return dimListToShow;
    }

    @Override
    protected List<IMembPermSaveCheck> getChecktorList() {
        return super.getChecktorList();
    }

    @Override
    public String getFormType() {
        return "manage";
    }

    @Override
    protected void onFillBackMemberRow(DynamicObject newRow, boolean hasRealMember, boolean isInit) {
        if (!isInit) {
            newRow.set(DimMembPermType.MANAGER.getBoxKey(), (Object)true);
        }
        this.fillBackViewGroupName(newRow);
    }

    private void fillBackViewGroupName(DynamicObject newRow) {
        Long viewId = newRow.getLong("viewid0");
        String groupName = this.getViewGroupName(viewId);
        newRow.set("viewgroupname", (Object)groupName);
    }

    public String getViewGroupName(Long viewId) {
        return this.getViewGroupByView(viewId).getName();
    }

    public BasedataPojo getViewGroupByView(Long viewId) {
        return this.viewIdMapGroupName.computeIfAbsent(viewId, key -> {
            BasedataPojo group = null;
            try {
                DynamicObject groupObj;
                DynamicObject viewObj = BusinessDataServiceHelper.loadSingleFromCache((Object)key, (String)"eb_dimensionview");
                if (viewObj != null && (groupObj = viewObj.getDynamicObject("viewgroup")) != null) {
                    DynamicObject parentObj = groupObj.getDynamicObject("parent");
                    if (parentObj != null) {
                        groupObj = parentObj;
                    }
                    group = new BasedataPojo(Long.valueOf(groupObj.getLong("id")), groupObj.getString("name"), groupObj.getString("number"));
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (group == null) {
                group = new BasedataPojo(Long.valueOf(0L), "", "");
            }
            return group;
        });
    }

    @Override
    protected void afterDelMember(int rowIndex, int memberSeq) {
        this.getModel().setValue("viewgroupname", null, rowIndex);
    }

    @Override
    protected void afterAddMember(DynamicObject currentRowObj, int rowIndex, int dimSize) {
        Long viewId = currentRowObj.getLong("viewid0");
        String groupName = this.getViewGroupName(viewId);
        this.getModel().setValue("viewgroupname", (Object)groupName);
    }

    @Override
    protected void dealDimCol(EntryGrid entryGrid, Dimension dimension, int dimSeq) {
        this.getView().setVisible(Boolean.valueOf(SysDimensionEnum.dimHasView((String)dimension.getNumber()) && (this.currentModelIsBGMD() || this.isNewEbForm() && SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) && dimSeq == 0), new String[]{"viewgroupname"});
    }

    @Override
    protected void selRowOtherInfo(StringBuilder rowStr, Object rowObj, List<DimViewInfo> dimViewInfos) {
        Long viewId = null;
        if (rowObj instanceof DynamicObject) {
            viewId = ((DynamicObject)rowObj).getLong("viewid0");
        } else if (this.notEmpty(dimViewInfos)) {
            viewId = dimViewInfos.get(0).getViewId();
        }
        if (viewId == null) {
            viewId = 0L;
        }
        BasedataPojo group = this.getViewGroupByView(viewId);
        rowStr.append(',').append(group.getId());
    }

    @Override
    protected boolean checkRowRepByOtherInfo(ListSelectedRow selRow, DynamicObject targetRowObj) {
        Long sourceViewId = (Long)selRow.getDataMap().get("viewid");
        Long targetViewId = targetRowObj.getLong("viewid0");
        if (this.isEmpty(sourceViewId) && this.isEmpty(targetViewId)) {
            return true;
        }
        return this.getViewGroupByView(sourceViewId).getId().equals(this.getViewGroupByView(targetViewId).getId());
    }
}

