/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.perm;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.utils.PermControlDimUtil;
import kd.epm.eb.common.applybill.Count;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.MembPermRecordUtil;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.enums.PermConditionType;
import kd.epm.eb.common.permission.enums.PermGroupEnum;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.permission.pojo.DimMembPermDetailRecord;
import kd.epm.eb.common.permission.pojo.DimMembPermRecord;
import kd.epm.eb.common.permission.pojo.PermSaveArgs;
import kd.epm.eb.common.permission.pojo.UserInfo;
import kd.epm.eb.common.permission.pojo.UserInfoOnPage;
import kd.epm.eb.common.permission.policyUtils.IMembPermSaveCheck;
import kd.epm.eb.common.permission.policyUtils.LevelBreakCheck;
import kd.epm.eb.common.permission.policyUtils.PermDimCheck;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.formplugin.perm.DimMembPermBasePlugin;
import kd.epm.eb.model.utils.UserSelectUtil;

public class DimMembDataPermPlugin
extends DimMembPermBasePlugin {
    private static final String bizCtrlRange_key = "bizctrlrange";
    private static final String PermDimSetting_back = "PermDimSetting_back";
    private static final String PermDimGroupSetting_back = "PermDimGroupSetting_back";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{bizCtrlRange_key});
    }

    @Override
    protected boolean selectedAllCondition() {
        boolean allSelected = super.selectedAllCondition();
        if (allSelected && this.needCheckBCR()) {
            Long currentBusModelId = this.getBizCtrlRangeId();
            allSelected = currentBusModelId != 0L;
        }
        return allSelected;
    }

    @Override
    public void dealPropChanged(PropertyChangedArgs e) {
        super.dealPropChanged(e);
        String propName = e.getProperty().getName();
        if (bizCtrlRange_key.equals(propName)) {
            this.dealConditionChange(PermConditionType.BIZCTRLRANGE);
        } else if (propName.endsWith("_box")) {
            this.dealPermValChange(e);
        }
    }

    @Override
    protected List<IMembPermSaveCheck> getChecktorList() {
        List<IMembPermSaveCheck> checktorList = super.getChecktorList();
        checktorList.add(0, (IMembPermSaveCheck)new PermDimCheck());
        checktorList.add((IMembPermSaveCheck)new LevelBreakCheck(DimMembPermType.GIVE));
        return checktorList;
    }

    private void dealPermValChange(PropertyChangedArgs changedArgs) {
        DynamicObject rowObj;
        String propName = changedArgs.getProperty().getName();
        ChangeData changeData = changedArgs.getChangeSet()[0];
        boolean newPerm = (Boolean)changeData.getNewValue();
        int index = changeData.getRowIndex();
        boolean cancel = false;
        if (DimMembPermType.READ.getBoxKey().equals(propName) && !newPerm) {
            boolean writePerm = (Boolean)this.getModel().getValue(DimMembPermType.WRITE.getBoxKey(), index);
            if (writePerm) {
                this.setHasReadPerm(index);
                cancel = true;
            }
        } else if (DimMembPermType.WRITE.getBoxKey().equals(propName) && newPerm) {
            this.setHasReadPerm(index);
        } else if (DimMembPermType.DATAPERMEXTENDS.getBoxKey().equals(propName) && newPerm && !this.checkRowHasRealMember(rowObj = this.getModel().getEntryRowEntity("memberentry", index), this.getCurrentDimNums().size())) {
            this.setCheckBoxVal(propName, index, false);
            cancel = true;
        }
        if (!cancel) {
            this.markRecordChanged(true);
        }
    }

    @Override
    protected void afterAddMember(DynamicObject currentRowObj, int rowIndex, int dimSize) {
        super.afterAddMember(currentRowObj, rowIndex, dimSize);
        if (!this.checkRowHasRealMember(currentRowObj, dimSize)) {
            this.getModel().setValue(DimMembPermType.DATAPERMEXTENDS.getBoxKey(), (Object)false, rowIndex);
        }
    }

    private void setHasReadPerm(int rowIndex) {
        this.setCheckBoxVal(DimMembPermType.READ.getBoxKey(), rowIndex, true);
    }

    private void setCheckBoxVal(String boxKey, int rowIndex, boolean check) {
        this.setNoNeedResponseChange(true);
        this.getModel().setValue(boxKey, (Object)check, rowIndex);
        this.setNoNeedResponseChange(false);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String f7Key;
        super.beforeF7Select(beforeF7SelectEvent);
        switch (f7Key = beforeF7SelectEvent.getProperty().getName()) {
            case "bizctrlrange": {
                this.b4SelectBCR(beforeF7SelectEvent);
                break;
            }
        }
    }

    private void b4SelectBCR(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (!this.checkModel()) {
            beforeF7SelectEvent.setCancel(true);
        } else {
            ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters().addAll(this.getBizCtrlRanegFilter());
        }
    }

    private List<QFilter> getBizCtrlRanegFilter() {
        Long modelId = this.getModelId();
        QFBuilder qb = new QFBuilder("model", "=", (Object)modelId);
        if (!ModelServiceHelper.isModelManager((Long)modelId)) {
            qb.add("id", "in", this.getBCRIdsOnGivePerm(modelId));
        }
        return qb.toList();
    }

    @Override
    protected void rollbackCondition(PermConditionType conditionType) {
        super.rollbackCondition(conditionType);
        this.setNoNeedResponseChange(true);
        switch (conditionType) {
            case BIZCTRLRANGE: {
                Long lastBCRId = this.getLastBCRId();
                this.getModel().setValue(bizCtrlRange_key, (Object)lastBCRId);
                break;
            }
        }
        this.setNoNeedResponseChange(false);
    }

    protected void dealBizCtrlRangeChange() {
        Long bizCtrlRangeId = this.getBizCtrlRangeId();
        this.getOrCacheLastBCRId(bizCtrlRangeId);
        this.cleanMembEntry();
        this.updateDimList(true);
        UserSelectUtil.saveUserSelectWhenBizModelChange((IFormView)this.getView(), (Long)this.getLastModelId(), (Long)this.getLastBCRId());
    }

    @Override
    protected void dealCallBackAfterCheck(String actionKey) {
        super.dealCallBackAfterCheck(actionKey);
        if ("PermDimCheck".equals(actionKey)) {
            this.cleanMembEntry();
            this.updateDimList(true);
            this.markRecordChanged(false);
        }
    }

    @Override
    protected List<BasedataPojo> getDimListToShow() {
        List<BasedataPojo> dimListToShow = super.getDimListToShow();
        if (dimListToShow.size() > 0) {
            Set allDimNums = dimListToShow.stream().map(BasedataPojo::getNumber).collect(Collectors.toSet());
            Long bizCtrlRangeId = this.getBizCtrlRangeId();
            Long modelId = this.getModelId();
            Long userId = this.getUserId();
            if (this.needCheckBCR() && bizCtrlRangeId == 0L) {
                dimListToShow.clear();
            }
            if (dimListToShow.size() > 0) {
                List permControlDim = PermControlDimUtil.getPermControlDim((Long)modelId);
                Set dimNums = permControlDim.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                dimListToShow.removeIf(dim -> !dimNums.contains(dim.getNumber()));
                DimMembPermUtil.getPermControlDimGroup((Long)this.getModelId(), (Long)bizCtrlRangeId).forEach(group -> {
                    for (BasedataPojo basedataPojo : group.getDimGroup()) {
                        if (allDimNums.contains(basedataPojo.getNumber())) continue;
                        return;
                    }
                    String numStr = group.getDimGroup().stream().map(BasedataPojo::getNumber).collect(Collectors.joining(","));
                    dimListToShow.add(new BasedataPojo(Long.valueOf(0L), group.getName(), numStr));
                });
                if (!ModelServiceHelper.isUserHasRootPermByModel((long)userId, (Long)modelId)) {
                    IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
                    Set dimShortNumStr = MembPermRecordUtil.getDimShortNumStrOnGivePerm((Long)userId, (Long)modelId, (Long)bizCtrlRangeId);
                    HashSet<String> dimNumStrs = new HashSet<String>(dimShortNumStr.size());
                    for (String shortNumStr : dimShortNumStr) {
                        List dimNumsByShortStr = DimMembPermUtil.getDimNumsByShortStr((String)shortNumStr, (IModelCacheHelper)modelCacheHelper);
                        dimNumStrs.add(String.join((CharSequence)",", dimNumsByShortStr));
                    }
                    dimListToShow.removeIf(dim -> !dimNumStrs.contains(dim.getNumber()));
                }
            }
        }
        return dimListToShow;
    }

    @Override
    protected Map<String, Set<Long>> getMemberFilter(String currentDimNum, int rowIndex) {
        Long modelId = this.getModelId();
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Dimension dimension = modelCacheHelper.getDimension(currentDimNum);
        if (dimension != null && !ModelServiceHelper.isUserHasRootPermByModel((long)this.getUserId(), (Long)modelId)) {
            DynamicObject row = this.getModel().getEntryRowEntity("memberentry", rowIndex);
            HashMap<String, Set<Long>> memberFilter = new HashMap<String, Set<Long>>();
            List<String> currentDimNums = this.getCurrentDimNums();
            for (int dimSeq = 0; dimSeq < currentDimNums.size(); ++dimSeq) {
                Long memberId;
                String dimNum = currentDimNums.get(dimSeq);
                if (dimNum.equals(currentDimNum) || !this.notEmpty(memberId = Long.valueOf(row.getLong("memberid" + dimSeq)))) continue;
                memberFilter.put(dimNum, Sets.newHashSet((Object[])new Long[]{memberId}));
            }
            return memberFilter;
        }
        return null;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ((PermDimSetting_back.equals(actionId) || PermDimGroupSetting_back.equals(actionId)) && returnData != null) {
            this.upDimListAfterPermDimSet();
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
    }

    @Override
    protected void filterMembPermRecord(DimMembPermRecord permRecord, UserInfoOnPage userInfo) {
        List<String> dimNums;
        Long lastBCRId;
        DimMemberPermChecker permChecker;
        Long modelId = permRecord.getModelId();
        Long userId = this.getUserId();
        if (!ModelServiceHelper.isUserHasRootPermByModel((long)userId, (Long)modelId) && !(permChecker = DimMembPermHelper.getPermChecker((Long)modelId, (Long)(lastBCRId = this.getLastBCRId()), dimNums = this.getLastDimNums(), (boolean)true, (Long)userId, (DimMembPermType)DimMembPermType.GIVE)).hasAllPerm()) {
            Iterator iterator = permRecord.getAllDetailRecords().entrySet().iterator();
            HashMap<String, MemberItem> memberItemMap = new HashMap<String, MemberItem>();
            while (iterator.hasNext()) {
                DimMembPermDetailRecord[] rowData = (DimMembPermDetailRecord[])iterator.next().getValue();
                for (int i = 0; i < rowData.length; ++i) {
                    DimMembPermDetailRecord membObj = rowData[i];
                    memberItemMap.put(dimNums.get(i), new MemberItem(membObj.isMember(), membObj.getMemberId()));
                }
                if (permChecker.check(memberItemMap)) continue;
                iterator.remove();
            }
        }
    }

    @Override
    protected void fillOldRecord(PermSaveArgs args, DimMembPermRecord toSavePermRecrod, UserInfoOnPage currentUserInfo) {
        if (!ModelServiceHelper.isUserHasRootPermByModel((long)args.getCurrentUserId(), (Long)args.getModelId())) {
            Set<String> delRows = this.getOrCacheDelRows(null);
            DimMembPermRecord permRecord = this.getPermRecord((UserInfo)currentUserInfo);
            if (permRecord != null && !permRecord.getAllDetailRecords().isEmpty()) {
                Map newDetailRecords = toSavePermRecrod.getAllDetailRecords();
                Count seq = new Count(newDetailRecords.size());
                HashSet newRecordMembIdStrs = new HashSet(newDetailRecords.size());
                StringBuilder sb = new StringBuilder();
                newDetailRecords.values().forEach(members -> {
                    for (DimMembPermDetailRecord detailRecord : members) {
                        sb.append(detailRecord.getMemberId()).append(',');
                    }
                    newRecordMembIdStrs.add(sb.toString());
                    sb.setLength(0);
                });
                Map oldDetailRecords = permRecord.getAllDetailRecords();
                oldDetailRecords.values().forEach(members -> {
                    for (DimMembPermDetailRecord detailRecord : members) {
                        sb.append(detailRecord.getMemberId()).append(',');
                    }
                    String memberIdStr = sb.toString();
                    if (!newRecordMembIdStrs.contains(memberIdStr) && !delRows.contains(memberIdStr)) {
                        for (DimMembPermDetailRecord detailRecord : members) {
                            detailRecord.setSeq(seq.getCount());
                        }
                        newDetailRecords.put(seq.getCount(), members);
                        seq.addOne();
                    }
                    sb.setLength(0);
                });
            }
        }
    }

    private void upDimListAfterPermDimSet() {
        String lastDimNum = this.getLastDimNum();
        Set<String> newPermDimList = this.updateDimList(false);
        if (newPermDimList.contains(lastDimNum)) {
            this.selectDim(lastDimNum);
        } else if (this.notEmpty(lastDimNum)) {
            this.handleConditionChanged(PermConditionType.DIMENSION);
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7ef4\u5ea6/\u7ef4\u5ea6\u7ec4\u5408\u201c%1\u201d\u5df2\u4e0d\u5c5e\u4e8e\u6388\u6743\u7ef4\u5ea6/\u7ef4\u5ea6\u7ec4\u5408\u3002", (String)"DimMembDataPermPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{lastDimNum}));
        }
    }

    @Override
    protected Long getBizCtrlRangeId() {
        Object busModelId = this.getValue(bizCtrlRange_key, "id");
        return ConvertUtils.toLong((Object)busModelId);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_permdimsetting": {
                this.showPermDimSetting(false);
                break;
            }
            case "btn_permdimgroupsetting": {
                this.showPermDimSetting(true);
                break;
            }
            case "btn_searchbymember": {
                this.openMemberSearchForm();
                break;
            }
        }
    }

    private void openMemberSearchForm() {
        Long modelId = this.getModelId();
        if (this.isEmpty(modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"DimMembDataPermPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!ModelServiceHelper.isUserHasRootPermByModel((long)this.getUserId(), (Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u4f53\u7cfb\u7ba1\u7406\u5458\u5141\u8bb8\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"DimMembPermBasePlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long bizCtrlRangeId = this.getBizCtrlRangeId();
        if (this.needCheckBCR() && this.isEmpty(bizCtrlRangeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"DimMembPermBasePlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_datapermbymember");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("modelId", (Object)String.valueOf(modelId));
        formShowParameter.setCustomParam("bizModelId", (Object)String.valueOf(bizCtrlRangeId));
        this.getView().showForm(formShowParameter);
    }

    private void showPermDimSetting(boolean isDimGroup) {
        FormShowParameter formShowParameter;
        Long modelId = this.getModelId();
        if (this.isEmpty(modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"DimMembDataPermPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!ModelServiceHelper.isUserHasRootPermByModel((long)this.getUserId(), (Long)modelId)) {
            String info = isDimGroup ? ResManager.loadKDString((String)"\u6388\u6743\u7ef4\u5ea6\u7ec4\u5408", (String)"DimMembDataPermPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6388\u6743\u7ef4\u5ea6", (String)"DimMembDataPermPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5f53\u524d\u7528\u6237\u6240\u9009\u4f53\u7cfb\u6ca1\u6709\u7ba1\u7406\u6743\uff0c\u4e0d\u80fd\u8fdb\u884c%1\u8bbe\u7f6e", (String)"DimMembDataPermPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{info}));
            return;
        }
        if (isDimGroup) {
            DynamicObject permDimGroupObj = BusinessDataServiceHelper.loadSingle((String)"eb_permdimgroup", (String)"id", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
            HashMap<String, String> openParameter = new HashMap<String, String>(4);
            openParameter.put("formId", "eb_permdimgroup");
            openParameter.put("pkId", permDimGroupObj == null ? null : permDimGroupObj.getString("id"));
            formShowParameter = FormShowParameter.createFormShowParameter(openParameter);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PermDimGroupSetting_back));
        } else {
            formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("eb_permdimsetting");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PermDimSetting_back));
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (this.notEmpty(modelId)) {
            formShowParameter.setCustomParam("modelId", (Object)modelId);
            this.getView().showForm(formShowParameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"DimMembPermBasePlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    protected boolean isManageForm() {
        return false;
    }

    @Override
    protected void callConditionHandle(PermConditionType conditionType) {
        super.callConditionHandle(conditionType);
        switch (conditionType) {
            case BIZCTRLRANGE: {
                this.dealBizCtrlRangeChange();
                break;
            }
        }
    }

    @Override
    protected void dealModelChange() {
        this.cleanBizCtrlRange();
        this.getView().setVisible(Boolean.valueOf(this.currentModelIsBGMD()), new String[]{bizCtrlRange_key});
        super.dealModelChange();
    }

    private void cleanBizCtrlRange() {
        this.setNoNeedResponseChange(true);
        this.getModel().setValue(bizCtrlRange_key, null);
        this.setNoNeedResponseChange(false);
    }

    @Override
    protected Set<Long> getFilterModelIds() {
        Set<Long> filterModelIds = super.getFilterModelIds();
        Set modelIdsOnGivePerm = MembPermRecordUtil.getModelIdsOnGivePerm((Long)this.getUserId());
        filterModelIds.addAll(modelIdsOnGivePerm);
        return filterModelIds;
    }

    @Override
    public List<DimMembPermType> getPermTypeList() {
        return DimMembPermType.getPermTypeListByGroup((PermGroupEnum)PermGroupEnum.DATA);
    }

    @Override
    public String getFormType() {
        return "member";
    }

    @Override
    protected void update4NewEb() {
        super.update4NewEb();
        if (this.isNewEbForm()) {
            this.setBgDefaultBCR(bizCtrlRange_key, true);
        }
    }

    @Override
    protected void dealDimensionChange() {
        super.dealDimensionChange();
    }

    private boolean isDimGroup(String number) {
        return this.notEmpty(number) && number.contains(",");
    }

    @Override
    protected void addBatMemberFilter(Map<String, Object> formParams, Long modelId, Long bizModelId, List<String> currentDimNums) {
        HashMap<String, Set> memberFilters = new HashMap<String, Set>();
        HashMap<String, Set> propFilters = new HashMap<String, Set>();
        List<DimMembPermType> permTypes = Collections.singletonList(DimMembPermType.GIVE);
        boolean hasAllPerm = DimMembPermHelper.readMemberPerm((Long)modelId, (Long)bizModelId, new HashSet<String>(currentDimNums), (Long)this.getUserId(), permTypes, (boolean)false, (boolean)true, null, permInfo -> permInfo.getMemberGroup().forEach((dimNum, member) -> {
            if (member.isMember()) {
                memberFilters.computeIfAbsent((String)dimNum, key -> new HashSet(16)).add(member.getMemberId());
            } else {
                propFilters.computeIfAbsent((String)dimNum, key -> new HashSet(16)).add(member.getMemberId());
            }
        }));
        if (!hasAllPerm && currentDimNums.size() > 1) {
            Set propValIds;
            Set membIds;
            HashMap singleDimPermMembIds = new HashMap(currentDimNums.size());
            HashMap singleDimPermPropValIds = new HashMap(currentDimNums.size());
            for (String dimNun : currentDimNums) {
                membIds = new HashSet(16);
                propValIds = new HashSet(16);
                DimMembPermHelper.readMemberPerm((Long)modelId, (Long)bizModelId, (Set)Sets.newHashSet((Object[])new String[]{dimNun}), (Long)this.getUserId(), permTypes, (boolean)false, (boolean)true, null, permInfo -> {
                    MemberItem memberItem = (MemberItem)permInfo.getMemberGroup().get(dimNun);
                    if (memberItem != null) {
                        if (memberItem.isMember()) {
                            membIds.add(memberItem.getMemberId());
                        } else {
                            propValIds.add(memberItem.getMemberId());
                        }
                    }
                });
                if (membIds.isEmpty() && propValIds.isEmpty()) {
                    singleDimPermMembIds.clear();
                    singleDimPermPropValIds.clear();
                    break;
                }
                singleDimPermMembIds.put(dimNun, membIds);
                singleDimPermPropValIds.put(dimNun, propValIds);
            }
            for (String dimNun : currentDimNums) {
                membIds = singleDimPermMembIds.getOrDefault(dimNun, new HashSet(16));
                propValIds = singleDimPermPropValIds.getOrDefault(dimNun, new HashSet(16));
                memberFilters.computeIfAbsent(dimNun, key -> new HashSet(16)).addAll(membIds);
                propFilters.computeIfAbsent(dimNun, key -> new HashSet(16)).addAll(propValIds);
            }
        }
        if (!hasAllPerm) {
            if (memberFilters.isEmpty()) {
                currentDimNums.forEach(dim -> {
                    Set cfr_ignored_0 = memberFilters.put((String)dim, new HashSet(16));
                });
            }
            formParams.put("mutildimf7_memberfilter", SerializationUtils.serializeToBase64(memberFilters));
        }
        if (!hasAllPerm) {
            if (propFilters.isEmpty()) {
                currentDimNums.forEach(dim -> {
                    Set cfr_ignored_0 = propFilters.put((String)dim, new HashSet(16));
                });
            }
            formParams.put("mutildimf7_propvalfilter", SerializationUtils.serializeToBase64(propFilters));
        }
    }

    @Override
    protected void onFillBackMemberRow(DynamicObject newRow, boolean hasRealMember, boolean isInit) {
        if (!hasRealMember) {
            newRow.set(DimMembPermType.DATAPERMEXTENDS.getBoxKey(), (Object)false);
        }
    }

    @Override
    protected void dealDimCol(EntryGrid entryGrid, Dimension dimension, int dimSeq) {
        entryGrid.setColumnProperty("viewname" + dimSeq, "header", (Object)new LocaleString(dimension.getName()));
    }
}

