/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.perm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.applyTemplate.helper.ExcelHelper;
import kd.epm.eb.common.applybill.Count;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.member.f7.MemberF7Utils;
import kd.epm.eb.common.model.UserSelectModel;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.MembPermRecordUtil;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.enums.PermConditionType;
import kd.epm.eb.common.permission.enums.PermGroupEnum;
import kd.epm.eb.common.permission.pojo.DimMembPermDetailRecord;
import kd.epm.eb.common.permission.pojo.DimMembPermRecord;
import kd.epm.eb.common.permission.pojo.PermCopyFormParam;
import kd.epm.eb.common.permission.pojo.PermSaveArgs;
import kd.epm.eb.common.permission.pojo.ShowConfirmInfo;
import kd.epm.eb.common.permission.pojo.UserInfo;
import kd.epm.eb.common.permission.pojo.UserInfoOnPage;
import kd.epm.eb.common.permission.policyUtils.BaseConditionCheck;
import kd.epm.eb.common.permission.policyUtils.DataChangedCheck;
import kd.epm.eb.common.permission.policyUtils.IMembPermSaveCheck;
import kd.epm.eb.common.permission.policyUtils.ModifiedCheck;
import kd.epm.eb.common.permission.policyUtils.MustInputCheck;
import kd.epm.eb.common.permission.policyUtils.NoManagerCheck;
import kd.epm.eb.common.permission.policyUtils.RowContainsCheck;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.pojo.MultiDim.DimViewInfo;
import kd.epm.eb.common.pojo.MultiDim.MultiDimMembResult;
import kd.epm.eb.common.pojo.MultiDim.MultiDimMemberVal;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import kd.epm.eb.common.utils.fileImport.FileImportUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.bgadjust.utils.AdjustUtil;
import kd.epm.eb.formplugin.perm.DimPermImportUtil;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DimMembPermBasePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
RowClickEventListener,
HyperLinkClickListener,
SelectRowsEventListener {
    protected static final String membentryentity = "memberentry";
    private static final String dimentryentity = "dimentryentity";
    protected static final String userentry = "userentry";
    protected static final String lastModelCache = "lastModelCache";
    protected static final String lastUserCache = "lastUserCache";
    protected static final String lastDimCache = "lastDimCache";
    protected static final String lastBCRCache = "lastBCRCache";
    private static final String bizCtrlRange_key = "bizctrlrange";
    private static final String dimListKey = "dimensioncombo";
    private static final String modelKey = "model";
    protected static final String BatMemberSet_back = "BatMemberSet_back";
    private Map<Long, String> dimViewMap = new HashMap<Long, String>(16);
    private String dealPropChanged = null;
    private static final Log log = LogFactory.getLog(DimMembPermBasePlugin.class);
    private final FileImportUtils fileImportUtils = FileImportUtils.getInstance();
    private final DimPermImportUtil dimPermImportUtil = DimPermImportUtil.getInstance();

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl(userentry);
        entryGrid.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbar_main", "advcontoolbarap", "advcontoolbarap1"});
        this.addClickListeners(new String[]{"selectmember", "delmember", ""});
        this.addF7SelectListener(this, new String[]{modelKey});
        this.addMemberCellClickListener();
    }

    private void addMemberCellClickListener() {
        List<String> currentDimNums = this.getCurrentDimNums();
        String[] keys = new String[currentDimNums.size()];
        for (int i = 0; i < currentDimNums.size(); ++i) {
            keys[i] = "membernum" + i;
        }
        if (keys.length > 0) {
            this.addClickListeners(keys);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initUserSelect();
    }

    private void initUserSelect() {
        List userInfos;
        Long bizModelId;
        String _modelId = (String)this.getFormCustomParam("modelId");
        String _bizModelId = (String)this.getFormCustomParam("bizModelId");
        String _dimNumStr = (String)this.getFormCustomParam("dimNumStr");
        String _userId = (String)this.getFormCustomParam("userId");
        UserSelectModel selectModel = UserSelectUtil.getUserSelect4PermForm((IFormView)this.getView(), (String)modelKey, (!this.isManageForm() ? 1 : 0) != 0, (boolean)false);
        Long model = this.notEmpty(_modelId) ? Long.valueOf(_modelId) : selectModel.getModel();
        Long l = bizModelId = this.notEmpty(_bizModelId) ? Long.valueOf(_bizModelId) : selectModel.getBizModelId();
        if (this.notEmpty(model)) {
            this.getModel().setValue(modelKey, (Object)model);
            this.callConditionHandle(PermConditionType.MODEL);
        }
        if (this.needCheckBCR() && this.notEmpty(bizModelId)) {
            this.getModel().setValue(bizCtrlRange_key, (Object)bizModelId);
            this.callConditionHandle(PermConditionType.BIZCTRLRANGE);
        }
        if (this.notEmpty(_dimNumStr)) {
            this.getModel().setValue(dimListKey, (Object)_dimNumStr);
            this.callConditionHandle(PermConditionType.DIMENSION);
        }
        if (this.notEmpty(_userId) && (userInfos = UserUtils.getUserInfo(Collections.singletonList(Long.valueOf(_userId)), (boolean)false)).size() > 0) {
            UserInfo userInfo = (UserInfo)userInfos.get(0);
            ListSelectedRowCollection selectedRows = new ListSelectedRowCollection();
            ListSelectedRow row = new ListSelectedRow();
            row.setNumber(userInfo.getNumber());
            row.setName(userInfo.getName());
            row.setPrimaryKeyValue((Object)userInfo.getId());
            selectedRows.add((Object)row);
            this.showBackUsers(userInfo.isUserGroup() ? "bos_usergroup" : "bos_user", selectedRows);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (this.notEmpty(key) && key.startsWith("membernum")) {
            this.doSelMember(key);
        }
    }

    private void doSelMember(String propKey) {
        int seq = this.getMemberSeqByKey(propKey);
        IDataModel dataModel = this.getModel();
        int rowIndex = dataModel.getEntryCurrentRowIndex(membentryentity);
        Long memberId = (Long)dataModel.getValue("memberid" + seq, rowIndex);
        Long viewId = (Long)dataModel.getValue("viewid" + seq, rowIndex);
        Long modelId = this.getModelId();
        List<String> currentDimNums = this.getCurrentDimNums();
        String currentDimNum = currentDimNums.get(seq);
        if (!this.checkDimExist(modelId, currentDimNums)) {
            return;
        }
        Map<String, Set<Long>> memberFilter = this.getMemberFilter(currentDimNum, rowIndex);
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "dimMembSelect" + seq);
        Long busModelId = this.getBizCtrlRangeId();
        MemberF7Parameter f7Param = NewF7Utils.multipleF8((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)currentDimNum), (String)ListSelectedRow.class.getName());
        if (IDUtils.isNotNull((Long)busModelId)) {
            f7Param.setBusModelId(busModelId);
            if (SysDimensionEnum.Account.getNumber().equals(currentDimNum)) {
                HashSet allDimIdSet = new HashSet(currentDimNums.size());
                currentDimNums.forEach(dimNum -> {
                    Dimension dim = modelCacheHelper.getDimension(dimNum);
                    if (dim != null && !currentDimNum.equals(dim.getDimNum())) {
                        allDimIdSet.add(dim.getId());
                    }
                });
                List filterDataSetIds = DatasetServiceHelper.getDatasetByDimFilter((Long)busModelId, allDimIdSet);
                f7Param.setDatasetIds(filterDataSetIds);
            }
        }
        if (this.isManageForm()) {
            List viewList;
            f7Param.setLoadDefaultBusModel(false);
            if (this.isEmpty(viewId) && this.notEmpty(viewList = modelCacheHelper.getDimension(currentDimNum).getViewList())) {
                viewId = (Long)viewList.get(0);
            }
        } else {
            f7Param.setPermType(DimMembPermType.GIVE);
            f7Param.setDimNums4PermGroup(this.getCurrentDimNums());
        }
        f7Param.setVerifyPermission(true);
        if (this.notEmpty(memberFilter)) {
            f7Param.setCombPermMap(memberFilter);
        }
        f7Param.setCanSelectRoot(true);
        f7Param.setMultiSelect(false);
        f7Param.setCutTree(false);
        f7Param.setSelectId(memberId);
        f7Param.setViewId(viewId);
        f7Param.setShowCustomProperty(true);
        f7Param.setLockRangeSelect(true);
        if (SysDimensionEnum.dimHasView((String)currentDimNum) && (modelCacheHelper.getModelobj().isModelByBGMD() || this.isNewEbForm() && SysDimensionEnum.Entity.getNumber().equals(currentDimNum))) {
            f7Param.setEnableView(true);
        } else {
            f7Param.setEnableView(false);
        }
        NewF7Utils.openF8((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)closeCallBack);
    }

    private int getMemberSeqByKey(String propKey) {
        int seq = 0;
        if (this.notEmpty(propKey)) {
            char c = propKey.charAt(propKey.length() - 1);
            seq = c - 48;
        }
        return seq;
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("newentry".equals(operateKey) && !this.checkBaseInfoB4AddRow()) {
            args.setCancel(true);
        }
    }

    private void handDelPermRecord() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(membentryentity);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u9664\u7684\u884c\u3002", (String)"DimMembPermBasePlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showConfirm(ResManager.loadResFormat((String)"\u786e\u8ba4\u5220\u9664\u9009\u4e2d\u7684%1\u884c?", (String)"DimMembPermBasePlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[]{selectRows.length}), MessageBoxOptions.YesNo, new ConfirmCallBackListener("DelPermRecord", (IFormPlugin)this));
        }
    }

    private void delPermRecordRow() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(membentryentity);
        int[] selectRows = entryGrid.getSelectRows();
        this.cacheDeledRowInfo(selectRows);
        this.getModel().deleteEntryRows(membentryentity, selectRows);
        this.markRecordChanged(true);
    }

    private void cacheDeledRowInfo(int[] rowIndexs) {
        Set<String> delRowsInfo;
        if (ModelServiceHelper.isUserHasRootPermByModel((long)UserUtils.getUserId(), (Long)this.getLastModelId())) {
            return;
        }
        DynamicObjectCollection membs = this.getModel().getEntryEntity(membentryentity);
        StringBuilder sb = new StringBuilder();
        HashSet<String> membIdsStr = new HashSet<String>(16);
        block0: for (int index : rowIndexs) {
            List<String> dimNums = this.getCurrentDimNums();
            DynamicObject row = (DynamicObject)membs.get(index);
            for (int i = 0; i < dimNums.size(); ++i) {
                Long memberId = row.getLong("memberid" + i);
                if (this.isEmpty(memberId)) continue block0;
                sb.append(memberId).append(',');
            }
            membIdsStr.add(sb.toString());
            sb.setLength(0);
        }
        if (membIdsStr.size() > 0 && (delRowsInfo = this.getOrCacheDelRows(null)).addAll(membIdsStr)) {
            this.getOrCacheDelRows(delRowsInfo);
        }
    }

    protected Set<String> getOrCacheDelRows(Set<String> deledRowMemberIds) {
        if (deledRowMemberIds == null) {
            String cacheStr = this.getPageCache().get("DelRowsInfo");
            deledRowMemberIds = this.notEmpty(cacheStr) ? (HashSet)SerializationUtils.deSerializeFromBase64((String)cacheStr) : new HashSet(16);
        } else {
            this.getPageCache().put("DelRowsInfo", SerializationUtils.serializeToBase64(deledRowMemberIds));
        }
        return deledRowMemberIds;
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.needResponseChange()) {
            return;
        }
        String propName = e.getProperty().getName();
        if (modelKey.equals(propName)) {
            this.dealConditionChange(PermConditionType.MODEL);
        } else if (propName.equals(dimListKey)) {
            this.dealConditionChange(PermConditionType.DIMENSION);
        } else if (propName.startsWith("membernum")) {
            this.dealMemberChange(e.getChangeSet()[0], propName);
        }
        this.dealPropChanged(e);
    }

    protected void dealMemberChange(ChangeData changeData, String propKey) {
        Object newValue = changeData.getNewValue();
        if (this.isEmpty(newValue)) {
            int rowIndex = changeData.getRowIndex();
            int membSeq = Integer.parseInt(propKey.replace("membernum", ""));
            this.cacheDeledRowInfo(new int[]{rowIndex});
            this.getModel().setValue("membername" + membSeq, null, rowIndex);
            this.getModel().setValue("memberid" + membSeq, null, rowIndex);
            this.getModel().setValue("viewid" + membSeq, null, rowIndex);
            this.getModel().setValue("viewname" + membSeq, null, rowIndex);
            this.afterDelMember(rowIndex, membSeq);
            this.markRecordChanged(true);
        }
    }

    protected void afterDelMember(int rowIndex, int memberSeq) {
    }

    protected void dealPropChanged(PropertyChangedArgs e) {
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String proName = beforeF7SelectEvent.getProperty().getName();
        if (modelKey.equals(proName)) {
            this.filterModelList(beforeF7SelectEvent);
        }
    }

    private void filterModelList(BeforeF7SelectEvent beforeF7SelectEvent) {
        IFormView view = this.getView();
        ArrayList<QFilter> modelQFilters = new ArrayList<QFilter>();
        QFilter qApp = ModelUtil.getModelQfilterByApp((IFormView)view);
        Set<Long> filterModelIds = this.getFilterModelIds();
        QFilter qIds = new QFilter("id", "in", filterModelIds);
        modelQFilters.add(qApp);
        modelQFilters.add(qIds);
        beforeF7SelectEvent.getCustomQFilters().addAll(modelQFilters);
        beforeF7SelectEvent.getFormShowParameter().getCustomParams().put("noNeedDefaultQFilter", "true");
    }

    protected Set<Long> getFilterModelIds() {
        return ModelUtil.getModelIds((IFormView)this.getView(), (boolean)true);
    }

    protected Set<Long> getBCRIdsOnGivePerm(Long modelId) {
        Long personId = this.getUserId();
        Set bcrIdOnGivePerm = MembPermRecordUtil.getBCRIdsOnGivePerm((Long)modelId, (Long)personId);
        return bcrIdOnGivePerm;
    }

    private void addUserAndGroupFilter(String userType, ListShowParameter listShowParameter) {
        DynamicObjectCollection us = this.getModel().getEntryEntity(userentry);
        ArrayList<Long> selectedIds = new ArrayList<Long>(16);
        if (us != null && !us.isEmpty()) {
            us.forEach(u -> {
                if (u != null && userType.equals(u.getString("etype"))) {
                    selectedIds.add(this.getUserIdOnEntryRow((DynamicObject)u));
                }
            });
        }
        if ("bos_user".equals(userType)) {
            selectedIds.add(UserUtils.getUserId());
        }
        Set managers = ModelServiceHelper.getManagersByModel((Long)this.getLastModelId(), (boolean)true, (boolean)true);
        selectedIds.addAll(managers);
        if (!selectedIds.isEmpty()) {
            listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", selectedIds));
        }
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        String entryKey = entryGrid.getEntryKey();
        if (entryKey.equals(userentry)) {
            this.dealConditionChange(PermConditionType.USERCHAHNGE);
        }
    }

    protected boolean selectedAllCondition() {
        Long modelId = this.getModelId();
        Long lastUserId = this.getLastUserId();
        UserInfoOnPage currentTargetPersonId = this.getLastUserInfo();
        List<String> currentDimNums = this.getCurrentDimNums();
        if (this.notEmpty(lastUserId) && this.isEmpty(currentTargetPersonId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u7528\u6237/\u7528\u6237\u7ec4\u4fe1\u606f\u5df2\u8fc7\u65f6\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u5220\u9664\u3002", (String)"DimMembPermBasePlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return modelId != 0L && currentTargetPersonId != null && this.notEmpty(currentDimNums);
    }

    @Override
    public Long getModelId() {
        Long modelId = (Long)this.getValue(modelKey, "id");
        if (this.isEmpty(modelId)) {
            return 0L;
        }
        return modelId;
    }

    protected void dealUserChange() {
        this.cacheCurrentUser();
    }

    protected void cacheCurrentUser() {
        Pair<Long, Integer> userRowInfo = this.getNowFocusUser();
        this.getOrCacheLastFocusUser((Long)userRowInfo.p1);
    }

    protected Pair<Long, Integer> getNowFocusUser() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(userentry);
        int focusRow = entryGrid.getEntryState().getFocusRow();
        if (focusRow < 0) {
            return new Pair((Object)0L, (Object)-1);
        }
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(userentry, focusRow);
        return new Pair((Object)this.getUserIdOnEntryRow(entryRowEntity), (Object)focusRow);
    }

    protected Long getUserIdOnEntryRow(DynamicObject entryRowEntity) {
        if (entryRowEntity == null) {
            return 0L;
        }
        return entryRowEntity.getLong("eusers.id");
    }

    private void initPermRecorEntry() {
        UserInfoOnPage userInfo = this.getLastUserInfo();
        DimMembPermRecord permRecord = this.getPermRecord((UserInfo)userInfo);
        if (permRecord != null && !permRecord.getAllDetailRecords().isEmpty()) {
            this.filterMembPermRecord(permRecord, userInfo);
            Map permDetailRecords = permRecord.getAllDetailRecords();
            List<String> dimNums = this.getCurrentDimNums();
            IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
            MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)this.getModelId());
            IDataModel dataModel = this.getModel();
            List<DimMembPermType> permTypeList = this.getPermTypeList();
            List permRecords = permDetailRecords.values().stream().sorted(Comparator.comparing(record -> record[0].getSeq())).collect(Collectors.toList());
            DynamicObjectCollection entryEntity = dataModel.getEntryEntity(membentryentity);
            int index = 0;
            for (DimMembPermDetailRecord[] detailRecord : permRecords) {
                DynamicObject row = entryEntity.addNew();
                boolean error = false;
                int memberSeq = 0;
                boolean hasMember = false;
                for (DimMembPermDetailRecord membRecord : detailRecord) {
                    if (this.fillMember2Row(row, memberPropCache, modelCacheHelper, membRecord.getMemberId(), dimNums.get(memberSeq), membRecord.getViewId(), membRecord.isMember(), memberSeq)) {
                        error = true;
                        break;
                    }
                    hasMember = hasMember || membRecord.isMember();
                    ++memberSeq;
                }
                if (error) {
                    entryEntity.remove(index);
                    continue;
                }
                this.onFillBackMemberRow(row, hasMember, true);
                byte permVal = detailRecord[0].getPermVal();
                for (DimMembPermType permType : permTypeList) {
                    if (permType.hasPerm(permVal)) {
                        row.set(permType.getBoxKey(), (Object)true);
                        continue;
                    }
                    row.set(permType.getBoxKey(), (Object)false);
                }
                ++index;
            }
            this.getModel().updateEntryCache(entryEntity);
            this.getView().updateView(membentryentity);
        }
        this.getOrCachePermInitTime(TimeServiceHelper.now());
    }

    protected void filterMembPermRecord(DimMembPermRecord permRecord, UserInfoOnPage userInfo) {
    }

    protected void markRecordChanged(boolean changed) {
        if (changed) {
            this.getPageCache().put("recordChanged", "true");
        } else {
            this.getPageCache().remove("recordChanged");
        }
    }

    protected boolean hasRecordChanged() {
        return this.getPageCache().get("recordChanged") != null;
    }

    private UserInfoOnPage getLastUserInfo() {
        Long lastFocusUser = this.getLastUserId();
        UserInfoOnPage userInfo = null;
        if (lastFocusUser != null) {
            DynamicObjectCollection entryRows = this.getModel().getEntryEntity(userentry);
            int index = 0;
            for (DynamicObject row : entryRows) {
                DynamicObject user = row.getDynamicObject("eusers");
                if (user != null && lastFocusUser.equals(user.getLong("id"))) {
                    String userType = row.getString("etype");
                    boolean isUserGroup = "bos_usergroup".equals(userType);
                    userInfo = new UserInfoOnPage(Long.valueOf(user.getLong("id")), user.getString("number"), user.getString("name"), isUserGroup, index);
                    break;
                }
                ++index;
            }
        }
        return userInfo;
    }

    protected DimMembPermRecord getPermRecord(UserInfo userInfo) {
        List<String> dimNums;
        Long modelId = this.getLastModelId();
        if (!this.checkDimExist(modelId, dimNums = this.getLastDimNums())) {
            return null;
        }
        Long bizCtrlRangeId = this.getLastBCRId();
        boolean isManagerForm = this.isManageForm();
        DimMembPermRecord permRecord = MembPermRecordUtil.getMainPermRecord((Long)modelId, (Long)bizCtrlRangeId, dimNums, (Long)userInfo.getId(), (PermGroupEnum)(isManagerForm ? PermGroupEnum.MANAGER : PermGroupEnum.DATA));
        return permRecord;
    }

    private boolean checkDimExist(Long modelId, Collection<String> dimNums) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        if (this.isEmpty(dimNums)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4e0d\u5b58\u5728\u3002", (String)"DimMembPermBasePlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        for (String dimNum : dimNums) {
            if (modelCacheHelper.getDimension(dimNum) != null) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"DimMembPermBasePlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[]{dimNum}));
            return false;
        }
        return true;
    }

    protected List<String> getCurrentDimNums() {
        return this.getDimNums(this.getCurrentDimNum());
    }

    protected List<String> getLastDimNums() {
        return this.getDimNums(this.getLastDimNum());
    }

    protected List<String> getDimNums(String dimNumStr) {
        ArrayList<String> dimNums = new ArrayList<String>(16);
        if (this.notEmpty(dimNumStr)) {
            for (String dimNum : dimNumStr.split(",")) {
                dimNums.add(dimNum);
            }
        }
        return dimNums;
    }

    protected String getCurrentDimNum() {
        return (String)this.getValue(dimListKey, null);
    }

    public boolean currentModelIsBGMD() {
        Long currentModelId = this.getCurrentModelId();
        return !currentModelId.equals(0L) && ModelServiceHelper.isBGMDModel((Long)currentModelId);
    }

    protected boolean needCheckBCR() {
        return !this.isManageForm() && (this.currentModelIsBGMD() || this.isNewEbForm());
    }

    protected Set<String> updateDimList(boolean setDefault) {
        List<BasedataPojo> dimListToShow = this.getDimListToShow();
        HashSet<String> dimNums = new HashSet<String>(16);
        ComboEdit comboEdit = (ComboEdit)this.getControl(dimListKey);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(dimListToShow.size());
        HashMap<String, String> dimInfoMap = new HashMap<String, String>(16);
        for (BasedataPojo dimensionInfo : dimListToShow) {
            items.add(new ComboItem(new LocaleString(dimensionInfo.getName()), dimensionInfo.getNumber()));
            dimNums.add(dimensionInfo.getNumber());
            dimInfoMap.put(dimensionInfo.getNumber(), dimensionInfo.getName());
        }
        comboEdit.setComboItems(items);
        if (setDefault && dimListToShow.size() > 0) {
            this.selectDim(dimListToShow.get(0).getNumber());
            this.handleConditionChanged(PermConditionType.DIMENSION);
        } else {
            this.selectDim(null);
        }
        this.getOrCacheObj(dimInfoMap, null, "dimInfoMap", true, HashMap.class, false);
        return dimNums;
    }

    public Map<String, String> getDimInfoMap() {
        return (Map)this.getOrCacheObjWithDef(null, null, "dimInfoMap", true, HashMap.class, false);
    }

    protected void selectDim(String dimNum) {
        this.setNoNeedResponseChange(true);
        this.getModel().setValue(dimListKey, (Object)dimNum);
        this.setNoNeedResponseChange(false);
        this.getOrCacheLastDimNum(dimNum == null ? "" : dimNum);
    }

    protected void dealModelChange() {
        this.cleanUserEntry();
        this.cleanMembEntry();
        this.getOrCacheLastModel(this.getModelId());
        this.getOrCacheLastFocusUser(0L);
        this.getOrCacheLastBCRId(0L);
        this.update4NewEb();
        this.updateDimList(true);
        UserSelectUtil.saveUserSelectWhenBizModelChange((IFormView)this.getView(), (Long)this.getLastModelId(), (Long)this.getLastBCRId());
    }

    protected void update4NewEb() {
        Long modelId = this.getModelId();
        boolean newEbModel = NewEbAppUtil.isNewEbModel((Long)modelId);
        this.markNewEbForm(newEbModel);
    }

    protected Long getLastUserId() {
        return this.getOrCacheLastFocusUser(null);
    }

    protected Long getLastModelId() {
        return this.getOrCacheLastModel(null);
    }

    protected String getLastDimNum() {
        return this.getOrCacheLastDimNum(null);
    }

    protected Long getLastBCRId() {
        return this.getOrCacheLastBCRId(null);
    }

    protected Long getOrCacheLastBCRId(Long bizCtrlRangeId) {
        return this.getOrSetLastCondition(lastBCRCache, bizCtrlRangeId, 0L);
    }

    protected Long getOrCacheLastFocusUser(Long userId) {
        return this.getOrSetLastCondition(lastUserCache, userId, 0L);
    }

    protected Long getOrCacheLastModel(Long modelId) {
        return this.getOrSetLastCondition(lastModelCache, modelId, 0L);
    }

    protected String getOrCacheLastDimNum(String dimNumber) {
        return this.getOrSetLastCondition(lastDimCache, dimNumber, "");
    }

    protected void cleanUserEntry() {
        this.getModel().deleteEntryData(userentry);
    }

    protected void cleanMembEntry() {
        this.getModel().deleteEntryData(membentryentity);
    }

    protected void checkAndInitMembEntry() {
        this.cleanMembEntry();
        if (this.selectedAllCondition()) {
            this.initPermRecorEntry();
        }
        this.markRecordChanged(false);
    }

    protected List<BasedataPojo> getDimListToShow() {
        ArrayList<BasedataPojo> dimList = new ArrayList<BasedataPojo>(16);
        Long modelId = this.getModelId();
        if (!modelId.equals(0L)) {
            IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
            Long bizCtrlRangeId = this.getBizCtrlRangeId();
            List dimensionList = this.isManageForm() || modelCacheHelper.getModelobj().isModelByEB() ? modelCacheHelper.getDimensionList() : modelCacheHelper.getDimensionListByBusModel(bizCtrlRangeId);
            boolean isNewEb = this.isNewEbForm();
            for (Dimension dim : dimensionList) {
                String dimNum = dim.getNumber();
                if (SysDimensionEnum.Process.getNumber().equals(dimNum) || SysDimensionEnum.Scenario.getNumber().equals(dimNum) || isNewEb && SysDimensionEnum.InternalCompany.getNumber().equals(dimNum)) continue;
                BasedataPojo dimensionInfo = new BasedataPojo(dim.getId(), dim.getName(), dimNum);
                dimList.add(dimensionInfo);
            }
        }
        return dimList;
    }

    protected void setNoNeedResponseChange(boolean noNeed) {
        this.dealPropChanged = noNeed ? "false" : null;
    }

    protected boolean needResponseChange() {
        return this.dealPropChanged == null;
    }

    protected List<DimMembPermType> getPermTypeList() {
        return new ArrayList<DimMembPermType>(16);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "baritem_save": {
                this.handleSaveData(null);
                break;
            }
            case "adduser": {
                this.showUserOrGroupForm("bos_user", "addBaseUser");
                break;
            }
            case "addusergroup": {
                this.showUserOrGroupForm("bos_usergroup", "addBaseUserGroup");
                break;
            }
            case "deluser": {
                this.dealDelUser();
                break;
            }
            case "btn_showpermsearch": {
                this.showMembPermSearchForm();
                break;
            }
            case "btn_permcopy": {
                this.showPermCopy();
                break;
            }
            case "selectmember": {
                break;
            }
            case "delmember": {
                this.handDelPermRecord();
                break;
            }
            case "import": {
                this.showImportForm();
                break;
            }
            case "export": {
                this.exportExcel();
                break;
            }
            case "btn_reflesh": {
                this.dealConditionChange(PermConditionType.REFLESH);
                break;
            }
            case "btn_batsetmemb": {
                this.dealAddDimMemb();
                break;
            }
            case "updatetest": {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("eb_membpermsearch");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(showParameter);
                break;
            }
            case "baritem_close": {
                this.handleClose();
                break;
            }
        }
    }

    private void handleClose() {
        if (this.hasRecordChanged() && this.canSave()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6743\u9650\u503c\u5df2\u4fee\u6539\uff0c\u662f\u5426\u7ee7\u7eed\u9000\u51fa\uff1f", (String)"DimMembPermBasePlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("close", (IFormPlugin)this));
        } else {
            this.getView().close();
        }
    }

    private void updateOldPerm() {
    }

    private List<Long> getAllModelIdOnOldPerm() {
        LinkedList<Long> modelIds = new LinkedList<Long>();
        try (DataSet dataSet = DB.queryDataSet((String)"getAllModelIdOnOldPerm", (DBRoute)BgBaseConstant.epm, (String)"select distinct  fmodel  from t_eb_dataperm");){
            for (kd.bos.algo.Row row : dataSet) {
                modelIds.add(row.getLong("fmodel"));
            }
        }
        return modelIds;
    }

    private void dealDelUser() {
        EntryGrid userEntity = (EntryGrid)this.getControl(userentry);
        int[] rowIndexs = userEntity.getEntryState().getSelectedRows();
        if (rowIndexs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u8981\u5220\u9664\u7684\u884c\u3002", (String)"EbDataPermPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.dealConditionChange(PermConditionType.UESRDEL);
        }
    }

    private void dealAddDimMemb() {
        if (!this.checkBaseInfoB4AddRow()) {
            return;
        }
        List<String> currentDimNums = this.getCurrentDimNums();
        Long modelId = this.getModelId();
        Long bizModelId = this.getBizCtrlRangeId();
        HashMap<String, Object> formParams = new HashMap<String, Object>(16);
        this.addBatMemberFilter(formParams, modelId, bizModelId, currentDimNums);
        MemberF7Utils.openMultiDimMemberF7(currentDimNums, (Long)this.getModelId(), (Long)this.getBizCtrlRangeId(), (!this.isManageForm() ? 1 : 0) != 0, (IFormView)this.getView(), formParams, (CloseCallBack)new CloseCallBack((IFormPlugin)this, BatMemberSet_back));
    }

    protected void addBatMemberFilter(Map<String, Object> formParams, Long modelId, Long bizModelId, List<String> currentDimNums) {
    }

    private boolean checkBaseInfoB4AddRow() {
        List<String> currentDimNums = this.getCurrentDimNums();
        if (this.isEmpty(currentDimNums)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6/\u7ef4\u5ea6\u7ec4\u5408\u3002", (String)"DimMembPermBasePlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        Long lastUserId = this.getLastUserId();
        if (this.isEmpty(lastUserId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7528\u6237\u6216\u7528\u6237\u7ec4\u3002", (String)"DimMembPermBasePlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        UserInfoOnPage lastUserInfo = this.getLastUserInfo();
        if (lastUserInfo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u7528\u6237/\u7528\u6237\u7ec4\u4fe1\u606f\u5df2\u8fc7\u65f6\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u5220\u9664\u3002", (String)"DimMembPermBasePlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected Map<String, Set<Long>> getMemberFilter(String currentDimNum, int rowIndex) {
        return null;
    }

    private void showPermCopy() {
        Long modelId = this.getModelId();
        Long targetUId = this.getLastUserId();
        if (this.isEmpty(modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"DimMembPermBasePlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!ModelServiceHelper.isUserHasRootPermByModel((long)UserUtils.getUserId(), (Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u4f53\u7cfb\u7ba1\u7406\u5458\u624d\u80fd\u8fdb\u884c\u6743\u9650\u590d\u5236\u3002", (String)"DimMembPermBasePlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.isEmpty(targetUId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u7528\u6237\u6216\u7528\u6237\u7ec4\u3002", (String)"DimMembPermBasePlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        UserInfoOnPage lastUserInfo = this.getLastUserInfo();
        if (lastUserInfo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u7528\u6237/\u7528\u6237\u7ec4\u4fe1\u606f\u5df2\u8fc7\u65f6\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u5220\u9664\u3002", (String)"DimMembPermBasePlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        PermGroupEnum permGroupEnum = this.isManageForm() ? PermGroupEnum.MANAGER : PermGroupEnum.DATA;
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_dimensionpermcopy");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458%1\u6743\u9650\u590d\u5236", (String)"DimMembPermBasePlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[]{permGroupEnum.getName()}));
        PermCopyFormParam formParam = new PermCopyFormParam();
        formParam.setPermGroup(permGroupEnum);
        formParam.setModelId(modelId);
        formParam.setSourceUserId(targetUId);
        formParam.setEbModel(ModelServiceHelper.isOldEbModel((Long)modelId));
        formShowParameter.setCustomParam("sourceInfo", (Object)SerializationUtils.toJsonString((Object)formParam));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "permCopy"));
        this.getView().showForm(formShowParameter);
    }

    private void showMembPermSearchForm() {
        ReportShowParameter reportShowParameter = new ReportShowParameter();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        String formType = this.getFormType();
        paramMap.put("formType", formType);
        EntryGrid entryGrid = (EntryGrid)this.getControl(userentry);
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity(userentry);
        for (int selectRow : selectRows) {
            DynamicObject dynamicObject = (DynamicObject)entryRows.get(selectRow);
            DynamicObject user = dynamicObject.getDynamicObject("eusers");
            if (user == null) continue;
            String userType = dynamicObject.getString("etype");
            paramMap.put("userType", userType);
            paramMap.put("userId", user.getLong("id"));
        }
        paramMap.put(modelKey, this.getModelId());
        paramMap.put("bizModel", this.getBizCtrlRangeId());
        Object dimensioncombo = this.getModel().getValue(dimListKey);
        if (dimensioncombo != null) {
            paramMap.put("dimension", String.valueOf(dimensioncombo));
        }
        String caption = ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ba1\u7406\u6743\u9650\u67e5\u8be2", (String)"DimMembPermBasePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        if ("member".equals(formType)) {
            caption = ResManager.loadKDString((String)"\u6210\u5458\u6570\u636e\u6743\u9650\u67e5\u8be2", (String)"DimMembPermBasePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        reportShowParameter.setCaption(caption);
        reportShowParameter.setCustomParams(paramMap);
        reportShowParameter.setFormId("eb_userpermreport");
        reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)reportShowParameter);
    }

    private void showUserOrGroupForm(String entityType, String callBackKey) {
        if (!this.checkModel()) {
            return;
        }
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)entityType, (boolean)true);
        this.addUserAndGroupFilter(entityType, listShowParameter);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackKey));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    protected boolean checkModel() {
        Long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"EbDataPermPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public Long getCurrentModelId() {
        return this.getModelId();
    }

    protected <T> T getOrSetLastCondition(String key, T contition, T defaultVal) {
        if (contition == null) {
            String cacheStr = this.getPageCache().get(key);
            contition = !this.isEmptyStr(cacheStr) ? SerializationUtils.deSerializeFromBase64((String)cacheStr) : defaultVal;
        } else {
            this.getPageCache().put(key, SerializationUtils.serializeToBase64(contition));
        }
        return contition;
    }

    protected Long getBizCtrlRangeId() {
        return 0L;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionKey = closedCallBackEvent.getActionId();
        Object backData = closedCallBackEvent.getReturnData();
        if (backData == null) {
            return;
        }
        switch (actionKey) {
            case "addBaseUser": {
                this.showBackUsers("bos_user", backData);
                break;
            }
            case "addBaseUserGroup": {
                this.showBackUsers("bos_usergroup", backData);
                break;
            }
            case "permCopy": {
                this.afterCopyPerm(backData);
                break;
            }
            case "dataImport": {
                this.showDataImportTips(backData);
                break;
            }
            case "BatMemberSet_back": {
                this.fillBackBatMember((MultiDimMembResult)backData);
                break;
            }
            default: {
                if (!this.notEmpty(actionKey) || !actionKey.startsWith("dimMembSelect")) break;
                this.addDimMember(backData, this.getMemberSeqByKey(actionKey));
            }
        }
    }

    private void showDataImportTips(Object backData) {
        String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"DimMembPermBasePlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)msg, (CharSequence)String.valueOf(backData))) {
            this.getView().showSuccessNotification(msg);
        } else {
            this.getView().showTipNotification(String.valueOf(backData));
        }
        this.dealConditionChange(PermConditionType.REFLESH);
    }

    private void addDimMember(Object backData, int memberSeq) {
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)backData;
        IDataModel dataModel = this.getModel();
        int backRowCount = selectedRows.size();
        if (backRowCount == 0) {
            return;
        }
        ListSelectedRow selRow = selectedRows.get(0);
        boolean selAllOnRow = true;
        List<String> currentDimNums = this.getCurrentDimNums();
        ArrayList<Object> currentRowMemberIds = new ArrayList<Object>(currentDimNums.size());
        int currentRowIndex = dataModel.getEntryCurrentRowIndex(membentryentity);
        int dimSize = currentDimNums.size();
        DynamicObjectCollection existRows = dataModel.getEntryEntity(membentryentity);
        DynamicObject currentRowObj = (DynamicObject)existRows.get(currentRowIndex);
        for (int i = 0; i < dimSize; ++i) {
            Long membId = memberSeq == i ? ((Long)selRow.getPrimaryKeyValue()).longValue() : currentRowObj.getLong("memberid" + i);
            if (this.notEmpty(membId)) {
                currentRowMemberIds.add(membId);
                continue;
            }
            currentRowMemberIds.add(0L);
            selAllOnRow = false;
        }
        if (selAllOnRow) {
            int rowIndex = -1;
            block1: for (DynamicObject rowObj : existRows) {
                if (++rowIndex == currentRowIndex) continue;
                for (int i = 0; i < dimSize; ++i) {
                    Long rowMembId = rowObj.getLong("memberid" + i);
                    Long cMembId = (Long)currentRowMemberIds.get(i);
                    if (this.isEmpty(rowMembId) || !rowMembId.equals(cMembId)) continue block1;
                }
                if (!this.checkRowRepByOtherInfo(selRow, rowObj)) continue;
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u4e0e\u7b2c%1\u7684\u914d\u7f6e\u91cd\u590d", (String)"DimMembPermBasePlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[]{rowIndex + 1}));
                return;
            }
            this.cacheDeledRowInfo(new int[]{currentRowIndex});
        }
        boolean isMember = RangeF7PropertyCataEnum.Member.getIndex().equals(selRow.getDataMap().get("type"));
        dataModel.setValue("membernum" + memberSeq, selRow.getDataMap().get("shownumber"), currentRowIndex);
        dataModel.setValue("memberid" + memberSeq, selRow.getPrimaryKeyValue(), currentRowIndex);
        dataModel.setValue("membername" + memberSeq, (Object)selRow.getName(), currentRowIndex);
        dataModel.setValue("ismember" + memberSeq, (Object)isMember, currentRowIndex);
        Long viewId = isMember ? (Long)selRow.getDataMap().get("viewid") : null;
        dataModel.setValue("viewid" + memberSeq, (Object)viewId, currentRowIndex);
        dataModel.setValue("viewname" + memberSeq, (Object)this.getViewNameById(viewId), currentRowIndex);
        this.afterAddMember(currentRowObj, currentRowIndex, dimSize);
        this.markRecordChanged(true);
    }

    protected boolean checkRowRepByOtherInfo(ListSelectedRow selRow, DynamicObject targetRowObj) {
        return true;
    }

    protected void afterAddMember(DynamicObject currentRowObj, int rowIndex, int dimSize) {
    }

    protected boolean checkRowHasRealMember(DynamicObject rowObj, int dimSize) {
        boolean hasRealMember = false;
        List<String> currentDimNums = this.getCurrentDimNums();
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        for (int i = 0; i < dimSize && i < currentDimNums.size(); ++i) {
            Long memberId;
            Long viewId;
            String dimNum;
            Member member;
            if (!rowObj.getBoolean("ismember" + i) || (member = modelCacheHelper.getMember(dimNum = currentDimNums.get(i), viewId = Long.valueOf(rowObj.getLong("viewid" + i)), memberId = Long.valueOf(rowObj.getLong("memberid" + i)))) == null) continue;
            hasRealMember = true;
            break;
        }
        return hasRealMember;
    }

    private void showBackUsers(String userType, Object backData) {
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)backData;
        ArrayList selectIds = new ArrayList(selectedRows.size());
        ArrayList userNumbers = new ArrayList(selectedRows.size());
        selectedRows.forEach(row -> {
            selectIds.add(row.getPrimaryKeyValue());
            userNumbers.add(row.getNumber());
        });
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection userRows = dataModel.getEntryEntity(userentry);
        int counts = userRows.size();
        if (counts == 1 && ((DynamicObject)userRows.get(0)).getString("etype") == null) {
            dataModel.deleteEntryData(userentry);
            counts = 0;
        }
        dataModel.batchCreateNewEntryRow(userentry, selectIds.size());
        for (int i = counts; i < counts + selectIds.size(); ++i) {
            this.getModel().setValue("etype", (Object)userType, i);
            this.getModel().setValue("eusers", selectIds.get(i - counts), i);
            this.getModel().setValue("eusersnum", userNumbers.get(i - counts), i);
        }
        if (counts <= 0 && selectIds.size() > 0) {
            EntryGrid userEntry = (EntryGrid)this.getControl(userentry);
            userEntry.selectRows(0, true);
            this.dealConditionChange(PermConditionType.USERCHAHNGE);
        }
    }

    private void afterCopyPerm(Object backData) {
        if (this.notEmpty(backData)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6743\u9650\u590d\u5236\u6210\u529f", (String)"EbDataPermPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public String getFormType() {
        return "manager";
    }

    protected boolean isManageForm() {
        return true;
    }

    public PermSaveArgs handleSaveData(String callBackKey) {
        PermSaveArgs permSaveArgs = new PermSaveArgs();
        permSaveArgs.setCallBackKey(callBackKey);
        this.selectBaseCondition(permSaveArgs);
        this.checkBeforeSave(permSaveArgs);
        if (!permSaveArgs.isCancel()) {
            this.savePerm(permSaveArgs);
            this.afterSave(permSaveArgs);
        }
        return permSaveArgs;
    }

    protected void checkBeforeSave(PermSaveArgs args) {
        List<IMembPermSaveCheck> checktorList = this.getChecktorList();
        for (IMembPermSaveCheck checktor : checktorList) {
            if (checktor.check(args, this.getView(), this.getModel())) continue;
            args.setCancel(true);
            if (args.getCheckErrorMsg().size() == 1) {
                this.getView().showTipNotification((String)args.getCheckErrorMsg().get(0));
            } else if (args.getCheckErrorMsg().size() > 1) {
                CommonServiceHelper.showErrorInfoForm((IFormView)this.getView(), (List)args.getCheckErrorMsg(), null);
            } else if (args.getConfirmMsg().size() > 0) {
                ShowConfirmInfo showConfirmInfo = (ShowConfirmInfo)args.getConfirmMsg().get(0);
                this.getView().showConfirm(showConfirmInfo.getMessage(), MessageBoxOptions.YesNo, new ConfirmCallBackListener(showConfirmInfo.getCallBackKey(), (IFormPlugin)this));
            }
            if (args.getCallBackActionKey() != null) {
                this.dealCallBackAfterCheck(args.getCallBackActionKey());
            }
            return;
        }
    }

    protected void dealCallBackAfterCheck(String actionKey) {
    }

    protected void selectBaseCondition(PermSaveArgs args) {
        Long bizCtrlRangeId = this.getLastBCRId();
        Long modelId = this.getLastModelId();
        Long targetPersonId = this.getLastUserId();
        args.setModelId(modelId);
        args.setDimNums(this.getLastDimNums());
        args.setDimValStr(this.getLastDimNum());
        args.setTargetUserId(targetPersonId);
        args.setBizCtrlRangeId(bizCtrlRangeId);
        args.setCurrentUserId(UserUtils.getUserId());
        args.setManagerForm(this.isManageForm());
    }

    protected List<IMembPermSaveCheck> getChecktorList() {
        ArrayList<IMembPermSaveCheck> checkList = new ArrayList<IMembPermSaveCheck>();
        checkList.add((IMembPermSaveCheck)new BaseConditionCheck());
        checkList.add((IMembPermSaveCheck)new NoManagerCheck());
        checkList.add((IMembPermSaveCheck)new DataChangedCheck(this.hasRecordChanged()));
        checkList.add((IMembPermSaveCheck)new ModifiedCheck(this.getOrCachePermInitTime(null)));
        checkList.add((IMembPermSaveCheck)new MustInputCheck(this.getPermTypeList()));
        checkList.add((IMembPermSaveCheck)new RowContainsCheck());
        return checkList;
    }

    private Date getOrCachePermInitTime(Date initTime) {
        if (initTime == null) {
            String cacheStr = this.getPageCache().get("permInitTime");
            initTime = this.isEmptyStr(cacheStr) ? TimeServiceHelper.now() : new Date(Long.parseLong(cacheStr));
        } else {
            this.getPageCache().put("permInitTime", String.valueOf(initTime.getTime()));
        }
        return initTime;
    }

    private void savePerm(PermSaveArgs args) {
        UserInfoOnPage currentUserInfo = this.getLastUserInfo();
        if (currentUserInfo == null) {
            return;
        }
        DimMembPermRecord toSavePermRecord = args.getToSavePermRecrod();
        this.fillOldRecord(args, toSavePermRecord, currentUserInfo);
        Set refMainRecordIds = args.getRefMainRecordIds();
        MembPermRecordUtil.savePermRecord((Set)refMainRecordIds, (Long)currentUserInfo.getId(), (boolean)currentUserInfo.isUserGroup(), (DimMembPermRecord)toSavePermRecord);
    }

    protected void fillOldRecord(PermSaveArgs args, DimMembPermRecord toSavePermRecrod, UserInfoOnPage currentUserInfo) {
    }

    protected void afterSave(PermSaveArgs args) {
        if (args.getCheckErrorMsg().isEmpty()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"EbDataPermPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.addSaveOpLog(args);
        }
        this.markRecordChanged(false);
        this.getOrCachePermInitTime(TimeServiceHelper.now());
        this.getOrCacheDelRows(new HashSet<String>(16));
    }

    protected void addSaveOpLog(PermSaveArgs args) {
        try {
            String dimType;
            UserInfo userInfo = UserUtils.getUserOrGroupInfo((Long)args.getTargetUserId());
            if (userInfo == null) {
                userInfo = new UserInfo(args.getTargetUserId(), args.getTargetUserId().toString(), args.getTargetUserId().toString(), false);
            }
            String userName = userInfo.getNumber();
            String userType = !userInfo.isUserGroup() ? ResManager.loadKDString((String)"\u7528\u6237", (String)"DimMembPermBasePlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7528\u6237\u7ec4", (String)"DimMembPermBasePlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            Model model = ModelCacheContext.getOrCreate((Long)args.getModelId()).getModelobj();
            String modelNum = model.getNumber();
            boolean isManager = this.isManageForm();
            String permType = !isManager ? ResManager.loadKDString((String)"\u6210\u5458\u6570\u636e\u6743\u9650", (String)"DimMembPermBasePlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ba1\u7406\u6743\u9650", (String)"DimMembPermBasePlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            String dimName = this.getDimInfoMap().get(args.getDimValStr());
            String string = dimType = args.getDimNums().size() > 1 ? ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ec4\u5408", (String)"DimMembPermBasePlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7ef4\u5ea6", (String)"DimMembPermBasePlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            if (isManager || model.isModelByEB() || model.isModelByNewEB()) {
                this.writeLog(null, "save", new MultiLangEnumBridge("\u4fdd\u5b58", "DimMembPermBasePlugin_31", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5bf9%1$s\u201c%2$s\u201d\u8fdb\u884c\u4f53\u7cfb\u201c%3$s\u201d\u3001%4$s\u201c%5$s\u201d\u7684%6$s\u7f16\u8f91\u64cd\u4f5c", "DimMembPermBasePlugin_38", "epm-eb-formplugin"), new String[]{userType, userName, modelNum, dimType, dimName, permType});
            } else {
                String bizModelNumber = (String)CommonServiceHelper.getValueFromDB((String)"eb_businessmodel", (String)"number", (String)"id", (Object[])new Object[]{args.getBizCtrlRangeId()});
                this.writeLog(null, "save", new MultiLangEnumBridge("\u4fdd\u5b58", "DimMembPermBasePlugin_31", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5bf9%1$s\u201c%2$s\u201d\u8fdb\u884c\u4f53\u7cfb\u201c%3$s\u201d\u3001\u4e1a\u52a1\u6a21\u578b\u201c%4$s\u201d\u3001%5$s\u201c%6$s\u201d\u7684%7$s\u7f16\u8f91\u64cd\u4f5c", "DimMembPermBasePlugin_32", "epm-eb-formplugin"), new String[]{userType, userName, modelNum, bizModelNumber, dimType, dimName, permType});
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        boolean yes;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackKey = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        boolean bl = yes = messageBoxClosedEvent.getResult() == MessageBoxResult.Yes;
        if (callBackKey.startsWith("saveForConditionChanged_")) {
            this.dealConditionChangeCallBack(callBackKey, result);
        } else if ("DelPermRecord".equals(callBackKey) && yes) {
            this.delPermRecordRow();
        } else if (callBackKey.startsWith("overwriteToSave_")) {
            this.handleOverWriteToSave(yes, callBackKey);
        } else if ("close".equals(callBackKey) && yes) {
            this.getView().close();
        } else if ("showImportForm".equals(callBackKey)) {
            if (yes) {
                this.handleSaveData(null);
            } else {
                this.handleConditionChanged(PermConditionType.REFLESH);
            }
        }
    }

    private void handleOverWriteToSave(boolean isContinue, String callBackKey) {
        PermConditionType conditionType;
        callBackKey = callBackKey.replace("overwriteToSave_", "");
        if (isContinue) {
            Date permInitTime = this.getOrCachePermInitTime(null);
            this.getOrCachePermInitTime(TimeServiceHelper.now());
            PermSaveArgs saveArgs = this.handleSaveData(null);
            if (saveArgs.isCancel()) {
                this.getOrCachePermInitTime(permInitTime);
                return;
            }
        }
        if ((conditionType = PermConditionType.getConditionType((String)callBackKey)) != null) {
            this.handleConditionChanged(conditionType);
        }
    }

    private void dealConditionChangeCallBack(String callBackKey, MessageBoxResult result) {
        String conditionKey = callBackKey.replace("saveForConditionChanged_", "");
        PermConditionType conditionType = PermConditionType.getConditionType((String)conditionKey);
        if (conditionType != null) {
            PermSaveArgs permSaveArgs = null;
            if (result == MessageBoxResult.Yes) {
                try {
                    permSaveArgs = this.handleSaveData(conditionKey);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    permSaveArgs = new PermSaveArgs();
                    permSaveArgs.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u4fdd\u5b58\u5931\u8d25\uff0c%1\u3002", (String)"DimMembPermBasePlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[]{e.getMessage()}));
                }
            }
            if (permSaveArgs == null || !permSaveArgs.isCancel()) {
                this.handleConditionChanged(conditionType);
            } else {
                this.rollbackCondition(conditionType);
            }
        }
    }

    protected void rollbackCondition(PermConditionType conditionType) {
        this.setNoNeedResponseChange(true);
        switch (conditionType) {
            case MODEL: {
                Long lastModelId = this.getLastModelId();
                this.getModel().setValue(modelKey, (Object)lastModelId);
                break;
            }
            case USERCHAHNGE: {
                UserInfoOnPage lastUserInfo = this.getLastUserInfo();
                if (lastUserInfo == null) break;
                EntryGrid entryGrid = (EntryGrid)this.getControl(userentry);
                entryGrid.selectRows(lastUserInfo.getRowIndex());
                break;
            }
            case UESRDEL: {
                break;
            }
            case DIMENSION: {
                this.getModel().setValue(dimListKey, (Object)this.getLastDimNum());
            }
        }
        this.setNoNeedResponseChange(false);
    }

    protected void dealConditionChange(PermConditionType conditionType) {
        boolean peamChanged = this.hasRecordChanged();
        if (peamChanged && this.canSave()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6743\u9650\u503c\u5df2\u4fee\u6539\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"DimMembPermBasePlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("saveForConditionChanged_" + conditionType, (IFormPlugin)this));
        } else {
            this.handleConditionChanged(conditionType);
        }
    }

    protected boolean canSave() {
        UserInfoOnPage lastUserInfo = this.getLastUserInfo();
        return lastUserInfo != null;
    }

    protected void handleConditionChanged(PermConditionType conditionType) {
        this.callConditionHandle(conditionType);
        this.checkAndInitMembEntry();
    }

    protected void callConditionHandle(PermConditionType conditionType) {
        switch (conditionType) {
            case MODEL: {
                this.dealModelChange();
                break;
            }
            case USERCHAHNGE: {
                this.dealUserChange();
                break;
            }
            case UESRDEL: {
                this.dealRemoveUserRow();
                break;
            }
            case DIMENSION: {
                this.dealDimensionChange();
            }
        }
    }

    private void dealRemoveUserRow() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(userentry);
        int selectRow = entryGrid.getEntryState().getFocusRow();
        this.getModel().deleteEntryRow(userentry, selectRow);
        if (selectRow > 0) {
            entryGrid.selectRows(selectRow - 1);
        }
        this.cacheCurrentUser();
    }

    protected void dealDimensionChange() {
        int i;
        String currentDimNum = this.getCurrentDimNum();
        if (currentDimNum == null) {
            currentDimNum = "";
        }
        this.getOrCacheLastDimNum(currentDimNum);
        ArrayList<String> toHideCols = new ArrayList<String>(16);
        ArrayList<String> toShowCols = new ArrayList<String>(16);
        String[] dimNums = this.isEmpty(currentDimNum) ? new String[]{} : currentDimNum.split(",");
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        EntryGrid entryGrid = (EntryGrid)this.getControl(membentryentity);
        for (i = 0; i < dimNums.length; ++i) {
            Dimension dimension = modelCacheHelper.getDimension(dimNums[i]);
            if (dimension == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"DimMembPermBasePlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[]{dimNums[i]}));
                dimNums = new String[]{};
                this.setNoNeedResponseChange(true);
                this.getModel().setValue(dimListKey, null);
                this.setNoNeedResponseChange(false);
                this.getOrCacheLastDimNum("");
                toShowCols.clear();
                break;
            }
            entryGrid.setColumnProperty("membernum" + i, "header", (Object)new LocaleString(ResManager.loadResFormat((String)"%1\u7f16\u7801", (String)"DimMembPermBasePlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getName()})));
            entryGrid.setColumnProperty("membername" + i, "header", (Object)new LocaleString(ResManager.loadResFormat((String)"%1\u540d\u79f0", (String)"DimMembPermBasePlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getName()})));
            toShowCols.add("membernum" + i);
            toShowCols.add("membername" + i);
            if (SysDimensionEnum.dimHasView((String)dimension.getNumber()) && (this.currentModelIsBGMD() || this.isNewEbForm() && SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber()))) {
                toShowCols.add("viewname" + i);
            } else {
                toHideCols.add("viewname" + i);
            }
            this.dealDimCol(entryGrid, dimension, i);
        }
        for (i = dimNums.length; i < 6; ++i) {
            toHideCols.add("membernum" + i);
            toHideCols.add("membername" + i);
            toHideCols.add("viewname" + i);
        }
        if (toHideCols.size() > 0) {
            this.getView().setVisible(Boolean.valueOf(false), toHideCols.toArray(new String[1]));
        }
        if (toShowCols.size() > 0) {
            this.getView().setVisible(Boolean.valueOf(true), toShowCols.toArray(new String[1]));
        }
    }

    protected void dealDimCol(EntryGrid entryGrid, Dimension dimension, int dimSeq) {
    }

    @Override
    public boolean isCheckModel() {
        return false;
    }

    private void showImportForm() {
        boolean peamChanged = this.hasRecordChanged();
        if (peamChanged && this.canSave()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6743\u9650\u503c\u5df2\u4fee\u6539\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"DimMembPermBasePlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("showImportForm", (IFormPlugin)this));
        } else {
            this.doShowImportForm();
        }
    }

    private void doShowImportForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_dimperm_import");
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        Long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"DimMembPermBasePlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        paramMap.put(modelKey, this.getModelId());
        String formType = this.getFormType();
        paramMap.put("formType", formType);
        Object dimensioncombo = this.getModel().getValue(dimListKey);
        if (dimensioncombo != null) {
            paramMap.put("dimensions", String.valueOf(dimensioncombo).replace(",", "#"));
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(userentry);
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity(userentry);
        ArrayList<UserInfo> userInfoList = new ArrayList<UserInfo>(entryRows.size());
        for (int selectRow : selectRows) {
            DynamicObject dynamicObject = (DynamicObject)entryRows.get(selectRow);
            DynamicObject user = dynamicObject.getDynamicObject("eusers");
            if (user == null) continue;
            String userType = dynamicObject.getString("etype");
            boolean isUserGroup = "bos_usergroup".equals(userType);
            UserInfo userInfo = new UserInfo(Long.valueOf(user.getLong("id")), user.getString("number"), user.getString("name"), isUserGroup);
            userInfoList.add(userInfo);
        }
        if (!userInfoList.isEmpty()) {
            paramMap.put("userInfoList", SerializationUtils.serializeToBase64(userInfoList));
        }
        String caption = null;
        if ("manage".equals(formType)) {
            caption = ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ba1\u7406\u6743\u9650\u5bfc\u5165", (String)"DimMembPermBasePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        } else if ("member".equals(formType)) {
            DynamicObject bizModel = (DynamicObject)this.getModel().getValue(bizCtrlRange_key);
            if (bizModel != null) {
                paramMap.put("bizModel", bizModel.getLong("id"));
            }
            caption = ResManager.loadKDString((String)"\u6210\u5458\u6570\u636e\u6743\u9650\u5bfc\u5165", (String)"DimMembPermBasePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        formShowParameter.setCaption(caption);
        formShowParameter.setCustomParams(paramMap);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dataImport"));
        this.getView().showForm(formShowParameter);
    }

    public void exportExcel() {
        Workbook sheets;
        Map brCsPermRecordNoDetail;
        EntryGrid entryGrid = (EntryGrid)this.getControl(membentryentity);
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(membentryentity);
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u5bfc\u51fa\u6570\u636e\u3002", (String)"DimMembPermBasePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        LinkedHashMap<String, Map<String, Boolean>> dataMap = new LinkedHashMap<String, Map<String, Boolean>>(entryEntity.size());
        Date permInitTime = this.getOrCachePermInitTime(null);
        PermGroupEnum permGroupEnum = PermGroupEnum.DATA;
        if ("manage".equals(this.getFormType())) {
            permGroupEnum = PermGroupEnum.MANAGER;
        }
        if ((brCsPermRecordNoDetail = MembPermRecordUtil.getBRCsPermRecordNoDetail((Long)this.getModelId(), (Long)this.getBizCtrlRangeId(), this.getDimNums(this.getCurrentDimNum()), (Long)this.getUserId(), (PermGroupEnum)permGroupEnum)).size() > 0) {
            for (DimMembPermRecord permRecord : brCsPermRecordNoDetail.values()) {
                if (!permRecord.getModifytime().after(permInitTime)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6743\u9650\u5df2\u53d1\u751f\u66f4\u6539\uff0c\u8bf7\u5237\u65b0\u9875\u9762", (String)"DimMembPermBasePlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        Object dimensioncombo = this.getModel().getValue(dimListKey);
        String dimensionStr = String.valueOf(dimensioncombo).replace(",", "#");
        if (selectRows.length > 0) {
            for (int selectRow : selectRows) {
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(selectRow);
                String memberStr = this.dimPermImportUtil.getMemberStr(dynamicObject, dimensionStr);
                Map<String, Boolean> permMap = this.dimPermImportUtil.getPermMap(dynamicObject, dimensionStr, this.getFormType());
                dataMap.put(memberStr, permMap);
            }
        } else {
            Object object = entryEntity.iterator();
            while (object.hasNext()) {
                DynamicObject dynamicObject = (DynamicObject)object.next();
                String memberStr = this.dimPermImportUtil.getMemberStr(dynamicObject, dimensionStr);
                Map<String, Boolean> permMap = this.dimPermImportUtil.getPermMap(dynamicObject, dimensionStr, this.getFormType());
                dataMap.put(memberStr, permMap);
            }
        }
        if ((sheets = this.fillPermInfo(dataMap, dimensionStr)) != null) {
            try {
                this.downloadExportFile(this.xssToInputSteam(sheets));
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Workbook fillPermInfo(Map<String, Map<String, Boolean>> dataMap, String dimensionStr) {
        String formType = this.getFormType();
        String path = "dimperm/memberdata_template.xlsx";
        if ("manage".equals(formType)) {
            path = "dimperm/dimensionmanage_template.xlsx";
        }
        if ((AdjustUtil.isBGMModel(this.getModelId()) || AdjustUtil.isBGModel(this.getModelId())) && "manage".equals(formType)) {
            path = "dimperm/dimensionmanage_template_view.xlsx";
        }
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(path);){
            if (inputStream == null) return null;
            XSSFWorkbook sheets = new XSSFWorkbook(inputStream);
            this.dimPermImportUtil.transSheetName((Workbook)sheets, formType, dimensionStr, this.getModelId());
            CellStyle textCellStyle = POIUtils.get().getTextCellStyle((Workbook)sheets);
            Workbook workbook = this.doFillPermInfo((Workbook)sheets, dataMap, dimensionStr, textCellStyle);
            return workbook;
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private Workbook doFillPermInfo(Workbook sheets, Map<String, Map<String, Boolean>> dataMap, String dimensionStr, CellStyle textCellStyle) {
        List<String> dimensionNames;
        List<String> dimensionNumbers;
        Sheet sheetAt = sheets.getSheetAt(0);
        Row modelRow = this.fileImportUtils.getRow(sheetAt, 0);
        ExcelHelper.setCellValue((Cell)this.fileImportUtils.getCell(modelRow, 1), (CellStyle)textCellStyle, (String)((String)this.getValue(modelKey, "shownumber")));
        ExcelHelper.setCellValue((Cell)this.fileImportUtils.getCell(modelRow, 2), (CellStyle)textCellStyle, (String)((OrmLocaleValue)this.getValue(modelKey, "name")).getLocaleValue());
        String formType = this.getFormType();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        MemberPropCache propCache = MemberPropCacheService.getOrCreate((Long)this.getModelId());
        StringBuilder groupDimensionName = new StringBuilder();
        if (dimensionStr.contains("#")) {
            String[] split = dimensionStr.split("#");
            dimensionNumbers = new ArrayList<String>(split.length);
            dimensionNames = new ArrayList<String>(split.length);
            List permControlDimGroup = DimMembPermUtil.getPermControlDimGroup((Long)this.getModelId());
            permControlDimGroup.forEach(permDimGroup -> {
                String numStr = permDimGroup.getDimGroup().stream().map(BasedataPojo::getNumber).collect(Collectors.joining("#"));
                if (numStr.equals(dimensionStr)) {
                    groupDimensionName.append(permDimGroup.getName());
                }
            });
            for (String s : split) {
                dimensionNumbers.add(modelCacheHelper.getDimension(s).getNumber());
                dimensionNames.add(modelCacheHelper.getDimension(s).getName());
            }
        } else {
            dimensionNumbers = Collections.singletonList(modelCacheHelper.getDimension(dimensionStr).getNumber());
            dimensionNames = Collections.singletonList(modelCacheHelper.getDimension(dimensionStr).getName());
        }
        if ("member".equals(formType)) {
            Row bizModelRow = this.fileImportUtils.getRow(sheetAt, 1);
            Row dimensionRow = this.fileImportUtils.getRow(sheetAt, 2);
            if (this.currentModelIsBGMD()) {
                ExcelHelper.setCellValue((Cell)this.fileImportUtils.getCell(bizModelRow, 1), (CellStyle)textCellStyle, (String)((String)this.getValue(bizCtrlRange_key, "number")));
                ExcelHelper.setCellValue((Cell)this.fileImportUtils.getCell(bizModelRow, 2), (CellStyle)textCellStyle, (String)((OrmLocaleValue)this.getValue(bizCtrlRange_key, "name")).getLocaleValue());
            } else {
                bizModelRow.setZeroHeight(true);
            }
            ExcelHelper.setCellValue((Cell)this.fileImportUtils.getCell(dimensionRow, 1), (CellStyle)textCellStyle, (String)String.join((CharSequence)"#", dimensionNumbers));
            ExcelHelper.setCellValue((Cell)this.fileImportUtils.getCell(dimensionRow, 2), (CellStyle)textCellStyle, (String)(StringUtils.isEmpty((CharSequence)groupDimensionName) ? String.join((CharSequence)"+", dimensionNames) : groupDimensionName.toString()));
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(userentry);
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity(userentry);
        int index = 5;
        if (selectRows.length > 0) {
            for (int selectRow : selectRows) {
                DynamicObject entryRow = (DynamicObject)entryRows.get(selectRow);
                for (Map.Entry<String, Map<String, Boolean>> mapEntry : dataMap.entrySet()) {
                    Row row = this.fileImportUtils.getRow(sheetAt, index);
                    this.fileImportUtils.getCell(row, 0).setCellValue("");
                    String userType = entryRow.getString("etype");
                    boolean isUserGroup = "bos_usergroup".equals(userType);
                    String type = isUserGroup ? ResManager.loadKDString((String)"\u7528\u6237\u7ec4", (String)"DimMembPermBasePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7528\u6237", (String)"DimMembPermBasePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    this.fileImportUtils.getCell(row, 0).setCellValue(type);
                    ExcelHelper.setCellValue((Cell)this.fileImportUtils.getCell(row, 1), (CellStyle)textCellStyle, (String)entryRow.getString("eusers.number"));
                    ExcelHelper.setCellValue((Cell)this.fileImportUtils.getCell(row, 2), (CellStyle)textCellStyle, (String)entryRow.getString("eusers.name"));
                    String key = mapEntry.getKey();
                    Map<String, Boolean> value = mapEntry.getValue();
                    String[] membOrPropIds = key.split("_");
                    for (int i = 0; i < dimensionNumbers.size(); ++i) {
                        ExcelHelper.setCellValue((Cell)this.fileImportUtils.getCell(row, 3 + 4 * i), (CellStyle)textCellStyle, (String)dimensionNumbers.get(i));
                        ExcelHelper.setCellValue((Cell)this.fileImportUtils.getCell(row, 4 + 4 * i), (CellStyle)textCellStyle, (String)dimensionNames.get(i));
                        String membOrPropId = membOrPropIds[i];
                        String[] split = membOrPropId.split("!");
                        String viewNumber = "";
                        String viewName = "";
                        if (RangeF7PropertyCataEnum.Member.getIndex().equals(split[1])) {
                            Long viewId = IDUtils.toLong((Object)split[2]);
                            Member member = modelCacheHelper.getMember(dimensionNumbers.get(i), viewId, IDUtils.toLong((Object)split[0]));
                            if (member == null) continue;
                            ExcelHelper.setCellValue((Cell)this.fileImportUtils.getCell(row, 5 + 4 * i), (CellStyle)textCellStyle, (String)member.getNumber());
                            ExcelHelper.setCellValue((Cell)this.fileImportUtils.getCell(row, 6 + 4 * i), (CellStyle)textCellStyle, (String)member.getName());
                            Dimension dimension = modelCacheHelper.getDimension(dimensionNumbers.get(i));
                            View view = dimension.getView(viewId);
                            if (view != null) {
                                viewNumber = view.getNumber();
                                viewName = view.getName();
                            }
                        } else {
                            CustomPropertyValue propertyValue = propCache.getPropertyValue(IDUtils.toLong((Object)split[0]));
                            if (propertyValue == null) continue;
                            ExcelHelper.setCellValue((Cell)this.fileImportUtils.getCell(row, 5 + 4 * i), (CellStyle)textCellStyle, (String)(propertyValue.getProp().getNumber() + "!" + propertyValue.getNumber()));
                            ExcelHelper.setCellValue((Cell)this.fileImportUtils.getCell(row, 6 + 4 * i), (CellStyle)textCellStyle, (String)propertyValue.getName());
                        }
                        if (AdjustUtil.isBGMModel(this.getModelId()) || AdjustUtil.isBGModel(this.getModelId())) {
                            ExcelHelper.setCellValue((Cell)this.fileImportUtils.getCell(row, 7 + 4 * i), (CellStyle)textCellStyle, (String)viewNumber);
                            ExcelHelper.setCellValue((Cell)this.fileImportUtils.getCell(row, 8 + 4 * i), (CellStyle)textCellStyle, (String)viewName);
                            sheetAt.setColumnWidth(7 + 4 * i, 3500);
                            sheetAt.setColumnWidth(8 + 4 * i, 3500);
                        }
                        sheetAt.setColumnWidth(3 + 4 * i, 3500);
                        sheetAt.setColumnWidth(4 + 4 * i, 3500);
                        sheetAt.setColumnWidth(5 + 4 * i, 6500);
                        sheetAt.setColumnWidth(6 + 4 * i, 6500);
                    }
                    if ("manage".equals(formType)) {
                        if (AdjustUtil.isBGMModel(this.getModelId()) || AdjustUtil.isBGModel(this.getModelId())) {
                            this.fileImportUtils.getCell(row, 9).setCellValue(this.dimPermImportUtil.translateToString(value.get("manage")));
                        } else {
                            this.fileImportUtils.getCell(row, 7).setCellValue(this.dimPermImportUtil.translateToString(value.get("manage")));
                        }
                    } else if ("member".equals(formType)) {
                        this.fileImportUtils.getCell(row, 3 + 4 * dimensionNumbers.size()).setCellValue(this.dimPermImportUtil.translateToString(value.get("extends")));
                        this.fileImportUtils.getCell(row, 4 + 4 * dimensionNumbers.size()).setCellValue(this.dimPermImportUtil.translateToString(value.get("read")));
                        this.fileImportUtils.getCell(row, 5 + 4 * dimensionNumbers.size()).setCellValue(this.dimPermImportUtil.translateToString(value.get("write")));
                        this.fileImportUtils.getCell(row, 6 + 4 * dimensionNumbers.size()).setCellValue(this.dimPermImportUtil.translateToString(value.get("give")));
                        sheetAt.setColumnWidth(3 + 4 * dimensionNumbers.size(), 2500);
                        sheetAt.setColumnWidth(4 + 4 * dimensionNumbers.size(), 2500);
                        sheetAt.setColumnWidth(5 + 4 * dimensionNumbers.size(), 2500);
                        sheetAt.setColumnWidth(6 + 4 * dimensionNumbers.size(), 2500);
                    }
                    ++index;
                }
            }
        }
        return sheets;
    }

    private InputStream xssToInputSteam(Workbook sheets) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        sheets.write((OutputStream)bos);
        byte[] bytes = bos.toByteArray();
        return new ByteArrayInputStream(bytes);
    }

    private void downloadExportFile(InputStream inputStream) {
        String formType = this.getFormType();
        String fileName = "";
        String baseName = "";
        if ("manage".equals(formType)) {
            fileName = ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ba1\u7406\u6743\u9650\u5bfc\u51fa\u4fe1\u606f.xlsx", (String)"DimMembPermBasePlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            baseName = "eb_dimmanagerperm";
        } else if ("member".equals(formType)) {
            fileName = ResManager.loadKDString((String)"\u6210\u5458\u6570\u636e\u6743\u9650\u5bfc\u51fa\u4fe1\u606f.xlsx", (String)"DimMembPermBasePlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            baseName = "eb_dimmembdataperm";
        }
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, inputStream, 10000);
        ImportAndExportUtil.addTempFileCheck((String)url, (String)baseName, (String)"bgbd", (int)10000);
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
    }

    public void fillBackBatMember(MultiDimMembResult result) {
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)this.getModelId());
        List dimViewInfos = result.getDimViewInfos();
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity(membentryentity);
        Count rowCount = new Count(entryRows.size());
        if (rowCount.getCount() >= 10000) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6700\u5927\u7ef4\u5ea6\u7ec4\u5408\u6570\u4e3a%1\uff0c\u5df2\u8df3\u8fc7\u591a\u4f59\u7684\u7ef4\u5ea6\u7ec4\u5408\u3002", (String)"DimMembPermBasePlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[]{10000}));
            return;
        }
        int dimSize = dimViewInfos.size();
        Set<String> rowMemberIdsStr = this.selCurrentRowsInfo(entryRows, dimSize);
        boolean hasRep = false;
        int index = entryRows.size();
        int oldSize = rowCount.getCount();
        StringBuilder sb = new StringBuilder();
        block0: for (List memberGroup : result.getMemberRows()) {
            sb.setLength(0);
            for (MultiDimMemberVal memberVal : memberGroup) {
                sb.append(memberVal.getMemberId()).append(',');
            }
            this.selRowOtherInfo(sb, memberGroup, dimViewInfos);
            if (!rowMemberIdsStr.contains(sb.toString())) {
                DynamicObject newRow = entryRows.addNew();
                boolean hasRealMember = false;
                for (int i = 0; i < dimSize; ++i) {
                    MultiDimMemberVal memberVal = (MultiDimMemberVal)memberGroup.get(i);
                    DimViewInfo dimViewInfo = (DimViewInfo)dimViewInfos.get(i);
                    if (this.fillMember2Row(newRow, memberPropCache, modelCacheHelper, memberVal.getMemberId(), dimViewInfo.getDimNumber(), dimViewInfo.getViewId(), memberVal.isMember(), i)) {
                        entryRows.remove(index);
                        continue block0;
                    }
                    hasRealMember = hasRealMember || memberVal.isMember();
                }
                this.onFillBackMemberRow(newRow, hasRealMember, false);
                rowCount.addOne();
                ++index;
                if (rowCount.getCount() < 10000) continue;
                break;
            }
            hasRep = true;
        }
        if (hasRep) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ec4\u5408\u5b58\u5728\u91cd\u590d\u9009\u62e9\u8bb0\u5f55\uff0c\u5df2\u8df3\u8fc7\u3002", (String)"MultiDimMemberF7Plugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (rowCount.getCount() >= 10000) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6700\u5927\u7ef4\u5ea6\u7ec4\u5408\u6570\u4e3a%1\uff0c\u5df2\u8df3\u8fc7\u591a\u4f59\u7684\u7ef4\u5ea6\u7ec4\u5408\u3002", (String)"DimMembPermBasePlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[]{10000}));
        }
        if (rowCount.getCount() > oldSize) {
            this.getModel().updateEntryCache(entryRows);
            this.getView().updateView(membentryentity);
            this.markRecordChanged(true);
        }
    }

    protected Set<String> selCurrentRowsInfo(DynamicObjectCollection entryRows, int dimSize) {
        HashSet<String> rowMemberIdsStr = new HashSet<String>(entryRows.size());
        ArrayList<String> membIdColKeys = new ArrayList<String>(dimSize);
        for (int i = 0; i < dimSize; ++i) {
            membIdColKeys.add("memberid" + i);
        }
        StringBuilder sb = new StringBuilder();
        entryRows.forEach(row -> {
            for (String dimColKey : membIdColKeys) {
                sb.append(row.getLong(dimColKey)).append(',');
            }
            this.selRowOtherInfo(sb, row, null);
            rowMemberIdsStr.add(sb.toString());
            sb.setLength(0);
        });
        return rowMemberIdsStr;
    }

    protected void selRowOtherInfo(StringBuilder rowStr, Object rowObj, List<DimViewInfo> dimViewInfos) {
    }

    protected boolean fillMember2Row(DynamicObject newRow, MemberPropCache memberPropCache, IModelCacheHelper modelCacheHelper, Long memberId, String dimNumber, Long viewId, boolean isMember, int seq) {
        boolean errorMember = false;
        if (isMember) {
            Member member1 = modelCacheHelper.getMember(dimNumber, viewId, memberId);
            if (member1 == null) {
                errorMember = true;
            } else {
                newRow.set("ismember" + seq, (Object)true);
                newRow.set("membernum" + seq, (Object)member1.getShowNumber());
                newRow.set("membername" + seq, (Object)member1.getName());
                newRow.set("memberid" + seq, (Object)member1.getId());
                newRow.set("viewid" + seq, (Object)viewId);
                newRow.set("viewname" + seq, (Object)this.getViewNameById(viewId));
            }
        } else {
            CustomPropertyValue propertyValue = memberPropCache.getPropertyValue(dimNumber, memberId);
            if (propertyValue == null) {
                errorMember = true;
            } else {
                newRow.set("ismember" + seq, (Object)false);
                newRow.set("membernum" + seq, (Object)propertyValue.getNumber());
                newRow.set("membername" + seq, (Object)propertyValue.getName());
                newRow.set("memberid" + seq, (Object)propertyValue.getId());
            }
        }
        return errorMember;
    }

    protected void onFillBackMemberRow(DynamicObject newRow, boolean hasRealMember, boolean isInit) {
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long lastUserId = this.getLastUserId();
        if (this.notEmpty(lastUserId)) {
            EntryGrid userEntry = (EntryGrid)this.getControl(userentry);
            userEntry.selectRows(0, true);
        }
    }

    private String getViewNameById(Long viewId) {
        return this.dimViewMap.computeIfAbsent(viewId, key -> {
            String name;
            try {
                DynamicObject viewObj = BusinessDataServiceHelper.loadSingleFromCache((Object)key, (String)"eb_dimensionview");
                name = viewObj != null ? viewObj.getString("name") : "";
            }
            catch (NullPointerException exception) {
                name = "";
            }
            return name;
        });
    }
}

