/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.perm;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.impl.ViewMember;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.membpermlog.MembPermOpType;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.MembPermRecordUtil;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.enums.PermGroupEnum;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.permission.pojo.DimMembPermDetailRecord;
import kd.epm.eb.common.permission.pojo.DimMembPermRecord;
import kd.epm.eb.common.permission.pojo.PermDimGroup;
import kd.epm.eb.common.permission.pojo.UserInfo;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import kd.epm.eb.common.utils.fileImport.FileImportUtils;
import kd.epm.eb.formplugin.bgadjust.utils.AdjustUtil;
import kd.epm.eb.formplugin.perm.DimPermImportUtil;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DimMembPermImportPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final Log LOG = LogFactory.getLog(DimMembPermImportPlugin.class);
    private final FileImportUtils fileImportUtils = FileImportUtils.getInstance();
    private final DimPermImportUtil dimPermImportUtil = DimPermImportUtil.getInstance();
    private static final String MEMBER = "member";
    private static final String MANAGE = "manage";
    private static final String OTHER = "other";
    private Map<Integer, Set<String>> errorMap = new LinkedHashMap<Integer, Set<String>>(16, 0.75f, false);
    private Set<String> errorKeySet = new HashSet<String>(16);
    private IModelCacheHelper modelCacheHelper;
    private MemberPropCache propCache;
    private boolean isDimensionGroup = false;
    private String dimPermGroupNumber = "";
    private int dimPermGroupSize = 0;
    private static final String SPLIT = "#";
    private static final String DOUBLE_AND = "&&";
    private static final String DOUBLE_SPLIT = "##";
    private Map<String, Member> accountMemberMap = new HashMap<String, Member>(16);
    private Map<Long, Member> accountIdMemberMap = new HashMap<Long, Member>(16);
    private Map<String, Map<String, Long>> dimViewNumberIdMap = new HashMap<String, Map<String, Long>>(16);
    private Map<String, Map<String, String>> dimViewGroupNumMap = new HashMap<String, Map<String, String>>(16);
    private boolean isEbModel = false;
    private boolean errorFlag = false;
    private boolean insertFlag = false;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btndownload", "btndwntemp"});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null) {
            Object bizModel;
            String formType;
            Object model = customParams.get("model");
            if (model != null) {
                this.getPageCache().put("model", String.valueOf(model));
            }
            if (StringUtils.isNotEmpty((CharSequence)(formType = (String)customParams.get("formType")))) {
                this.getPageCache().put("formType", formType);
            }
            if ((bizModel = customParams.get("bizModel")) != null) {
                this.getPageCache().put("bizModel", String.valueOf(bizModel));
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Button)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
            try {
                String file_url = this.getPageCache().get("file_url");
                if (file_url == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5bfc\u5165\u6570\u636e\u3002", (String)"DimMembPermImportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                List urls = (List)SerializationUtils.fromJsonString((String)file_url, List.class);
                if (urls.isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5bfc\u5165\u6570\u636e\u3002", (String)"DimMembPermImportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                for (String url : urls) {
                    String[] reqParams = new URL(url).getQuery().split("&");
                    HashMap<String, String> map = new HashMap<String, String>(reqParams.length);
                    for (String param : reqParams) {
                        String[] p = param.split("=");
                        map.put(p[0], p[1]);
                    }
                    TempFileCacheDownloadable.Content content = fileCache.get((String)map.get("configKey"), (String)map.get("id"));
                    InputStream inputStream = content.getInputStream();
                    XSSFWorkbook sheets = new XSSFWorkbook(inputStream);
                    this.handleInputStream(sheets);
                    if (!this.errorFlag) {
                        if (this.insertFlag) {
                            this.getView().returnDataToParent((Object)ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"DimMembPermImportPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        } else {
                            this.getView().returnDataToParent((Object)ResManager.loadKDString((String)"\u6682\u65e0\u9700\u8981\u5bfc\u5165\u7684\u6570\u636e\u3002", (String)"DimMembPermImportPlugin_45", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        }
                        this.getView().close();
                    } else {
                        if (this.insertFlag) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u63d2\u5165\u6210\u529f\u3002\u5df2\u4e0b\u8f7d\u5bf9\u5e94\u9519\u8bef\u6587\u4ef6\u3002", (String)"DimMembPermImportPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            this.getPageCache().put("insertFlag", "true");
                        } else {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u3002\u5df2\u4e0b\u8f7d\u5bf9\u5e94\u9519\u8bef\u6587\u4ef6\u3002", (String)"DimMembPermImportPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            this.getPageCache().put("insertFlag", "false");
                        }
                        XSSFWorkbook errorSheets = this.fillErrorMsg(sheets);
                        this.downloadErrorFile(this.xssToInputSteam((Workbook)errorSheets));
                    }
                    this.addOpLog();
                }
            }
            catch (Exception e) {
                if (e instanceof KDBizException) {
                    throw new KDBizException(e.getMessage());
                }
                LOG.error("DimMembPermImportError" + ExceptionUtils.getStackTrace((Throwable)e), (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u6743\u9650\u5bfc\u5165\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DimMembPermImportPlugin_68", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        if ("btndwntemp".equals(key)) {
            String path = "dimperm/dimensionmanage_template_view.xlsx";
            Map paramMap = this.getView().getFormShowParameter().getCustomParams();
            String formType = (String)paramMap.get("formType");
            if (MEMBER.equals(formType)) {
                path = "dimperm/memberdata_template.xlsx";
            } else if (AdjustUtil.isEBModel(this.getModelId())) {
                path = "dimperm/dimensionmanage_template.xlsx";
            }
            InputStream inputStream = null;
            InputStream xssToInputSteam = null;
            String fileName = null;
            try {
                inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(path);
                if (inputStream != null) {
                    XSSFWorkbook sheets = new XSSFWorkbook(inputStream);
                    String dimensionStr = (String)paramMap.get("dimensions");
                    if (MANAGE.equals(formType)) {
                        fileName = ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ba1\u7406\u6743\u9650\u5bfc\u5165\u6a21\u677f.xlsx", (String)"DimMembPermImportPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                        this.fillManageData(sheets.getSheetAt(0), paramMap);
                    } else if (MEMBER.equals(formType)) {
                        if (StringUtils.isNotEmpty((CharSequence)dimensionStr) && dimensionStr.contains(SPLIT)) {
                            this.dimPermImportUtil.buildDimensionColumn(dimensionStr, sheets.getSheetAt(0));
                        }
                        fileName = ResManager.loadKDString((String)"\u6210\u5458\u6570\u636e\u6743\u9650\u5bfc\u5165\u6a21\u677f.xlsx", (String)"DimMembPermImportPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                        this.fillMemberData(sheets.getSheetAt(0), paramMap);
                    }
                    this.dimPermImportUtil.transSheetName((Workbook)sheets, formType, dimensionStr, this.getModelId());
                    xssToInputSteam = this.xssToInputSteam((Workbook)sheets);
                    String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, xssToInputSteam, 10000);
                    if (StringUtils.isNotEmpty((CharSequence)url)) {
                        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
                    }
                }
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (xssToInputSteam != null) {
                    try {
                        xssToInputSteam.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void addOpLog() {
        if (this.insertFlag) {
            try {
                boolean needBizModel;
                Long modelId = this.getModelId();
                Long bizModel = this.getBizModel();
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
                String modelNumber = modelCacheHelper.getModelobj().getNumber();
                String formType = this.getPageCache().get("formType");
                boolean bl = needBizModel = MEMBER.equals(formType) && !modelCacheHelper.getModelobj().isModelByEB() && !modelCacheHelper.getModelobj().isModelByNewEB();
                if (needBizModel) {
                    String bizModelNum = (String)CommonServiceHelper.getValueFromDB((String)"eb_businessmodel", (String)"number", (String)"id", (Object[])new Object[]{bizModel});
                    MultiLangEnumBridge opdesc = MEMBER.equals(formType) ? new MultiLangEnumBridge("\u5bfc\u5165\u4f53\u7cfb\u201c%1$s\u201d,\u4e1a\u52a1\u6a21\u578b%2\u7684\u6210\u5458\u6570\u636e\u6743\u9650\u8bb0\u5f55", "DimMembPermImportPlugin_91", "epm-eb-formplugin") : new MultiLangEnumBridge("\u5bfc\u5165\u4f53\u7cfb\u201c%1$s\u201d,\u4e1a\u52a1\u6a21\u578b%2\u7684\u6210\u5458\u7ba1\u7406\u6743\u9650\u8bb0\u5f55", "DimMembPermImportPlugin_93", "epm-eb-formplugin");
                    OperationLogUtil.log((String)ApplicationTypeEnum.BGBD.getAppnum(), (String)this.getModel().getDataEntityType().getName(), null, null, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5bfc\u5165", "DimMembPermImportPlugin_72", "epm-eb-formplugin"), (MultiLangEnumBridge)opdesc, (String[])new String[]{modelNumber, bizModelNum});
                } else {
                    String bizModelNum = "";
                    MultiLangEnumBridge opdesc = MEMBER.equals(formType) ? new MultiLangEnumBridge("\u5bfc\u5165\u4f53\u7cfb\u201c%1$s\u201d\u7684\u6210\u5458\u6570\u636e\u6743\u9650\u8bb0\u5f55", "DimMembPermImportPlugin_90", "epm-eb-formplugin") : new MultiLangEnumBridge("\u5bfc\u5165\u4f53\u7cfb\u201c%1$s\u201d\u7684\u6210\u5458\u7ba1\u7406\u6743\u9650\u8bb0\u5f55", "DimMembPermImportPlugin_92", "epm-eb-formplugin");
                    OperationLogUtil.log((String)ApplicationTypeEnum.BGBD.getAppnum(), (String)this.getModel().getDataEntityType().getName(), null, null, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5bfc\u5165", "DimMembPermImportPlugin_72", "epm-eb-formplugin"), (MultiLangEnumBridge)opdesc, (String[])new String[]{modelNumber, bizModelNum});
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private XSSFWorkbook fillErrorMsg(XSSFWorkbook sheets) {
        return this.doFillErrorMsgInBook(sheets);
    }

    private XSSFWorkbook doFillErrorMsgInBook(XSSFWorkbook sheets) {
        int index;
        XSSFSheet sheetAt = sheets.getSheetAt(0);
        String formType = this.getPageCache().get("formType");
        int n = index = this.isEbModel ? 8 : 10;
        if (MEMBER.equals(formType)) {
            index = this.dimPermGroupSize == 0 ? 11 : 7 + this.dimPermGroupSize * 4;
        }
        Row errorRow = sheetAt.getRow(4);
        Cell errorCell = errorRow.createCell(index);
        errorCell.setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u8be6\u60c5", (String)"DimMembPermImportPlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        sheetAt.setColumnWidth(index, 4000);
        POIUtils.setCellStyleOfRed((Cell)errorCell);
        for (Map.Entry<Integer, Set<String>> entry : this.errorMap.entrySet()) {
            Row row = sheetAt.getRow(entry.getKey().intValue());
            Cell cell = row.createCell(index);
            this.fileImportUtils.setCellStringValue(cell, StringUtils.join((Iterable)entry.getValue(), (String)";\n"));
            POIUtils.setCellStyleOfRed((Cell)cell);
        }
        return sheets;
    }

    private void fillMemberData(Sheet sheet, Map<String, Object> paramMap) {
        this.fillModelData(sheet, paramMap);
        this.fillBizModelData(sheet, paramMap);
        this.fillDimensionData(sheet, paramMap);
        this.fillUserInfoData(sheet, paramMap);
    }

    private void fillUserInfoData(Sheet sheet, Map<String, Object> paramMap) {
        String userInfoStr = (String)paramMap.get("userInfoList");
        List userInfoList = new ArrayList(10);
        String formType = (String)paramMap.get("formType");
        if (userInfoStr != null) {
            userInfoList = (List)SerializationUtils.deSerializeFromBase64((String)userInfoStr);
        }
        int index = 5;
        String dimensionStr = (String)paramMap.get("dimensions");
        ArrayList<Member> members = new ArrayList<Member>(10);
        if (dimensionStr != null) {
            String[] split;
            Long biModelId = ConvertUtils.toLong((Object)paramMap.get("bizModel"));
            if (dimensionStr.contains(SPLIT)) {
                return;
            }
            if (dimensionStr.contains(SysDimensionEnum.Account.getNumber())) {
                this.initAccountMemberMap();
            }
            for (String s : split = dimensionStr.split(",")) {
                if (MEMBER.equals(formType) && SysDimensionEnum.Account.getNumber().equals(s)) {
                    members.addAll(this.accountMemberMap.values());
                    continue;
                }
                Long viewId = this.modelCacheHelper.getViewByBusModelAndDimNumber(biModelId, s);
                members.addAll(this.modelCacheHelper.getMembers(viewId, s));
            }
        }
        for (UserInfo userInfo : userInfoList) {
            String type = userInfo.isUserGroup() ? this.dimPermImportUtil.getLocalName("userGroup") : this.dimPermImportUtil.getLocalName("user");
            String number = userInfo.getNumber();
            String name = userInfo.getName();
            for (Member member : members) {
                Row row = sheet.createRow(index);
                String dimensionNumber = member.getDimension().getNumber();
                String dimensionName = member.getDimension().getName();
                this.fileImportUtils.getCell(row, 0).setCellValue(type);
                this.fileImportUtils.getCell(row, 1).setCellValue(number);
                this.fileImportUtils.getCell(row, 2).setCellValue(name);
                this.fileImportUtils.getCell(row, 3).setCellValue(dimensionNumber);
                this.fileImportUtils.getCell(row, 4).setCellValue(dimensionName);
                this.fileImportUtils.getCell(row, 5).setCellValue(member.getNumber());
                this.fileImportUtils.getCell(row, 6).setCellValue(member.getName());
                ++index;
            }
        }
    }

    private Long getModelId() {
        String model = this.getPageCache().get("model");
        if (StringUtils.isNotEmpty((CharSequence)model)) {
            return Long.parseLong(model);
        }
        return 0L;
    }

    private Long getBizModel() {
        String bizModel = this.getPageCache().get("bizModel");
        if (StringUtils.isNotEmpty((CharSequence)bizModel)) {
            return Long.parseLong(bizModel);
        }
        return 0L;
    }

    private void fillBizModelData(Sheet sheet, Map<String, Object> paramMap) {
        String tmpIsBGMDModel;
        Row bizModelRow = sheet.getRow(1);
        Object bizModel = paramMap.get("bizModel");
        String bizModelName = null;
        String bizModelNumber = null;
        if (bizModel != null) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)bizModel, (String)"eb_businessmodel");
            if (dynamicObject != null) {
                bizModelName = dynamicObject.getString("name");
                bizModelNumber = dynamicObject.getString("number");
            }
            this.fileImportUtils.getCell(bizModelRow, 1).setCellValue(bizModelNumber);
            this.fileImportUtils.getCell(bizModelRow, 2).setCellValue(bizModelName);
        }
        if (!Boolean.parseBoolean(tmpIsBGMDModel = this.getPageCache().get("tmpIsBGMDModel"))) {
            bizModelRow.setZeroHeight(true);
        }
    }

    private void fillDimensionData(Sheet sheet, Map<String, Object> paramMap) {
        Row dimensionRow = sheet.getRow(2);
        String dimensionStr = (String)paramMap.get("dimensions");
        if (dimensionStr != null) {
            String[] split = dimensionStr.split(SPLIT);
            StringBuilder stringBuilder = new StringBuilder();
            for (String s : split) {
                Dimension dimension = this.modelCacheHelper.getDimension(s);
                if (dimension == null) continue;
                stringBuilder.append(dimension.getName()).append("+");
            }
            stringBuilder.deleteCharAt(stringBuilder.lastIndexOf("+"));
            this.fileImportUtils.getCell(dimensionRow, 1).setCellValue(dimensionStr);
            this.fileImportUtils.getCell(dimensionRow, 2).setCellValue(stringBuilder.toString());
        }
    }

    private InputStream xssToInputSteam(Workbook sheets) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        sheets.write((OutputStream)bos);
        byte[] bytes = bos.toByteArray();
        return new ByteArrayInputStream(bytes);
    }

    private void fillManageData(Sheet sheet, Map<String, Object> paramMap) {
        this.fillModelData(sheet, paramMap);
        this.fillUserInfoData(sheet, paramMap);
    }

    private void fillModelData(Sheet sheet, Map<String, Object> paramMap) {
        DynamicObject dynamicObject;
        Row row = sheet.getRow(0);
        Object model = paramMap.get("model");
        String modelNumber = null;
        String modelName = null;
        if (model != null && (dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)model, (String)"epm_model")) != null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)dynamicObject.getLong("id"));
            boolean isBGMDModel = ModelServiceHelper.isBGMDModel((Long)dynamicObject.getLong("id"));
            this.getPageCache().put("tmpIsBGMDModel", String.valueOf(isBGMDModel));
            modelName = dynamicObject.getString("name");
            modelNumber = dynamicObject.getString("shownumber");
        }
        this.fileImportUtils.getCell(row, 1).setCellValue(modelNumber);
        this.fileImportUtils.getCell(row, 2).setCellValue(modelName);
    }

    private void handleInputStream(XSSFWorkbook sheets) {
        XSSFSheet sheetAt = sheets.getSheetAt(0);
        this.validTemplate((Sheet)sheetAt);
        if (this.validBaseInfo((Sheet)sheetAt)) {
            this.getPageCache().put("baseInfoCheck", "pass");
            this.cacheCurrentUserString();
            this.cacheAllViewNumber();
            Map<String, List<Row>> stringListMap = this.resolveSheetByDimension(sheets);
            if (stringListMap.size() == 0 && this.errorMap.size() > 0) {
                this.errorFlag = true;
                return;
            }
            this.validPermByDimension(stringListMap);
            this.getPageCache().put("currentUserIsModelManage", "");
            this.errorFlag = this.errorMap.size() > 0;
        } else {
            this.errorFlag = true;
            this.getPageCache().remove("baseInfoCheck");
        }
        if (!this.errorMap.isEmpty()) {
            this.errorFlag = true;
        }
    }

    private void cacheAllViewNumber() {
        DynamicObject[] dimensionViews;
        Long modelId = this.getModelId();
        for (DynamicObject dynamicObject : dimensionViews = BusinessDataServiceHelper.load((String)"eb_dimensionview", (String)"id,number,dimension.number,viewgroup.number", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray())) {
            String dimensionNumber = dynamicObject.getString("dimension.number");
            Map numberIdMap = this.dimViewNumberIdMap.computeIfAbsent(dimensionNumber, v -> new HashMap(16));
            numberIdMap.put(dynamicObject.getString("number"), dynamicObject.getLong("id"));
            Map viewGroupMap = this.dimViewGroupNumMap.computeIfAbsent(dimensionNumber, v -> new HashMap(16));
            viewGroupMap.put(dynamicObject.getString("number"), dynamicObject.getString("viewgroup.number"));
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void validPermByDimension(Map<String, List<Row>> map) {
        String formType = this.getPageCache().get("formType");
        boolean manager = false;
        Set modelIds = ModelUtil.getModelIds((IFormView)this.getView(), (boolean)true);
        if (modelIds.contains(this.getModelId())) {
            manager = true;
        }
        this.getPageCache().put("currentUserIsModelManage", String.valueOf(manager));
        ListIterator<Map.Entry<String, List<Row>>> iterator = new ArrayList<Map.Entry<String, List<Row>>>(map.entrySet()).listIterator(map.size());
        String totalUser = this.getPageCache().get("totalUser");
        String totalGroup = this.getPageCache().get("totalGroup");
        Map userMap = new HashMap(16);
        Map groupMap = new HashMap(16);
        if (StringUtils.isNotEmpty((CharSequence)totalUser)) {
            userMap = (Map)SerializationUtils.deSerializeFromBase64((String)totalUser);
        }
        if (StringUtils.isNotEmpty((CharSequence)totalGroup)) {
            groupMap = (Map)SerializationUtils.deSerializeFromBase64((String)totalGroup);
        }
        while (iterator.hasPrevious()) {
            ArrayList<DimMembPermRecord> permList = new ArrayList<DimMembPermRecord>(10);
            Map.Entry<String, List<Row>> entry = iterator.previous();
            String dimensionNumber = entry.getKey();
            HashMap<String, LinkedHashMap<String, List>> userDimensionMap = new HashMap<String, LinkedHashMap<String, List>>(16);
            HashSet<Long> userIds = new HashSet<Long>(16);
            this.getPageCache().put("currentDimension", dimensionNumber);
            if (dimensionNumber == null) continue;
            boolean needValidView = !this.isEbModel && !View.NoViewDimNums.contains(dimensionNumber);
            List<Row> data = entry.getValue();
            String[] numSplit = dimensionNumber.split(SPLIT);
            List<String> dimNums = Arrays.asList(numSplit);
            HashMap<Long, DimMembPermRecord> permRecordMap = new HashMap(16);
            for (Row row : data) {
                Cell typeCell = this.fileImportUtils.getCell(row, 0);
                Cell numberCell = this.fileImportUtils.getCell(row, 1);
                Cell memberCell = this.fileImportUtils.getCell(row, 5);
                String type = this.fileImportUtils.getCellStringValue(typeCell);
                String number = this.fileImportUtils.getCellStringValue(numberCell);
                String memberNumber = this.fileImportUtils.getCellStringValue(memberCell);
                memberNumber = memberNumber.contains("!") ? memberNumber + "!" + RangeF7PropertyCataEnum.Property.getIndex() : memberNumber + "!" + RangeF7PropertyCataEnum.Member.getIndex();
                if (this.isDimensionGroup) {
                    String[] split = this.dimPermGroupNumber.split(SPLIT);
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String dimension : split) {
                        for (int j = 0; j < this.dimPermGroupSize; ++j) {
                            String dimensionStr = this.getCellStringByRowAndIndex(row, 3 + 4 * j);
                            if (!StringUtils.equals((CharSequence)dimension, (CharSequence)dimensionStr)) continue;
                            String memberStr = this.getCellStringByRowAndIndex(row, 5 + 4 * j);
                            if (memberStr.contains("!")) {
                                stringBuilder.append(memberStr).append("!").append(RangeF7PropertyCataEnum.Property.getIndex()).append(SPLIT);
                                continue;
                            }
                            stringBuilder.append(memberStr).append("!").append(RangeF7PropertyCataEnum.Member.getIndex()).append(SPLIT);
                        }
                    }
                    memberNumber = stringBuilder.substring(0, stringBuilder.length() - 1);
                }
                Long id = this.dimPermImportUtil.getLocalName("user").equals(type) ? (Long)userMap.get(number) : (Long)groupMap.get(number);
                userIds.add(id);
                StringBuilder sb = new StringBuilder();
                sb.append(type).append(DOUBLE_SPLIT).append(number).append(DOUBLE_AND).append(id);
                LinkedHashMap<String, List> stringSetMap = (LinkedHashMap<String, List>)userDimensionMap.get(sb.toString());
                if (stringSetMap == null) {
                    stringSetMap = new LinkedHashMap<String, List>(16);
                    ArrayList<Row> rowSet = new ArrayList<Row>(10);
                    rowSet.add(row);
                    stringSetMap.put(memberNumber, rowSet);
                } else {
                    List rows = stringSetMap.computeIfAbsent(memberNumber, v -> new ArrayList(10));
                    rows.add(row);
                    stringSetMap.put(memberNumber, rows);
                }
                userDimensionMap.put(sb.toString(), stringSetMap);
            }
            Map viewMap = null;
            if (MEMBER.equals(formType)) {
                permRecordMap = MembPermRecordUtil.getUsersPermRecord((Long)this.getModelId(), (Long)this.getBizModel(), dimNums, userIds, (PermGroupEnum)PermGroupEnum.DATA);
                viewMap = this.modelCacheHelper.getViewGroupViewsByBusModel(this.getBizModel());
            } else if (MANAGE.equals(formType)) {
                permRecordMap = MembPermRecordUtil.getUsersPermRecord((Long)this.getModelId(), (Long)this.getBizModel(), dimNums, userIds, (PermGroupEnum)PermGroupEnum.MANAGER);
            }
            for (Map.Entry mapEntry : userDimensionMap.entrySet()) {
                String key = (String)mapEntry.getKey();
                String number = "";
                if (StringUtils.isNotEmpty((CharSequence)key)) {
                    this.getPageCache().put("userId", key.split(DOUBLE_AND)[1]);
                    String[] split = key.split(DOUBLE_SPLIT);
                    number = split[1].split(DOUBLE_AND)[0];
                    this.getPageCache().put("userNumber", number);
                }
                Map value = (Map)mapEntry.getValue();
                LinkedHashMap<String, List<Row>> rowMap = new LinkedHashMap<String, List<Row>>(16);
                LinkedHashMap<String, Row> memberRowMap = new LinkedHashMap<String, Row>(16);
                for (Map.Entry stringSetEntry : value.entrySet()) {
                    String errorMsg;
                    List rows = (List)stringSetEntry.getValue();
                    String memberNumber = (String)stringSetEntry.getKey();
                    if (MEMBER.equals(formType)) {
                        if (CollectionUtils.isNotEmpty((Collection)rows) && rows.size() > 1) {
                            errorMsg = ResManager.loadResFormat((String)"\u7528\u6237\u201c%1\u201d\u7684\u7ef4\u5ea6\u201c%2\u201d\u7684\u7ef4\u5ea6\u6210\u5458\u6216\u5c5e\u6027\u5b58\u5728\u591a\u884c", (String)"DimMembPermImportPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[]{number, dimensionNumber});
                            for (Row row : rows) {
                                this.putErrorMsg(row, errorMsg);
                            }
                            continue;
                        }
                        memberRowMap.put(memberNumber, (Row)rows.get(0));
                        continue;
                    }
                    if (!MANAGE.equals(formType)) continue;
                    if (CollectionUtils.isNotEmpty((Collection)rows) && rows.size() > 1) {
                        if (needValidView) {
                            HashMap<String, Set> repeatRowMap = new HashMap<String, Set>(16);
                            for (Row row : rows) {
                                Cell cell = this.fileImportUtils.getCell(row, 7);
                                String viewNumber = this.fileImportUtils.getCellStringValue(cell);
                                Map<String, String> viewGroupMap = this.dimViewGroupNumMap.get(dimensionNumber);
                                if (viewGroupMap == null || !viewGroupMap.containsKey(viewNumber)) continue;
                                Set rowSet = repeatRowMap.computeIfAbsent(viewGroupMap.get(viewNumber), v -> new HashSet(16));
                                rowSet.add(row);
                            }
                            for (Map.Entry setEntry : repeatRowMap.entrySet()) {
                                Set rowSet = (Set)setEntry.getValue();
                                if (!CollectionUtils.isNotEmpty((Collection)rowSet)) continue;
                                if (rowSet.size() > 1) {
                                    String errorMsg2 = ResManager.loadResFormat((String)"\u7528\u6237\u201c%1\u201d\u7684\u7ef4\u5ea6\u201c%2\u201d\u7684\u7ef4\u5ea6\u6210\u5458\u6216\u5c5e\u6027\u5b58\u5728\u591a\u884c", (String)"DimMembPermImportPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[]{number, dimensionNumber});
                                    for (Row row : rowSet) {
                                        this.putErrorMsg(row, errorMsg2);
                                    }
                                    continue;
                                }
                                List rowList = rowMap.computeIfAbsent(memberNumber, v -> new ArrayList(1));
                                rowList.add(rowSet.iterator().next());
                            }
                            continue;
                        }
                        errorMsg = ResManager.loadResFormat((String)"\u7528\u6237\u201c%1\u201d\u7684\u7ef4\u5ea6\u201c%2\u201d\u7684\u7ef4\u5ea6\u6210\u5458\u6216\u5c5e\u6027\u5b58\u5728\u591a\u884c", (String)"DimMembPermImportPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[]{number, dimensionNumber});
                        for (Row row : rows) {
                            this.putErrorMsg(row, errorMsg);
                        }
                        continue;
                    }
                    List rowList = rowMap.computeIfAbsent(memberNumber, v -> new ArrayList(1));
                    rowList.add(rows.get(0));
                }
                if (MANAGE.equals(formType)) {
                    this.ValidManagePerm(rowMap, permRecordMap, permList);
                    continue;
                }
                if (!MEMBER.equals(formType)) continue;
                this.validMemberPerm(memberRowMap, permRecordMap, permList, viewMap);
            }
            MembPermRecordUtil.batchSavePermRecord(permList, dimNums, (Long)this.getBizModel(), (Long)this.getModelId(), (MembPermOpType)MembPermOpType.IMPORT);
        }
    }

    private void cacheCurrentUserString() {
        Long userId = UserUtils.getUserId();
        StringBuilder stringBuilder = new StringBuilder(this.dimPermImportUtil.getLocalName("user"));
        String number = "";
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user");
        if (dynamicObject != null) {
            number = dynamicObject.getString("number");
            stringBuilder.append(DOUBLE_AND).append(number);
        }
        this.getPageCache().put("currentUser", stringBuilder.toString());
    }

    private void validTemplate(Sheet sheetAt) {
        String formType = this.getPageCache().get("formType");
        Row modelRow = this.fileImportUtils.getRow(sheetAt, 0);
        Row bizModelRow = this.fileImportUtils.getRow(sheetAt, 1);
        Row dimensionRow = this.fileImportUtils.getRow(sheetAt, 2);
        String cellStringByRowAndIndex = this.getCellStringByRowAndIndex(dimensionRow, 1);
        int dimensionTempSize = 0;
        if (StringUtils.isNotEmpty((CharSequence)cellStringByRowAndIndex) && cellStringByRowAndIndex.contains(SPLIT)) {
            String[] split = cellStringByRowAndIndex.split(SPLIT);
            dimensionTempSize = split.length;
        }
        Row titleRow = this.fileImportUtils.getRow(sheetAt, 4);
        String model = this.getCellStringByRowAndIndex(modelRow, 0);
        if (!StringUtils.equals((CharSequence)this.dimPermImportUtil.getLocalName("model"), (CharSequence)model)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"DimMembPermImportPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (MEMBER.equals(formType)) {
            String bizModel = this.getCellStringByRowAndIndex(bizModelRow, 0);
            String dimension = this.getCellStringByRowAndIndex(dimensionRow, 0);
            if (!StringUtils.equals((CharSequence)this.dimPermImportUtil.getLocalName("bizModel"), (CharSequence)bizModel) || !StringUtils.equals((CharSequence)this.dimPermImportUtil.getLocalName("dimension"), (CharSequence)dimension)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"DimMembPermImportPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            for (int i = 0; i <= dimensionTempSize; ++i) {
                String dimensionNumber = this.getCellStringByRowAndIndex(titleRow, 3);
                String memberNumber = this.getCellStringByRowAndIndex(titleRow, 5);
                if (StringUtils.equals((CharSequence)this.dimPermImportUtil.getLocalName("dimensionNumber"), (CharSequence)dimensionNumber) && StringUtils.equals((CharSequence)this.dimPermImportUtil.getLocalName("membOrPropNumber"), (CharSequence)memberNumber)) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"DimMembPermImportPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            String include = this.getCellStringByRowAndIndex(titleRow, dimensionTempSize == 0 ? 7 : 7 + (dimensionTempSize - 1) * 4);
            String read = this.getCellStringByRowAndIndex(titleRow, dimensionTempSize == 0 ? 8 : 8 + (dimensionTempSize - 1) * 4);
            String write = this.getCellStringByRowAndIndex(titleRow, dimensionTempSize == 0 ? 9 : 9 + (dimensionTempSize - 1) * 4);
            String give = this.getCellStringByRowAndIndex(titleRow, dimensionTempSize == 0 ? 10 : 10 + (dimensionTempSize - 1) * 4);
            if (!(StringUtils.equals((CharSequence)this.dimPermImportUtil.getLocalName("include"), (CharSequence)include) && StringUtils.equals((CharSequence)DimMembPermType.READ.getName(), (CharSequence)read) && StringUtils.equals((CharSequence)DimMembPermType.WRITE.getName(), (CharSequence)write) && StringUtils.equals((CharSequence)DimMembPermType.GIVE.getName(), (CharSequence)give))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"DimMembPermImportPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else if (MANAGE.equals(formType)) {
            String dimensionNumber = this.getCellStringByRowAndIndex(titleRow, 3);
            String membOrPropNumber = this.getCellStringByRowAndIndex(titleRow, 5);
            if (!StringUtils.equals((CharSequence)this.dimPermImportUtil.getLocalName("dimensionNumber"), (CharSequence)dimensionNumber) || !StringUtils.equals((CharSequence)this.dimPermImportUtil.getLocalName("membOrPropNumber"), (CharSequence)membOrPropNumber)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"DimMembPermImportPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        String userType = this.getCellStringByRowAndIndex(titleRow, 0);
        String userNumber = this.getCellStringByRowAndIndex(titleRow, 1);
        if (!StringUtils.equals((CharSequence)this.dimPermImportUtil.getLocalName("userType"), (CharSequence)userType) || !StringUtils.equals((CharSequence)this.dimPermImportUtil.getLocalName("userNumber"), (CharSequence)userNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"DimMembPermImportPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private String getCellStringByRowAndIndex(Row row, int index) {
        Cell cell = this.fileImportUtils.getCell(row, index);
        return this.fileImportUtils.getCellStringValue(cell);
    }

    private boolean validBaseInfo(Sheet sheetAt) {
        this.validModel(sheetAt);
        String formType = this.getPageCache().get("formType");
        if (MEMBER.equals(formType)) {
            String isBGMDModel;
            if (this.errorMap.isEmpty() && Boolean.parseBoolean(isBGMDModel = this.getPageCache().get("isBGMDModel"))) {
                this.validBizModel(sheetAt);
            }
            if (this.errorMap.isEmpty()) {
                this.validDimension(sheetAt);
            }
        }
        return this.errorMap.isEmpty();
    }

    private void validDimension(Sheet sheetAt) {
        long bizModel = this.getBizModel();
        Row row = this.fileImportUtils.getRow(sheetAt, 2);
        Cell dimensionCell = this.fileImportUtils.getCell(row, 1);
        String dimensionNumber = this.fileImportUtils.getCellStringValue(dimensionCell);
        this.getPageCache().put("dimensionNumber", dimensionNumber);
        if (StringUtils.isEmpty((CharSequence)dimensionNumber)) {
            String errorMsg = ResManager.loadKDString((String)"\u6388\u6743\u7ef4\u5ea6\u7f16\u7801\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728", (String)"DimMembPermImportPlugin_54", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.putErrorMsg(row, errorMsg);
        } else {
            String isBGMDModel = this.getPageCache().get("isBGMDModel");
            this.isDimensionGroup = dimensionNumber.contains(SPLIT);
            if (this.isDimensionGroup) {
                List<String> list = Arrays.asList(dimensionNumber.split(SPLIT));
                ArrayList dimGroups = new ArrayList(list.size());
                this.modelCacheHelper.getDimensionList().forEach(dimension -> {
                    if (list.contains(dimension.getNumber())) {
                        dimGroups.add(dimension.getNumber());
                    }
                });
                if (dimGroups.size() != list.size()) {
                    String errorMsg = ResManager.loadResFormat((String)"\u6388\u6743\u7ef4\u5ea6\u7ec4\u5408\u201c%1\u201d\u5728\u4f53\u7cfb\u4e2d\u4e0d\u5b58\u5728", (String)"DimMembPermImportPlugin_61", (String)"epm-eb-formplugin", (Object[])new Object[]{dimensionNumber});
                    this.putErrorMsg(row, errorMsg);
                    return;
                }
                boolean contains = false;
                List permControlDimGroup = DimMembPermUtil.getPermControlDimGroup((Long)this.getModelId(), (Long)this.getBizModel());
                for (PermDimGroup permDimGroup : permControlDimGroup) {
                    List dimNums = permDimGroup.getDimNums();
                    if (!StringUtils.equals((CharSequence)String.join((CharSequence)SPLIT, dimGroups), (CharSequence)String.join((CharSequence)SPLIT, dimNums)) || dimNums.size() != dimGroups.size()) continue;
                    contains = true;
                    this.dimPermGroupNumber = String.join((CharSequence)SPLIT, dimGroups);
                    this.dimPermGroupSize = dimGroups.size();
                    break;
                }
                if (!contains) {
                    String errorMsg = ResManager.loadResFormat((String)"\u6388\u6743\u7ef4\u5ea6\u7ec4\u5408\u201c%1\u201d\u5728\u4f53\u7cfb\u4e2d\u4e0d\u5b58\u5728", (String)"DimMembPermImportPlugin_61", (String)"epm-eb-formplugin", (Object[])new Object[]{dimensionNumber});
                    this.putErrorMsg(row, errorMsg);
                } else {
                    boolean present = list.stream().anyMatch(s -> SysDimensionEnum.Account.getNumber().equals(s));
                    if (present) {
                        this.initAccountMemberMap();
                    }
                }
            } else {
                QFilter qFilter;
                String[] split = dimensionNumber.split(",");
                if (Boolean.parseBoolean(isBGMDModel)) {
                    DatasetServiceHelper instance = DatasetServiceHelper.getInstance();
                    String[] dimensionList = instance.listDimensionBybizmodelId(Long.valueOf(bizModel));
                    List ids = dimensionList.stream().map(kd.epm.eb.common.model.Dimension::getId).collect(Collectors.toList());
                    qFilter = new QFilter("id", "in", ids);
                } else {
                    qFilter = new QFilter("model", "=", (Object)this.getModelId());
                }
                List collect = Arrays.stream(BusinessDataServiceHelper.load((String)"epm_dimension", (String)"number,id", (QFilter[])qFilter.toArray())).collect(Collectors.toList());
                for (String s2 : split) {
                    Optional<DynamicObject> first = collect.stream().filter(dynamicObject -> s2.equals(dynamicObject.getString("number"))).findFirst();
                    if (!StringUtils.isNotEmpty((CharSequence)s2)) continue;
                    if (!first.isPresent()) {
                        String errorMsg = bizModel != 0L ? ResManager.loadResFormat((String)"\u6388\u6743\u7ef4\u5ea6%1\u4e0d\u5728\u5bf9\u5e94\u4e1a\u52a1\u6a21\u578b\u5185", (String)"DimMembPermImportPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[]{s2}) : ResManager.loadResFormat((String)"\u6388\u6743\u7ef4\u5ea6%1\u4e0d\u5728\u5bf9\u5e94\u4f53\u7cfb\u5185", (String)"DimMembPermImportPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[]{s2});
                        this.putErrorMsg(row, errorMsg);
                        continue;
                    }
                    List dimensions = DimMembPermUtil.getPermControlDim((Long)this.getModelId()).stream().map(BaseCache::getNumber).collect(Collectors.toList());
                    if (dimensions.contains(s2)) continue;
                    String errorMsg = ResManager.loadResFormat((String)"\u6388\u6743\u7ef4\u5ea6\u201c%1\u201d\u4e0d\u5728\u5bf9\u5e94\u4f53\u7cfb\u7684\u6388\u6743\u7ef4\u5ea6\u4e2d", (String)"DimMembPermImportPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[]{s2});
                    this.putErrorMsg(row, errorMsg);
                }
                if (this.errorMap.isEmpty()) {
                    this.getPageCache().put("dimPermNumber", dimensionNumber);
                    boolean present = Arrays.stream(split).anyMatch(s -> SysDimensionEnum.Account.getNumber().equals(s));
                    if (present) {
                        this.initAccountMemberMap();
                    }
                }
            }
        }
    }

    private void validBizModel(Sheet sheetAt) {
        Long modelId = this.getModelId();
        Row row = this.fileImportUtils.getRow(sheetAt, 1);
        Cell bizModelCell = this.fileImportUtils.getCell(row, 1);
        String bizModelNumber = this.fileImportUtils.getCellStringValue(bizModelCell);
        this.getPageCache().put("bizModelNumber", bizModelNumber);
        if (StringUtils.isEmpty((CharSequence)bizModelNumber)) {
            String errorMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u7f16\u7801\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728\u3002", (String)"DimMembPermImportPlugin_53", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.putErrorMsg(row, errorMsg);
        } else {
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            QFilter number = new QFilter("number", "=", (Object)bizModelNumber);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_businessmodel", (QFilter[])new QFilter[]{qFilter, number});
            if (dynamicObject == null) {
                String errorMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u7f16\u7801\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728\u3002", (String)"DimMembPermImportPlugin_53", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.putErrorMsg(row, errorMsg);
            } else {
                this.getPageCache().put("bizModel", dynamicObject.getString("id"));
            }
        }
    }

    private void validModel(Sheet sheetAt) {
        Row row = this.fileImportUtils.getRow(sheetAt, 0);
        Cell modelCell = this.fileImportUtils.getCell(row, 1);
        String number = this.fileImportUtils.getCellStringValue(modelCell);
        this.getPageCache().put("modelNumber", number);
        if (StringUtils.isEmpty((CharSequence)number)) {
            String errorMsg = ResManager.loadKDString((String)"\u4f53\u7cfb\u7f16\u7801\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728", (String)"DimMembPermImportPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.putErrorMsg(row, errorMsg);
        } else {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_model", (String)"reporttype", (QFilter[])new QFilter[]{new QFilter("shownumber", "=", (Object)number)});
            String formType = this.getPageCache().get("formType");
            boolean onlyManager = StringUtils.equals((CharSequence)MANAGE, (CharSequence)formType);
            if (dynamicObject != null) {
                Set modelIds;
                this.isEbModel = ApplicationTypeEnum.EB.getIndex().equals(dynamicObject.getString("reporttype"));
                if (onlyManager) {
                    Row titleRow = this.fileImportUtils.getRow(sheetAt, 4);
                    if (this.isEbModel) {
                        String manage = this.getCellStringByRowAndIndex(titleRow, 7);
                        if (!StringUtils.equals((CharSequence)DimMembPermType.MANAGER.getName(), (CharSequence)manage)) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"DimMembPermImportPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        }
                    } else {
                        String viewNumber = this.getCellStringByRowAndIndex(titleRow, 7);
                        String viewName = this.getCellStringByRowAndIndex(titleRow, 8);
                        String manage = this.getCellStringByRowAndIndex(titleRow, 9);
                        if (!(StringUtils.equals((CharSequence)this.dimPermImportUtil.getLocalName("viewNumber"), (CharSequence)viewNumber) && StringUtils.equals((CharSequence)this.dimPermImportUtil.getLocalName("viewName"), (CharSequence)viewName) && StringUtils.equals((CharSequence)DimMembPermType.MANAGER.getName(), (CharSequence)manage))) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"DimMembPermImportPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        }
                    }
                }
                if (!(modelIds = ModelUtil.getModelIds((IFormView)this.getView(), (boolean)onlyManager)).contains(dynamicObject.getLong("id"))) {
                    String errorMsg = ResManager.loadResFormat((String)"\u60a8\u4e0d\u662f\u4f53\u7cfb\u201c%1\u201d\u7684\u7ba1\u7406\u5458", (String)"DimMembPermImportPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[]{number});
                    this.putErrorMsg(row, errorMsg);
                } else {
                    this.getPageCache().put("model", dynamicObject.getString("id"));
                    this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)dynamicObject.getLong("id"));
                    this.propCache = MemberPropCacheService.getOrCreate((Long)dynamicObject.getLong("id"));
                    boolean isBGMDModel = ModelServiceHelper.isBGMDModel((Long)dynamicObject.getLong("id"));
                    this.getPageCache().put("isBGMDModel", String.valueOf(isBGMDModel));
                }
            } else {
                String errorMsg = ResManager.loadKDString((String)"\u4f53\u7cfb\u7f16\u7801\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728", (String)"DimMembPermImportPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.putErrorMsg(row, errorMsg);
            }
        }
    }

    private void putErrorMsg(Row row, String errorMsg) {
        Set<String> strings = this.errorMap.get(row.getRowNum());
        if (CollectionUtils.isEmpty(strings)) {
            strings = new HashSet<String>(10);
        }
        strings.add(errorMsg);
        this.errorMap.put(row.getRowNum(), strings);
    }

    private void downloadErrorFile(InputStream inputStream) {
        String formType = this.getPageCache().get("formType");
        String fileName = "";
        if (MANAGE.equals(formType)) {
            fileName = ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ba1\u7406\u6743\u9650\u5bfc\u5165\u62a5\u9519\u4fe1\u606f.xlsx", (String)"DimMembPermImportPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        } else if (MEMBER.equals(formType)) {
            fileName = ResManager.loadKDString((String)"\u6210\u5458\u6570\u636e\u6743\u9650\u5bfc\u5165\u62a5\u9519\u4fe1\u606f.xlsx", (String)"DimMembPermImportPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, inputStream, 10000);
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        String file_url = this.getPageCache().get("file_url");
        List urls = file_url == null ? new ArrayList(10) : (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        for (Object url : evt.getUrls()) {
            urls.add((String)((Map)url).get("url"));
        }
        if (urls.size() > 0) {
            this.getPageCache().put("file_url", SerializationUtils.toJsonString(urls));
        }
    }

    public void afterRemove(UploadEvent evt) {
        String file_url = this.getPageCache().get("file_url");
        if (file_url != null) {
            Object[] objects;
            List urls = (List)SerializationUtils.fromJsonString((String)file_url, List.class);
            for (Object object : objects = evt.getUrls()) {
                String url = (String)((Map)object).get("url");
                urls.remove(url);
            }
            this.getPageCache().put("file_url", SerializationUtils.toJsonString((Object)urls));
        }
    }

    private int getRealRowNum(Sheet sheet) {
        int lastRowNum = sheet.getLastRowNum();
        int realLastRowNum = 0;
        String formType = this.getPageCache().get("formType");
        int endValidIndex = 0;
        if (MEMBER.equals(formType)) {
            Row dimensionRow = this.fileImportUtils.getRow(sheet, 2);
            Cell dimensionNumberCell = this.fileImportUtils.getCell(dimensionRow, 1);
            String cellStringValue = this.fileImportUtils.getCellStringValue(dimensionNumberCell);
            if (StringUtils.isNotEmpty((CharSequence)cellStringValue) && cellStringValue.contains(SPLIT)) {
                String[] split = cellStringValue.split(SPLIT);
                endValidIndex = 6 + 4 * split.length;
            } else {
                endValidIndex = 10;
            }
        } else if (MANAGE.equals(formType)) {
            endValidIndex = this.isEbModel ? 7 : 9;
        }
        for (int i = lastRowNum; i > 4; --i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            boolean isEmpty = true;
            for (int j = 0; j <= endValidIndex; ++j) {
                Cell cell = this.fileImportUtils.getCell(row, j);
                String cellStringValue = this.fileImportUtils.getCellStringValue(cell);
                if (!StringUtils.isNotEmpty((CharSequence)cellStringValue)) continue;
                isEmpty = false;
                break;
            }
            if (isEmpty) continue;
            realLastRowNum = i;
            break;
        }
        return realLastRowNum;
    }

    private Map<String, List<Row>> resolveSheetByDimension(XSSFWorkbook sheets) {
        XSSFSheet sheet = sheets.getSheetAt(0);
        LinkedHashMap<String, List<Row>> map = new LinkedHashMap<String, List<Row>>(16);
        int realRowNum = this.getRealRowNum((Sheet)sheet);
        this.cacheUserAndGroup();
        String currentUser = this.getPageCache().get("currentUser");
        String totalUser = this.getPageCache().get("totalUser");
        String totalGroup = this.getPageCache().get("totalGroup");
        Map userMap = new HashMap(16);
        Map groupMap = new HashMap(16);
        if (StringUtils.isNotEmpty((CharSequence)totalGroup)) {
            groupMap = (Map)SerializationUtils.deSerializeFromBase64((String)totalGroup);
        }
        if (StringUtils.isNotEmpty((CharSequence)totalUser)) {
            userMap = (Map)SerializationUtils.deSerializeFromBase64((String)totalUser);
        }
        Set managersByModel = ModelServiceHelper.getManagersByModel((Long)this.getModelId(), (boolean)true, (boolean)true);
        String formType = this.getPageCache().get("formType");
        if (MANAGE.equals(formType)) {
            Object[] dimensionNums = this.modelCacheHelper.getDimensionNums();
            this.getPageCache().put("modelDimension", StringUtils.join((Object[])dimensionNums, (String)","));
        }
        for (int i = 5; i <= realRowNum; ++i) {
            Row row = sheet.getRow(i);
            if (row == null || !this.validMustInput(row)) continue;
            Cell dimensionCell = this.fileImportUtils.getCell(row, 3);
            Cell numberCell = this.fileImportUtils.getCell(row, 1);
            Cell typeCell = this.fileImportUtils.getCell(row, 0);
            String dimension = this.fileImportUtils.getCellStringValue(dimensionCell);
            if (this.isDimensionGroup) {
                dimension = this.dimPermGroupNumber;
            }
            String number = this.fileImportUtils.getCellStringValue(numberCell);
            String type = this.fileImportUtils.getCellStringValue(typeCell);
            String userNumber = type + DOUBLE_AND + number;
            if (StringUtils.equals((CharSequence)userNumber, (CharSequence)currentUser)) {
                String errorMsg = ResManager.loadResFormat((String)"\u7528\u6237\u201c%1\u201d\u4e0e\u6267\u884c\u5bfc\u5165\u7528\u6237\u76f8\u540c", (String)"DimMembPermImportPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[]{number});
                this.putErrorMsg(row, errorMsg);
                continue;
            }
            boolean needRemove = false;
            Long currentUserOrGroupId = 0L;
            if (StringUtils.equals((CharSequence)this.dimPermImportUtil.getLocalName("user"), (CharSequence)type)) {
                currentUserOrGroupId = (Long)userMap.get(number);
                if (IDUtils.isNull((Long)currentUserOrGroupId)) {
                    needRemove = true;
                } else if (managersByModel.contains(currentUserOrGroupId)) {
                    continue;
                }
            } else if (StringUtils.equals((CharSequence)this.dimPermImportUtil.getLocalName("userGroup"), (CharSequence)type)) {
                currentUserOrGroupId = (Long)groupMap.get(number);
                if (IDUtils.isNull((Long)currentUserOrGroupId)) {
                    needRemove = true;
                } else if (managersByModel.contains(currentUserOrGroupId)) continue;
            }
            if (needRemove) {
                String errorMsg = ResManager.loadResFormat((String)"\u201c%1\u201d\u548c\u201c%2\u201d\u4e3a\u7a7a\u6216\u8005\u4e0d\u5b58\u5728", (String)"DimMembPermImportPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[]{type, number});
                this.putErrorMsg(row, errorMsg);
                continue;
            }
            ArrayList<Row> rows = map.containsKey(dimension) ? (ArrayList<Row>)map.get(dimension) : new ArrayList<Row>(10);
            rows.add(row);
            map.put(dimension, rows);
        }
        return map;
    }

    private void cacheUserAndGroup() {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryUser", (String)"bos_user", (String)"number,id", (QFilter[])new QFilter[0], null);
        HashMap<String, Long> userMap = new HashMap<String, Long>(16);
        HashMap<String, Long> groupMap = new HashMap<String, Long>(16);
        while (dataSet.hasNext()) {
            kd.bos.algo.Row next = dataSet.next();
            String number = next.getString("number");
            Long id = next.getLong("id");
            userMap.put(number, id);
        }
        DataSet groupDataSet = QueryServiceHelper.queryDataSet((String)"queryGroup", (String)"bos_usergroup", (String)"number,id", (QFilter[])new QFilter[0], null);
        while (groupDataSet.hasNext()) {
            kd.bos.algo.Row next = groupDataSet.next();
            String number = next.getString("number");
            Long id = next.getLong("id");
            groupMap.put(number, id);
        }
        this.getPageCache().put("totalUser", SerializationUtils.serializeToBase64(userMap));
        this.getPageCache().put("totalGroup", SerializationUtils.serializeToBase64(groupMap));
    }

    private boolean validMustInput(Row row) {
        Cell userNumberCell;
        String userNumber;
        boolean needResolve = true;
        Cell typeCell = this.fileImportUtils.getCell(row, 0);
        String stringCellValue = this.fileImportUtils.getCellStringValue(typeCell);
        if (!this.dimPermImportUtil.getLocalName("user").equals(stringCellValue) && !this.dimPermImportUtil.getLocalName("userGroup").equals(stringCellValue)) {
            needResolve = false;
            String errorMsg = ResManager.loadResFormat((String)"\u7528\u6237\u7c7b\u578b\u4e3a\u7a7a\u6216\u4e0d\u6b63\u786e", (String)"DimMembPermImportPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.putErrorMsg(row, errorMsg);
        }
        if (StringUtils.isEmpty((CharSequence)(userNumber = this.fileImportUtils.getCellStringValue(userNumberCell = this.fileImportUtils.getCell(row, 1))))) {
            needResolve = false;
            String errorMsg = ResManager.loadResFormat((String)"\u7528\u6237\u7c7b\u578b\u7f16\u7801\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728", (String)"DimMembPermImportPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.putErrorMsg(row, errorMsg);
        }
        if (this.isDimensionGroup) {
            if (StringUtils.isNotEmpty((CharSequence)this.dimPermGroupNumber)) {
                String give;
                String write;
                String read;
                String[] split = this.dimPermGroupNumber.split(SPLIT);
                int validIndex = 3;
                HashSet<String> dimensionNumberSet = new HashSet<String>(split.length);
                for (int i = 0; i < split.length; ++i) {
                    String errorMsg;
                    Cell dimensionCell = this.fileImportUtils.getCell(row, validIndex + i * 4);
                    String dimension = this.fileImportUtils.getCellStringValue(dimensionCell);
                    if (StringUtils.isEmpty((CharSequence)dimension) || !this.dimPermGroupNumber.contains(dimension)) {
                        needResolve = false;
                        errorMsg = ResManager.loadResFormat((String)"\u7ef4\u5ea6%1\u4e3a\u7a7a\u6216\u8005\u4e0d\u5728\u6388\u6743\u7ef4\u5ea6\u7ec4\u5408\u5185", (String)"DimMembPermImportPlugin_58", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension});
                        this.putErrorMsg(row, errorMsg);
                    } else if (!dimensionNumberSet.add(dimension)) {
                        needResolve = false;
                        errorMsg = ResManager.loadResFormat((String)"\u7ef4\u5ea6%1\u5b58\u5728\u91cd\u590d\u6570\u636e", (String)"DimMembPermImportPlugin_59", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension});
                        this.putErrorMsg(row, errorMsg);
                        break;
                    }
                    Cell memberCell = this.fileImportUtils.getCell(row, validIndex + 2 + i * 4);
                    String member = this.fileImportUtils.getCellStringValue(memberCell);
                    if (!StringUtils.isEmpty((CharSequence)member)) continue;
                    needResolve = false;
                    String errorMsg2 = ResManager.loadResFormat((String)"\u7ef4\u5ea6%1\u7684\u7ef4\u5ea6\u6210\u5458\u7f16\u7801/\u5c5e\u6027\u7f16\u7801\u4e3a\u7a7a\u6216\u8005\u4e0d\u5b58\u5728", (String)"DimMembPermImportPlugin_77", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension});
                    this.putErrorMsg(row, errorMsg2);
                }
                Cell includeCell = this.fileImportUtils.getCell(row, validIndex + split.length * 4);
                Cell readCell = this.fileImportUtils.getCell(row, validIndex + split.length * 4 + 1);
                Cell writeCell = this.fileImportUtils.getCell(row, validIndex + split.length * 4 + 2);
                Cell giveCell = this.fileImportUtils.getCell(row, validIndex + split.length * 4 + 3);
                String include = this.fileImportUtils.getCellStringValue(includeCell);
                if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{include, read = this.fileImportUtils.getCellStringValue(readCell), write = this.fileImportUtils.getCellStringValue(writeCell), give = this.fileImportUtils.getCellStringValue(giveCell)})) {
                    needResolve = false;
                    String errorMsg = ResManager.loadResFormat((String)"\u6388\u6743\u7ef4\u5ea6\u7ec4\u5408\u7684\u6743\u9650\u9879\u90fd\u4e3a\u7a7a", (String)"DimMembPermImportPlugin_60", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    this.putErrorMsg(row, errorMsg);
                }
            }
        } else {
            String formType;
            Cell dimensionCell = this.fileImportUtils.getCell(row, 3);
            String dimension = this.fileImportUtils.getCellStringValue(dimensionCell);
            Cell memberCell = this.fileImportUtils.getCell(row, 5);
            String member = this.fileImportUtils.getCellStringValue(memberCell);
            if (StringUtils.isEmpty((CharSequence)member)) {
                needResolve = false;
                String errorMsg = ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u6210\u5458\u7f16\u7801\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728", (String)"DimMembPermImportPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension});
                this.putErrorMsg(row, errorMsg);
            }
            if (MEMBER.equals(formType = this.getPageCache().get("formType"))) {
                String give;
                String write;
                String read;
                String dimensions = this.getDimPermNumber();
                if (StringUtils.isEmpty((CharSequence)dimensions) || StringUtils.isEmpty((CharSequence)dimension) || !dimensions.contains(dimension)) {
                    needResolve = false;
                    String errorMsg = ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u4e3a\u7a7a\u6216\u4e0d\u5728\u6388\u6743\u7ef4\u5ea6\u8303\u56f4\u5185", (String)"DimMembPermImportPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension});
                    this.putErrorMsg(row, errorMsg);
                }
                Cell includeCell = this.fileImportUtils.getCell(row, 7);
                Cell readCell = this.fileImportUtils.getCell(row, 8);
                Cell writeCell = this.fileImportUtils.getCell(row, 9);
                Cell giveCell = this.fileImportUtils.getCell(row, 10);
                String include = this.fileImportUtils.getCellStringValue(includeCell);
                if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{include, read = this.fileImportUtils.getCellStringValue(readCell), write = this.fileImportUtils.getCellStringValue(writeCell), give = this.fileImportUtils.getCellStringValue(giveCell)})) {
                    needResolve = false;
                    String errorMsg = ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458\u7f16\u7801%1\u7684\u6743\u9650\u9879\u90fd\u4e3a\u7a7a", (String)"DimMembPermImportPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[]{member});
                    this.putErrorMsg(row, errorMsg);
                }
            } else if (MANAGE.equals(formType)) {
                int manageIndex;
                Cell manageCell;
                String manage;
                String errorMsg;
                Cell viewCell;
                String viewNumber;
                Map<String, Long> numberIdMap;
                String modelDimension = this.getPageCache().get("modelDimension");
                if (StringUtils.isEmpty((CharSequence)modelDimension) || StringUtils.isEmpty((CharSequence)dimension) || !modelDimension.contains(dimension)) {
                    needResolve = false;
                    String errorMsg3 = ResManager.loadResFormat((String)"\u7ef4\u5ea6%1\u4e3a\u7a7a\uff0c\u6216\u4e0d\u5728\u5bf9\u5e94\u4f53\u7cfb\u5185", (String)"DimMembPermImportPlugin_55", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension});
                    this.putErrorMsg(row, errorMsg3);
                }
                if (!(!needResolve || this.isEbModel || (numberIdMap = this.dimViewNumberIdMap.get(dimension)) == null || numberIdMap.size() <= 0 || numberIdMap.containsKey(viewNumber = this.fileImportUtils.getCellStringValue(viewCell = this.fileImportUtils.getCell(row, 7))) || !StringUtils.isEmpty((CharSequence)member) && member.contains("!"))) {
                    needResolve = false;
                    errorMsg = ResManager.loadResFormat((String)"\u7ef4\u5ea6\u89c6\u56fe\u7f16\u7801%1\u4e3a\u7a7a\uff0c\u6216\u4e0d\u5728\u5bf9\u5e94\u4f53\u7cfb\u5185", (String)"DimMembPermImportPlugin_80", (String)"epm-eb-formplugin", (Object[])new Object[]{viewNumber});
                    this.putErrorMsg(row, errorMsg);
                }
                if (StringUtils.isEmpty((CharSequence)(manage = this.fileImportUtils.getCellStringValue(manageCell = this.fileImportUtils.getCell(row, manageIndex = this.isEbModel ? 7 : 9))))) {
                    needResolve = false;
                    errorMsg = ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458\u7f16\u7801/\u5c5e\u6027\u7f16\u7801%1\u7684\u7ba1\u7406\u6743\u6743\u9650\u9879\u4e3a\u7a7a", (String)"DimMembPermImportPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[]{member});
                    this.putErrorMsg(row, errorMsg);
                }
            }
        }
        return needResolve;
    }

    private void ValidManagePerm(Map<String, List<Row>> rowMap, Map<Long, DimMembPermRecord> permRecordMap, List<DimMembPermRecord> permList) {
        boolean needValidView;
        Iterator<Map.Entry<String, List<Row>>> iterator = rowMap.entrySet().iterator();
        String currentDimension = this.getPageCache().get("currentDimension");
        boolean bl = needValidView = !this.isEbModel && !View.NoViewDimNums.contains(currentDimension);
        while (iterator.hasNext()) {
            Map.Entry<String, List<Row>> next = iterator.next();
            List<Row> value = next.getValue();
            for (Row row : value) {
                Member member;
                Cell memberCell = this.fileImportUtils.getCell(row, 5);
                String membOrProp = this.fileImportUtils.getCellStringValue(memberCell);
                if (membOrProp.contains("!")) continue;
                Dimension dimension = this.modelCacheHelper.getDimension(currentDimension);
                if (needValidView) {
                    Cell viewCell = this.fileImportUtils.getCell(row, 7);
                    String viewNumber = this.fileImportUtils.getCellStringValue(viewCell);
                    Map<String, Long> numberIdMap = this.dimViewNumberIdMap.get(currentDimension);
                    member = dimension.getMember(numberIdMap.get(viewNumber), membOrProp);
                } else {
                    member = dimension.getStructOfMember(membOrProp);
                }
                if (member != null && !MemberSourceEnum.COSMIC_INVISIBLE.getIndex().equals(member.getSource())) continue;
                String errorMsg = ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458%1\u4e3a\u7a7a\u6216\u8005\u4e0d\u5b58\u5728", (String)"DimMembPermImportPlugin_76", (String)"epm-eb-formplugin", (Object[])new Object[]{membOrProp});
                this.putErrorMsg(row, errorMsg);
                iterator.remove();
            }
        }
        this.doValidManagePerm(rowMap, permRecordMap, permList, needValidView);
    }

    private void doValidManagePerm(Map<String, List<Row>> rowMap, Map<Long, DimMembPermRecord> permRecordMap, List<DimMembPermRecord> permList, boolean needValidView) {
        int manageIndex = this.isEbModel ? 7 : 9;
        IPageCache pageCache = this.getPageCache();
        String currentDimension = pageCache.get("currentDimension");
        String userIdStr = this.getPageCache().get("userId");
        long userId = Long.parseLong(userIdStr);
        Dimension dimension = this.modelCacheHelper.getDimension(currentDimension);
        if (dimension == null) {
            String errorMsg = ResManager.loadResFormat((String)"\u7ef4\u5ea6%1\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728", (String)"DimMembPermImportPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[]{currentDimension});
            Collection<List<Row>> values = rowMap.values();
            for (List<Row> value : values) {
                value.forEach(row -> this.putErrorMsg((Row)row, errorMsg));
            }
            return;
        }
        DimMembPermRecord mainPermRecord = null;
        if (permRecordMap != null) {
            mainPermRecord = permRecordMap.get(userId);
        }
        Map<String, DimMembPermDetailRecord[]> refDetailRecordMap = this.dimPermImportUtil.getRefDetailRecordMap(mainPermRecord, true);
        Long modifierId = UserUtils.getUserId();
        int seq = mainPermRecord == null ? 0 : mainPermRecord.getAllDetailRecords().size();
        for (Map.Entry<String, List<Row>> entry : rowMap.entrySet()) {
            List<Row> value = entry.getValue();
            for (Row row2 : value) {
                String memberStr;
                boolean perm;
                String errorMsg;
                String permStr;
                Cell permCell;
                String errorMsg2;
                String rowKey = entry.getKey();
                if (this.errorKeySet.contains(rowKey)) continue;
                Cell numberCell = this.fileImportUtils.getCell(row2, 5);
                String number = this.fileImportUtils.getCellStringValue(numberCell);
                boolean isProp = number.contains("!");
                Long viewId = 0L;
                if (isProp) {
                    CustomPropertyValue propertyValue = this.propCache.getPropertyValue(currentDimension, number);
                    if (propertyValue == null) {
                        errorMsg2 = ResManager.loadResFormat((String)"\u5c5e\u6027\u6210\u5458%1\u4e3a\u7a7a\u6216\u8005\u4e0d\u5b58\u5728", (String)"DimMembPermImportPlugin_62", (String)"epm-eb-formplugin", (Object[])new Object[]{number});
                        this.putErrorMsg(row2, errorMsg2);
                        continue;
                    }
                    if (SysDimensionEnum.Account.getNumber().equals(currentDimension)) {
                        errorMsg2 = ResManager.loadResFormat((String)"\u7ef4\u5ea6%1\u4e0d\u5141\u8bb8\u5bfc\u5165\u5c5e\u6027\u6210\u5458", (String)"DimMembPermImportPlugin_74", (String)"epm-eb-formplugin", (Object[])new Object[]{currentDimension});
                        this.putErrorMsg(row2, errorMsg2);
                        continue;
                    }
                    permCell = this.fileImportUtils.getCell(row2, manageIndex);
                    permStr = this.getPermStringCellValue(permCell);
                    if (!StringUtils.isNotEmpty((CharSequence)permStr) || StringUtils.equals((CharSequence)OTHER, (CharSequence)permStr) || !Boolean.parseBoolean(permStr)) {
                        errorMsg = ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458%1\u7684%2\u6743\u9650\u8bbe\u7f6e\u6709\u8bef\uff0c\u5df2\u8df3\u8fc7\u5bf9\u5e94\u6743\u9650\u9879", (String)"DimMembPermImportPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[]{number, DimMembPermType.MANAGER.getName()});
                        this.putErrorMsg(row2, errorMsg);
                        continue;
                    }
                    perm = Boolean.parseBoolean(permStr);
                    memberStr = this.propCache.getPropertyValue(currentDimension, number).getId() + "!" + RangeF7PropertyCataEnum.Property.getIndex() + "!0";
                } else {
                    Member member;
                    if (needValidView) {
                        Cell viewCell = this.fileImportUtils.getCell(row2, 7);
                        String viewNumber = this.fileImportUtils.getCellStringValue(viewCell);
                        Map<String, Long> numberIdMap = this.dimViewNumberIdMap.get(currentDimension);
                        viewId = numberIdMap.get(viewNumber);
                        member = dimension.getMember(viewId, number);
                    } else {
                        member = dimension.getStructOfMember(number);
                    }
                    if (member == null) {
                        errorMsg2 = ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458%1\u4e3a\u7a7a\u6216\u8005\u4e0d\u5b58\u5728", (String)"DimMembPermImportPlugin_76", (String)"epm-eb-formplugin", (Object[])new Object[]{number});
                        this.putErrorMsg(row2, errorMsg2);
                        continue;
                    }
                    memberStr = member.getId() + "!" + RangeF7PropertyCataEnum.Member.getIndex() + "!" + viewId;
                    permCell = this.fileImportUtils.getCell(row2, manageIndex);
                    permStr = this.getPermStringCellValue(permCell);
                    if (StringUtils.isNotEmpty((CharSequence)permStr) && !StringUtils.equals((CharSequence)OTHER, (CharSequence)permStr) && Boolean.parseBoolean(permStr)) {
                        perm = Boolean.parseBoolean(permStr);
                    } else {
                        errorMsg = ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458%1\u7684%2\u6743\u9650\u8bbe\u7f6e\u6709\u8bef\uff0c\u5df2\u8df3\u8fc7\u5bf9\u5e94\u6743\u9650\u9879", (String)"DimMembPermImportPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[]{number, DimMembPermType.MANAGER.getName()});
                        this.putErrorMsg(row2, errorMsg);
                        continue;
                    }
                }
                if (!perm) continue;
                DimMembPermDetailRecord[] permDetailRecords = null;
                String[] split = memberStr.split("!");
                long entryId = GlobalIdUtil.genGlobalLongId();
                if (mainPermRecord == null) {
                    long mainId = GlobalIdUtil.genGlobalLongId();
                    mainPermRecord = new DimMembPermRecord(Long.valueOf(mainId), this.getModelId(), "!" + dimension.getShortNumber() + "!", Long.valueOf(userId), Long.valueOf(0L), PermGroupEnum.MANAGER, modifierId, new Timestamp(TimeServiceHelper.now().getTime()));
                    permDetailRecords = new DimMembPermDetailRecord[1];
                    byte divNum = DimMembPermType.MANAGER.getDivNum();
                    permDetailRecords[0] = new DimMembPermDetailRecord(Long.valueOf(mainId), Long.valueOf(entryId), IDUtils.toLong((Object)split[0]), viewId, divNum, seq, !isProp, 0);
                } else {
                    permDetailRecords = refDetailRecordMap.get(memberStr);
                    if (permDetailRecords == null) {
                        permDetailRecords = new DimMembPermDetailRecord[1];
                        byte divNum = DimMembPermType.MANAGER.getDivNum();
                        permDetailRecords[0] = new DimMembPermDetailRecord(mainPermRecord.getId(), Long.valueOf(entryId), IDUtils.toLong((Object)split[0]), viewId, divNum, seq, !isProp, 0);
                    } else {
                        byte permVal = permDetailRecords[0].getPermVal();
                        permDetailRecords[0].setPermVal((byte)(permVal | DimMembPermType.MANAGER.getDivNum()));
                    }
                }
                this.insertFlag = true;
                HashMap<Integer, DimMembPermDetailRecord[]> allDetailRecords = mainPermRecord.getAllDetailRecords();
                if (allDetailRecords == null) {
                    allDetailRecords = new HashMap<Integer, DimMembPermDetailRecord[]>(16);
                    mainPermRecord.setAllDetailRecords(allDetailRecords);
                }
                allDetailRecords.put(permDetailRecords[0].getSeq(), permDetailRecords);
                ++seq;
            }
        }
        if (mainPermRecord != null && this.insertFlag) {
            permList.add(mainPermRecord);
        }
    }

    private void validMemberPerm(Map<String, Row> rowMap, Map<Long, DimMembPermRecord> permRecordMap, List<DimMembPermRecord> permList, Map<String, List<Long>> viewMap) {
        String currentUserIsModelManageStr = this.getPageCache().get("currentUserIsModelManage");
        boolean currentUserIsModelManage = Boolean.parseBoolean(currentUserIsModelManageStr);
        Iterator<Map.Entry<String, Row>> iterator = rowMap.entrySet().iterator();
        Long userId = UserUtils.getUserId();
        String[] dimensionSplit = this.dimPermGroupNumber.split(SPLIT);
        DimMemberPermChecker currentUserGivePermChecker = this.isDimensionGroup ? DimMembPermHelper.getPermChecker((Long)this.getModelId(), (Long)this.getBizModel(), Arrays.asList(dimensionSplit), (Long)userId, (DimMembPermType)DimMembPermType.GIVE) : DimMembPermHelper.getPermChecker((Long)this.getModelId(), (Long)this.getBizModel(), (List)Lists.newArrayList((Object[])new String[]{this.getPageCache().get("currentDimension")}), (Long)userId, (DimMembPermType)DimMembPermType.GIVE);
        HashMap<String, Map<String, List<Member>>> allFileDataMemberMap = new HashMap<String, Map<String, List<Member>>>(256);
        HashMap<String, Set<String>> fileLevelKeyMap = new HashMap<String, Set<String>>(256);
        HashMap<String, Map<String, Set<String>>> allFileRowDataMap = new HashMap<String, Map<String, Set<String>>>(16);
        HashMap<String, Map<String, Map<String, Set<String>>>> allFilePermLevelMap = new HashMap<String, Map<String, Map<String, Set<String>>>>(16);
        String userIdStr = this.getPageCache().get("userId");
        DimMembPermRecord mainPermRecord = null;
        if (permRecordMap != null) {
            mainPermRecord = permRecordMap.get(Long.parseLong(userIdStr));
        }
        Map<String, DimMembPermDetailRecord[]> refDetailRecordMap = this.dimPermImportUtil.getRefDetailRecordMap(mainPermRecord, false);
        while (iterator.hasNext()) {
            Map levelNumberMap;
            boolean containProp = false;
            Map.Entry<String, Row> next = iterator.next();
            Row row = next.getValue();
            String key = next.getKey();
            HashMap<String, MemberItem> memberItemMap = new HashMap<String, MemberItem>(16);
            int limit = this.dimPermGroupSize == 0 ? 4 : 3 + 4 * this.dimPermGroupSize;
            boolean needValid = true;
            LinkedHashMap<String, List<Member>> dimensionMap = new LinkedHashMap<String, List<Member>>(this.dimPermGroupSize);
            HashMap<String, HashSet> rowDataMap = new HashMap<String, HashSet>(16);
            HashSet<StringBuilder> groupLevelSet = new HashSet<StringBuilder>(16);
            StringBuilder idStr = new StringBuilder();
            StringBuilder permKey = new StringBuilder();
            HashMap<String, Boolean> permMap = new HashMap<String, Boolean>(4);
            for (int i = 3; i < limit; i += 4) {
                Cell includeCell = this.fileImportUtils.getCell(row, this.dimPermGroupSize == 0 ? 7 : 3 + this.dimPermGroupSize * 4);
                Cell readCell = this.fileImportUtils.getCell(row, this.dimPermGroupSize == 0 ? 8 : 4 + this.dimPermGroupSize * 4);
                Cell writeCell = this.fileImportUtils.getCell(row, this.dimPermGroupSize == 0 ? 9 : 5 + this.dimPermGroupSize * 4);
                Cell giveCell = this.fileImportUtils.getCell(row, this.dimPermGroupSize == 0 ? 10 : 6 + this.dimPermGroupSize * 4);
                String includeStr = this.getPermStringCellValue(includeCell);
                String readStr = this.getPermStringCellValue(readCell);
                String writeStr = this.getPermStringCellValue(writeCell);
                String giveStr = this.getPermStringCellValue(giveCell);
                if (StringUtils.isNotEmpty((CharSequence)readStr) && !StringUtils.equals((CharSequence)OTHER, (CharSequence)readStr)) {
                    permMap.put("read", Boolean.parseBoolean(readStr));
                }
                if (StringUtils.isNotEmpty((CharSequence)writeStr) && !StringUtils.equals((CharSequence)OTHER, (CharSequence)writeStr)) {
                    permMap.put("write", Boolean.parseBoolean(writeStr));
                }
                if (StringUtils.isNotEmpty((CharSequence)giveStr) && !StringUtils.equals((CharSequence)OTHER, (CharSequence)giveStr)) {
                    permMap.put("give", Boolean.parseBoolean(giveStr));
                }
                if (StringUtils.isNotEmpty((CharSequence)includeStr) && !StringUtils.equals((CharSequence)OTHER, (CharSequence)includeStr)) {
                    permMap.put("include", Boolean.parseBoolean(includeStr));
                }
                String dimensionStr = this.fileImportUtils.getCellStringValue(this.fileImportUtils.getCell(row, i));
                String membOrProp = this.fileImportUtils.getCellStringValue(this.fileImportUtils.getCell(row, i + 2));
                HashSet<StringBuilder> levelTemSet = new HashSet<StringBuilder>(16);
                StringBuilder idStrTmp = new StringBuilder();
                if (membOrProp.contains("!")) {
                    StringBuilder levelTmp = new StringBuilder();
                    CustomPropertyValue propertyValue = this.propCache.getPropertyValue(dimensionStr, membOrProp);
                    if (propertyValue == null) {
                        rowDataMap.clear();
                        String errorMsg = ResManager.loadResFormat((String)"\u7ef4\u5ea6%1\u4e2d\u4e0d\u5b58\u5728\u5c5e\u6027%2", (String)"DimMembPermImportPlugin_63", (String)"epm-eb-formplugin", (Object[])new Object[]{dimensionStr, membOrProp});
                        this.putErrorMsg(row, errorMsg);
                        iterator.remove();
                        break;
                    }
                    if (SysDimensionEnum.Account.getNumber().equals(dimensionStr)) {
                        rowDataMap.clear();
                        String errorMsg = ResManager.loadResFormat((String)"\u7ef4\u5ea6%1\u4e0d\u5141\u8bb8\u5bfc\u5165\u5c5e\u6027\u6210\u5458", (String)"DimMembPermImportPlugin_74", (String)"epm-eb-formplugin", (Object[])new Object[]{dimensionStr});
                        this.putErrorMsg(row, errorMsg);
                        iterator.remove();
                        break;
                    }
                    needValid = false;
                    rowDataMap.put(dimensionStr, Sets.newHashSet((Object[])new String[]{propertyValue.getLongNumber() + "!"}));
                    levelTmp.append("0").append("!");
                    idStrTmp.append(propertyValue.getId()).append("!").append(RangeF7PropertyCataEnum.Property.getIndex()).append(SPLIT);
                    levelTemSet.add(levelTmp);
                    containProp = true;
                    if (this.dimPermGroupSize > 0) {
                        for (int j = 0; j < dimensionSplit.length; ++j) {
                            if (!dimensionSplit[j].equals(dimensionStr)) continue;
                            if (4 * j + 3 >= i) {
                                this.dimPermImportUtil.connectLevelStr(groupLevelSet, levelTemSet, true);
                                idStr.append((CharSequence)idStrTmp);
                                continue;
                            }
                            this.dimPermImportUtil.connectLevelStr(groupLevelSet, levelTemSet, false);
                            idStr = idStrTmp.append((CharSequence)idStr);
                        }
                        continue;
                    }
                    this.dimPermImportUtil.connectLevelStr(groupLevelSet, levelTemSet, true);
                    idStr.append((CharSequence)idStrTmp);
                    continue;
                }
                List<Member> members = this.dimPermImportUtil.getMember(dimensionStr, membOrProp, true, viewMap, this.modelCacheHelper, this.accountMemberMap);
                if (CollectionUtils.isEmpty(members)) {
                    rowDataMap.clear();
                    dimensionMap.clear();
                    String errorMsg = ResManager.loadResFormat((String)"\u7ef4\u5ea6%1\u7684\u6210\u5458%2\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728\u3002", (String)"DimMembPermImportPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[]{dimensionStr, membOrProp});
                    this.putErrorMsg(row, errorMsg);
                    iterator.remove();
                    break;
                }
                Member member = members.get(0);
                MemberItem memberItem = new MemberItem(true, member.getId());
                memberItemMap.put(dimensionStr, memberItem);
                members.forEach(mem -> {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(mem.getLevel()).append("!");
                    levelTemSet.add(stringBuilder);
                });
                idStrTmp.append(member.getId()).append("!").append(RangeF7PropertyCataEnum.Member.getIndex()).append(SPLIT);
                dimensionMap.put(dimensionStr, members);
                rowDataMap.put(dimensionStr, Sets.newHashSet((Object[])new String[]{member.getLongNumber()}));
                if (this.dimPermGroupSize > 0) {
                    for (int j = 0; j < dimensionSplit.length; ++j) {
                        if (!dimensionSplit[j].equals(dimensionStr)) continue;
                        if (4 * j + 3 >= i) {
                            this.dimPermImportUtil.connectLevelStr(groupLevelSet, levelTemSet, true);
                            idStr.append((CharSequence)idStrTmp);
                            continue;
                        }
                        this.dimPermImportUtil.connectLevelStr(groupLevelSet, levelTemSet, false);
                        idStr = idStrTmp.append((CharSequence)idStr);
                    }
                    continue;
                }
                this.dimPermImportUtil.connectLevelStr(groupLevelSet, levelTemSet, true);
                idStr.append((CharSequence)idStrTmp);
            }
            if (!currentUserIsModelManage && needValid && !currentUserGivePermChecker.check(memberItemMap)) {
                String errorMsg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6388\u6743\u8be5\u884c\u6570\u636e\u7684\u529f\u80fd\u6743\u9650", (String)"DimMembPermImportPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.putErrorMsg(row, errorMsg);
                iterator.remove();
            }
            if (StringUtils.isNotEmpty((CharSequence)idStr)) {
                Boolean permFromDatabase;
                String dataKey = idStr.substring(0, idStr.length() - 1);
                if (permMap.containsKey("read")) {
                    permKey.append(permMap.get("read")).append("_");
                } else {
                    permFromDatabase = this.dimPermImportUtil.getPermFromDatabase(dataKey, refDetailRecordMap, DimMembPermType.READ);
                    permKey.append(permFromDatabase).append("_");
                }
                if (permMap.containsKey("write")) {
                    permKey.append(permMap.get("write")).append("_");
                } else {
                    permFromDatabase = this.dimPermImportUtil.getPermFromDatabase(dataKey, refDetailRecordMap, DimMembPermType.WRITE);
                    permKey.append(permFromDatabase).append("_");
                }
                if (permMap.containsKey("give")) {
                    permKey.append(permMap.get("give")).append("_");
                } else {
                    permFromDatabase = this.dimPermImportUtil.getPermFromDatabase(dataKey, refDetailRecordMap, DimMembPermType.GIVE);
                    permKey.append(permFromDatabase).append("_");
                }
                if (permMap.containsKey("include")) {
                    permKey.append(permMap.get("include"));
                } else {
                    permFromDatabase = this.dimPermImportUtil.getPermFromDatabase(dataKey, refDetailRecordMap, DimMembPermType.DATAPERMEXTENDS);
                    permKey.append(permFromDatabase);
                }
            }
            if (rowDataMap.size() <= 0) continue;
            if (containProp) {
                Map propMap = allFilePermLevelMap.computeIfAbsent("prop", v -> new HashMap(256));
                levelNumberMap = propMap.computeIfAbsent(permKey.toString(), v -> new HashMap(16));
                groupLevelSet.forEach(groupLevel -> {
                    String substring = groupLevel.substring(0, groupLevel.length() - 1);
                    Set strings = levelNumberMap.computeIfAbsent(substring, v -> new HashSet(256));
                    strings.add(key);
                });
            } else {
                Map memberMap = allFilePermLevelMap.computeIfAbsent(MEMBER, v -> new HashMap(256));
                levelNumberMap = memberMap.computeIfAbsent(permKey.toString(), v -> new HashMap(16));
                groupLevelSet.forEach(groupLevel -> {
                    String substring = groupLevel.substring(0, groupLevel.length() - 1);
                    Set strings = levelNumberMap.computeIfAbsent(substring, v -> new HashSet(256));
                    strings.add(key);
                });
                if (dimensionMap.size() > 0) {
                    allFileDataMemberMap.put(key, dimensionMap);
                    groupLevelSet.forEach(groupLevel -> {
                        String substring = groupLevel.substring(0, groupLevel.length() - 1);
                        Set levelKeys = fileLevelKeyMap.computeIfAbsent(substring, v -> new HashSet(256));
                        levelKeys.add(key);
                    });
                }
            }
            allFileRowDataMap.put(key, rowDataMap);
        }
        this.doValidMemberPerm(rowMap, permRecordMap, permList, allFileDataMemberMap, fileLevelKeyMap, allFileRowDataMap, allFilePermLevelMap, refDetailRecordMap, viewMap);
    }

    private void doValidMemberPerm(Map<String, Row> rowMap, Map<Long, DimMembPermRecord> permRecordMap, List<DimMembPermRecord> permList, Map<String, Map<String, List<Member>>> allFileDataMemberMap, Map<String, Set<String>> fileLevelKeyMap, Map<String, Map<String, Set<String>>> allFileRowDataMap, Map<String, Map<String, Map<String, Set<String>>>> allFilePermLevelMap, Map<String, DimMembPermDetailRecord[]> refDetailRecordMap, Map<String, List<Long>> viewMap) {
        String userIdStr = this.getPageCache().get("userId");
        long userId = Long.parseLong(userIdStr);
        DimMembPermRecord mainPermRecord = null;
        String currentDimension = this.getPageCache().get("currentDimension");
        String[] dimSplit = this.dimPermGroupSize > 0 ? this.dimPermGroupNumber.split(SPLIT) : currentDimension.split(SPLIT);
        ArrayList<Dimension> dimensionList = new ArrayList<Dimension>(dimSplit.length);
        for (String dim : dimSplit) {
            dimensionList.add(this.modelCacheHelper.getDimension(dim));
        }
        if (permRecordMap != null) {
            mainPermRecord = permRecordMap.get(userId);
        }
        Map<String, Map<String, Map<String, Set<String>>>> dataPermMap = this.dimPermImportUtil.getRefPermMap(mainPermRecord, dimensionList, this.propCache, viewMap, this.accountIdMemberMap);
        Map<String, Map<String, Set<String>>> dataMemberOrPropMap = this.dimPermImportUtil.getDataMemberOrProp(mainPermRecord, dimensionList, this.propCache, viewMap, this.accountIdMemberMap);
        Map<String, Map<String, Map<String, List<Member>>>> dataLevelKeyMap = this.dimPermImportUtil.getDataLevelKeyMap(mainPermRecord, dimensionList, viewMap, this.accountIdMemberMap);
        int seq = mainPermRecord == null ? 0 : mainPermRecord.getAllDetailRecords().size();
        Long modifierId = UserUtils.getUserId();
        String[] dimensionSplit = this.dimPermGroupNumber.split(SPLIT);
        for (Map.Entry<String, Row> entry : rowMap.entrySet()) {
            HashMap<Integer, DimMembPermDetailRecord[]> allDetailRecords;
            Boolean permFromDatabase;
            boolean readWriteLogic;
            String errorMsg;
            String rowKey = entry.getKey();
            if (this.errorKeySet.contains(rowKey)) continue;
            Row row = entry.getValue();
            boolean childCheck = true;
            boolean parentCheck = true;
            boolean needInsertInclude = false;
            boolean needInsertRead = false;
            boolean needInsertWrite = false;
            boolean needInsertGive = false;
            HashMap<String, Boolean> permMap = new HashMap<String, Boolean>(4);
            StringBuilder membOrPropIdStr = new StringBuilder();
            int limit = this.dimPermGroupSize == 0 ? 1 : this.dimPermGroupSize;
            boolean needValidGivePerm = true;
            boolean basePermValid = true;
            boolean isAllPropOrVir = true;
            boolean containProp = false;
            HashMap<String, List<Member>> currentMemberMap = new HashMap<String, List<Member>>(limit);
            HashSet<StringBuilder> groupLevelSet = new HashSet<StringBuilder>(16);
            for (int i = 0; i < limit; ++i) {
                long membOrPropId;
                Cell dimensionCell = this.fileImportUtils.getCell(row, i == 0 ? 3 : 3 + i * 4);
                Cell membOrPropCell = this.fileImportUtils.getCell(row, i == 0 ? 5 : 5 + i * 4);
                Cell includeCell = this.fileImportUtils.getCell(row, this.dimPermGroupSize == 0 ? 7 : 3 + this.dimPermGroupSize * 4);
                Cell readCell = this.fileImportUtils.getCell(row, this.dimPermGroupSize == 0 ? 8 : 4 + this.dimPermGroupSize * 4);
                Cell writeCell = this.fileImportUtils.getCell(row, this.dimPermGroupSize == 0 ? 9 : 5 + this.dimPermGroupSize * 4);
                Cell giveCell = this.fileImportUtils.getCell(row, this.dimPermGroupSize == 0 ? 10 : 6 + this.dimPermGroupSize * 4);
                String dimension = this.fileImportUtils.getCellStringValue(dimensionCell);
                Dimension helperDimension = this.modelCacheHelper.getDimension(dimension);
                if (helperDimension == null) {
                    String errorMsg2 = ResManager.loadResFormat((String)"\u7ef4\u5ea6%1\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728", (String)"DimMembPermImportPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension});
                    for (Row _row : rowMap.values()) {
                        this.putErrorMsg(_row, errorMsg2);
                    }
                    return;
                }
                String membOrPropNum = this.fileImportUtils.getCellStringValue(membOrPropCell);
                if (permMap.size() == 0) {
                    String giveStr;
                    String writeStr;
                    String includeStr = this.getPermStringCellValue(includeCell);
                    String readStr = this.getPermStringCellValue(readCell);
                    if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{readStr, writeStr = this.getPermStringCellValue(writeCell), giveStr = this.getPermStringCellValue(giveCell)})) {
                        needValidGivePerm = false;
                        basePermValid = false;
                        errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u884c\u5bf9\u5e94\u6743\u9650\u5747\u4e3a\u7a7a\uff0c\u5df2\u8df3\u8fc7\u8be5\u6761\u6570\u636e\u5904\u7406", (String)"DimMembPermImportPlugin_64", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                        this.putErrorMsg(row, errorMsg);
                        break;
                    }
                    Boolean include = null;
                    Boolean read = null;
                    Boolean write = null;
                    Boolean give = null;
                    StringBuilder errorPermItem = new StringBuilder();
                    if (StringUtils.isNotEmpty((CharSequence)readStr) && !StringUtils.equals((CharSequence)OTHER, (CharSequence)readStr)) {
                        needInsertRead = true;
                        read = Boolean.parseBoolean(readStr);
                    } else if (StringUtils.equals((CharSequence)OTHER, (CharSequence)readStr)) {
                        errorPermItem.append(DimMembPermType.READ.getName()).append("\u3001");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)writeStr) && !StringUtils.equals((CharSequence)OTHER, (CharSequence)writeStr)) {
                        needInsertWrite = true;
                        write = Boolean.parseBoolean(writeStr);
                    } else if (StringUtils.equals((CharSequence)OTHER, (CharSequence)writeStr)) {
                        errorPermItem.append(DimMembPermType.WRITE.getName()).append("\u3001");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)includeStr) && !StringUtils.equals((CharSequence)OTHER, (CharSequence)includeStr)) {
                        needInsertInclude = true;
                        include = Boolean.parseBoolean(includeStr);
                    } else if (StringUtils.equals((CharSequence)OTHER, (CharSequence)includeStr)) {
                        errorPermItem.append(DimMembPermType.DATAPERMEXTENDS.getName()).append("\u3001");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)giveStr) && !StringUtils.equals((CharSequence)OTHER, (CharSequence)giveStr)) {
                        needInsertGive = true;
                        give = Boolean.parseBoolean(giveStr);
                    } else if (StringUtils.equals((CharSequence)OTHER, (CharSequence)giveStr)) {
                        errorPermItem.append(DimMembPermType.GIVE.getName()).append("\u3001");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)errorPermItem)) {
                        String errorMsg3 = ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458%1\u7684%2\u6743\u9650\u8bbe\u7f6e\u6709\u8bef\uff0c\u5df2\u8df3\u8fc7\u5bf9\u5e94\u6743\u9650\u9879", (String)"DimMembPermImportPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[]{membOrPropNum, errorPermItem.deleteCharAt(errorPermItem.length() - 1)});
                        this.putErrorMsg(row, errorMsg3);
                        basePermValid = false;
                        break;
                    }
                    permMap.put("read", read);
                    permMap.put("write", write);
                    permMap.put("give", give);
                    permMap.put("include", include);
                }
                boolean isProp = membOrPropNum.contains("!");
                String[] tempLevelSet = new HashSet(16);
                if (isProp) {
                    StringBuilder levelTmp = new StringBuilder();
                    membOrPropId = this.propCache.getPropertyValue(dimension, membOrPropNum).getId();
                    levelTmp.append("0").append("!");
                    tempLevelSet.add(levelTmp);
                    containProp = true;
                } else {
                    List<Member> members = this.dimPermImportUtil.getMember(dimension, membOrPropNum, false, viewMap, this.modelCacheHelper, this.accountMemberMap);
                    membOrPropId = members.get(0).getId();
                    isAllPropOrVir = false;
                    currentMemberMap.put(dimension, members);
                    members.forEach(arg_0 -> DimMembPermImportPlugin.lambda$doValidMemberPerm$22((Set)tempLevelSet, arg_0));
                }
                StringBuilder tmp = new StringBuilder();
                tmp.append(membOrPropId).append("!").append(isProp ? RangeF7PropertyCataEnum.Property.getIndex() : RangeF7PropertyCataEnum.Member.getIndex()).append(SPLIT);
                if (this.dimPermGroupSize > 0) {
                    for (int j = 0; j < dimensionSplit.length; ++j) {
                        if (!dimensionSplit[j].equals(dimension)) continue;
                        if (j >= i) {
                            this.dimPermImportUtil.connectLevelStr(groupLevelSet, (Set<StringBuilder>)tempLevelSet, true);
                            membOrPropIdStr.append((CharSequence)tmp);
                            continue;
                        }
                        this.dimPermImportUtil.connectLevelStr(groupLevelSet, (Set<StringBuilder>)tempLevelSet, false);
                        membOrPropIdStr = tmp.append((CharSequence)membOrPropIdStr);
                    }
                } else {
                    this.dimPermImportUtil.connectLevelStr(groupLevelSet, (Set<StringBuilder>)tempLevelSet, true);
                    membOrPropIdStr.append((CharSequence)tmp);
                }
                if (!isProp) continue;
                needValidGivePerm = false;
            }
            if (basePermValid && !(readWriteLogic = this.validReadWriteLogic(row, refDetailRecordMap, membOrPropIdStr.substring(0, membOrPropIdStr.length() - 1)))) {
                basePermValid = false;
            }
            if (isAllPropOrVir) {
                needInsertInclude = false;
            }
            String substring = "";
            if (basePermValid) {
                substring = membOrPropIdStr.substring(0, membOrPropIdStr.length() - 1);
            }
            if (permMap.get("read") == null) {
                permFromDatabase = this.dimPermImportUtil.getPermFromDatabase(substring, refDetailRecordMap, DimMembPermType.READ);
                permMap.put("read", permFromDatabase);
            }
            if (permMap.get("write") == null) {
                permFromDatabase = this.dimPermImportUtil.getPermFromDatabase(substring, refDetailRecordMap, DimMembPermType.WRITE);
                permMap.put("write", permFromDatabase);
            }
            Boolean databaseGive = this.dimPermImportUtil.getPermFromDatabase(substring, refDetailRecordMap, DimMembPermType.GIVE);
            permMap.putIfAbsent("give", databaseGive);
            Boolean databaseInclude = this.dimPermImportUtil.getPermFromDatabase(substring, refDetailRecordMap, DimMembPermType.DATAPERMEXTENDS);
            permMap.putIfAbsent("include", databaseInclude);
            if (basePermValid && needValidGivePerm) {
                String errorMsg4;
                String[] strings = substring.split(SPLIT);
                if (strings.length == 1) {
                    if (needInsertGive) {
                        String dimension = this.getCellStringByRowAndIndex(row, 3);
                        String memberNumber = this.getCellStringByRowAndIndex(row, 5);
                        List<Member> members = this.dimPermImportUtil.getMember(dimension, memberNumber, false, viewMap, this.modelCacheHelper, this.accountMemberMap);
                        Iterator<String> children = new ArrayList(10);
                        HashSet<String> longNumberSet = new HashSet<String>(16);
                        for (Member member : members) {
                            String longNumber = member.getLongNumber();
                            Boolean give = (Boolean)permMap.get("give");
                            if (BooleanUtils.isTrue((Boolean)give)) {
                                children.addAll(this.modelCacheHelper.getChildren(member, false));
                                longNumber = "";
                            }
                            if (!StringUtils.isNotEmpty((CharSequence)longNumber)) continue;
                            longNumberSet.add(longNumber);
                        }
                        HashSet<String> errorParentNumbers = new HashSet<String>(16);
                        for (String longNumber : longNumberSet) {
                            String[] split;
                            for (String s : split = longNumber.split("!")) {
                                Cell parentPermCell;
                                String parentPermStr;
                                if (StringUtils.equals((CharSequence)s, (CharSequence)memberNumber)) continue;
                                Row parentRow = rowMap.get(s + "!1");
                                Boolean parentPerm = parentRow != null ? (StringUtils.isNotEmpty((CharSequence)(parentPermStr = this.getPermStringCellValue(parentPermCell = this.fileImportUtils.getCell(parentRow, 10)))) && !StringUtils.equals((CharSequence)OTHER, (CharSequence)parentPermStr) ? Boolean.valueOf(Boolean.parseBoolean(parentPermStr)) : this.dimPermImportUtil.getPermFromDatabase(this.dimPermImportUtil.getMember(dimension, s, false, viewMap, this.modelCacheHelper, this.accountMemberMap).get(0).getId() + "!" + RangeF7PropertyCataEnum.Member.getIndex(), refDetailRecordMap, DimMembPermType.GIVE)) : this.dimPermImportUtil.getPermFromDatabase(this.dimPermImportUtil.getMember(dimension, s, false, viewMap, this.modelCacheHelper, this.accountMemberMap).get(0).getId() + "!" + RangeF7PropertyCataEnum.Member.getIndex(), refDetailRecordMap, DimMembPermType.GIVE);
                                if (parentPerm == null || !parentPerm.equals(true)) continue;
                                parentCheck = false;
                                errorParentNumbers.add(s);
                            }
                            if (parentCheck || !CollectionUtils.isNotEmpty(errorParentNumbers)) continue;
                            String join = String.join((CharSequence)"\u3001", errorParentNumbers);
                            String errorMsg5 = ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458%1\u4e0e\u4e0a\u7ea7\u7ef4\u5ea6\u6210\u5458%2\u7684%3\u6743\u9650\u903b\u8f91\u4e0d\u4e00\u81f4", (String)"DimMembPermImportPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[]{memberNumber, join, DimMembPermType.GIVE.getName()});
                            this.putErrorMsg(row, errorMsg5);
                        }
                        HashSet<String> errorChildNumbers = new HashSet<String>(16);
                        Iterator longNumber = children.iterator();
                        while (longNumber.hasNext()) {
                            Boolean childPerm;
                            Member child = (Member)longNumber.next();
                            String childNumber = child.getNumber();
                            Row childRow = rowMap.get(childNumber + "!1");
                            String databaseKey = child.getId() + "!" + RangeF7PropertyCataEnum.Member.getIndex();
                            if (childRow != null) {
                                Cell childPermCell = this.fileImportUtils.getCell(childRow, 10);
                                String childPermStr = this.getPermStringCellValue(childPermCell);
                                childPerm = StringUtils.isNotEmpty((CharSequence)childPermStr) && !StringUtils.equals((CharSequence)OTHER, (CharSequence)childPermStr) ? Boolean.valueOf(Boolean.parseBoolean(childPermStr)) : this.dimPermImportUtil.getPermFromDatabase(databaseKey, refDetailRecordMap, DimMembPermType.GIVE);
                                if (childPerm != null && !childPerm.equals(false)) continue;
                                childCheck = false;
                                errorChildNumbers.add(child.getNumber());
                                continue;
                            }
                            childPerm = this.dimPermImportUtil.getPermFromDatabase(databaseKey, refDetailRecordMap, DimMembPermType.GIVE);
                            if (childPerm == null || !childPerm.equals(false)) continue;
                            childCheck = false;
                            errorChildNumbers.add(child.getNumber());
                        }
                        if (!childCheck && CollectionUtils.isNotEmpty(errorChildNumbers)) {
                            String join = String.join((CharSequence)"\u3001", errorChildNumbers);
                            errorMsg4 = ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458%1\u4e0e\u4e0b\u7ea7\u7ef4\u5ea6\u6210\u5458%2\u7684%3\u6743\u9650\u903b\u8f91\u4e0d\u4e00\u81f4", (String)"DimMembPermImportPlugin_44", (String)"epm-eb-formplugin", (Object[])new Object[]{memberNumber, join, DimMembPermType.GIVE.getName()});
                            this.putErrorMsg(row, errorMsg4);
                        }
                        if (!childCheck || !parentCheck) {
                            needInsertGive = false;
                        }
                    }
                } else if (needInsertGive) {
                    String errorNumber;
                    Boolean hasPerm;
                    String errorMsg6;
                    Set<String> set;
                    Map<String, Set<String>> refRowMap = this.dimPermImportUtil.getCurrentRefRowMap(allFileDataMemberMap, fileLevelKeyMap, currentMemberMap, dataLevelKeyMap, membOrPropIdStr.substring(0, membOrPropIdStr.length() - 1), groupLevelSet, dimensionSplit);
                    Boolean give = (Boolean)permMap.get("give");
                    if (BooleanUtils.isTrue((Boolean)give)) {
                        set = refRowMap.get("child");
                        if (CollectionUtils.isNotEmpty(set)) {
                            for (String key : set) {
                                Row childRow = rowMap.get(key);
                                if (childRow != null) {
                                    Cell childPermCell = this.fileImportUtils.getCell(childRow, 6 + 4 * this.dimPermGroupSize);
                                    String childGiveStr = this.getPermStringCellValue(childPermCell);
                                    if (StringUtils.isNotEmpty((CharSequence)childGiveStr) && !StringUtils.equals((CharSequence)OTHER, (CharSequence)childGiveStr)) {
                                        boolean childGive = Boolean.parseBoolean(childGiveStr);
                                        if (childGive) continue;
                                        errorMsg6 = ResManager.loadResFormat((String)"\u5f53\u524d\u7ef4\u5ea6\u7ec4\u5408\u4e0e\u4e0b\u7ea7\u7ef4\u5ea6\u7ec4\u5408%1\u7684%2\u6743\u9650\u903b\u8f91\u4e0d\u4e00\u81f4", (String)"DimMembPermImportPlugin_65", (String)"epm-eb-formplugin", (Object[])new Object[]{key.replace("!1", "").replace("!2", ""), DimMembPermType.GIVE.getName()});
                                        this.putErrorMsg(row, errorMsg6);
                                        needInsertGive = false;
                                    } else {
                                        hasPerm = this.dimPermImportUtil.getPermFromDatabase(key, refDetailRecordMap, DimMembPermType.GIVE);
                                        if (hasPerm != null && !hasPerm.equals(false)) continue;
                                        errorNumber = "";
                                        errorNumber = refDetailRecordMap.containsKey(key) ? this.transIdToNumber(key) : key.replace("!1", "").replace("!2", "");
                                        errorMsg = ResManager.loadResFormat((String)"\u5f53\u524d\u7ef4\u5ea6\u7ec4\u5408\u4e0e\u4e0b\u7ea7\u7ef4\u5ea6\u7ec4\u5408%1\u7684%2\u6743\u9650\u903b\u8f91\u4e0d\u4e00\u81f4", (String)"DimMembPermImportPlugin_65", (String)"epm-eb-formplugin", (Object[])new Object[]{errorNumber, DimMembPermType.GIVE.getName()});
                                        this.putErrorMsg(row, errorMsg);
                                        needInsertGive = false;
                                    }
                                } else {
                                    Boolean hasPerm2 = this.dimPermImportUtil.getPermFromDatabase(key, refDetailRecordMap, DimMembPermType.GIVE);
                                    if (hasPerm2 == null || !hasPerm2.equals(false)) continue;
                                    String errorNumber2 = this.transIdToNumber(key);
                                    errorMsg4 = ResManager.loadResFormat((String)"\u5f53\u524d\u7ef4\u5ea6\u7ec4\u5408\u4e0e\u4e0b\u7ea7\u7ef4\u5ea6\u7ec4\u5408%1\u7684%2\u6743\u9650\u903b\u8f91\u4e0d\u4e00\u81f4", (String)"DimMembPermImportPlugin_65", (String)"epm-eb-formplugin", (Object[])new Object[]{errorNumber2, DimMembPermType.GIVE.getName()});
                                    this.putErrorMsg(row, errorMsg4);
                                    needInsertGive = false;
                                }
                                break;
                            }
                        }
                    } else {
                        set = refRowMap.get("parent");
                        if (CollectionUtils.isNotEmpty(set)) {
                            for (String key : set) {
                                Row parentRow = rowMap.get(key);
                                if (parentRow != null) {
                                    Cell parentPermCell = this.fileImportUtils.getCell(parentRow, 6 + 4 * this.dimPermGroupSize);
                                    String parentGiveStr = this.getPermStringCellValue(parentPermCell);
                                    if (StringUtils.isNotEmpty((CharSequence)parentGiveStr) && !StringUtils.equals((CharSequence)OTHER, (CharSequence)parentGiveStr)) {
                                        boolean parentGive = Boolean.parseBoolean(parentGiveStr);
                                        if (!parentGive) continue;
                                        errorMsg6 = ResManager.loadResFormat((String)"\u5f53\u524d\u7ef4\u5ea6\u7ec4\u5408\u4e0e\u4e0a\u7ea7\u7ef4\u5ea6\u7ec4\u5408%1\u7684%2\u6743\u9650\u903b\u8f91\u4e0d\u4e00\u81f4", (String)"DimMembPermImportPlugin_66", (String)"epm-eb-formplugin", (Object[])new Object[]{key.replace("!1", "").replace("!2", ""), DimMembPermType.GIVE.getName()});
                                        this.putErrorMsg(row, errorMsg6);
                                        needInsertGive = false;
                                    } else {
                                        hasPerm = this.dimPermImportUtil.getPermFromDatabase(key, refDetailRecordMap, DimMembPermType.GIVE);
                                        if (hasPerm == null || !hasPerm.equals(true)) continue;
                                        errorNumber = this.transIdToNumber(key);
                                        errorMsg = ResManager.loadResFormat((String)"\u5f53\u524d\u7ef4\u5ea6\u7ec4\u5408\u4e0e\u4e0a\u7ea7\u7ef4\u5ea6\u7ec4\u5408%1\u7684%2\u6743\u9650\u903b\u8f91\u4e0d\u4e00\u81f4", (String)"DimMembPermImportPlugin_66", (String)"epm-eb-formplugin", (Object[])new Object[]{errorNumber, DimMembPermType.GIVE.getName()});
                                        this.putErrorMsg(row, errorMsg);
                                        needInsertGive = false;
                                    }
                                } else {
                                    Boolean hasPerm3 = this.dimPermImportUtil.getPermFromDatabase(key, refDetailRecordMap, DimMembPermType.GIVE);
                                    if (hasPerm3 == null || !hasPerm3.equals(true)) continue;
                                    String errorNumber3 = this.transIdToNumber(key);
                                    errorMsg4 = ResManager.loadResFormat((String)"\u5f53\u524d\u7ef4\u5ea6\u7ec4\u5408\u4e0e\u4e0a\u7ea7\u7ef4\u5ea6\u7ec4\u5408%1\u7684%2\u6743\u9650\u903b\u8f91\u4e0d\u4e00\u81f4", (String)"DimMembPermImportPlugin_66", (String)"epm-eb-formplugin", (Object[])new Object[]{errorNumber3, DimMembPermType.GIVE.getName()});
                                    this.putErrorMsg(row, errorMsg4);
                                    needInsertGive = false;
                                }
                                break;
                            }
                        }
                    }
                }
            }
            if (basePermValid) {
                Set<String> repeatPermKeys;
                if (!needInsertGive) {
                    permMap.put("give", databaseGive != null && databaseGive != false);
                }
                if (!needInsertInclude) {
                    permMap.put("include", databaseInclude != null && databaseInclude != false);
                }
                if (this.isDimensionGroup && CollectionUtils.isNotEmpty(repeatPermKeys = this.dimPermImportUtil.validRepeatPerm(rowKey, permMap, currentMemberMap, allFileRowDataMap, dataPermMap, dataMemberOrPropMap, allFilePermLevelMap, groupLevelSet, containProp))) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String repeatPermKey : repeatPermKeys) {
                        if (!StringUtils.isNotEmpty((CharSequence)repeatPermKey)) continue;
                        stringBuilder.append(repeatPermKey.replace("!1", "").replace("!2", "")).append("\u3001");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)stringBuilder)) {
                        String msg = ResManager.loadResFormat((String)"\u5f53\u524d\u7ef4\u5ea6\u6210\u5458\u4e0e\u7ef4\u5ea6\u6210\u5458%1\u6743\u9650\u8bbe\u7f6e\u4e00\u81f4\u4e14\u6210\u5458\u95f4\u5b58\u5728\u4e0a\u4e0b\u7ea7\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5", (String)"DimMembPermImportPlugin_71", (String)"epm-eb-formplugin", (Object[])new Object[]{stringBuilder.substring(0, stringBuilder.length() - 1)});
                        this.putErrorMsg(row, msg);
                        basePermValid = false;
                    }
                }
            }
            if (!basePermValid || !needInsertRead && !needInsertWrite && !needInsertGive) continue;
            DimMembPermDetailRecord[] permDetailRecords = null;
            ArrayList<String> dimNums = new ArrayList<String>(this.dimPermGroupSize == 0 ? 1 : this.dimPermGroupSize);
            if (this.dimPermGroupSize > 0) {
                dimNums.addAll(Arrays.asList(dimensionSplit));
            } else {
                dimNums.add(this.getPageCache().get("currentDimension"));
            }
            String dimShortNumsStr = DimMembPermUtil.getDimShortNumsStr((IModelCacheHelper)this.modelCacheHelper, dimNums, (boolean)false);
            if (mainPermRecord == null) {
                long mainId = GlobalIdUtil.genGlobalLongId();
                mainPermRecord = new DimMembPermRecord(Long.valueOf(mainId), this.getModelId(), dimShortNumsStr, Long.valueOf(userId), this.getBizModel(), PermGroupEnum.DATA, modifierId, new Timestamp(TimeServiceHelper.now().getTime()));
                String[] membOrPropIds = substring.split(SPLIT);
                permDetailRecords = new DimMembPermDetailRecord[this.dimPermGroupSize == 0 ? 1 : this.dimPermGroupSize];
                for (int i = 0; i < permDetailRecords.length; ++i) {
                    long entryId = GlobalIdUtil.genGlobalLongId();
                    String membOrPropId = membOrPropIds[i];
                    String[] split = membOrPropId.split("!");
                    boolean isMember = split[1].contains(RangeF7PropertyCataEnum.Member.getIndex());
                    Long viewId = 0L;
                    Member memberById = this.dimPermImportUtil.getSourceMemberById(dimSplit[i], IDUtils.toLong((Object)split[0]), this.modelCacheHelper, this.getBizModel(), this.accountIdMemberMap);
                    if (isMember && memberById instanceof ViewMember) {
                        viewId = ((ViewMember)memberById).getViewId();
                    }
                    permDetailRecords[i] = new DimMembPermDetailRecord(Long.valueOf(mainId), Long.valueOf(entryId), IDUtils.toLong((Object)split[0]), viewId, 0, seq, isMember, i);
                }
            } else {
                permDetailRecords = refDetailRecordMap.get(substring);
                if (permDetailRecords == null) {
                    permDetailRecords = new DimMembPermDetailRecord[this.dimPermGroupSize == 0 ? 1 : this.dimPermGroupSize];
                    String[] membOrPropIds = substring.split(SPLIT);
                    for (int i = 0; i < permDetailRecords.length; ++i) {
                        long entryId = GlobalIdUtil.genGlobalLongId();
                        String membOrPropId = membOrPropIds[i];
                        String[] split = membOrPropId.split("!");
                        boolean isMember = split[1].contains(RangeF7PropertyCataEnum.Member.getIndex());
                        Long viewId = 0L;
                        Member memberById = this.dimPermImportUtil.getSourceMemberById(dimSplit[i], IDUtils.toLong((Object)split[0]), this.modelCacheHelper, this.getBizModel(), this.accountIdMemberMap);
                        if (isMember && memberById instanceof ViewMember) {
                            viewId = ((ViewMember)memberById).getViewId();
                        }
                        permDetailRecords[i] = new DimMembPermDetailRecord(mainPermRecord.getId(), Long.valueOf(entryId), IDUtils.toLong((Object)split[0]), viewId, 0, seq, isMember, i);
                    }
                }
            }
            if (needInsertInclude) {
                this.insertFlag = true;
                this.dimPermImportUtil.setDetailRecord(permDetailRecords, DimMembPermType.DATAPERMEXTENDS, (Boolean)permMap.get("include"));
            }
            if (needInsertRead) {
                this.insertFlag = true;
                this.dimPermImportUtil.setDetailRecord(permDetailRecords, DimMembPermType.READ, (Boolean)permMap.get("read"));
            }
            if (needInsertWrite) {
                this.insertFlag = true;
                this.dimPermImportUtil.setDetailRecord(permDetailRecords, DimMembPermType.WRITE, (Boolean)permMap.get("write"));
            }
            if (needInsertGive) {
                this.insertFlag = true;
                this.dimPermImportUtil.setDetailRecord(permDetailRecords, DimMembPermType.GIVE, (Boolean)permMap.get("give"));
            }
            if ((allDetailRecords = mainPermRecord.getAllDetailRecords()) == null) {
                allDetailRecords = new HashMap<Integer, DimMembPermDetailRecord[]>(16);
                mainPermRecord.setAllDetailRecords(allDetailRecords);
            }
            allDetailRecords.put(permDetailRecords[0].getSeq(), permDetailRecords);
            ++seq;
        }
        if (mainPermRecord != null && this.insertFlag) {
            permList.add(mainPermRecord);
        }
    }

    private String transIdToNumber(String key) {
        String[] dimensions = this.dimPermGroupNumber.split(SPLIT);
        String[] split = key.split(SPLIT);
        StringBuilder memberNumber = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            String replace = split[i].replace("!1", "");
            Member memberById = this.dimPermImportUtil.getSourceMemberById(dimensions[i], Long.parseLong(replace), this.modelCacheHelper, this.getBizModel(), this.accountIdMemberMap);
            if (memberById == null) continue;
            memberNumber.append(memberById.getNumber()).append(SPLIT);
        }
        return memberNumber.substring(0, memberNumber.length() - 1);
    }

    private void initAccountMemberMap() {
        HashSet memberSet = new HashSet(16);
        Dimension dimension = this.modelCacheHelper.getDimension(SysDimensionEnum.Account.getNumber());
        String formType = this.getPageCache().get("formType");
        if (MEMBER.equals(formType)) {
            if (ModelUtil.isEbOrBgModel((Long)this.getModelId())) {
                memberSet.addAll(dimension.getAllMembers());
            } else {
                List datasetIds = DatasetServiceHelper.getInstance().getDataSetIdByBizModelId(this.getBizModel());
                for (Long datasetId : datasetIds) {
                    memberSet.addAll(dimension.getAllMembersByDataSetId(datasetId));
                }
            }
        } else {
            memberSet.addAll(dimension.getAllMembers());
        }
        for (Member member : memberSet) {
            this.accountMemberMap.put(member.getNumber(), member);
            this.accountIdMemberMap.put(member.getId(), member);
        }
    }

    private boolean validReadWriteLogic(Row row, Map<String, DimMembPermDetailRecord[]> refDetailRecordMap, String memberStr) {
        Cell readCell = this.fileImportUtils.getCell(row, this.dimPermGroupSize == 0 ? 8 : 4 + this.dimPermGroupSize * 4);
        Cell writeCell = this.fileImportUtils.getCell(row, this.dimPermGroupSize == 0 ? 9 : 5 + this.dimPermGroupSize * 4);
        String readStr = this.getPermStringCellValue(readCell);
        String writeStr = this.getPermStringCellValue(writeCell);
        Boolean read = StringUtils.isNotEmpty((CharSequence)readStr) && !StringUtils.equals((CharSequence)OTHER, (CharSequence)readStr) ? Boolean.valueOf(Boolean.parseBoolean(readStr)) : this.dimPermImportUtil.getPermFromDatabase(memberStr, refDetailRecordMap, DimMembPermType.READ);
        Boolean write = StringUtils.isNotEmpty((CharSequence)writeStr) && !StringUtils.equals((CharSequence)OTHER, (CharSequence)writeStr) ? Boolean.valueOf(Boolean.parseBoolean(writeStr)) : this.dimPermImportUtil.getPermFromDatabase(memberStr, refDetailRecordMap, DimMembPermType.WRITE);
        if (Boolean.TRUE.equals(write) && !Boolean.TRUE.equals(read)) {
            String errorMsg = ResManager.loadResFormat((String)"\u8bbe\u7f6e\u6570\u636e\u5199\u5165\u6743\u9650\u5fc5\u987b\u8bbe\u7f6e\u6570\u636e\u8bfb\u53d6\u6743\u9650\uff0c\u8be5\u884c\u6570\u636e\u5df2\u8df3\u8fc7\u5904\u7406", (String)"DimMembPermImportPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.putErrorMsg(row, errorMsg);
            return false;
        }
        return true;
    }

    private String getPermStringCellValue(Cell cell) {
        String stringCellValue = this.fileImportUtils.getCellStringValue(cell);
        if ("Y".equalsIgnoreCase(stringCellValue)) {
            return "true";
        }
        if ("N".equalsIgnoreCase(stringCellValue)) {
            return "false";
        }
        if (StringUtils.isEmpty((CharSequence)stringCellValue)) {
            return null;
        }
        return OTHER;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String insertFlag = this.getPageCache().get("insertFlag");
        if ("true".equals(insertFlag)) {
            this.getView().returnDataToParent((Object)ResManager.loadKDString((String)"\u90e8\u5206\u5bfc\u5165\u6210\u529f", (String)"DimMembPermImportPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private String getDimPermNumber() {
        return this.getPageCache().get("dimPermNumber");
    }

    private static /* synthetic */ void lambda$doValidMemberPerm$22(Set tempLevelSet, Member memb) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(memb.getLevel()).append("!");
        tempLevelSet.add(stringBuilder);
    }
}

