/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.perm;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.utils.PermControlDimUtil;
import kd.epm.eb.common.cache.DimMembPermVerHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.ebcommon.common.enums.dimension.SysDimensionEnum;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.membpermlog.EbMembPermLogHelper;
import kd.epm.eb.common.membpermlog.MembPermOpType;
import kd.epm.eb.common.membpermlog.MembPermType;
import kd.epm.eb.common.model.UserSelectModel;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.MembPermRecordUtil;
import kd.epm.eb.common.permission.enums.PermGroupEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserSelectServiceHelperNew;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.collections.CollectionUtils;

public class EbPermDimSettingPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String MODEL = "model";
    private static final String BTN_NEWENTRY = "newentry";
    private static final String BTN_DELETEENTRY = "deleteentry";
    private static final String BTN_SURE = "btn_sure";
    private static final String ENTRYENTITY = "entryentity";
    private static final String PERCONTROLDIM = "permcontroldim";
    private static final String INITPERMDIMROWS = "initPermDimRows";
    private static final Set<String> eb_noCheckDims = new HashSet<String>(Arrays.asList(SysDimensionEnum.Currency.getNumber(), SysDimensionEnum.Period.getNumber(), SysDimensionEnum.Year.getNumber(), SysDimensionEnum.InternalCompany.getNumber(), SysDimensionEnum.Scenario.getNumber(), SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.Process.getNumber()));
    private static final Set<String> bgmd_noCheckDims = new HashSet<String>(Arrays.asList(SysDimensionEnum.Currency.getNumber(), SysDimensionEnum.InternalCompany.getNumber(), "BudgetPeriod"));

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initModel();
        this.initEntry();
    }

    private void initEntry() {
        this.loadEntryData();
    }

    private Set<String> getSelectedDims() {
        HashSet<String> perControlDims = new HashSet<String>(16);
        DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRYENTITY);
        if (CollectionUtils.isNotEmpty((Collection)entity)) {
            for (DynamicObject dynamicObject : entity) {
                String dimNumber = dynamicObject.getString("permcontroldim.number");
                if (!StringUtils.isNotEmpty((String)dimNumber)) continue;
                perControlDims.add(dimNumber);
            }
        }
        return perControlDims;
    }

    private void loadEntryData() {
        Dimension dimension;
        this.getModel().deleteEntryData(ENTRYENTITY);
        if (IDUtils.isEmptyLong((Long)this.getModelId()).booleanValue()) {
            return;
        }
        List permControlDim = PermControlDimUtil.getPermControlDim((Long)this.getModelId());
        if (permControlDim.size() == 0 && (dimension = this.getIModelCacheHelper().getDimension("Entity")) != null) {
            permControlDim.add(dimension);
        }
        if (permControlDim.size() > 0) {
            if (this.isModelByEB()) {
                permControlDim.removeIf(e -> eb_noCheckDims.contains(e.getNumber()));
            } else {
                permControlDim.removeIf(e -> bgmd_noCheckDims.contains(e.getNumber()));
            }
        }
        HashSet<String> oldPermCtrlDims = new HashSet<String>(permControlDim.size());
        if (!permControlDim.isEmpty()) {
            IDataModel iDataModel = this.getModel();
            iDataModel.beginInit();
            int[] indexs = iDataModel.batchCreateNewEntryRow(ENTRYENTITY, permControlDim.size());
            for (int i = 0; i < permControlDim.size(); ++i) {
                int index = indexs[i];
                Dimension dimension2 = (Dimension)permControlDim.get(i);
                iDataModel.setValue(PERCONTROLDIM, (Object)dimension2.getId(), index);
                this.getView().setEnable(Boolean.FALSE, index, new String[]{PERCONTROLDIM});
                oldPermCtrlDims.add(dimension2.getNumber());
            }
            iDataModel.endInit();
            this.getView().updateView(ENTRYENTITY);
        }
        this.getOrCacheOldPermCtrlDims(oldPermCtrlDims);
    }

    private boolean isModelByEB() {
        boolean isModelByEB = false;
        IModelCacheHelper iModelCacheHelper = this.getIModelCacheHelper();
        if (iModelCacheHelper != null) {
            isModelByEB = iModelCacheHelper.getModelobj().isModelByEB();
        }
        return isModelByEB;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_SURE, BTN_NEWENTRY, BTN_DELETEENTRY});
        BasedataEdit model = (BasedataEdit)this.getControl(MODEL);
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dimension = (BasedataEdit)this.getControl(PERCONTROLDIM);
        dimension.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (MODEL.equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            ArrayList qFilterList = ((BasedataEdit)this.getControl(MODEL)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList();
            }
            qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView(), (boolean)true));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, "shownumber"));
        } else if (PERCONTROLDIM.equals(key)) {
            this.setDimFilter(e);
        }
    }

    private void setDimFilter(BeforeF7SelectEvent e) {
        if (IDUtils.isEmptyLong((Long)this.getModelId()).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"EbPermDimSettingPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(PERCONTROLDIM)).getQFilters();
        if (qFilterList == null) {
            qFilterList = new ArrayList<QFilter>();
        }
        qFilterList.add(new QFilter(MODEL, "=", (Object)this.getModelId()));
        qFilterList.add(new QFilter("number", "not in", this.getSelectedDims()));
        Set<String> noCheckDims = this.isModelByEB() ? eb_noCheckDims : bgmd_noCheckDims;
        qFilterList.add(new QFilter("number", "not in", noCheckDims));
        showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, "number"));
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String type = ((AbstractOperate)args.getSource()).getOperateKey();
        if (BTN_DELETEENTRY.equals(type)) {
            this.checkDelRows();
        }
    }

    private void checkDelRows() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        if (entryGrid.getSelectRows().length > 0) {
            String value;
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
            DynamicObject object = (DynamicObject)this.getModel().getValue(PERCONTROLDIM, entryCurrentRowIndex);
            String string = value = object != null ? object.getString("number") : null;
            if (StringUtils.isEmpty((String)value)) {
                this.getModel().deleteEntryRow(ENTRYENTITY, entryCurrentRowIndex);
            } else if (SysDimensionEnum.Entity.getNumber().equals(value)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7ef4\u5ea6\u9a8c\u6743\u4e3a\u9ed8\u8ba4\u503c\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"EbPermDimSettingPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (this.checkIsExistPermRecord(value)) {
                IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
                this.getView().showConfirm(ResManager.loadResFormat((String)"\u5f53\u524d\u7ef4\u5ea6\u201c%1\u201d\u5df2\u5b58\u5728\u6570\u636e\u6743\u9650\u6388\u6743\u8bb0\u5f55\u3002\u5220\u9664\u6743\u9650\u63a7\u5236\u7ef4\u5ea6\u540e\uff0c\u5c06\u4e0d\u518d\u6821\u9a8c\u8be5\u7ef4\u5ea6\u7684\u6570\u636e\u8bfb\u5199\u7b49\u76f8\u5173\u6743\u9650\uff0c\u786e\u8ba4\u8981\u5220\u9664\u5417\uff1f", (String)"EbPermDimSettingPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{modelCache.getDimension(value).getName()}), MessageBoxOptions.YesNo, new ConfirmCallBackListener("confirmDel", (IFormPlugin)this));
            } else {
                this.delRow();
            }
        }
    }

    private boolean checkIsExistPermRecord(String dimNumber) {
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Dimension dimension = modelCacheHelper.getDimension(dimNumber);
        if (dimension != null) {
            Long modelId = this.getModelId();
            Set dimShortNumStrs = DimMembPermUtil.getRefDimShortNums((Collection)Sets.newHashSet((Object[])new Long[]{dimension.getId()}), (Long)modelId);
            Set mainRecordIds = MembPermRecordUtil.getMainRecordIdByDims((Long)modelId, (Set)dimShortNumStrs, (PermGroupEnum)PermGroupEnum.DATA);
            return !mainRecordIds.isEmpty();
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String key = evt.getCallBackId();
        if ("confirmDel".equals(key) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.delRow();
        }
    }

    private void delRow() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        this.getModel().deleteEntryRow(ENTRYENTITY, entryCurrentRowIndex);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_SURE.equals(key)) {
            this.dealSave();
        }
    }

    private void dealSave() {
        if (IDUtils.isEmptyLong((Long)this.getModelId()).booleanValue()) {
            return;
        }
        Set<String> perControlDims = this.getSelectedDims();
        try (TXHandle th = TX.required((String)"SavePermControlDim");){
            try {
                PermControlDimUtil.savePermControlDim((Long)this.getModelId(), (String)String.join((CharSequence)"!", perControlDims));
                this.updateMembPermInfo(perControlDims);
            }
            catch (Exception e) {
                th.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(perControlDims));
        this.getView().close();
    }

    private Set<String> getOrCacheOldPermCtrlDims(Set<String> permCtrlDims) {
        if (permCtrlDims == null) {
            String cacheStr = this.getPageCache().get("OldPermCtrlDims");
            permCtrlDims = !this.isEmptyStr(cacheStr) ? (HashSet)SerializationUtils.fromJsonString((String)cacheStr, HashSet.class) : new HashSet(16);
        } else {
            this.getPageCache().put("OldPermCtrlDims", SerializationUtils.toJsonString(permCtrlDims));
        }
        return permCtrlDims;
    }

    private void updateMembPermInfo(Set<String> newPermControlDims) {
        Set<String> oldPermCtrlDims = this.getOrCacheOldPermCtrlDims(null);
        HashSet<String> newAddDims = new HashSet<String>(16);
        for (String dimNum : newPermControlDims) {
            if (oldPermCtrlDims.remove(dimNum)) continue;
            newAddDims.add(dimNum);
        }
        if (this.isNotEmptyColl(oldPermCtrlDims) || this.isNotEmptyColl(newAddDims)) {
            StringBuilder newDimNameStr = new StringBuilder();
            StringBuilder delDimNameStr = new StringBuilder();
            IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
            List dimensionList = modelCacheHelper.getDimensionList();
            ArrayList<Long> toUpVerDimIds = new ArrayList<Long>(16);
            HashSet<Long> toDelRecordDimIds = new HashSet<Long>(16);
            HashSet<String> toDelRecordDimNums = new HashSet<String>(16);
            for (Dimension dimension : dimensionList) {
                if (oldPermCtrlDims.contains(dimension.getNumber())) {
                    toUpVerDimIds.add(dimension.getId());
                    toDelRecordDimIds.add(dimension.getId());
                    toDelRecordDimNums.add(dimension.getNumber());
                    delDimNameStr.append(dimension.getName()).append(',');
                    continue;
                }
                if (!newAddDims.contains(dimension.getNumber())) continue;
                toUpVerDimIds.add(dimension.getId());
                newDimNameStr.append(dimension.getName()).append(',');
            }
            DimMembPermVerHelper.updateVer4BatDimension(toUpVerDimIds, (Long)this.getModelId(), (boolean)true);
            if (this.isNotEmptyColl(toDelRecordDimIds)) {
                MembPermRecordUtil.delPermRecordByDims((Long)this.getModelId(), toDelRecordDimIds, (PermGroupEnum)PermGroupEnum.DATA);
                EbMembPermLogHelper.addOpLog((Long)this.getModelId(), null, (Long)0L, (Long)0L, (MembPermType)MembPermType.DAG, (String)("delByDimsOnPermDimSet->refDimNums:" + SerializationUtils.toJsonString(toDelRecordDimNums)), (MembPermOpType)MembPermOpType.DEL);
            }
            this.writeOpLog(newDimNameStr, delDimNameStr);
        }
    }

    private void writeOpLog(StringBuilder newDimNameStr, StringBuilder delDimNameStr) {
        try {
            String modelNumber = (String)this.getValue(MODEL, "shownumber");
            String allStr = "";
            if (newDimNameStr.length() > 0 && delDimNameStr.length() > 0) {
                newDimNameStr.setLength(newDimNameStr.length() - 1);
                delDimNameStr.setLength(delDimNameStr.length() - 1);
                allStr = ResManager.loadResFormat((String)"\u589e\u52a0\u4e86\u7ef4\u5ea6\u201c%1\u201d\uff0c\u5220\u9664\u4e86\u7ef4\u5ea6\u201c%2\u201d", (String)"EbPermDimSettingPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[]{newDimNameStr.toString(), delDimNameStr.toString()});
            } else if (newDimNameStr.length() > 0 && delDimNameStr.length() <= 0) {
                newDimNameStr.setLength(newDimNameStr.length() - 1);
                allStr = ResManager.loadResFormat((String)"\u589e\u52a0\u4e86\u7ef4\u5ea6\u201c%1\u201d", (String)"EbPermDimSettingPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{newDimNameStr.toString()});
            } else if (newDimNameStr.length() <= 0 && delDimNameStr.length() > 0) {
                newDimNameStr.setLength(newDimNameStr.length() - 1);
                allStr = ResManager.loadResFormat((String)"\u5220\u9664\u4e86\u7ef4\u5ea6\u201c%1\u201d", (String)"EbPermDimSettingPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[]{delDimNameStr.toString()});
            }
            this.writeLog(null, "save", new MultiLangEnumBridge("\u786e\u5b9a", "EbPermDimSettingPlugin_4", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5bf9\u4f53\u7cfb\u201c%1$s\u201d\u7684\u6388\u6743\u7ef4\u5ea6%2$s\u7684\u64cd\u4f5c", "EbPermDimSettingPlugin_5", "epm-eb-formplugin"), new String[]{modelNumber, allStr});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String itemKey = e.getProperty().getName();
        if (MODEL.equals(itemKey)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newValue != null) {
                this.getView().getPageCache().put(MODEL, newValue.getString("id"));
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)this.getModelId());
            } else {
                this.getView().getPageCache().remove(MODEL);
            }
            this.initEntry();
        }
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getView().getPageCache().get(MODEL));
    }

    private void initModel() {
        UserSelectModel userSelect;
        this.getView().setEnable(Boolean.valueOf(false), new String[]{MODEL});
        Long modelId = (Long)this.getCustomFormParam("modelId");
        if (this.isEmpty(modelId) && (userSelect = UserSelectServiceHelperNew.getUserSelect((Long)UserUtils.getUserId(), (String)"id,model,application,entity,period,currency,modifier,onlymodel,formid,date,version,bizmodel,modeltype", (ApplicationTypeEnum)ApplicationTypeEnum.BGMD, (IFormView)this.getView())) != null) {
            modelId = userSelect.getModel();
        }
        if (IDUtils.isNotNull((Long)modelId) && ModelServiceHelper.isUserHasRootPermByModel((long)UserUtils.getUserId(), (Long)modelId)) {
            this.getModel().setValue(MODEL, (Object)modelId);
            this.getView().getPageCache().put(MODEL, modelId.toString());
            return;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"EbPermDimSettingPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }
}

