/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.perm;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.membpermlog.MembPermOpType;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.MembPermRecordUtil;
import kd.epm.eb.common.permission.enums.PermGroupEnum;
import kd.epm.eb.common.permission.pojo.BatchPermSaveArgs;
import kd.epm.eb.common.permission.pojo.DimMembPermRecord;
import kd.epm.eb.common.permission.pojo.PermCopyFormParam;
import kd.epm.eb.common.permission.pojo.PermDimGroup;
import kd.epm.eb.common.permission.pojo.UserInfo;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class MembPermCopyPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String BTN_SURE = "btn_sure";
    private static final String bcr_key = "bizctrlrange";
    private static final String model_key = "model";
    private static final String s_user_key = "s_user";
    private static final String t_user_key = "t_user";
    private static final String s_userType_key = "s_usertype";
    private static final String t_userType_key = "t_usertype";
    private static final String dimList_key = "dimlist";
    private static final String userSelectSign = "_selectUser";
    private static final String userEntryKey = "userentry";
    private PermCopyFormParam permParam = null;
    private static final Log log = LogFactory.getLog(MembPermCopyPlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addClickListeners(new String[]{BTN_SURE});
        this.addF7SelectListener(this, new String[]{bcr_key});
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String proName = beforeF7SelectEvent.getProperty().getName();
        if (bcr_key.equals(proName)) {
            this.addBCRF7Filter(beforeF7SelectEvent);
        }
    }

    private void addBCRF7Filter(BeforeF7SelectEvent beforeF7SelectEvent) {
        Long modelId = this.getModelId();
        List customQFilters = beforeF7SelectEvent.getCustomQFilters();
        customQFilters.add(new QFilter(model_key, "=", (Object)modelId));
    }

    public void afterCreateNewData(EventObject e) {
        this.initBaseInfo();
        this.updateDimList();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        if (bcr_key.equals(proName)) {
            this.updateDimList();
        }
    }

    private void updateDimList() {
        List<BasedataPojo> dimensionList = this.getDimAndGroupListToShow();
        ComboEdit comboEdit = (ComboEdit)this.getControl(dimList_key);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        for (BasedataPojo dimension : dimensionList) {
            items.add(new ComboItem(new LocaleString(dimension.getName()), dimension.getNumber()));
        }
        comboEdit.setComboItems(items);
        this.getModel().setValue(dimList_key, null);
    }

    private List<Dimension> getDimListToShow() {
        ArrayList<Dimension> dimensionList;
        PermCopyFormParam permParam = this.getPermParam();
        boolean isNewEb = this.isNewEbForm();
        if (permParam.getPermGroup() == PermGroupEnum.MANAGER) {
            IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
            List dimensions = modelCacheHelper.getDimensionList();
            dimensionList = new ArrayList<Dimension>(dimensions);
            dimensionList.removeIf(dim -> DimMembPermHelper.noCheckDimsOnManPerm.contains(dim.getNumber()) || SysDimensionEnum.Process.getNumber().equals(dim.getNumber()) || SysDimensionEnum.Scenario.getNumber().equals(dim.getNumber()) || isNewEb && SysDimensionEnum.InternalCompany.getNumber().equals(dim.getNumber()));
        } else {
            dimensionList = DimMembPermUtil.getPermControlDim((Long)this.getModelId());
            Set<Long> selectedBCRIds = this.getSelectedBCRIds();
            Map refDimsByBCRIds = BusinessModelServiceHelper.getRefDimsByBCRIds(selectedBCRIds);
            Iterator dimensionIterator = dimensionList.iterator();
            while (dimensionIterator.hasNext()) {
                Dimension dimension = (Dimension)dimensionIterator.next();
                String dimNum = dimension.getNumber();
                boolean allContains = true;
                for (Set dimIds : refDimsByBCRIds.values()) {
                    if (dimIds.contains(dimension.getId())) continue;
                    allContains = false;
                    break;
                }
                if ((allContains || SysDimensionEnum.Account.getNumber().equals(dimNum)) && !SysDimensionEnum.Process.getNumber().equals(dimNum) && !SysDimensionEnum.Scenario.getNumber().equals(dimNum) && (!isNewEb || !SysDimensionEnum.InternalCompany.getNumber().equals(dimNum))) continue;
                dimensionIterator.remove();
            }
        }
        return dimensionList;
    }

    private List<BasedataPojo> getDimAndGroupListToShow() {
        PermCopyFormParam permParam = this.getPermParam();
        List<Dimension> dimensionList = this.getDimListToShow();
        LinkedList<BasedataPojo> result = new LinkedList<BasedataPojo>();
        if (dimensionList.size() > 0) {
            HashSet dimNums = new HashSet(16);
            dimensionList.forEach(dim -> {
                dimNums.add(dim.getNumber());
                result.add(new BasedataPojo(dim.getId(), dim.getName(), DimMembPermUtil.getDimShortNumsStr((String)dim.getShortNumber())));
            });
            if (permParam.getPermGroup() != PermGroupEnum.MANAGER) {
                List permControlDimGroup = DimMembPermUtil.getPermControlDimGroup((Long)this.getModelId());
                permControlDimGroup.forEach(dimGroup -> {
                    for (BasedataPojo dimObj : dimGroup.getDimGroup()) {
                        if (dimNums.contains(dimObj.getNumber())) continue;
                        return;
                    }
                    result.add(new BasedataPojo(dimGroup.getId(), dimGroup.getName(), dimGroup.getDimShortNumStr()));
                });
            }
        }
        return result;
    }

    private Set<Long> getSelectedTargetUsers() {
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity(userEntryKey);
        HashSet<Long> result = new HashSet<Long>(entryRows.size());
        entryRows.forEach(row -> {
            DynamicObject uObj = row.getDynamicObject(t_user_key);
            if (uObj != null) {
                result.add(uObj.getLong("id"));
            }
        });
        return result;
    }

    private String getSelectedTargetUserStr() {
        StringBuilder sb = new StringBuilder();
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity(userEntryKey);
        entryRows.forEach(row -> {
            DynamicObject uObj = row.getDynamicObject(t_user_key);
            if (uObj != null) {
                sb.append(uObj.getString("number")).append(',');
            }
        });
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private Set<String> getSelectedDimShortStr() {
        HashSet<String> result = new HashSet<String>(16);
        String dimsStr = (String)this.getValue(dimList_key, null);
        if (this.notEmpty(dimsStr)) {
            for (String shortNumStr : dimsStr.split(",")) {
                if (!this.notEmpty(shortNumStr)) continue;
                result.add(shortNumStr);
            }
        }
        return result;
    }

    private Set<Long> getSelectedBCRIds() {
        HashSet<Long> result = new HashSet<Long>(16);
        if (this.needBizCtrlRange()) {
            DynamicObjectCollection objs = (DynamicObjectCollection)this.getValue(bcr_key, null);
            if (objs != null) {
                objs.forEach(obj -> result.add(obj.getLong("fbasedataid.id")));
            }
        } else {
            result.add(0L);
        }
        return result;
    }

    private String getSelectedBCRNumStr() {
        DynamicObjectCollection objs;
        StringBuilder sb = new StringBuilder();
        if (this.needBizCtrlRange() && (objs = (DynamicObjectCollection)this.getValue(bcr_key, null)) != null) {
            objs.forEach(obj -> sb.append(obj.getString("fbasedataid.name")).append(','));
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private boolean needBizCtrlRange() {
        PermCopyFormParam permParam = this.getPermParam();
        return permParam.getPermGroup() == PermGroupEnum.DATA && !permParam.isEbModel();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("seluser".equals(itemKey)) {
            this.openUserListForm(true);
        } else if ("selusergrouop".equals(itemKey)) {
            this.openUserListForm(false);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String btnKey = ((Control)evt.getSource()).getKey();
        if (BTN_SURE.equals(btnKey)) {
            this.doCopyPerm();
        }
    }

    private void doCopyPerm() {
        Set<Long> selectedBCRIds = this.getSelectedBCRIds();
        Set<String> selectedDimShortStr = this.getSelectedDimShortStr();
        Set<Long> selectedTargetUsers = this.getSelectedTargetUsers();
        if (this.isEmpty(selectedBCRIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"MembPermCopyPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.isEmpty(selectedDimShortStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6/\u7ef4\u5ea6\u7ec4\u5408\u3002", (String)"MembPermCopyPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.isEmpty(selectedTargetUsers)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u7528\u6237\u6216\u7528\u6237\u7ec4\u3002", (String)"MembPermCopyPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        PermCopyFormParam permParam = this.getPermParam();
        selectedTargetUsers.add(permParam.getSourceUserId());
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        HashSet tagetUserRefMainRecord = new HashSet(16);
        Long cUser = UserUtils.getUserId();
        Timestamp now = new Timestamp(TimeServiceHelper.now().getTime());
        HashMap mainPermRecord = new HashMap(16);
        for (String string : selectedDimShortStr) {
            List dimNumsByShortStr = DimMembPermUtil.getDimNumsByShortStr((String)string, (IModelCacheHelper)modelCacheHelper);
            if (this.isEmpty(dimNumsByShortStr)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u76f8\u5173\u7ef4\u5ea6\uff1a%s\u4e0d\u5b58\u5728\u3002", (String)"MembPermCopyPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[]{string}));
                return;
            }
            Map allRecord = MembPermRecordUtil.getPermRecordByBizModels((IModelCacheHelper)modelCacheHelper, selectedBCRIds, (List)dimNumsByShortStr, selectedTargetUsers, (PermGroupEnum)permParam.getPermGroup(), (boolean)false, (boolean)false);
            allRecord.values().forEach(allDimGroupPerm -> allDimGroupPerm.forEach((shortNumStr, userPermRecords) -> {
                if (string.equals(shortNumStr)) {
                    userPermRecords.forEach((userId, permRecord) -> {
                        if (!permParam.getSourceUserId().equals(userId)) {
                            tagetUserRefMainRecord.add(permRecord.getId());
                        } else {
                            mainPermRecord.put(permRecord.getId(), permRecord);
                        }
                    });
                }
            }));
        }
        MembPermRecordUtil.fillDetailRecord(mainPermRecord);
        if (mainPermRecord.size() > 0 || tagetUserRefMainRecord.size() > 0) {
            LinkedList<DimMembPermRecord> toSaveMainRecord = new LinkedList<DimMembPermRecord>();
            selectedTargetUsers.remove(permParam.getSourceUserId());
            for (Long targetUser : selectedTargetUsers) {
                for (DimMembPermRecord permRecord : mainPermRecord.values()) {
                    DimMembPermRecord newMainRecord = permRecord.cloneObj();
                    newMainRecord.setUid(targetUser);
                    newMainRecord.setModifierId(cUser);
                    newMainRecord.setModifytime(now);
                    toSaveMainRecord.add(newMainRecord);
                }
            }
            UserInfo userInfo = UserUtils.getUserInfo((Long)permParam.getSourceUserId());
            String logInfo = "sourceUser:" + (userInfo == null ? permParam.getSourceUserId() : userInfo.getName());
            BatchPermSaveArgs saveArgs = new BatchPermSaveArgs(tagetUserRefMainRecord, toSaveMainRecord, selectedTargetUsers, selectedDimShortStr, selectedBCRIds, permParam.getModelId(), MembPermOpType.COPY);
            saveArgs.setLogInfo(logInfo);
            MembPermRecordUtil.batchSavePermRecord((BatchPermSaveArgs)saveArgs);
            this.writeOpLog(selectedDimShortStr);
            this.getView().returnDataToParent((Object)"ok");
            this.getView().close();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u590d\u5236\u7684\u6743\u9650\u8bb0\u5f55\u3002", (String)"MembPermCopyPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void writeOpLog(Set<String> selectedDimShortStr) {
        try {
            String selectedBCRNumStr = this.getSelectedBCRNumStr();
            String selectedTargetUserStr = this.getSelectedTargetUserStr();
            Map<String, String> dimGroupMap = DimMembPermUtil.getPermControlDimGroup((Long)this.getModelId()).stream().collect(Collectors.toMap(PermDimGroup::getDimShortNumStr, PermDimGroup::getName));
            IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
            Map<String, String> dimShortNumStrMap = modelCacheHelper.getDimensionList().stream().collect(Collectors.toMap(d1 -> DimMembPermUtil.getDimShortNumsStr((String)d1.getShortNumber()), BaseCache::getName));
            StringBuilder dimInfo = new StringBuilder();
            selectedDimShortStr.forEach(dimShortStr -> {
                String name = (String)dimShortNumStrMap.get(dimShortStr);
                if (name == null) {
                    name = (String)dimGroupMap.get(dimShortStr);
                }
                dimInfo.append(name).append(',');
            });
            if (dimInfo.length() > 0) {
                dimInfo.setLength(dimInfo.length() - 1);
            }
            PermCopyFormParam permParam = this.getPermParam();
            String permType = ResManager.loadKDString((String)"\u6210\u5458%s\u6743\u9650", (String)"MembPermCopyPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[]{permParam.getPermGroup().getName()});
            String modelNumber = (String)this.getValue(model_key, "shownumber");
            if (this.notEmpty(selectedBCRNumStr)) {
                this.writeLog(null, "copy", new MultiLangEnumBridge("\u590d\u5236", "MembPermCopyPlugin_5", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5bf9\u7528\u6237/\u7528\u6237\u7ec4\u201c%1$s\u201d\u8fdb\u884c\u4f53\u7cfb\u201c%2$s\u201d\u3001\u4e1a\u52a1\u6a21\u578b\u201c%3$s\u201c\u3001\u7ef4\u5ea6/\u7ef4\u5ea6\u7ec4\u5408\u201c%4$s\u201d\u7684%5$s\u64cd\u4f5c", "MembPermCopyPlugin_6", "epm-eb-formplugin"), new String[]{selectedTargetUserStr, modelNumber, selectedBCRNumStr, dimInfo.toString(), permType});
            } else {
                this.writeLog(null, "copy", new MultiLangEnumBridge("\u590d\u5236", "MembPermCopyPlugin_5", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5bf9\u7528\u6237/\u7528\u6237\u7ec4\u201c%1$s\u201d\u8fdb\u884c\u4f53\u7cfb\u201c%2$s\u201d\u3001\u7ef4\u5ea6/\u7ef4\u5ea6\u7ec4\u5408\u201c%3$s\u201d\u7684%4$s\u64cd\u4f5c", "MembPermCopyPlugin_7", "epm-eb-formplugin"), new String[]{selectedTargetUserStr, modelNumber, dimInfo.toString(), permType});
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private void openUserListForm(boolean isUser) {
        String userType = isUser ? "bos_user" : "bos_usergroup";
        ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)userType, (boolean)true);
        List<Long> ignoreUsers = this.getIgnoreUsers();
        List qFilters = showListForm.getListFilterParameter().getQFilters();
        qFilters.add(new QFilter("id", "not in", ignoreUsers));
        String callBackKey = userType + userSelectSign;
        showListForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackKey));
        this.getView().showForm((FormShowParameter)showListForm);
    }

    private List<Long> getIgnoreUsers() {
        ArrayList<Long> userIds = new ArrayList<Long>(16);
        PermCopyFormParam permParam = this.getPermParam();
        Set managers = ModelServiceHelper.getManagersByModel((Long)permParam.getModelId(), (boolean)true, (boolean)true);
        Set<Long> selectedTargetUsers = this.getSelectedTargetUsers();
        userIds.addAll(managers);
        userIds.addAll(selectedTargetUsers);
        userIds.add(permParam.getSourceUserId());
        return userIds;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (actionId.endsWith(userSelectSign)) {
            this.fillBackUsers(actionId, returnData);
        }
    }

    private void fillBackUsers(String actionId, Object selectedUsers) {
        if (this.notEmpty(selectedUsers)) {
            String userType = actionId.replace(userSelectSign, "");
            ListSelectedRowCollection rows = (ListSelectedRowCollection)selectedUsers;
            IDataModel dataModel = this.getModel();
            int[] newRowIndexs = dataModel.batchCreateNewEntryRow(userEntryKey, rows.size());
            for (int i = 0; i < newRowIndexs.length && i < rows.size(); ++i) {
                ListSelectedRow selectedRow = rows.get(i);
                dataModel.setValue(t_userType_key, (Object)userType, newRowIndexs[i]);
                dataModel.setValue(t_user_key, selectedRow.getPrimaryKeyValue(), newRowIndexs[i]);
            }
        }
    }

    private void initBaseInfo() {
        FieldEdit dimList;
        DynamicObject defObj;
        PermCopyFormParam permParam = this.getPermParam();
        this.getModel().setValue(model_key, (Object)permParam.getModelId());
        UserInfo userInfo = UserUtils.getUserInfo((Long)permParam.getSourceUserId());
        String userType = userInfo == null ? "bos_usergroup" : "bos_user";
        this.getModel().setValue(s_userType_key, (Object)userType);
        this.getModel().setValue(s_user_key, (Object)permParam.getSourceUserId());
        if (PermGroupEnum.MANAGER == permParam.getPermGroup() || !ModelServiceHelper.isBGMDModel((Long)permParam.getModelId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{bcr_key});
        }
        if (this.isNewEbForm() && PermGroupEnum.MANAGER != permParam.getPermGroup() && (defObj = NewEbAppUtil.getDefaultObj((String)"eb_businessmodel", (Long)permParam.getModelId())) != null) {
            this.getModel().setValue(bcr_key, (Object)new Object[]{defObj.getLong("id")});
        }
        if (PermGroupEnum.MANAGER != permParam.getPermGroup() && (dimList = (FieldEdit)this.getControl(dimList_key)) != null) {
            dimList.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7ef4\u5ea6/\u7ef4\u5ea6\u7ec4\u5408", (String)"MembPermCopyPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        }
    }

    @Override
    public Long getModelId() {
        Object modelId = this.getValue(model_key, "id");
        return ConvertUtils.toLong((Object)modelId);
    }

    private PermCopyFormParam getPermParam() {
        if (this.permParam == null) {
            String sourceInfoStr = (String)this.getView().getFormShowParameter().getCustomParam("sourceInfo");
            this.permParam = this.isEmpty(sourceInfoStr) ? new PermCopyFormParam() : (PermCopyFormParam)SerializationUtils.fromJsonString((String)sourceInfoStr, PermCopyFormParam.class);
        }
        return this.permParam;
    }
}

