/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.perm;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.model.utils.ModelUtil;

public class MembPermSearchPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String entryentity = "entryentity";

    @Override
    public void registerListener(EventObject e) {
        this.addF7SelectListener(this, new String[]{"dimension", "bizrange", "model"});
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"groupmember"});
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String f7Key;
        switch (f7Key = beforeF7SelectEvent.getProperty().getName()) {
            case "dimension": 
            case "bizrange": {
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("model", "=", (Object)this.getModelId()));
                break;
            }
            case "model": {
                List modelFilter = ModelUtil.getModelFilter((IFormView)this.getView());
                beforeF7SelectEvent.getCustomQFilters().addAll(modelFilter);
            }
        }
    }

    @Override
    public Long getModelId() {
        Long modelId = (Long)this.getValue("model", "id");
        if (modelId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"MembPermSearchPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return modelId;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propKey = e.getProperty().getName();
        Object newVal = e.getChangeSet()[0].getNewValue();
        switch (propKey) {
            case "model": {
                this.getModel().setValue("dimension", null);
                this.getModel().setValue("bizrange", null);
                this.setBizCtrlRangeView();
                this.updateMemberGroupEntity();
                break;
            }
            case "user": {
                if (newVal == null) break;
                this.getModel().setValue("usergroup", null);
                break;
            }
            case "usergroup": {
                if (newVal == null) break;
                this.getModel().setValue("user", null);
                break;
            }
            case "groupmember": {
                if (!this.isEmpty(newVal)) break;
                int rowIndex = this.getModel().getEntryCurrentRowIndex("membergroupentity");
                this.getModel().setValue("groupmembid", null, rowIndex);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "search": {
                this.searchPerm();
                break;
            }
            case "clean": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u6e05\u9664\u6240\u6709\u4f53\u7cfb\u7684\u6210\u5458\u6743\u9650\u7f13\u5b58\uff1f", (String)"MembPermSearchPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("cleanPermCache", (IFormPlugin)this));
                break;
            }
            case "btn_checkperm": {
                this.checkMemberGroupPerm();
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = this.getClickCtrlKey(evt);
        if ("groupmember".equals(key)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("membergroupentity");
            Long modelId = this.getModelId();
            String dimNum = (String)this.getModel().getValue("groupdimnum", rowIndex);
            MemberF7Parameter f7Parameter = NewF7Utils.multipleF8((Long)this.getModelId(), (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNum), (String)ListSelectedRow.class.getName());
            f7Parameter.setBusModelId(this.getbizModelId());
            f7Parameter.setCanSelectRoot(true);
            f7Parameter.setShowCustomProperty(true);
            f7Parameter.setLockRangeSelect(true);
            f7Parameter.setDefRangeValue(RangeEnum.ALL);
            f7Parameter.setShowAnalyseMember(true);
            NewF7Utils.openF8((IFormView)this.getView(), (MemberF7Parameter)f7Parameter, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "groupmember"));
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("groupmember".equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("membergroupentity");
            String currentNumVal = (String)this.getModel().getValue("groupmember", rowIndex);
            String currentIdVal = (String)this.getModel().getValue("groupmembid", rowIndex);
            HashSet<String> ids = new HashSet<String>(16);
            HashSet<String> numbers = new HashSet<String>(16);
            if (this.notEmpty(currentIdVal)) {
                for (String id : currentIdVal.split(",")) {
                    ids.add(id);
                }
            }
            if (this.notEmpty(currentNumVal)) {
                for (String num : currentNumVal.split(",")) {
                    numbers.add(num);
                }
            }
            ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            rows.forEach(row -> {
                ids.add(row.getPrimaryKeyValue().toString());
                numbers.add(row.getNumber());
            });
            this.getModel().setValue("groupmember", (Object)String.join((CharSequence)",", numbers), rowIndex);
            this.getModel().setValue("groupmembid", (Object)String.join((CharSequence)",", ids), rowIndex);
            this.getModel().setValue("checkpermdim", (Object)true, rowIndex);
        }
    }

    private Long getbizModelId() {
        return (Long)this.getValue("bizrange", "id");
    }

    private void checkMemberGroupPerm() {
        Long modelId = this.getModelId();
        Long bizRangeId = this.getbizModelId();
        String permTypeNum = (String)this.getValue("permtype", null);
        if (this.isEmpty(modelId) || this.isEmpty(permTypeNum) || ModelServiceHelper.isBGMDModel((Long)modelId) && this.isEmpty(bizRangeId)) {
            return;
        }
        Long userId = (Long)this.getValue("user", "id");
        Long userGrouopId = (Long)this.getValue("usergroup", "id");
        if (this.isEmpty(userGrouopId) && this.isEmpty(userId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7528\u6237\u6216\u7528\u6237\u7ec4\u3002", (String)"MembPermSearchPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DimMembPermType permTypeEnum = DimMembPermType.valueOf((String)permTypeNum);
        DynamicObjectCollection memberRows = this.getModel().getEntryEntity("membergroupentity");
        ArrayList members = new ArrayList(memberRows.size());
        ArrayList<String> dimNums = new ArrayList<String>(memberRows.size());
        ArrayList<String> toCheckDimNums = new ArrayList<String>(memberRows.size());
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelId);
        IModelCacheHelper iModelCacheHelper = this.getIModelCacheHelper();
        Map<String, Dimension> dimensionMap = this.isEmpty(bizRangeId) ? iModelCacheHelper.getDimensionList().stream().collect(Collectors.toMap(BaseCache::getNumber, dim -> dim)) : iModelCacheHelper.getDimensionListByBusModel(bizRangeId).stream().collect(Collectors.toMap(BaseCache::getNumber, dim -> dim));
        Map viewsByBusModel = iModelCacheHelper.getViewsByBusModel(bizRangeId);
        for (DynamicObject row : memberRows) {
            String memberStr;
            Dimension dimension = dimensionMap.get(row.getString("groupdimnum"));
            if (dimension == null) continue;
            if (row.getBoolean("checkpermdim")) {
                toCheckDimNums.add(dimension.getNumber());
            }
            if (!this.notEmpty(memberStr = row.getString("groupmembid"))) continue;
            dimNums.add(dimension.getNumber());
            ArrayList<MemberObj> memberItems = new ArrayList<MemberObj>(16);
            Long viewId = (Long)viewsByBusModel.get(dimension.getNumber());
            for (String membId : memberStr.split(",")) {
                Long id = Long.valueOf(membId);
                Member member = dimension.getMember(viewId, id);
                if (member != null) {
                    memberItems.add(new MemberObj(id, member.getNumber(), member.getName(), true));
                    continue;
                }
                CustomPropertyValue propertyValue = memberPropCache.getPropertyValue(dimension.getNumber(), id);
                if (propertyValue == null) continue;
                memberItems.add(new MemberObj(id, propertyValue.getNumber(), propertyValue.getName(), false));
            }
            members.add(memberItems);
        }
        if (toCheckDimNums.isEmpty()) {
            return;
        }
        DimMemberPermChecker permChecker = DimMembPermHelper.getPermChecker((Long)modelId, (Long)bizRangeId, toCheckDimNums, (permTypeEnum == DimMembPermType.GIVE ? 1 : 0) != 0, (Long)(userId == null ? userGrouopId : userId), (DimMembPermType)permTypeEnum);
        if (permChecker.hasAllPerm()) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5f53\u524d\u7528\u6237/\u7528\u6237\u7ec4\u662f\u5f53\u524d\u4f53\u7cfb\u7684\u7ba1\u7406\u5458\u6216\u5f53\u524d\u7ef4\u5ea6\u4e0d\u63a7\u5236\u201c%1\u201d\u6743\u9650\u3002", (String)"MembPermSearchPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{permTypeEnum.getName()}));
        } else {
            this.getModel().deleteEntryData(entryentity);
            DynamicObjectCollection permMemberRows = this.getModel().getEntryEntity(entryentity);
            HashMap memberItemMap = new HashMap();
            StringBuilder nameBuilder = new StringBuilder();
            StringBuilder numbreBuilder = new StringBuilder();
            StringBuilder idBuilder = new StringBuilder();
            boolean checkHasPerm = (Boolean)this.getValue("needhasperm", null);
            CommonServiceHelper.buildDescartes(members, memberGroup -> {
                for (int i = 0; i < dimNums.size(); ++i) {
                    MemberObj memberObj = (MemberObj)memberGroup.get(i);
                    memberItemMap.put(dimNums.get(i), new MemberItem(memberObj.isMember, memberObj.getId()));
                }
                boolean hasPerm = permChecker.check(memberItemMap);
                if (checkHasPerm && hasPerm || !checkHasPerm && !hasPerm) {
                    DynamicObject newRow = permMemberRows.addNew();
                    memberGroup.forEach(memb -> {
                        nameBuilder.append(memb.getName()).append(',');
                        numbreBuilder.append(memb.getNumber()).append(',');
                        idBuilder.append(memb.getId()).append(',');
                    });
                    nameBuilder.deleteCharAt(nameBuilder.length() - 1);
                    numbreBuilder.deleteCharAt(numbreBuilder.length() - 1);
                    idBuilder.deleteCharAt(idBuilder.length() - 1);
                    newRow.set("name", (Object)nameBuilder.toString());
                    newRow.set("number", (Object)numbreBuilder.toString());
                    newRow.set("id", (Object)idBuilder.toString());
                    nameBuilder.setLength(0);
                    numbreBuilder.setLength(0);
                    idBuilder.setLength(0);
                }
                return false;
            });
            this.getModel().updateEntryCache(permMemberRows);
            this.getView().updateView(entryentity);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        int value;
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.equals("cleanPermCache") && (value = messageBoxClosedEvent.getResult().getValue()) == MessageBoxResult.Yes.getValue()) {
            this.cleanPermCache();
        }
    }

    private void updateMemberGroupEntity() {
        Long modelId = this.getModelId();
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData("membergroupentity");
        if (this.notEmpty(modelId)) {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            List dimensionList = modelCacheHelper.getDimensionList();
            dataModel.batchCreateNewEntryRow("membergroupentity", dimensionList.size());
            for (int i = 0; i < dimensionList.size(); ++i) {
                Dimension dimension = (Dimension)dimensionList.get(i);
                dataModel.setValue("groupdim", (Object)dimension.getName(), i);
                dataModel.setValue("groupdimnum", (Object)dimension.getNumber(), i);
            }
        }
    }

    private void setBizCtrlRangeView() {
        Long modelId = (Long)this.getValue("model", "id");
        if (modelId != null) {
            DynamicObject defaultObj;
            this.getView().setVisible(Boolean.valueOf(ModelServiceHelper.isBGMDModel((Long)modelId)), new String[]{"bizrange"});
            if (ModelUtil.isBGModel((Long)modelId) && (defaultObj = NewEbAppUtil.getDefaultObj((String)"eb_businessmodel", (Long)modelId)) != null) {
                this.getModel().setValue("bizrange", (Object)defaultObj.getLong("id"));
            }
        }
    }

    private void searchPerm() {
        Long modelId = this.getModelId();
        String dimNum = (String)this.getValue("dimension", "number");
        if (dimNum == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6", (String)"MembPermSearchPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Long bizRangeId = this.getbizModelId();
        if (ModelServiceHelper.isBGMDModel((Long)modelId)) {
            if (bizRangeId == null || bizRangeId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"MembPermSearchPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else {
            bizRangeId = 0L;
        }
        Long userId = (Long)this.getValue("user", "id");
        Long userGrouopId = (Long)this.getValue("usergroup", "id");
        if (userId == null && userGrouopId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7528\u6237\u6216\u7528\u6237\u7ec4\u3002", (String)"MembPermSearchPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String permTypeNum = (String)this.getValue("permtype", null);
        if (this.isEmpty(permTypeNum)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6743\u9650\u7c7b\u578b\u3002", (String)"MembPermSearchPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DimMembPermType permTypeEnum = DimMembPermType.valueOf((String)permTypeNum);
        boolean needHasPerm = (Boolean)this.getValue("needhasperm", null);
        Set membIds = DimMembPermHelper.getPermMemberIds((Long)(userId == null ? userGrouopId : userId), (String)dimNum, (Long)modelId, (Long)bizRangeId, null, (DimMembPermType)permTypeEnum, (boolean)needHasPerm);
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData(entryentity);
        if (membIds == null) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5f53\u524d\u7528\u6237/\u7528\u6237\u7ec4\u662f\u5f53\u524d\u4f53\u7cfb\u7684\u7ba1\u7406\u5458\u6216\u5f53\u524d\u7ef4\u5ea6\u4e0d\u63a7\u5236\u201c%1\u201d\u6743\u9650\u3002", (String)"MembPermSearchPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{permTypeEnum.getName()}));
        } else {
            DynamicInfoCollection membInfo = new DynamicInfoCollection("memberInfo - name,id,number", new String[]{"name", "id", "number"});
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            Long viewId = modelCacheHelper.getViewByBusModelAndDimNumber(bizRangeId, dimNum);
            for (Long membId : membIds) {
                Member member = modelCacheHelper.getMember(dimNum, viewId, membId);
                if (member != null) {
                    membInfo.addInfo(new Object[]{member.getName(), membId, member.getNumber()});
                    continue;
                }
                membInfo.addInfo(new Object[]{"", membId, ""});
            }
            if (!membInfo.isEmpty()) {
                dataModel.batchCreateNewEntryRow(entryentity, membInfo.getValues().size());
                int rowNum = 0;
                for (DynamicInfoCollection.InfoObject memb : membInfo.getValues()) {
                    DynamicObject row = dataModel.getEntryRowEntity(entryentity, rowNum);
                    row.set("name", memb.getValueByPropName("name"));
                    row.set("id", memb.getValueByPropName("id"));
                    row.set("number", memb.getValueByPropName("number"));
                    ++rowNum;
                }
            }
        }
        this.getView().updateView(entryentity);
    }

    private void cleanPermCache() {
        DynamicObject[] allVersionObjs = BusinessDataServiceHelper.load((String)"eb_membpermversion", (String)"id,version", null);
        if (allVersionObjs != null && allVersionObjs.length > 0) {
            for (DynamicObject obj : allVersionObjs) {
                obj.set("version", (Object)(obj.getLong("version") + 1L));
            }
            SaveServiceHelper.save((DynamicObject[])allVersionObjs);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6e05\u7406\u6210\u529f", (String)"MembPermSearchPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private static class MemberObj {
        private Long id;
        private String number;
        private String name;
        private boolean isMember;

        public MemberObj(Long id, String number, String name, boolean isMember) {
            this.id = id;
            this.number = number;
            this.name = name;
            this.isMember = isMember;
        }

        public Long getId() {
            return this.id;
        }

        public String getNumber() {
            return this.number;
        }

        public String getName() {
            return this.name;
        }

        public boolean isMember() {
            return this.isMember;
        }
    }
}

