/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.perm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.epm.eb.common.cache.DimMembPermVerHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.MembPermRecordUtil;
import kd.epm.eb.common.permission.enums.PermGroupEnum;
import kd.epm.eb.common.permission.pojo.PermDimGroup;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.utils.CommonMethod;
import kd.epm.eb.common.utils.OperationLogUtil;

public class PermDimGroupSettingPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
CommonMethod {
    private static final String dimGroupKey = "dimgroup";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("model", (Object)this.getModelId());
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        List dimensionList = this.getIModelCacheHelper().getDimensionList();
        Map<Long, Integer> dimSeqMap = dimensionList.stream().collect(Collectors.toMap(BaseCache::getId, BaseCache::getSeq));
        this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").forEach(row -> row.getDynamicObjectCollection(dimGroupKey).sort((obj1, obj2) -> {
            Long dimId1 = obj1.getLong("fbasedataid_id");
            Long dimId2 = obj2.getLong("fbasedataid_id");
            return Integer.compare(dimSeqMap.getOrDefault(dimId1, 0), dimSeqMap.getOrDefault(dimId2, 0));
        }));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_sure"});
        this.addF7SelectListener(this, new String[]{dimGroupKey});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_sure".equals(key) && !this.checkCancelBeforeSave()) {
            this.saveData();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName = beforeF7SelectEvent.getProperty().getName();
        if (dimGroupKey.equals(propName)) {
            this.setDimGroupFilter((ListShowParameter)beforeF7SelectEvent.getFormShowParameter());
        }
    }

    private void setDimGroupFilter(ListShowParameter showParameter) {
        showParameter.getListFilterParameter().setFilter(new QFilter("model", "=", (Object)this.getModelId()));
        List dimIds = DimMembPermUtil.getPermControlDim((Long)this.getModelId()).stream().map(BaseCache::getId).collect(Collectors.toList());
        showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", dimIds));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, dimGroupKey));
    }

    public Long getModelId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("modelId");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
    }

    private boolean checkCancelBeforeSave() {
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity("entryentity");
        ArrayList<Set<String>> allDimNumsOnGroup = new ArrayList<Set<String>>(16);
        int currentRowIndex = 1;
        HashMap<String, String> dimNumNameMap = new HashMap<String, String>(16);
        for (Dimension dimension : this.getIModelCacheHelper().getDimensionList()) {
            dimNumNameMap.put(dimension.getNumber(), dimension.getName());
        }
        HashMap<String, Integer> nameMap = new HashMap<String, Integer>(16);
        for (DynamicObject row : entryRows) {
            DynamicObjectCollection dims = row.getDynamicObjectCollection(dimGroupKey);
            HashSet<String> dimNums = new HashSet<String>(dims.size());
            String name = row.getString("dimgroupname");
            Integer nameIndex = nameMap.put(name, currentRowIndex);
            if (nameIndex != null) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u548c\u7b2c%2\u884c\u7684\u540d\u79f0\u91cd\u590d\u3002", (String)"PermDimGroupSettingPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{nameIndex, currentRowIndex}));
                return true;
            }
            for (DynamicObject dim : dims) {
                DynamicObject dynamicObject = dim.getDynamicObject("fbasedataid");
                dimNums.add(dynamicObject.getString("number"));
            }
            int refRowIndex = 1;
            for (Set set : allDimNumsOnGroup) {
                LinkedList dimNames = new LinkedList();
                for (String dimNum : dimNums) {
                    if (!set.contains(dimNum)) continue;
                    dimNames.add(dimNumNameMap.get(dimNum));
                }
                if (dimNames.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u548c\u7b2c%2\u884c\u7684\u7ef4\u5ea6\u90fd\u5305\u542b\u201c%3\u201d\uff0c\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u591a\u4e2a\u5305\u542b\u4e24\u4e2a\u53ca\u4ee5\u4e0a\u76f8\u540c\u7ef4\u5ea6\u7684\u7ec4\u5408", (String)"PermDimGroupSettingPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{refRowIndex, currentRowIndex, String.join((CharSequence)",", dimNames)}));
                    return true;
                }
                ++refRowIndex;
            }
            allDimNumsOnGroup.add(dimNums);
            ++currentRowIndex;
        }
        return this.checkChange(allDimNumsOnGroup);
    }

    private boolean checkChange(List<Set<String>> allDimNumsOnNewGroup) {
        Set dimShortNumStrWithData;
        List oldPermGroup = DimMembPermUtil.getPermControlDimGroup((Long)this.getModelId());
        if (oldPermGroup.isEmpty()) {
            return false;
        }
        HashMap<String, PermDimGroup> changedGroup = new HashMap<String, PermDimGroup>(16);
        block0: for (PermDimGroup dimGroup : oldPermGroup) {
            block1: for (Set<String> dimNums : allDimNumsOnNewGroup) {
                for (BasedataPojo dimObj : dimGroup.getDimGroup()) {
                    if (dimNums.contains(dimObj.getNumber())) continue;
                    continue block1;
                }
                if (dimNums.size() != dimGroup.getDimGroup().size()) continue;
                continue block0;
            }
            changedGroup.put(dimGroup.getDimShortNumStr(), dimGroup);
        }
        if (changedGroup.size() > 0 && (dimShortNumStrWithData = MembPermRecordUtil.getDimShortNumStrWithData((Long)this.getModelId(), null, changedGroup.keySet(), null, (PermGroupEnum)PermGroupEnum.DATA)) != null && dimShortNumStrWithData.size() > 0) {
            String groupNames = changedGroup.values().stream().filter(group -> dimShortNumStrWithData.contains(group.getDimShortNumStr())).map(PermDimGroup::getName).collect(Collectors.joining(","));
            this.getView().showConfirm(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u7ec4\u5408\uff1a%1\uff0c\u5df2\u7ecf\u5b58\u5728\u6743\u9650\u8bb0\u5f55\uff0c\u4fee\u6539\u6216\u5220\u9664\u7ef4\u5ea6\u7ec4\u5408\u540e\uff0c\u6743\u9650\u8bb0\u5f55\u5c06\u88ab\u6e05\u9664\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PermDimGroupSettingPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{groupNames}), MessageBoxOptions.YesNo, new ConfirmCallBackListener("delChangeDimGroup"));
            this.getOrCache2DelShortNumStrs(dimShortNumStrWithData);
            return true;
        }
        this.getOrCache2DelShortNumStrs(Collections.emptySet());
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("delChangeDimGroup".equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.saveData();
        }
    }

    private void saveData() {
        Set<String> toDelShortNumStrs = this.getOrCache2DelShortNumStrs(null);
        Throwable throwable = null;
        try (TXHandle tx = TX.required((String)"saveData: PermDimGroup");){
            List oldPermGroup = DimMembPermUtil.getPermControlDimGroup((Long)this.getModelId());
            Set mainIds = MembPermRecordUtil.getMainRecordIdByDims((Long)this.getModelId(), toDelShortNumStrs, (PermGroupEnum)PermGroupEnum.DATA);
            MembPermRecordUtil.delPermRecord(null, (Set)mainIds);
            DimMembPermVerHelper.updateVer4DimShortNums(toDelShortNumStrs, (Long)this.getModelId(), (boolean)true);
            OperateOption op = OperateOption.create();
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"eb_permdimgroup", (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)}, (OperateOption)op);
            if (!operationResult.isSuccess()) {
                List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
                if (allErrorOrValidateInfo.size() == 1) {
                    this.getView().showTipNotification(((IOperateInfo)allErrorOrValidateInfo.get(0)).getMessage());
                } else {
                    List allMessage = allErrorOrValidateInfo.stream().map(IOperateInfo::getMessage).collect(Collectors.toList());
                    this.getView().showMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"PermDimGroupSettingPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\n", allMessage), MessageTypes.Default);
                }
                tx.markRollback();
                return;
            }
            try {
                List newPermGroup = DimMembPermUtil.getPermControlDimGroup((Long)this.getModelId());
                this.addOpLog(oldPermGroup, newPermGroup);
            }
            catch (Throwable ex) {
                tx.markRollback();
                throw ex;
            }
        }
        this.getModel().setDataChanged(false);
        this.getView().returnDataToParent((Object)"ok");
        this.getView().close();
    }

    private void addOpLog(List<PermDimGroup> oldPermGroup, List<PermDimGroup> newPermGroup) {
        try {
            Map<String, String> oldGroupMap = oldPermGroup.stream().collect(Collectors.toMap(PermDimGroup::getDimShortNumStr, PermDimGroup::getName));
            StringBuilder newGroupStr = new StringBuilder();
            for (PermDimGroup group : newPermGroup) {
                if (oldGroupMap.remove(group.getDimShortNumStr()) != null) continue;
                newGroupStr.append(group.getName()).append(',');
            }
            String delGroupStr = String.join((CharSequence)",", oldGroupMap.values());
            String addGroupStr = "";
            String allGroupStr = "";
            allGroupStr = newGroupStr.length() > 0 && oldGroupMap.size() > 0 ? ResManager.loadResFormat((String)"\u589e\u52a0\u4e86\u7ef4\u5ea6\u7ec4\u5408\u201c%1\u201d\uff0c\u5220\u9664\u4e86\u7ef4\u5ea6\u7ec4\u5408\u201c%2\u201d", (String)"PermDimGroupSettingPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[]{newGroupStr, delGroupStr}) : (newGroupStr.length() <= 0 && oldGroupMap.size() > 0 ? ResManager.loadResFormat((String)"\u5220\u9664\u4e86\u7ef4\u5ea6\u7ec4\u5408\u201c%1\u201d", (String)"PermDimGroupSettingPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[]{delGroupStr}) : (newGroupStr.length() > 0 && oldGroupMap.size() <= 0 ? ResManager.loadResFormat((String)"\u589e\u52a0\u4e86\u7ef4\u5ea6\u7ec4\u5408\uff1a%1\u3002", (String)"PermDimGroupSettingPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[]{newGroupStr}) : addGroupStr + delGroupStr));
            String modelNumber = this.getIModelCacheHelper().getModelobj().getNumber();
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u786e\u5b9a", "PermDimGroupSettingPlugin_7", "epm-eb-formplugin");
            MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u5bf9\u4f53\u7cfb\u201c%1$s\u201d\u7684\u6388\u6743\u7ef4\u5ea6\u7ec4\u5408%2$s\u7684\u64cd\u4f5c", "PermDimGroupSettingPlugin_8", "epm-eb-formplugin");
            OperationLogUtil.log((String)ApplicationTypeEnum.BGBD.getAppnum(), (String)this.getModel().getDataEntityType().getName(), (String)"", (String)"", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])new String[]{modelNumber, allGroupStr});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Set<String> getOrCache2DelShortNumStrs(Set<String> dimShortNumStrs) {
        if (dimShortNumStrs == null) {
            String cacheStr = this.getPageCache().get("2DelShortNumStr");
            dimShortNumStrs = this.notEmpty(cacheStr) ? (HashSet)SerializationUtils.fromJsonString((String)cacheStr, Set.class) : new HashSet(1);
        } else {
            this.getPageCache().put("2DelShortNumStr", SerializationUtils.toJsonString(dimShortNumStrs));
        }
        return dimShortNumStrs;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (dimGroupKey.equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            this.fillBackDimGroup((ListSelectedRowCollection)closedCallBackEvent.getReturnData());
        }
    }

    private void fillBackDimGroup(ListSelectedRowCollection selectedRows) {
        if (selectedRows.size() < 2 || selectedRows.size() > 6) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u4e00\u884c\u8bb0\u5f55\u81f3\u5c11\u9700\u89812\u4e2a\u4ee5\u4e0a6\u4e2a\u4ee5\u4e0b\u7684\u7ef4\u5ea6\u3002", (String)"PermDimGroupSettingPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Set pkIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        LinkedList dimIds = new LinkedList();
        modelCacheHelper.getDimensionList().forEach(dimension -> {
            if (pkIds.contains(dimension.getId())) {
                dimIds.add(dimension.getId());
            }
        });
        this.getModel().setValue(dimGroupKey, (Object)dimIds.toArray());
    }
}

