/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.perm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.FilterModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.SearchEvent;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.filter.SearchListener;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.ebcommon.common.enums.dimension.SysDimensionEnum;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.member.f7.MemberF7Utils;
import kd.epm.eb.common.model.UserSelectModel;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.MembPermRecordUtil;
import kd.epm.eb.common.permission.pojo.PermDimGroup;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.pojo.MultiDim.DimViewInfo;
import kd.epm.eb.common.pojo.MultiDim.MultiDimMembResult;
import kd.epm.eb.common.pojo.MultiDim.MultiDimMemberVal;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.bgadjust.utils.AdjustUtil;
import kd.epm.eb.formplugin.utils.PermQueryReportUtil;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class UserPermQueryFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
SearchListener {
    private static final String SELECT_MODEL = "selectmodel";
    private static final String SELECT_BIZCTRL_MODEL = "selectbizctrlmodel";
    private static final String SELECT_DIMENSION = "selectdimension";
    private static final String SELECT_MEMBER = "selectmember";
    private static final String SELECT_USER = "selectuser";
    private static final String SELECT_PERM_ITEM = "selectpermitem";
    private static final String SELECT_USER_TYPE = "selectusertype";
    private static final String SELECT_USER_GROUP = "selectusergroup";
    private static final String SELECT_DIM_GROUP = "selectdimgroup";
    private static final String SELECT_GROUP_MEMB = "selectgroupmemb";
    private static final String MODEL = "model";
    private static final String ID = "id";
    private static final String MEMBER_CALL_BACK = "memberCallBack";
    private static final String CACHE_MEMBER = "cache-member-ids";

    public void setSortAndFilter(List<SortAndFilterEvent> list) {
        super.setSortAndFilter(list);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        String formType = this.getPageCache().get("formType");
        String selectMember = this.getPageCache().get(SELECT_MEMBER);
        String selectGroupMemb = this.getPageCache().get(SELECT_GROUP_MEMB);
        String selectGroupMemberIdMap = this.getPageCache().get("selectGroupMemberIdMap");
        String selectMemberIdMap = this.getPageCache().get("selectMemberIdMap");
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("formType", formType);
        String userType = (String)this.getModel().getValue(SELECT_USER_TYPE);
        Long modelId = this.getModelId();
        String queryUserKey = SELECT_USER;
        boolean isGroupQuery = "2".equals(userType);
        if (isGroupQuery) {
            queryUserKey = SELECT_USER_GROUP;
        }
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getModel().getValue(queryUserKey);
        StringBuilder queryTips = new StringBuilder();
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject userOrGroup = (DynamicObject)dynamicObject.get("fbasedataid");
            long userOrGroupId = userOrGroup.getLong(ID);
            Set managers = ModelServiceHelper.getManagersByModel((Long)modelId, (boolean)true, (boolean)true);
            if (!managers.contains(userOrGroupId)) continue;
            queryTips.append(userOrGroup.getString("name")).append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)queryTips)) {
            String tips = isGroupQuery ? ResManager.loadResFormat((String)"\u7528\u6237\u7ec4\uff1a%1\u662f\u5f53\u524d\u6240\u9009\u4f53\u7cfb\u7684\u7ba1\u7406\u5458\u3002", (String)"UserPermQueryFormPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[]{queryTips.deleteCharAt(queryTips.length() - 1)}) : ResManager.loadResFormat((String)"\u7528\u6237%1\u662f\u5f53\u524d\u6240\u9009\u4f53\u7cfb\u7684\u7ba1\u7406\u5458\u3002", (String)"UserPermQueryFormPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[]{queryTips.deleteCharAt(queryTips.length() - 1)});
            this.getView().showTipNotification(tips);
        }
        map.put("userType", userType);
        map.put("selectMember", selectMember);
        map.put("selectGroupMemb", selectGroupMemb);
        map.put("selectGroupMemberIdMap", selectGroupMemberIdMap);
        map.put("selectMemberIdMap", selectMemberIdMap);
        map.put("modelId", this.getModelId());
        map.put("viewId", this.getPageCache().get("cacheViewId"));
        Object dimgroup = this.getModel().getValue(SELECT_DIM_GROUP);
        Object dimension = this.getModel().getValue(SELECT_DIMENSION);
        map.put(SELECT_DIM_GROUP, dimgroup == null ? null : String.valueOf(dimgroup));
        map.put(SELECT_DIMENSION, dimension == null ? null : String.valueOf(dimension));
        queryParam.setCustomParam(map);
        super.beforeQuery(queryParam);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"configurereport"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{SELECT_USER_GROUP, SELECT_BIZCTRL_MODEL});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{SELECT_USER, SELECT_MEMBER});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        boolean needShowGroupMember = false;
        boolean needShowMember = false;
        if (customParams != null) {
            String formType = (String)customParams.get("formType");
            boolean isManagePermForm = StringUtils.equals((CharSequence)"manage", (CharSequence)formType);
            Long modelId = IDUtils.toLong(customParams.get(MODEL));
            Long bizModelId = IDUtils.toLong(customParams.get("bizModel"));
            String dimension = (String)customParams.get("dimension");
            String userType = (String)customParams.get("userType");
            String userIdStr = String.valueOf(customParams.get("userId"));
            long userId = 0L;
            if (StringUtils.isNotEmpty((CharSequence)userIdStr) && !StringUtils.equals((CharSequence)"null", (CharSequence)userIdStr)) {
                userId = Long.parseLong(userIdStr);
            }
            Long[] ids = new Long[]{userId};
            if (IDUtils.isNotNull((Long)modelId)) {
                this.getModel().setValue(SELECT_MODEL, (Object)modelId);
                boolean bgmdModel = ModelServiceHelper.isBGMDModel((Long)modelId);
                if (IDUtils.isNotNull((Long)bizModelId)) {
                    this.getModel().setValue(SELECT_BIZCTRL_MODEL, (Object)bizModelId);
                    if (StringUtils.isNotEmpty((CharSequence)dimension)) {
                        if (dimension.contains(",")) {
                            this.getModel().setValue(SELECT_DIM_GROUP, (Object)dimension.replace(",", "#"));
                            needShowGroupMember = true;
                        } else {
                            this.getModel().setValue(SELECT_DIMENSION, (Object)dimension);
                            needShowMember = true;
                        }
                    }
                    if (bgmdModel) {
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{SELECT_BIZCTRL_MODEL});
                    }
                } else if (!isManagePermForm) {
                    this.setDefaultBizModel(modelId);
                    if (bgmdModel) {
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{SELECT_BIZCTRL_MODEL});
                    } else if (ModelUtil.isEbOrBgModel((Long)modelId) && StringUtils.isNotEmpty((CharSequence)dimension)) {
                        if (dimension.contains(",")) {
                            this.getModel().setValue(SELECT_DIM_GROUP, (Object)dimension.replace(",", "#"));
                            needShowGroupMember = true;
                        } else {
                            this.getModel().setValue(SELECT_DIMENSION, (Object)dimension);
                            needShowMember = true;
                        }
                    }
                } else if (StringUtils.isNotEmpty((CharSequence)dimension)) {
                    if (dimension.contains(",")) {
                        this.getModel().setValue(SELECT_DIM_GROUP, (Object)dimension.replace(",", "#"));
                        needShowGroupMember = true;
                    } else {
                        this.getModel().setValue(SELECT_DIMENSION, (Object)dimension);
                        needShowMember = true;
                    }
                }
            } else {
                UserSelectModel selectModel = UserSelectUtil.getUserSelect4PermForm((IFormView)this.getView(), (String)MODEL, (!isManagePermForm ? 1 : 0) != 0, (boolean)true);
                modelId = selectModel.getModel();
                if (IDUtils.isNotNull((Long)modelId)) {
                    this.getModel().setValue(SELECT_MODEL, (Object)modelId);
                    boolean bgmdModel = ModelServiceHelper.isBGMDModel((Long)modelId);
                    if (!isManagePermForm && (bgmdModel || ModelUtil.isBGModel((Long)modelId))) {
                        if (selectModel.getBizModelId() == null || selectModel.getBizModelId() == 0L) {
                            this.setDefaultBizModel(modelId);
                        } else {
                            this.getModel().setValue(SELECT_BIZCTRL_MODEL, (Object)selectModel.getBizModelId());
                        }
                        if (bgmdModel) {
                            this.getView().setVisible(Boolean.valueOf(true), new String[]{SELECT_BIZCTRL_MODEL});
                        }
                    }
                }
            }
            boolean newEbModel = NewEbAppUtil.isNewEbModel((Long)this.getModelId());
            this.getView().getPageCache().put("newEbForm", String.valueOf(newEbModel));
            if (isManagePermForm) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{SELECT_BIZCTRL_MODEL, SELECT_PERM_ITEM, SELECT_DIM_GROUP, SELECT_GROUP_MEMB});
                if ("bos_usergroup".equals(userType) && userId != 0L) {
                    this.getModel().setValue(SELECT_USER_TYPE, (Object)"2");
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{SELECT_USER});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{SELECT_USER_GROUP});
                    this.getModel().setValue(SELECT_USER_GROUP, (Object)ids);
                } else if ("bos_user".equals(userType) && userId != 0L) {
                    this.getModel().setValue(SELECT_USER_TYPE, (Object)"1");
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{SELECT_USER});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{SELECT_USER_GROUP});
                    this.getModel().setValue(SELECT_USER, (Object)ids);
                }
            } else {
                this.getModel().setValue(SELECT_MODEL, (Object)modelId);
                Set modelIds = ModelUtil.getModelIds((IFormView)this.getView(), (boolean)true);
                if (modelIds.contains(modelId)) {
                    if ("bos_usergroup".equals(userType) && userId != 0L) {
                        this.getModel().setValue(SELECT_USER_TYPE, (Object)"2");
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{SELECT_USER});
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{SELECT_USER_GROUP});
                        this.getModel().setValue(SELECT_USER_GROUP, (Object)ids);
                    } else if ("bos_user".equals(userType) && userId != 0L) {
                        this.getModel().setValue(SELECT_USER_TYPE, (Object)"1");
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{SELECT_USER});
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{SELECT_USER_GROUP});
                        this.getModel().setValue(SELECT_USER, (Object)ids);
                    }
                } else {
                    this.setCurrentUserQuery();
                }
            }
            this.getPageCache().put("formType", formType);
        }
        this.filterFilterScheme();
        this.initSelectDimensionItem(needShowMember);
        this.initSelectDimGroupItem(needShowGroupMember);
    }

    private void initSelectDimensionItem(boolean needShowMember) {
        DynamicObject bizModel = (DynamicObject)this.getModel().getValue(SELECT_BIZCTRL_MODEL);
        Long modelId = this.getModelId();
        if (IDUtils.isNull((Long)modelId)) {
            ComboEdit control = (ComboEdit)this.getControl(SELECT_DIMENSION);
            control.setComboItems(null);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SELECT_MEMBER});
            return;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        String formType = this.getPageCache().get("formType");
        ArrayList<Dimension> dimensionList = new ArrayList<Dimension>(10);
        if (StringUtils.equals((CharSequence)"manage", (CharSequence)formType)) {
            modelCacheHelper.getDimensionList().forEach(dimension -> {
                if (!(DimMembPermHelper.noCheckDimsOnManPerm.contains(dimension.getNumber()) || SysDimensionEnum.Process.getNumber().equals(dimension.getNumber()) || SysDimensionEnum.Scenario.getNumber().equals(dimension.getNumber()) || ModelUtil.isBGModel((Long)modelId) && (!ModelUtil.isBGModel((Long)modelId) || SysDimensionEnum.InternalCompany.getNumber().equals(dimension.getNumber())))) {
                    dimensionList.add((Dimension)dimension);
                }
            });
        } else if (StringUtils.equals((CharSequence)"member", (CharSequence)formType)) {
            List ids = DimMembPermUtil.getPermControlDim((Long)modelId).stream().map(BaseCache::getId).collect(Collectors.toList());
            if (bizModel != null) {
                List<kd.epm.eb.common.model.Dimension> dimensions = PermQueryReportUtil.getDimensionListByBizModel(bizModel.getLong(ID));
                if (CollectionUtils.isNotEmpty(dimensions)) {
                    ids.retainAll(dimensions.stream().map(kd.epm.eb.common.model.Dimension::getId).collect(Collectors.toList()));
                }
            } else if (ModelUtil.isBGModel((Long)modelId) || ModelServiceHelper.isBGMDModel((Long)modelId)) {
                ids.clear();
            }
            modelCacheHelper.getDimensionList().forEach(dimension -> {
                if (ids.contains(dimension.getId())) {
                    dimensionList.add((Dimension)dimension);
                }
            });
        }
        this.buildItemList(dimensionList, needShowMember);
    }

    private void buildItemList(List<Dimension> dimensionList, boolean needShowMember) {
        if (CollectionUtils.isEmpty(dimensionList)) {
            ComboEdit control = (ComboEdit)this.getControl(SELECT_DIMENSION);
            control.setComboItems(null);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SELECT_MEMBER});
            return;
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(SELECT_DIMENSION);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(dimensionList.size());
        for (Dimension dimension : dimensionList) {
            items.add(new ComboItem(new LocaleString(dimension.getName()), dimension.getNumber()));
        }
        comboEdit.setComboItems(items);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{SELECT_DIMENSION});
        this.getView().setVisible(Boolean.valueOf(needShowMember), new String[]{SELECT_MEMBER});
        if (needShowMember) {
            this.clearSelectValue(SELECT_MEMBER);
        } else {
            this.clearSelectValue(SELECT_DIMENSION, SELECT_MEMBER);
        }
    }

    private void initSelectDimGroupItem(boolean needShowGroupMember) {
        if ("manage".equals(this.getPageCache().get("formType"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SELECT_DIM_GROUP, SELECT_GROUP_MEMB});
            return;
        }
        Long modelId = this.getModelId();
        if (IDUtils.isNull((Long)modelId)) {
            ComboEdit control = (ComboEdit)this.getControl(SELECT_DIM_GROUP);
            control.setComboItems(null);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SELECT_GROUP_MEMB});
            return;
        }
        List permControlDimGroup = DimMembPermUtil.getPermControlDimGroup((Long)modelId);
        boolean needBuildDimGroup = true;
        if (ModelUtil.isBGModel((Long)modelId) || AdjustUtil.isBGMModel(modelId)) {
            Long bizModel = this.getBizModel();
            if (IDUtils.isNotNull((Long)bizModel)) {
                permControlDimGroup = DimMembPermUtil.getPermControlDimGroup((Long)modelId, (Long)bizModel);
            } else {
                needBuildDimGroup = false;
            }
        }
        this.buildGroupItemList(permControlDimGroup, needBuildDimGroup, needShowGroupMember);
    }

    private void buildGroupItemList(List<PermDimGroup> permControlDimGroup, boolean needBuildDimGroup, boolean needShowGroupMember) {
        if (CollectionUtils.isNotEmpty(permControlDimGroup)) {
            if (needBuildDimGroup) {
                ComboEdit comboEdit = (ComboEdit)this.getControl(SELECT_DIM_GROUP);
                ArrayList<ComboItem> items = new ArrayList<ComboItem>(permControlDimGroup.size());
                for (PermDimGroup permDimGroup : permControlDimGroup) {
                    String numStr = permDimGroup.getDimGroup().stream().map(BasedataPojo::getNumber).collect(Collectors.joining("#"));
                    items.add(new ComboItem(new LocaleString(permDimGroup.getName()), numStr));
                }
                comboEdit.setComboItems(items);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{SELECT_DIM_GROUP});
            } else {
                ComboEdit control = (ComboEdit)this.getControl(SELECT_DIM_GROUP);
                control.setComboItems(null);
            }
            this.getView().setVisible(Boolean.valueOf(needShowGroupMember), new String[]{SELECT_GROUP_MEMB});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SELECT_GROUP_MEMB, SELECT_DIM_GROUP});
        }
        if (needShowGroupMember) {
            this.clearSelectValue(SELECT_GROUP_MEMB);
        } else {
            this.clearSelectValue(SELECT_GROUP_MEMB, SELECT_DIM_GROUP);
        }
    }

    private void filterFilterScheme() {
        FilterModel filterModel = new FilterModel();
        filterModel.setFormId(this.getView().getEntityId());
        List schemeList = filterModel.getSchemeList();
        ReportFilter reportFilter = (ReportFilter)this.getControl("reportfilterap");
        schemeList.removeIf(this::doFilterScheme);
        reportFilter.setSchemeList(schemeList);
    }

    private boolean doFilterScheme(FilterScheme next) {
        boolean needRemove;
        String schemeJson = next.getScheme();
        Map filterMap = (Map)SerializationUtils.fromJsonString((String)schemeJson, HashMap.class);
        String cusFilters = (String)filterMap.get("custfilters");
        Map scheme = (Map)SerializationUtils.fromJsonString((String)cusFilters, HashMap.class);
        Object selectbizctrlmodel = scheme.get(SELECT_BIZCTRL_MODEL);
        String formType = this.getPageCache().get("formType");
        boolean isManagePermForm = StringUtils.equals((CharSequence)"manage", (CharSequence)formType);
        if (isManagePermForm) {
            needRemove = selectbizctrlmodel != null;
        } else {
            boolean bl = needRemove = selectbizctrlmodel == null;
        }
        if (needRemove) {
            return true;
        }
        Object selectmodel = scheme.get("selectmodel_id");
        Set<Long> permModel = this.getPermModel(isManagePermForm);
        return !permModel.contains(IDUtils.toLong(selectmodel));
    }

    private void setCurrentUserQuery() {
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"id,number,name", (QFilter[])new QFilter(ID, "=", (Object)UserUtils.getUserId()).toArray());
        Long[] ids = new Long[]{user.getLong(ID)};
        this.getModel().setValue(SELECT_USER, (Object)ids);
        this.getModel().setValue(SELECT_USER_TYPE, (Object)"1");
        this.getView().setEnable(Boolean.valueOf(false), new String[]{SELECT_USER});
        this.clearSelectValue(SELECT_USER_GROUP);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{SELECT_USER_GROUP, SELECT_USER_TYPE});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{SELECT_USER});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit model = (BasedataEdit)this.getView().getControl(SELECT_MODEL);
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bizModel = (BasedataEdit)this.getView().getControl(SELECT_BIZCTRL_MODEL);
        bizModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit user = (BasedataEdit)this.getView().getControl(SELECT_USER);
        BasedataEdit userGroup = (BasedataEdit)this.getView().getControl(SELECT_USER_GROUP);
        user.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        userGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{SELECT_MEMBER, SELECT_GROUP_MEMB});
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportFilter reportFilter = (ReportFilter)this.getControl("reportfilterap");
        reportFilter.addSearchListener((SearchListener)this);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        String msg;
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObjectCollection user = filterInfo.getDynamicObjectCollection(SELECT_USER);
        DynamicObject model = filterInfo.getDynamicObject(SELECT_MODEL);
        DynamicObject bizModel = filterInfo.getDynamicObject(SELECT_BIZCTRL_MODEL);
        String permItem = filterInfo.getString(SELECT_PERM_ITEM);
        String userType = filterInfo.getString(SELECT_USER_TYPE);
        DynamicObjectCollection userGroup = filterInfo.getDynamicObjectCollection(SELECT_USER_GROUP);
        String dimension = filterInfo.getString(SELECT_DIMENSION);
        String groupDimension = filterInfo.getString(SELECT_DIM_GROUP);
        String formType = this.getPageCache().get("formType");
        StringBuilder params = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)userType)) {
            msg = ResManager.loadKDString((String)"\u7528\u6237\u7c7b\u578b", (String)"UserPermQueryFormPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            params.append(msg).append("\u3001");
        }
        if (StringUtils.equals((CharSequence)"1", (CharSequence)userType) && CollectionUtils.isEmpty((Collection)user)) {
            params.append(this.getType(SELECT_USER)).append("\u3001");
        }
        if (StringUtils.equals((CharSequence)"2", (CharSequence)userType) && CollectionUtils.isEmpty((Collection)userGroup)) {
            params.append(this.getType(SELECT_USER_GROUP)).append("\u3001");
        }
        if (model == null) {
            msg = ResManager.loadKDString((String)"\u4f53\u7cfb", (String)"UserPermQueryFormPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            params.append(msg).append("\u3001");
        }
        if (bizModel == null && ModelServiceHelper.isBGMDModel((Long)this.getModelId()) && !StringUtils.equals((CharSequence)"manage", (CharSequence)formType)) {
            msg = ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b", (String)"UserPermQueryFormPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            params.append(msg).append("\u3001");
        }
        if (StringUtils.isEmpty((CharSequence)permItem) && !StringUtils.equals((CharSequence)"manage", (CharSequence)formType)) {
            msg = ResManager.loadKDString((String)"\u6743\u9650\u9879", (String)"UserPermQueryFormPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            params.append(msg).append("\u3001");
        }
        if (StringUtils.isNotEmpty((CharSequence)String.valueOf(params))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5fc5\u586b\u9879\u662f\u5426\u4e3a\u7a7a\u3002", (String)"UserPermQueryFormPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{dimension, groupDimension})) {
            if ("manage".equals(formType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u4e2a\u7ef4\u5ea6\uff0c\u518d\u67e5\u8be2\u3002", (String)"UserPermQueryFormPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u4e2a\u7ef4\u5ea6\u6216\u7ef4\u5ea6\u7ec4\u5408\uff0c\u518d\u67e5\u8be2\u3002", (String)"UserPermQueryFormPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        this.setFilter(beforeF7SelectEvent, name);
    }

    private void setFilter(BeforeF7SelectEvent beforeF7SelectEvent, String name) {
        String sourceMethod = beforeF7SelectEvent.getSourceMethod();
        BasedataEdit control = (BasedataEdit)this.getControl(name);
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ArrayList<QFilter> qFilterList = control.getQFilters();
        if (qFilterList == null) {
            qFilterList = new ArrayList<QFilter>(10);
        }
        String formType = this.getPageCache().get("formType");
        DynamicObject model = (DynamicObject)this.getModel().getValue(SELECT_MODEL);
        switch (name) {
            case "selectmodel": {
                boolean onlyManage = StringUtils.equals((CharSequence)"manage", (CharSequence)formType);
                Set<Long> modelIds = this.getPermModel(onlyManage);
                QFilter idFilter = new QFilter(ID, "in", modelIds);
                qFilterList.add(idFilter);
                beforeF7SelectEvent.getFormShowParameter().getCustomParams().put("noNeedDefaultQFilter", "true");
                break;
            }
            case "selectbizctrlmodel": {
                if (model == null) {
                    if (!StringUtils.equals((CharSequence)"setItemByNumber", (CharSequence)sourceMethod)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\uff0c\u518d\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"UserPermQueryFormPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    beforeF7SelectEvent.setCancel(true);
                    break;
                }
                QFilter qFilter = new QFilter(MODEL, "=", (Object)model.getLong(ID));
                qFilterList.add(qFilter);
                break;
            }
            case "selectuser": 
            case "selectusergroup": {
                beforeF7SelectEvent.setCancel(this.checkModel(name, formType));
                break;
            }
        }
        formShowParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
    }

    private Set<Long> getPermModel(boolean onlyManage) {
        Set modelIds = ModelUtil.getModelIds((IFormView)this.getView(), (boolean)true);
        if (!onlyManage) {
            modelIds.addAll(MembPermRecordUtil.getModelIdsOnGivePerm((Long)this.getUserId()));
        }
        return modelIds;
    }

    private boolean checkModel(String key, String formType) {
        Long id;
        if ("member".equals(formType) && (id = this.getModelId()) == 0L) {
            if (SELECT_USER.equals(key)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\uff0c\u518d\u9009\u62e9\u7528\u6237\u3002", (String)"UserPermQueryFormPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (SELECT_USER_GROUP.equals(key)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u518d\u9009\u62e9\u7528\u6237\u7ec4\u3002", (String)"UserPermQueryFormPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            return true;
        }
        return false;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "selectmodel": {
                this.modelChange();
                break;
            }
            case "selectbizctrlmodel": {
                this.bizModelChange();
                break;
            }
            case "selectdimension": {
                this.dimensionChange();
                break;
            }
            case "selectusertype": {
                this.userTypeChange();
                break;
            }
            case "selectdimgroup": {
                this.selectDimGroupChange();
                break;
            }
            case "selectmember": 
            case "selectgroupmemb": {
                this.dealMemberChange(name);
                break;
            }
        }
    }

    private void dealMemberChange(String name) {
        Object value = this.getModel().getValue(name);
        if (value == null || StringUtils.isEmpty((CharSequence)String.valueOf(value))) {
            this.getPageCache().remove(name);
        }
        if (SELECT_MEMBER.equals(name)) {
            this.getPageCache().remove(CACHE_MEMBER);
            this.getPageCache().remove("cacheViewId");
        }
    }

    private void selectDimGroupChange() {
        this.clearSelectValue(SELECT_GROUP_MEMB);
        List<String> selectDimGroup = this.getSelectItemList(SELECT_DIM_GROUP);
        if (CollectionUtils.isNotEmpty(selectDimGroup)) {
            this.getModel().setValue(SELECT_DIM_GROUP, (Object)String.join((CharSequence)",", selectDimGroup));
        }
        this.getView().setVisible(Boolean.valueOf(CollectionUtils.isNotEmpty(selectDimGroup) && selectDimGroup.size() == 1), new String[]{SELECT_GROUP_MEMB});
    }

    private void userTypeChange() {
        String value = (String)this.getModel().getValue(SELECT_USER_TYPE);
        if (StringUtils.isEmpty((CharSequence)value)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7528\u6237\u7c7b\u578b\u3002", (String)"UserPermQueryFormPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (StringUtils.equals((CharSequence)"1", (CharSequence)value)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{SELECT_USER});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SELECT_USER_GROUP});
        } else if (StringUtils.equals((CharSequence)"2", (CharSequence)value)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SELECT_USER});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{SELECT_USER_GROUP});
        }
    }

    private void bizModelChange() {
        this.clearSelectValue(SELECT_DIMENSION, SELECT_DIM_GROUP);
        this.initSelectDimensionItem(false);
        this.initSelectDimGroupItem(false);
    }

    private void modelChange() {
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(SELECT_MODEL);
        String formType = this.getPageCache().get("formType");
        if (dynamicObject != null) {
            boolean isBGMDModel = ModelServiceHelper.isBGMDModel((Long)this.getModelId());
            BasedataEdit bizModel = (BasedataEdit)this.getControl(SELECT_BIZCTRL_MODEL);
            PermQueryReportUtil.setBizModelFilter(bizModel, dynamicObject.getLong(ID));
            boolean showBizModel = isBGMDModel && StringUtils.equals((CharSequence)"member", (CharSequence)formType);
            this.getView().setVisible(Boolean.valueOf(showBizModel), new String[]{SELECT_BIZCTRL_MODEL});
            if ("member".equals(formType)) {
                Set modelIds = ModelUtil.getModelIds((IFormView)this.getView(), (boolean)true);
                if (!modelIds.contains(dynamicObject.getLong(ID))) {
                    this.setCurrentUserQuery();
                } else {
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{SELECT_USER});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{SELECT_USER_TYPE});
                }
            }
            boolean newEbModel = NewEbAppUtil.isNewEbModel((Long)this.getModelId());
            this.getView().getPageCache().put("newEbForm", String.valueOf(newEbModel));
        }
        this.clearSelectValue(SELECT_BIZCTRL_MODEL, SELECT_DIMENSION, SELECT_DIM_GROUP, SELECT_GROUP_MEMB);
        if ("member".equals(formType)) {
            this.setDefaultBizModel(this.getModelId());
        }
        this.initSelectDimensionItem(false);
        this.initSelectDimGroupItem(false);
    }

    private void clearSelectValue(String ... strings) {
        DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
        for (String string : strings) {
            if (!properties.containsKey((Object)string)) continue;
            this.getModel().setValue(string, null);
        }
    }

    private void setDefaultBizModel(long modelId) {
        boolean isBGModel = ModelUtil.isBGModel((Long)modelId);
        if (isBGModel) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_businessmodel", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)modelId)});
            this.getModel().setValue(SELECT_BIZCTRL_MODEL, (Object)dynamicObject);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (SELECT_MEMBER.equals(key)) {
            this.memberClick();
        } else if (SELECT_GROUP_MEMB.equals(key)) {
            this.showMembGroupSelect();
        }
    }

    private void showMembGroupSelect() {
        List<String> selectDimGroup = this.getSelectItemList(SELECT_DIM_GROUP);
        if (CollectionUtils.isEmpty(selectDimGroup) || selectDimGroup.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6388\u6743\u7ef4\u5ea6\u7ec4\u5408\uff0c\u518d\u9009\u62e9\u6210\u5458\u3002", (String)"UserPermQueryFormPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String dimStr = selectDimGroup.get(0);
        String[] split = dimStr.split("#");
        List<String> list = Arrays.asList(split);
        MemberF7Utils.openMultiDimMemberF7(list, (Long)this.getModelId(), (Long)this.getBizModel(), (boolean)true, (IFormView)this.getView(), null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "membGroupSelectBack"));
    }

    private List<String> getSelectItemList(String name) {
        Object selectItemList = this.getModel().getValue(name);
        ArrayList<String> selectDimGroup = new ArrayList<String>(10);
        if (selectItemList != null) {
            String[] split;
            String s = String.valueOf(selectItemList);
            for (String item : split = s.split(",")) {
                if (!StringUtils.isNotEmpty((CharSequence)item)) continue;
                selectDimGroup.add(item);
            }
        }
        return selectDimGroup;
    }

    private void memberClick() {
        String cacheViewId;
        String selectIds;
        Object value = this.getModel().getValue(SELECT_DIMENSION);
        if (value == null) {
            return;
        }
        String number = String.valueOf(value).replace(",", "");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, MEMBER_CALL_BACK);
        Long modelId = this.getModelId();
        Long busModelId = this.getBizModel();
        MemberF7Parameter f7Param = NewF7Utils.multipleF8((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)number), (String)ListSelectedRow.class.getName());
        if (IDUtils.isNotNull((Long)busModelId)) {
            f7Param.setBusModelId(busModelId);
            if (SysDimensionEnum.Account.getNumber().equals(number)) {
                f7Param.setDatasetIds(DatasetServiceHelper.getInstance().getDataSetIdByBizModelId(busModelId));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(selectIds = this.getPageCache().get(CACHE_MEMBER)))) {
            f7Param.setSelectIds((Set)SerializationUtils.fromJsonString((String)selectIds, LinkedHashSet.class));
        }
        if (SysDimensionEnum.Entity.getNumber().equals(number) || SysDimensionEnum.getEnumByNumber((String)number) == null) {
            f7Param.setShowCustomProperty(true);
        }
        f7Param.setLockRangeSelect(true);
        String formType = this.getPageCache().get("formType");
        boolean isMember = "member".equals(formType);
        f7Param.setShowAnalyseMember(isMember);
        f7Param.setVerifyPermission(false);
        f7Param.setCutTree(false);
        f7Param.setEnableView(true);
        if (!isMember) {
            f7Param.setLoadDefaultBusModel(false);
            IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getModelId());
            Dimension dimension = orCreate.getDimension(number);
            List viewList = dimension.getViewList();
            if (CollectionUtils.isNotEmpty((Collection)viewList)) {
                f7Param.setViewId((Long)viewList.get(0));
            }
        }
        if (IDUtils.isNotNull((Long)IDUtils.toLong((Object)(cacheViewId = this.getPageCache().get("cacheViewId"))))) {
            f7Param.setViewId(IDUtils.toLong((Object)cacheViewId));
        }
        NewF7Utils.openF8((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)closeCallBack);
    }

    private Long getUserId() {
        return UserUtils.getUserId();
    }

    private Long getBizModel() {
        DynamicObject bizModel = (DynamicObject)this.getModel().getValue(SELECT_BIZCTRL_MODEL);
        if (bizModel != null) {
            return bizModel.getLong(ID);
        }
        return 0L;
    }

    private Long getModelId() {
        DynamicObject model = (DynamicObject)this.getModel().getValue(SELECT_MODEL);
        if (model != null) {
            return model.getLong(ID);
        }
        return 0L;
    }

    private void dimensionChange() {
        this.clearSelectValue(SELECT_MEMBER);
        List<String> selectItemList = this.getSelectItemList(SELECT_DIMENSION);
        if (CollectionUtils.isNotEmpty(selectItemList)) {
            this.getModel().setValue(SELECT_DIMENSION, (Object)String.join((CharSequence)",", selectItemList));
        }
        this.getView().setVisible(Boolean.valueOf(CollectionUtils.isNotEmpty(selectItemList) && selectItemList.size() == 1), new String[]{SELECT_MEMBER});
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (MEMBER_CALL_BACK.equals(actionId)) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (returnData != null) {
                this.memberCallBack(returnData);
            }
        } else if ("membGroupSelectBack".equals(actionId)) {
            MultiDimMembResult returnData = (MultiDimMembResult)closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            List dimViewInfos = returnData.getDimViewInfos();
            List memberRows = returnData.getMemberRows();
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
            MemberPropCache propCache = MemberPropCacheService.getOrCreate((Long)this.getModelId());
            ArrayList<String> membGroupList = new ArrayList<String>(memberRows.size());
            ArrayList<String> membGroupShow = new ArrayList<String>(memberRows.size());
            List<String> selectDimGroup = this.getSelectItemList(SELECT_DIM_GROUP);
            String dimGroup = selectDimGroup.get(0);
            String[] split = dimGroup.split("#");
            HashMap<String, Set> dimMemberSelectMap = new HashMap<String, Set>(16);
            for (List memberRow : memberRows) {
                StringBuilder idStr = new StringBuilder();
                StringBuilder showStr = new StringBuilder();
                for (int i = 0; i < dimViewInfos.size(); ++i) {
                    MultiDimMemberVal multiDimMemberVal = (MultiDimMemberVal)memberRow.get(i);
                    DimViewInfo dimViewInfo = (DimViewInfo)dimViewInfos.get(i);
                    long memberId = multiDimMemberVal.getMemberId();
                    Set longs = dimMemberSelectMap.computeIfAbsent(split[i], set -> new HashSet(16));
                    if (multiDimMemberVal.isMember()) {
                        Member member = modelCacheHelper.getMember(split[i], dimViewInfo.getViewId(), Long.valueOf(memberId));
                        showStr.append(member.getName()).append(",");
                    } else {
                        CustomPropertyValue propertyValue = propCache.getPropertyValue(split[i], Long.valueOf(memberId));
                        showStr.append(propertyValue.getName()).append(",");
                        List membersByPropValues = propCache.getMembersByPropValues(modelCacheHelper.getDimension(split[i]).getId(), dimViewInfo.getViewId(), Long.valueOf(memberId));
                        longs.addAll(membersByPropValues.stream().map(BaseCache::getId).collect(Collectors.toSet()));
                    }
                    longs.add(memberId);
                    idStr.append(memberId).append("!").append(multiDimMemberVal.isMember() ? RangeF7PropertyCataEnum.Member.getIndex() : RangeF7PropertyCataEnum.Property.getIndex()).append("_");
                }
                membGroupList.add(idStr.substring(0, idStr.length() - 1));
                membGroupShow.add(showStr.substring(0, showStr.length() - 1));
            }
            if (CollectionUtils.isNotEmpty(membGroupList)) {
                this.getPageCache().put(SELECT_GROUP_MEMB, String.join((CharSequence)",", membGroupList));
                this.getPageCache().put("selectGroupMemberIdMap", SerializationUtils.serializeToBase64(dimMemberSelectMap));
                this.getModel().setValue(SELECT_GROUP_MEMB, (Object)String.join((CharSequence)"\uff1b", membGroupShow));
            } else {
                this.clearSelectValue(SELECT_GROUP_MEMB);
                this.getPageCache().remove(SELECT_GROUP_MEMB);
            }
        }
    }

    private void memberCallBack(ListSelectedRowCollection returnData) {
        ArrayList<String> numbers = new ArrayList<String>(returnData.size());
        ArrayList<String> memberShow = new ArrayList<String>(returnData.size());
        ArrayList<Long> ids = new ArrayList<Long>(returnData.size());
        HashMap<String, Set> dimMemberSelectMap = new HashMap<String, Set>(16);
        Object value = this.getModel().getValue(SELECT_DIMENSION);
        if (value == null) {
            return;
        }
        String number = String.valueOf(value).replace(",", "");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Set memberIds = dimMemberSelectMap.computeIfAbsent(number, v -> new HashSet(16));
        Long viewId = 0L;
        for (ListSelectedRow data : returnData) {
            StringBuilder stringBuilder = new StringBuilder();
            Map dataMap = data.getDataMap();
            Object type = dataMap.get("type");
            Object viewid = dataMap.get("viewid");
            if (IDUtils.isNull((Long)viewId) && viewid instanceof Long) {
                viewId = (Long)viewid;
            }
            if (RangeF7PropertyCataEnum.Member.getIndex().equals(String.valueOf(type))) {
                stringBuilder.append(data.getPrimaryKeyValue()).append("!").append(RangeF7PropertyCataEnum.Member.getIndex());
            } else if (RangeF7PropertyCataEnum.Property.getIndex().equals(String.valueOf(type))) {
                stringBuilder.append(data.getPrimaryKeyValue()).append("!").append(RangeF7PropertyCataEnum.Property.getIndex());
                MemberPropCache orCreate = MemberPropCacheService.getOrCreate((Long)this.getModelId());
                List membersByPropValues = orCreate.getMembersByPropValues(modelCacheHelper.getDimension(number).getId(), viewId, IDUtils.toLong((Object)data.getPrimaryKeyValue()));
                memberIds.addAll(membersByPropValues.stream().map(BaseCache::getId).collect(Collectors.toSet()));
            }
            memberShow.add(String.valueOf(dataMap.get("name")));
            numbers.add(stringBuilder.toString());
            ids.add((Long)data.getPrimaryKeyValue());
            memberIds.add((Long)data.getPrimaryKeyValue());
        }
        if (CollectionUtils.isNotEmpty(numbers)) {
            this.getModel().setValue(SELECT_MEMBER, (Object)String.join((CharSequence)"\uff1b", memberShow));
            this.getPageCache().put("selectMemberIdMap", SerializationUtils.serializeToBase64(dimMemberSelectMap));
            this.getPageCache().put(SELECT_MEMBER, String.join((CharSequence)",", numbers));
        } else {
            this.getPageCache().remove(SELECT_MEMBER);
            this.clearSelectValue(SELECT_MEMBER);
        }
        this.getPageCache().put("cacheViewId", String.valueOf(viewId));
        this.getPageCache().put(CACHE_MEMBER, SerializationUtils.toJsonString(ids));
    }

    private String getType(String key) {
        if (SELECT_USER.equals(key)) {
            return ResManager.loadKDString((String)"\u7528\u6237", (String)"UserPermQueryFormPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        if (SELECT_USER_GROUP.equals(key)) {
            return ResManager.loadKDString((String)"\u7528\u6237\u7ec4", (String)"UserPermQueryFormPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    public void afterSetModelValue(DynamicObject scheme) {
        super.afterSetModelValue(scheme);
        String userType = scheme.getString(SELECT_USER_TYPE);
        this.setUserAndGroupVisible(userType);
    }

    private void setUserAndGroupVisible(String userType) {
        if (StringUtils.equals((CharSequence)"1", (CharSequence)userType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{SELECT_USER});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SELECT_USER_GROUP});
        } else if (StringUtils.equals((CharSequence)"2", (CharSequence)userType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SELECT_USER});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{SELECT_USER_GROUP});
        }
    }

    public void search(SearchEvent searchEvent) {
        ReportFilter reportFilter = (ReportFilter)this.getControl("reportfilterap");
        reportFilter.setCollapse(false);
    }
}

