/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.qinganalysis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.qinganalysis.QingAnalysisDSVarModelService;
import kd.epm.eb.business.qinganalysis.model.DimMemberDto;
import kd.epm.eb.business.qinganalysis.model.DimensionDto;
import kd.epm.eb.business.qinganalysis.model.ValueFieldConfigDto;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.UploadUtil;
import kd.epm.eb.common.utils.excel.BgExcelReader;
import kd.epm.eb.common.utils.excel.BgExcelWriter;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.qinganalysis.QingAnalysisDSControlHelper;
import kd.epm.eb.formplugin.qinganalysis.constant.QingAnalysisDSPluginConstants;
import kd.epm.eb.formplugin.qinganalysis.model.DimensionItem;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class QingAnalysisDSConfigImportPlugin
extends AbstractBasePlugin
implements UploadListener {
    private static final Log log = LogFactory.getLog(QingAnalysisDSConfigImportPlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IPageCache pageCache = this.getPageCache();
        pageCache.put("model", (String)this.getView().getFormShowParameter().getCustomParam("model"));
        pageCache.put("bizmodel", (String)this.getView().getFormShowParameter().getCustomParam("bizmodel"));
        pageCache.put("dataset", (String)this.getView().getFormShowParameter().getCustomParam("dataset"));
        pageCache.put("config_data", (String)this.getView().getFormShowParameter().getCustomParam("config_data"));
        pageCache.put("valuePoolField", (String)this.getView().getFormShowParameter().getCustomParam("valuePoolField"));
        pageCache.put("dimension_view", (String)this.getView().getFormShowParameter().getCustomParam("dimension_view"));
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachment");
        attachmentPanel.addUploadListener((UploadListener)this);
        this.addClickListeners(new String[]{"btn_import", "btn_downtemp"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btn_import".equals(key)) {
            if (this.getPageCache().get("importFile") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6587\u4ef6", (String)"QingAnalysisDsConfigImportPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            String importType = (String)this.getModel().getValue("importtype");
            if ("1".equals(importType)) {
                this.importData("1");
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u5bfc\u5165\u8986\u76d6\u5f53\u524d\u914d\u7f6e?", (String)"QingAnalysisDsConfigImportPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("coverImport", (IFormPlugin)this));
            }
        } else if ("btn_downtemp".equals(key)) {
            this.exportTemplate();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String key = evt.getCallBackId();
        if ("coverImport".equals(key) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.importData("2");
        }
    }

    public void afterUpload(UploadEvent evt) {
        Object[] fileUrls = evt.getUrls();
        if (fileUrls != null && fileUrls.length > 0) {
            this.getPageCache().put("importFile", JSON.toJSONString((Object)fileUrls[0]));
        }
    }

    public void afterRemove(UploadEvent evt) {
        super.afterRemove(evt);
        this.getPageCache().remove("importFile");
    }

    private void importData(String op) {
        List dataList;
        Map fileMap = (Map)JSON.parseObject((String)this.getPageCache().get("importFile"), Map.class);
        String name = (String)fileMap.get("name");
        if (StringUtils.isBlank((CharSequence)name)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"QingAnalysisDsConfigImportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!name.endsWith("xlsx") && !name.endsWith("xls")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528\u6b63\u786e\u7684\u6a21\u677f\u4e0a\u4f20\u3002", (String)"QingAnalysisDsConfigImportPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String fileUrl = (String)fileMap.get("url");
        if (StringUtils.isBlank((CharSequence)fileUrl)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"QingAnalysisDsConfigImportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        List<DimensionItem> allDimension = this.getAllDimension();
        int celSize = allDimension.size() * 2 + 1;
        InputStream in = null;
        try {
            in = UploadUtil.getFileInputStream((String)fileUrl);
            Object wb = name.endsWith("xlsx") ? new XSSFWorkbook(in) : new HSSFWorkbook(in);
            dataList = BgExcelReader.getInstance().readByWorkbook((Workbook)wb).read(0, 0, celSize - 1);
        }
        catch (IOException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"QingAnalysisDsConfigImportPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (CollectionUtils.isEmpty((Collection)dataList) || dataList.size() <= 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u4e3a\u7a7a\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"DataIntegrationMapPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ArrayList<ValueFieldConfigDto> dtoList = new ArrayList<ValueFieldConfigDto>(dataList.size());
        HashMap<Integer, String> errorMap = new HashMap<Integer, String>(dataList.size());
        this.parseData(dataList, dtoList, errorMap);
        if (MapUtils.isEmpty(errorMap) && "1".equals(op)) {
            this.compareCurrConfigData(dtoList, errorMap);
        }
        if (MapUtils.isNotEmpty(errorMap)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u6709\u8bef\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u5bfc\u51fa\u6587\u4ef6\u3002", (String)"QingAnalysisDsConfigImportPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.exportError(dataList, errorMap);
        } else {
            JSONObject returnData = new JSONObject();
            returnData.fluentPut("importtype", (Object)op).fluentPut("config_data", (Object)JSON.toJSONString(dtoList));
            this.getView().returnDataToParent((Object)returnData.toJSONString());
            this.getView().close();
        }
    }

    private void parseData(List<List<String>> dataList, List<ValueFieldConfigDto> dtoList, Map<Integer, String> errorMap) {
        Long modelId = this.getModelId();
        Long bizModelId = IDUtils.toLong((Object)this.getPageCache().get("bizmodel"));
        Long datasetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List<DimensionItem> allDimension = this.getAllDimension();
        HashMap<String, Integer> configMemberMap = new HashMap<String, Integer>(dataList.size());
        HashMap<String, Set> permMemberMap = new HashMap<String, Set>(allDimension.size());
        Map<String, Long> dimNumberView = QingAnalysisDSControlHelper.getDimViewMap(this.getView());
        ArrayList<Long> viewIds = new ArrayList<Long>(dimNumberView.values());
        Map viewInfoById = CollectionUtils.isEmpty(viewIds) ? new HashMap(16) : DimensionViewServiceHelper.getInstance().getViewInfoById(viewIds);
        for (int row = 1; row < dataList.size(); ++row) {
            List<String> dataLine = dataList.get(row);
            int colSize = dataLine.size();
            if (colSize != allDimension.size() * 2 + 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528\u6b63\u786e\u7684\u6a21\u677f\u4e0a\u4f20\u3002", (String)"QingAnalysisDsConfigImportPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            ValueFieldConfigDto configDto = new ValueFieldConfigDto();
            String name = dataLine.get(0);
            if (StringUtils.isBlank((CharSequence)name)) {
                errorMap.put(row, ResManager.loadResFormat((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"QingAnalysisDsConfigImportPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (name.length() > 50) {
                errorMap.put(row, ResManager.loadResFormat((String)"\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc750\u4e2a\u5b57\u7b26\u3002", (String)"QingAnalysisDsConfigImportPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            configDto.setName(name.trim());
            configDto.setKey(QingAnalysisDSPluginConstants.createDtoKey());
            int index = 1;
            boolean rowError = false;
            for (DimensionItem dimItem : allDimension) {
                String memName;
                Long memId;
                String dimNumber = dimItem.getNumber();
                String memNumber = dataLine.get(index);
                Long viewId = QingAnalysisDSControlHelper.getViewId(modelId, datasetId, dimNumber, this.getView());
                if (StringUtils.isBlank((CharSequence)memNumber)) {
                    errorMap.put(row, ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u6210\u5458\u7f16\u7801", (String)"QingAnalysisDsConfigImportPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[]{dimItem.getName()}));
                    rowError = true;
                    break;
                }
                memNumber = memNumber.trim();
                Member member = null;
                if (TemplateVarCommonUtil.checkIsVar((String)memNumber, (String)dimNumber).booleanValue()) {
                    DynamicObject variableObj = QingAnalysisDSVarModelService.getInstance().getVariableObj(modelId.longValue(), dimNumber, memNumber);
                    if (variableObj == null) {
                        errorMap.put(row, ResManager.loadResFormat((String)"\u7ef4\u5ea6\u53d8\u91cf\uff1a%1\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"QingAnalysisDsConfigImportPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[]{dimItem.getName()}));
                        rowError = true;
                        break;
                    }
                    memId = variableObj.getLong("id");
                    memName = variableObj.getString("name");
                } else {
                    member = modelCache.getMember(dimNumber, viewId, memNumber);
                    if (member == null) {
                        DynamicObject view = (DynamicObject)viewInfoById.get(viewId);
                        if (view == null) {
                            errorMap.put(row, ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u3002", (String)"QingAnalysisDsConfigImportPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{dimItem.getName()}));
                        } else {
                            errorMap.put(row, ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u6210\u5458\u5728%2\u89c6\u56fe\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u6210\u5458\u7f16\u7801", (String)"QingAnalysisDsConfigImportPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[]{dimItem.getName(), view.getString("name")}));
                        }
                        rowError = true;
                        break;
                    }
                    memId = member.getId();
                    memName = member.getName();
                }
                if (member != null) {
                    boolean modelManager;
                    if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
                        if (!datasetId.equals(member.getDatasetId())) {
                            errorMap.put(row, ResManager.loadKDString((String)"\u79d1\u76ee\u6210\u5458\u6240\u5728\u6570\u636e\u96c6\u4e0e\u6240\u9009\u6570\u636e\u96c6\u4e0d\u4e00\u81f4\u3002", (String)"QingAnalysisDsConfigImportPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            rowError = true;
                            break;
                        }
                    } else if (SysDimensionEnum.Metric.getNumber().equals(dimNumber) && !MetricDataTypeEnum.CURRENCY.getIndex().equals(member.getDatatype()) && !MetricDataTypeEnum.NONMONETARY.getIndex().equals(member.getDatatype()) && !MetricDataTypeEnum.RATE.getIndex().equals(member.getDatatype())) {
                        errorMap.put(row, ResManager.loadKDString((String)"\u5ea6\u91cf\u652f\u6301\u7684\u7c7b\u578b\uff1a\u8d27\u5e01\u3001\u6570\u503c\u3001\u767e\u5206\u6bd4", (String)"QingAnalysisDsConfigImportPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        rowError = true;
                        break;
                    }
                    if (!(modelManager = ModelServiceHelper.isModelManager((Long)modelId))) {
                        Set permMemberIds = (Set)permMemberMap.get(dimNumber);
                        if (permMemberIds == null) {
                            permMemberIds = DimMembPermHelper.getReadPermMembIds((String)dimNumber, (Long)modelId, (Long)bizModelId, (Long)viewId, (boolean)true);
                            permMemberMap.put(dimNumber, permMemberIds);
                        }
                        if (permMemberIds != null && !permMemberIds.contains(member.getId())) {
                            errorMap.put(row, ResManager.loadResFormat((String)"\u65e0%1\u7ef4\u5ea6\u6210\u5458\u7684\u8bfb\u53d6\u6743\u9650\u3002", (String)"QingAnalysisDsConfigImportPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[]{dimItem.getName()}));
                            rowError = true;
                            break;
                        }
                    }
                }
                DimensionDto dimensionDto = new DimensionDto();
                dimensionDto.setDimNumber(dimNumber);
                DimMemberDto memberDto = new DimMemberDto();
                memberDto.setId(memId);
                memberDto.setName(memName);
                memberDto.setNumber(memNumber);
                memberDto.setScope(String.valueOf(RangeEnum.ONLY.getIndex()));
                dimensionDto.setMembers(Collections.singletonList(memberDto));
                configDto.addDim(dimensionDto);
                index += 2;
            }
            if (!rowError) {
                String configMember = configDto.getDims().stream().map(dim -> ((DimMemberDto)dim.getMembers().get(0)).getNumber()).collect(Collectors.joining(","));
                if (configMemberMap.containsKey(configMember)) {
                    Integer repeatRowIndex = (Integer)configMemberMap.get(configMember);
                    errorMap.put(row, ResManager.loadResFormat((String)"\u7b2c%1\u884c\u4e0e\u7b2c%2\u884c\u7ef4\u5ea6\u6210\u5458\u7ec4\u5408\u91cd\u590d\u3002", (String)"QingAnalysisDsConfigImportPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[]{repeatRowIndex + 1, row + 1}));
                } else {
                    configMemberMap.put(configMember, row);
                }
            }
            dtoList.add(configDto);
        }
    }

    private void compareCurrConfigData(List<ValueFieldConfigDto> dtoList, Map<Integer, String> errorMap) {
        List<ValueFieldConfigDto> configData = this.getConfigData();
        if (CollectionUtils.isEmpty(configData)) {
            return;
        }
        Set configMemberSet = configData.stream().map(dto -> {
            if (CollectionUtils.isNotEmpty((Collection)dto.getDims())) {
                return dto.getDims().stream().map(d -> {
                    if (CollectionUtils.isNotEmpty((Collection)d.getMembers())) {
                        return ((DimMemberDto)d.getMembers().get(0)).getNumber();
                    }
                    return "";
                }).collect(Collectors.joining(","));
            }
            return "";
        }).collect(Collectors.toSet());
        int row = 0;
        for (ValueFieldConfigDto configDto : dtoList) {
            ++row;
            String configMember = configDto.getDims().stream().map(dim -> ((DimMemberDto)dim.getMembers().get(0)).getNumber()).collect(Collectors.joining(","));
            if (!configMemberSet.contains(configMember)) continue;
            errorMap.put(row, ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u7ec4\u5408\u5df2\u5b58\u5728\u3002", (String)"QingAnalysisDsConfigImportPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void exportError(List<List<String>> oriDataList, Map<Integer, String> errorMap) {
        BgExcelWriter excelWriter = BgExcelWriter.getInstance().readTemplateByClasspath("qinganalysis/valueFieldConfig.xlsx");
        excelWriter.setStarPosition(0, 0);
        List<String> oriHeadLine = oriDataList.get(0);
        int colSize = oriHeadLine.size() + 1;
        ArrayList<String> newHeadLine = new ArrayList<String>(colSize);
        newHeadLine.add(ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"QingAnalysisDsConfigImportPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        newHeadLine.addAll(oriHeadLine);
        excelWriter.createRow(newHeadLine);
        for (int row = 1; row < oriDataList.size(); ++row) {
            List<String> oriDataLine = oriDataList.get(row);
            ArrayList<String> newDataLine = new ArrayList<String>(colSize);
            newDataLine.add(errorMap.get(row) == null ? "" : errorMap.get(row));
            newDataLine.addAll(oriDataLine);
            excelWriter.createRow(newDataLine);
        }
        String fileName = ResManager.loadKDString((String)"\u5bfc\u5165\u9519\u8bef\u8be6\u60c5.xlsx", (String)"QingAnalysisDsConfigImportPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String url = excelWriter.getDownloadUrl(fileName);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
    }

    private void exportTemplate() {
        BgExcelWriter excelWriter = BgExcelWriter.getInstance().readTemplateByClasspath("qinganalysis/valueFieldConfig.xlsx");
        excelWriter.setStarPosition(0, 0);
        List<DimensionItem> allDimension = this.getAllDimension();
        Map<String, Long> dimNumberView = QingAnalysisDSControlHelper.getDimViewMap(this.getView());
        ArrayList<Long> viewIds = new ArrayList<Long>(dimNumberView.values());
        Map viewInfoById = CollectionUtils.isEmpty(viewIds) ? new HashMap(16) : DimensionViewServiceHelper.getInstance().getViewInfoById(viewIds);
        int colSize = allDimension.size() * 2 + 1;
        ArrayList<String> newHeadLine = new ArrayList<String>(colSize);
        newHeadLine.add(ResManager.loadKDString((String)"\u540d\u79f0*", (String)"QingAnalysisDsConfigImportPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        allDimension.forEach(dimItem -> {
            newHeadLine.add(ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u6210\u5458\u7f16\u7801*", (String)"QingAnalysisDsConfigImportPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[]{dimItem.getName()}));
            newHeadLine.add(ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u6210\u5458\u540d\u79f0", (String)"QingAnalysisDsConfigImportPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[]{dimItem.getName()}));
        });
        excelWriter.createRow(newHeadLine);
        excelWriter.autoSetColumnWidth(colSize);
        for (int i = 0; i < allDimension.size(); ++i) {
            DimensionItem dimItem2 = allDimension.get(i);
            if (View.NoViewDimNums.contains(dimItem2.getNumber())) continue;
            DynamicObject view = (DynamicObject)viewInfoById.get(dimNumberView.get(dimItem2.getNumber()));
            excelWriter.setComment(0, 2 * i + 1, ResManager.loadResFormat((String)"\u8bf7\u5bfc\u5165\u89c6\u56fe\u540d\u79f0\u4e3a\u201c%1\u201d\u4e0b\u7684\u7ef4\u5ea6\u6210\u5458\u3002", (String)"QingAnalysisDsConfigPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[]{view == null ? "" : view.getString("name")}));
        }
        String fileName = ResManager.loadResFormat((String)"\u6570\u503c\u5b57\u6bb5\u7ef4\u5ea6\u6210\u5458\u5bfc\u5165\u6a21\u677f%1.xlsx", (String)"QingAnalysisDsConfigImportPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[]{DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        String url = excelWriter.getDownloadUrl(fileName);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
    }

    private List<DimensionItem> getAllDimension() {
        String valueFields = this.getPageCache().get("valuePoolField");
        return JSON.parseArray((String)valueFields, DimensionItem.class);
    }

    private List<ValueFieldConfigDto> getConfigData() {
        String configData = this.getPageCache().get("config_data");
        if (StringUtils.isBlank((CharSequence)configData)) {
            return Collections.emptyList();
        }
        List dtoList = JSON.parseArray((String)configData, ValueFieldConfigDto.class);
        if (CollectionUtils.isEmpty((Collection)dtoList)) {
            return Collections.emptyList();
        }
        return dtoList;
    }

    @Override
    public Long getModelId() {
        String modelId = this.getPageCache().get("model");
        return IDUtils.toLong((Object)modelId);
    }
}

