/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.qinganalysis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.qinganalysis.model.DimMemberDto;
import kd.epm.eb.business.qinganalysis.model.DimensionDto;
import kd.epm.eb.business.qinganalysis.model.ValueFieldConfigDto;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.excel.BgExcelWriter;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.qinganalysis.QingAnalysisDSControlHelper;
import kd.epm.eb.formplugin.qinganalysis.constant.QingAnalysisDSPluginConstants;
import kd.epm.eb.formplugin.qinganalysis.model.DimensionItem;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class QingAnalysisDSConfigPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener,
ClickListener {
    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{"configentry"});
        IPageCache pageCache = this.getPageCache();
        if (pageCache.get("valuePoolField") == null) {
            String valueFields;
            Map params = this.getView().getFormShowParameter().getCustomParams();
            pageCache.put("model", params.get("model") != null ? String.valueOf(params.get("model")) : null);
            pageCache.put("bizmodel", params.get("bizmodel") != null ? String.valueOf(params.get("bizmodel")) : null);
            pageCache.put("dataset", params.get("dataset") != null ? String.valueOf(params.get("dataset")) : null);
            pageCache.put("config_data", params.get("config_data") != null ? String.valueOf(params.get("config_data")) : null);
            String string = valueFields = params.get("valuePoolField") != null ? String.valueOf(params.get("valuePoolField")) : null;
            if (StringUtils.isBlank((CharSequence)valueFields)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u95ed\u5e76\u91cd\u65b0\u8fdb\u5165\u914d\u7f6e\u9875\u9762\u3002", (String)"QingAnalysisDsConfigPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            pageCache.put("valuePoolField", valueFields);
            this.getPageCache().put("dimension_view", (String)this.getView().getFormShowParameter().getCustomParam("dimension_view"));
        }
    }

    public void afterCreateNewData(EventObject e) {
        EntryAp entryAp = this.createDynamicEntryAp();
        if (entryAp != null) {
            QingAnalysisDSControlHelper.updateControlMetadata(this.getView(), "configentry", entryAp.createControl());
            this.initEntryValue();
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_import", "btn_export", "btn_ok"});
    }

    @Override
    public Long getModelId() {
        String modelId = this.getPageCache().get("model");
        return IDUtils.toLong((Object)modelId);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        DimensionItem dimItem;
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        String propName = e.getProperty().getName();
        String dimNumber = "";
        if (QingAnalysisDSPluginConstants.isCustomItem(propName) && (dimItem = this.findItemByKey(propName)) != null) {
            dimNumber = dimItem.getNumber();
            if (QingAnalysisDSPluginConstants.isUserDefineDimension(dimNumber)) {
                qFilter.and(new QFilter("dimension", "=", (Object)dimItem.getId()));
            } else if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
                qFilter.and(new QFilter("dataset", "=", (Object)IDUtils.toLong((Object)this.getPageCache().get("dataset"))));
            } else if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
                qFilter.and(new QFilter("datatype", "in", (Object)Lists.newArrayList((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex(), MetricDataTypeEnum.RATE.getIndex()})));
            }
        }
        long bizModelId = IDUtils.toLong((Object)this.getPageCache().get("bizmodel"));
        long datasetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
        Long modelId = this.getModelId();
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
        f7Param.setBusModelId(Long.valueOf(bizModelId));
        f7Param.setDatasetId(Long.valueOf(datasetId));
        f7Param.addCustomFilter(qFilter);
        NewF7Utils.openF7((BeforeF7SelectEvent)e, (MemberF7Parameter)f7Param);
    }

    public String getCurrentDimNumber(String controlKey) {
        DimensionItem dimItem = this.findItemByKey(controlKey);
        if (dimItem != null) {
            return dimItem.getNumber();
        }
        return "";
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (QingAnalysisDSPluginConstants.isCustomItem(key)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.isEmpty((CharSequence)newVal)) {
                Optional<DimensionDto> optional;
                DimensionItem dimItem = this.findItemByKey(key);
                List<ValueFieldConfigDto> configDataList = this.getConfigData();
                ValueFieldConfigDto configDto = configDataList.get(rowIndex);
                if (CollectionUtils.isNotEmpty((Collection)configDto.getDims()) && dimItem != null && (optional = configDto.getDims().stream().filter(d -> d.getDimNumber().equals(dimItem.getNumber())).findFirst()).isPresent()) {
                    DimensionDto dimDto = optional.get();
                    dimDto.setMembers(null);
                }
                this.updateConfigData(configDataList);
            }
        } else if ("config_name".equals(key)) {
            ChangeData changeData = e.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            List<ValueFieldConfigDto> configDataList = this.getConfigData();
            ValueFieldConfigDto configDto = configDataList.get(rowIndex);
            configDto.setName(changeData.getNewValue().toString());
            this.updateConfigData(configDataList);
        }
    }

    private List<DimensionItem> getAllDimension() {
        String valueFields = this.getPageCache().get("valuePoolField");
        return JSON.parseArray((String)valueFields, DimensionItem.class);
    }

    private DimensionItem findItemByKey(String key) {
        List<DimensionItem> allDimension = this.getAllDimension();
        Optional<DimensionItem> optional = allDimension.stream().filter(d -> d.getFieldKey().equals(key)).findFirst();
        return optional.orElse(null);
    }

    private void registerDynamicProps(MainEntityType mainEntityType) {
        List<DimensionItem> dimItems = this.getAllDimension();
        if (CollectionUtils.isEmpty(dimItems)) {
            return;
        }
        if (mainEntityType == null) {
            mainEntityType = this.getModel().getDataEntityType();
        }
        EntryType entryType = (EntryType)mainEntityType.getAllEntities().get("configentry");
        entryType.createPropIndexs();
        entryType.setDbIgnore(true);
        QingAnalysisDSControlHelper.registerSimpleProp((EntityType)entryType, "config_key");
        QingAnalysisDSControlHelper.registerSimpleProp((EntityType)entryType, "config_name");
        for (DimensionItem item : dimItems) {
            String fieldKey = item.getFieldKey();
            QingAnalysisDSControlHelper.registerSimplePropWithId((EntityType)entryType, fieldKey);
        }
    }

    private EntryAp createDynamicEntryAp() {
        List<DimensionItem> dimItems = this.getAllDimension();
        if (CollectionUtils.isEmpty(dimItems)) {
            return null;
        }
        EntryAp entryAp = QingAnalysisDSControlHelper.createEntry("configentry");
        String nameStr = ResManager.loadKDString((String)"\u540d\u79f0", (String)"QingAnalysisDsConfigPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        QingAnalysisDSControlHelper.createEntryTextFieldAp(entryAp, "config_name", nameStr, false);
        dimItems.forEach(item -> QingAnalysisDSControlHelper.createEntryTextFieldAp(entryAp, item.getFieldKey(), item.getName(), true));
        return entryAp;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            MainEntityType newEntityType = (MainEntityType)e.getOriginalEntityType().clone();
            this.registerDynamicProps(newEntityType);
            e.setNewEntityType(newEntityType);
        }
        catch (CloneNotSupportedException ex) {
            throw new KDException((Throwable)ex, new ErrorCode("getEntityType", ex.getMessage()), new Object[0]);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        String ctrlKey = e.getKey();
        if ("config_name".equals(ctrlKey) || "config_key".equals(ctrlKey)) {
            TextEdit edit = QingAnalysisDSControlHelper.createEntryTextCtl(ctrlKey, "configentry", this.getModel(), this.getView());
            e.setControl((Control)edit);
        } else if (QingAnalysisDSPluginConstants.isCustomItem(ctrlKey)) {
            DimensionItem dimItem2 = this.findItemByKey(ctrlKey);
            if (dimItem2 != null) {
                TextEdit edit = QingAnalysisDSControlHelper.createEntryTextCtl(dimItem2.getFieldKey(), "configentry", this.getModel(), this.getView());
                edit.addClickListener((ClickListener)this);
                e.setControl((Control)edit);
            }
        } else if ("configentry".equals(ctrlKey)) {
            EntryGrid entryGrid = (EntryGrid)e.getControl();
            if (entryGrid == null) {
                return;
            }
            entryGrid.getItems().clear();
            TextEdit keyEdit = QingAnalysisDSControlHelper.createEntryTextCtl("config_key", "configentry", this.getModel(), this.getView());
            entryGrid.getItems().add(keyEdit);
            TextEdit nameEdit = QingAnalysisDSControlHelper.createEntryTextCtl("config_name", "configentry", this.getModel(), this.getView());
            entryGrid.getItems().add(nameEdit);
            List<DimensionItem> allDimension = this.getAllDimension();
            if (CollectionUtils.isNotEmpty(allDimension)) {
                allDimension.forEach(dimItem -> {
                    TextEdit textCtl = QingAnalysisDSControlHelper.createEntryTextCtl(dimItem.getFieldKey(), "configentry", this.getModel(), this.getView());
                    entryGrid.getItems().add(textCtl);
                });
            }
        }
    }

    private void initEntryValue() {
        IDataModel dataModel = this.getControl("configentry").getModel();
        dataModel.deleteEntryData("configentry");
        List<ValueFieldConfigDto> dtoList = this.getConfigData();
        if (CollectionUtils.isEmpty(dtoList)) {
            dataModel.batchCreateNewEntryRow("configentry", 1);
            this.addDtoRow();
        } else {
            dataModel.batchCreateNewEntryRow("configentry", dtoList.size());
        }
        this.getControl("configentry").getModel();
        this.setDtoValueToModel();
    }

    private void setDtoValueToModel() {
        List<ValueFieldConfigDto> dtoList = this.getConfigData();
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        IDataModel dataModel = this.getControl("configentry").getModel();
        List<DimensionItem> allDim = this.getAllDimension();
        for (int i = 0; i < dtoList.size(); ++i) {
            ValueFieldConfigDto configDto = dtoList.get(i);
            dataModel.setValue("config_key", (Object)configDto.getKey(), i);
            ArrayList<DimensionDto> dimDtoList = configDto.getDims();
            if (dimDtoList == null) {
                dimDtoList = new ArrayList<DimensionDto>(16);
            }
            Map<String, DimensionDto> dimDtoMap = dimDtoList.stream().collect(Collectors.toMap(DimensionDto::getDimNumber, v -> v));
            String name = configDto.getName();
            dataModel.setValue("config_name", (Object)name, i);
            for (DimensionItem dimItem : allDim) {
                List members;
                String fieldKey = dimItem.getFieldKey();
                String dimNumber = dimItem.getNumber();
                DimensionDto dimDto = dimDtoMap.get(dimNumber);
                if (dimDto == null) {
                    dimDto = new DimensionDto();
                    dimDto.setDimNumber(dimNumber);
                    dimDto.setMembers(new ArrayList(1));
                    dimDtoList.add(dimDto);
                }
                if (CollectionUtils.isEmpty((Collection)(members = dimDto.getMembers()))) continue;
                StringBuilder sb = new StringBuilder();
                members.forEach(mem -> QingAnalysisDSControlHelper.buildMultiSelectF7ReturnValue(sb, mem.getName(), Integer.parseInt(mem.getScope())));
                this.getModel().setValue(fieldKey, (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""), i);
            }
        }
        this.updateConfigData(dtoList);
    }

    private List<ValueFieldConfigDto> getConfigData() {
        String configData = this.getPageCache().get("config_data");
        if (StringUtils.isBlank((CharSequence)configData)) {
            return new ArrayList<ValueFieldConfigDto>(16);
        }
        List dtoList = JSON.parseArray((String)configData, ValueFieldConfigDto.class);
        if (CollectionUtils.isEmpty((Collection)dtoList)) {
            return new ArrayList<ValueFieldConfigDto>(16);
        }
        return dtoList;
    }

    private void updateConfigData(List<ValueFieldConfigDto> dtoList) {
        this.getPageCache().put("config_data", JSON.toJSONString(dtoList));
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key == null) {
            return;
        }
        switch (key) {
            case "btn_ok": {
                this.saveConfig();
                break;
            }
            case "btn_import": {
                this.openImportPage();
                break;
            }
            case "btn_export": {
                this.exportConfig();
                break;
            }
            default: {
                this.openMemberF7(key);
            }
        }
    }

    private void openMemberF7(String key) {
        if (QingAnalysisDSPluginConstants.isCustomItem(key)) {
            DimensionDto dimDto2;
            ValueFieldConfigDto configDto;
            Optional<DimensionDto> optional;
            DimensionItem dimItem = this.findItemByKey(key);
            if (dimItem == null) {
                return;
            }
            String dimNumber = dimItem.getNumber();
            Long modelId = this.getModelId();
            Long dataSetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
            Long bizModelId = IDUtils.toLong((Object)this.getPageCache().get("bizmodel"));
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
            qFilters.add(new QFilter("model", "=", (Object)modelId));
            if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
                qFilters.add(new QFilter("dataset", "=", (Object)dataSetId));
            } else if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
                qFilters.add(new QFilter("datatype", "in", (Object)Lists.newArrayList((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex(), MetricDataTypeEnum.RATE.getIndex()})));
            }
            Long viewId = QingAnalysisDSControlHelper.getViewId(this.getModelId(), dataSetId, dimNumber, this.getView());
            MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
            f7Param.setBusModelId(bizModelId);
            f7Param.setDatasetId(dataSetId);
            f7Param.setViewId(viewId);
            f7Param.addCustomFilter(qFilters);
            f7Param.setReturnAllData(true);
            f7Param.setShowVariable(true);
            f7Param.setCanSelectBudgetPeriodRoot(false);
            int currRowIndex = this.getCurrRowIndex();
            List<ValueFieldConfigDto> configData = this.getConfigData();
            if (CollectionUtils.isNotEmpty(configData) && configData.size() > currRowIndex && (optional = (configDto = configData.get(currRowIndex)).getDims().stream().filter(dimDto -> dimNumber.equals(dimDto.getDimNumber())).findFirst()).isPresent() && CollectionUtils.isNotEmpty((Collection)(dimDto2 = optional.get()).getMembers())) {
                Map viewIds = modelCache.getViewsByBusModel(bizModelId);
                Set ids = dimDto2.getMembers().stream().map(e -> {
                    if (IDUtils.isNotEmptyLong((Long)e.getId()).booleanValue()) {
                        return e.getId();
                    }
                    Member member = modelCache.getMember(dimNumber, (Long)viewIds.get(dimNumber), e.getNumber());
                    return member == null ? null : member.getId();
                }).filter(Objects::nonNull).collect(Collectors.toSet());
                f7Param.setSelectIds(ids);
            }
            f7Param.setEnableView(this.checkViewSelect(configData, dimNumber, currRowIndex));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
            NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)closeCallBack);
            this.getPageCache().remove(key);
        }
    }

    private boolean checkViewSelect(List<ValueFieldConfigDto> configData, String dimNumber, int currRowIndex) {
        ArrayList<ValueFieldConfigDto> newConfigData = new ArrayList<ValueFieldConfigDto>(16);
        for (int i = 0; i < configData.size(); ++i) {
            if (i == currRowIndex) continue;
            newConfigData.add(configData.get(i));
        }
        return CollectionUtils.isEmpty(newConfigData) || newConfigData.stream().allMatch(e -> {
            Optional<DimensionDto> optional = e.getDims().stream().filter(dimDto -> dimNumber.equals(dimDto.getDimNumber())).findFirst();
            if (optional.isPresent()) {
                DimensionDto dimensionModel = optional.get();
                return CollectionUtils.isEmpty((Collection)dimensionModel.getMembers());
            }
            return false;
        });
    }

    private void addDtoRow() {
        String op = this.getPageCache().get("importtype");
        if (StringUtils.isNotBlank((CharSequence)op)) {
            return;
        }
        List<ValueFieldConfigDto> dtoList = this.getConfigData();
        ValueFieldConfigDto dto = new ValueFieldConfigDto();
        dto.setKey(QingAnalysisDSPluginConstants.createDtoKey());
        dto.setDims(this.createNewDimDto());
        dtoList.add(dto);
        this.updateConfigData(dtoList);
    }

    private List<DimensionDto> createNewDimDto() {
        List<DimensionItem> allDim = this.getAllDimension();
        return allDim.stream().map(dimItem -> {
            DimensionDto dto = new DimensionDto();
            dto.setDimNumber(dimItem.getNumber());
            return dto;
        }).collect(Collectors.toList());
    }

    private void delDtoRow(int[] delRows) {
        List<ValueFieldConfigDto> dtoList = this.getConfigData();
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        ArrayList<ValueFieldConfigDto> removeList = new ArrayList<ValueFieldConfigDto>(16);
        for (int i : delRows) {
            removeList.add(dtoList.get(i));
        }
        if (CollectionUtils.isNotEmpty(removeList)) {
            dtoList.removeAll(removeList);
            this.updateConfigData(dtoList);
        }
    }

    public void afterMoveEntryUp(AfterMoveEntryEventArgs e) {
        int[] rowIndexs;
        super.afterMoveEntryUp(e);
        for (int rowIndex : rowIndexs = e.getRowIndexs()) {
            List<ValueFieldConfigDto> dtoList = this.getConfigData();
            ValueFieldConfigDto configDto = dtoList.remove(rowIndex);
            dtoList.add(rowIndex - 1, configDto);
            this.updateConfigData(dtoList);
        }
    }

    public void afterMoveEntryDown(AfterMoveEntryEventArgs e) {
        int[] rowIndexs;
        super.afterMoveEntryDown(e);
        for (int rowIndex : rowIndexs = e.getRowIndexs()) {
            List<ValueFieldConfigDto> dtoList = this.getConfigData();
            ValueFieldConfigDto configDto = dtoList.remove(rowIndex);
            dtoList.add(rowIndex + 1, configDto);
            this.updateConfigData(dtoList);
        }
    }

    private void saveConfig() {
        List<ValueFieldConfigDto> dtoList = this.getValueFieldConfigDtoList();
        if (dtoList == null) {
            return;
        }
        HashMap<String, String> returnData = new HashMap<String, String>(16);
        returnData.put("config_data", JSON.toJSONString(dtoList));
        returnData.put("dimension_view", this.getPageCache().get("dimension_view"));
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private List<ValueFieldConfigDto> getValueFieldConfigDtoList() {
        HashMap<String, Integer> configMemberMap = new HashMap<String, Integer>(16);
        List<ValueFieldConfigDto> configDtoList = this.getConfigData();
        if (CollectionUtils.isEmpty(configDtoList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u914d\u7f6e\u3002", (String)"QingAnalysisDsConfigImportPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        for (int rowIndex = 0; rowIndex < configDtoList.size(); ++rowIndex) {
            ValueFieldConfigDto configDto = configDtoList.get(rowIndex);
            if (StringUtils.isBlank((CharSequence)configDto.getName())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u540d\u79f0\u6216\u5220\u9664\u7a7a\u884c\u3002", (String)"QingAnalysisDsConfigPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return null;
            }
            Optional<DimensionDto> dtoOptional = configDto.getDims().stream().filter(dimDto -> {
                if (CollectionUtils.isEmpty((Collection)dimDto.getMembers())) {
                    return true;
                }
                Optional<DimMemberDto> optional = dimDto.getMembers().stream().filter(memDto -> memDto == null || StringUtils.isBlank((CharSequence)memDto.getNumber())).findAny();
                return optional.isPresent();
            }).findAny();
            if (dtoOptional.isPresent()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u6210\u5458\u6216\u5220\u9664\u7a7a\u884c\u3002", (String)"QingAnalysisDsConfigPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return null;
            }
            String configMember = configDto.getDims().stream().map(dim -> ((DimMemberDto)dim.getMembers().get(0)).getNumber()).collect(Collectors.joining(","));
            if (configMemberMap.containsKey(configMember)) {
                Integer repeatRowIndex = (Integer)configMemberMap.get(configMember);
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u4e0e\u7b2c%2\u884c\u7ef4\u5ea6\u6210\u5458\u7ec4\u5408\u91cd\u590d\u3002", (String)"QingAnalysisDsConfigPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[]{repeatRowIndex + 1, rowIndex + 1}));
                return null;
            }
            configMemberMap.put(configMember, rowIndex);
        }
        return configDtoList;
    }

    private void exportConfig() {
        List<ValueFieldConfigDto> dtoList = this.getValueFieldConfigDtoList();
        if (dtoList == null || dtoList.isEmpty()) {
            return;
        }
        BgExcelWriter excelWriter = BgExcelWriter.getInstance().readTemplateByClasspath("qinganalysis/valueFieldConfig.xlsx");
        excelWriter.setStarPosition(0, 0);
        excelWriter.setStyles(null);
        List<DimensionItem> allDimension = this.getAllDimension();
        Map<String, Long> dimNumberView = QingAnalysisDSControlHelper.getDimViewMap(this.getView());
        ArrayList<Long> viewIds = new ArrayList<Long>(dimNumberView.values());
        Map viewInfoById = CollectionUtils.isEmpty(viewIds) ? new HashMap(16) : DimensionViewServiceHelper.getInstance().getViewInfoById(viewIds);
        int colSize = allDimension.size() * 2 + 1;
        ArrayList<String> newHeadLine = new ArrayList<String>(colSize);
        newHeadLine.add(ResManager.loadKDString((String)"\u540d\u79f0", (String)"QingAnalysisDsConfigPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        allDimension.forEach(dimItem -> {
            newHeadLine.add(ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u6210\u5458\u7f16\u7801", (String)"QingAnalysisDsConfigPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[]{dimItem.getName()}));
            newHeadLine.add(ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u6210\u5458\u540d\u79f0", (String)"QingAnalysisDsConfigPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[]{dimItem.getName()}));
        });
        excelWriter.createRow(newHeadLine);
        dtoList.forEach(dto -> {
            ArrayList<String> dataLine = new ArrayList<String>(colSize);
            dataLine.add(dto.getName());
            allDimension.forEach(dimItem -> {
                String dimNumber = dimItem.getNumber();
                Optional<DimensionDto> optional = dto.getDims().stream().filter(dimDto -> dimDto.getDimNumber().equals(dimNumber)).findFirst();
                if (optional.isPresent()) {
                    DimensionDto dimDto2 = optional.get();
                    dataLine.add(((DimMemberDto)dimDto2.getMembers().get(0)).getNumber());
                    dataLine.add(((DimMemberDto)dimDto2.getMembers().get(0)).getName());
                } else {
                    dataLine.add("");
                    dataLine.add("");
                }
            });
            excelWriter.createRow(dataLine);
        });
        excelWriter.autoSetColumnWidth(colSize);
        for (int i = 0; i < allDimension.size(); ++i) {
            DimensionItem dimItem2 = allDimension.get(i);
            if (View.NoViewDimNums.contains(dimItem2.getNumber())) continue;
            DynamicObject view = (DynamicObject)viewInfoById.get(dimNumberView.get(dimItem2.getNumber()));
            excelWriter.setComment(0, 2 * i + 1, ResManager.loadResFormat((String)"\u8bf7\u5bfc\u5165\u89c6\u56fe\u540d\u79f0\u4e3a\u201c%1\u201d\u4e0b\u7684\u7ef4\u5ea6\u6210\u5458\u3002", (String)"QingAnalysisDsConfigPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[]{view == null ? "" : view.getString("name")}));
        }
        String fileName = ResManager.loadResFormat((String)"\u6570\u503c\u5b57\u6bb5\u7ef4\u5ea6\u6210\u5458_%1.xlsx", (String)"QingAnalysisDsConfigPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        String url = excelWriter.getDownloadUrl(fileName);
        ImportAndExportUtil.addTempFileCheck((String)url, (String)"eb_qinganalysisds_list", (String)ApplicationTypeEnum.BGMD.getAppnum(), (int)10000);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
    }

    private void openImportPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_qinganalysisds_confim");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "importCloseCallback");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(true);
        showParameter.setCustomParam("model", (Object)String.valueOf(this.getModelId()));
        showParameter.setCustomParam("bizmodel", (Object)this.getPageCache().get("bizmodel"));
        showParameter.setCustomParam("dataset", (Object)this.getPageCache().get("dataset"));
        showParameter.setCustomParam("valuePoolField", (Object)this.getPageCache().get("valuePoolField"));
        showParameter.setCustomParam("config_data", (Object)this.getPageCache().get("config_data"));
        showParameter.setCustomParam("dimension_view", (Object)this.getPageCache().get("dimension_view"));
        this.getView().showForm(showParameter);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        this.addDtoRow();
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.delDtoRow(e.getRowIndexs());
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("importCloseCallback".equals(actionId)) {
            Object returnData = evt.getReturnData();
            if (returnData == null) {
                return;
            }
            JSONObject jsonObject = JSON.parseObject((String)returnData.toString());
            String op = jsonObject.getString("importtype");
            String importData = jsonObject.getString("config_data");
            if (StringUtils.isBlank((CharSequence)importData)) {
                return;
            }
            List dtoList = JSON.parseArray((String)importData, ValueFieldConfigDto.class);
            if (CollectionUtils.isEmpty((Collection)dtoList)) {
                return;
            }
            this.getPageCache().put("importtype", op);
            if ("2".equals(op)) {
                this.updateConfigData(dtoList);
            } else {
                List<ValueFieldConfigDto> configData = this.getConfigData();
                configData.addAll(dtoList);
                this.updateConfigData(configData);
            }
            this.initEntryValue();
            this.getPageCache().remove("importtype");
        } else if (QingAnalysisDSPluginConstants.isCustomItem(actionId)) {
            ListSelectedRowCollection members;
            if (evt.getReturnData() == null) {
                return;
            }
            DimensionItem dimItem = this.findItemByKey(actionId);
            if (dimItem == null) {
                return;
            }
            if (evt.getReturnData() instanceof ListSelectedRowCollection && CollectionUtils.isNotEmpty((Collection)(members = (ListSelectedRowCollection)evt.getReturnData()))) {
                Optional<DimensionDto> optional;
                int rowIndex = this.getCurrRowIndex();
                String dimNumber = dimItem.getNumber();
                ListSelectedRow row = members.get(0);
                String memName = row.getName();
                StringBuilder sb = new StringBuilder();
                QingAnalysisDSControlHelper.buildMultiSelectF7ReturnValue(sb, memName, RangeEnum.ONLY.getIndex());
                this.getModel().setValue(actionId, (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""), rowIndex);
                List<ValueFieldConfigDto> configDataList = this.getConfigData();
                ValueFieldConfigDto configDto = configDataList.get(rowIndex);
                if (CollectionUtils.isNotEmpty((Collection)configDto.getDims()) && (optional = configDto.getDims().stream().filter(d -> d.getDimNumber().equals(dimNumber)).findFirst()).isPresent()) {
                    DimensionDto dimDto = optional.get();
                    DimMemberDto memDto = new DimMemberDto();
                    memDto.setId(IDUtils.toLong((Object)row.getPrimaryKeyValue()));
                    memDto.setName(memName);
                    memDto.setNumber(row.getNumber());
                    memDto.setScope(String.valueOf(RangeEnum.ONLY.getIndex()));
                    dimDto.setMembers(Collections.singletonList(memDto));
                }
                if (StringUtils.isBlank((CharSequence)configDto.getName())) {
                    this.getModel().setValue("config_name", (Object)memName, rowIndex);
                    configDto.setName(memName);
                }
                Object viewId = row.getDataMap().get("viewid");
                QingAnalysisDSControlHelper.updateDimensionView(dimNumber, IDUtils.toLong(viewId), this.getView());
                this.updateConfigData(configDataList);
            }
        }
    }

    private int getCurrRowIndex() {
        return this.getModel().getEntryCurrentRowIndex("configentry");
    }
}

