/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.qinganalysis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.qinganalysis.model.TextEditSelectItem;

public class QingAnalysisDSControlHelper {
    static void updateControlMetadata(IFormView view, String key, Map<String, Object> ctl) {
        ArrayList<Object> paras = new ArrayList<Object>(2);
        paras.add(key);
        ctl.computeIfAbsent("items", k -> new Object[0]);
        paras.add(ctl);
        IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        clientViewProxy.addAction("updateControlMetadata", paras);
    }

    static void registerComplexProp(EntityType entityType, String fieldKey, String baseDataEntity) {
        BasedataProp basedataProp = new BasedataProp();
        basedataProp.setName(fieldKey);
        basedataProp.setBaseEntityId(baseDataEntity);
        basedataProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)baseDataEntity));
        LongProp idProp = new LongProp();
        idProp.setName(fieldKey + "_id");
        idProp.setDbIgnore(true);
        basedataProp.setRefIdProp((IDataEntityProperty)idProp);
        basedataProp.setRefIdPropName(idProp.getName());
        entityType.addProperty((DynamicProperty)basedataProp);
        entityType.addProperty((DynamicProperty)idProp);
    }

    static void registerSimplePropWithId(EntityType entityType, String fieldKey) {
        TextProp textProp = new TextProp();
        textProp.setName(fieldKey);
        textProp.setDbIgnore(true);
        entityType.addProperty((DynamicProperty)textProp);
        LongProp idProp = new LongProp();
        idProp.setName(fieldKey + "_id");
        idProp.setDbIgnore(true);
        entityType.addProperty((DynamicProperty)idProp);
    }

    static void registerSimpleProp(EntityType entityType, String fieldKey) {
        TextProp textProp = new TextProp();
        textProp.setName(fieldKey);
        textProp.setDbIgnore(true);
        entityType.addProperty((DynamicProperty)textProp);
    }

    static TextEdit createTextCtl(String key, IDataModel dataModel, IFormView view) {
        return QingAnalysisDSControlHelper.createEntryTextCtl(key, "", dataModel, view);
    }

    static TextEdit createEntryTextCtl(String key, String entryKey, IDataModel dataModel, IFormView view) {
        TextEdit edit = new TextEdit();
        edit.setKey(key);
        edit.setView(view);
        edit.setModel(dataModel);
        if (StringUtils.isNotEmpty((String)entryKey)) {
            edit.setEntryKey(entryKey);
        }
        return edit;
    }

    static BasedataEdit createBaseDataCtl(String key, IDataModel dataModel, IFormView view) {
        return QingAnalysisDSControlHelper.createEntryBaseDataCtl(key, "", dataModel, view);
    }

    static BasedataEdit createEntryBaseDataCtl(String key, String entryKey, IDataModel dataModel, IFormView view) {
        BasedataEdit edit = new BasedataEdit();
        edit.setKey(key);
        edit.setModel(dataModel);
        edit.setView(view);
        if (StringUtils.isNotEmpty((String)entryKey)) {
            edit.setEntryKey(entryKey);
        }
        return edit;
    }

    static FlexPanelAp createFlexPanel(String key) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(key);
        return flexPanelAp;
    }

    static EntryAp createEntry(String key) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey(key);
        return entryAp;
    }

    static FieldAp createEntryTextFieldAp(EntryAp entryAp, String fieldKey, String name, boolean selectEdit) {
        EntryFieldAp textFieldAp = new EntryFieldAp();
        textFieldAp.setId(fieldKey);
        textFieldAp.setKey(fieldKey);
        textFieldAp.setName(new LocaleString(name));
        textFieldAp.setFireUpdEvt(true);
        textFieldAp.setWidth(new LocaleString("150px"));
        TextField textField = new TextField();
        textField.setId(fieldKey);
        textField.setKey(fieldKey);
        textField.setMustInput(true);
        textField.setMaxLength(50);
        if (selectEdit) {
            textField.setEditStyle(1);
        }
        textFieldAp.setField((Field)textField);
        entryAp.getItems().add(textFieldAp);
        return textFieldAp;
    }

    static FieldAp createTextFieldAp(FlexPanelAp flexPanelAp, String fieldKey, String name, boolean isLock, boolean selectEdit) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setName(new LocaleString(name));
        fieldAp.setQuickAddNew(false);
        fieldAp.setKey(fieldKey);
        fieldAp.setShowTitle(true);
        TextField textField = new TextField();
        if (selectEdit) {
            textField.setEditStyle(1);
        }
        fieldAp.setField((Field)textField);
        QingAnalysisDSControlHelper.setFieldStyle(fieldAp, isLock);
        flexPanelAp.getItems().add(fieldAp);
        return fieldAp;
    }

    static FieldAp createBaseDataFieldAp(FlexPanelAp flexPanelAp, String fieldKey, String name, String baseDataEntity) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setName(new LocaleString(name));
        fieldAp.setQuickAddNew(false);
        fieldAp.setKey(fieldKey);
        fieldAp.setShowTitle(true);
        BasedataField baseData = new BasedataField();
        baseData.setViewDetail(false);
        baseData.setBaseEntityId(baseDataEntity);
        fieldAp.setField((Field)baseData);
        QingAnalysisDSControlHelper.setFieldStyle(fieldAp, false);
        flexPanelAp.getItems().add(fieldAp);
        return fieldAp;
    }

    static EntryFieldAp createEntryBaseDataFieldAp(EntryAp entryAp, String fieldKey, String name) {
        EntryFieldAp fieldAp = new EntryFieldAp();
        fieldAp.setId(fieldKey);
        fieldAp.setKey(fieldKey);
        fieldAp.setName(new LocaleString(name));
        fieldAp.setQuickAddNew(false);
        fieldAp.setFireUpdEvt(true);
        fieldAp.setF7MultipleSelect(false);
        BasedataField baseData = new BasedataField();
        baseData.setViewDetail(false);
        baseData.setMustInput(true);
        fieldAp.setField((Field)baseData);
        entryAp.getItems().add(fieldAp);
        return fieldAp;
    }

    private static void setFieldStyle(FieldAp fieldAp, boolean isLock) {
        fieldAp.setWidth(new LocaleString("260px"));
        if (isLock) {
            fieldAp.setLock("new,edit,view");
            fieldAp.setWidth(new LocaleString("120px"));
        }
        fieldAp.setFieldTextAlign("center");
        fieldAp.setHeight(new LocaleString("40px"));
        Style style = new Style();
        Margin margin = new Margin();
        Padding padding = new Padding();
        padding.setRight("14px");
        padding.setLeft("14px");
        margin.setLeft("10px");
        margin.setRight("10px");
        margin.setTop("2px");
        margin.setBottom("2px");
        style.setMargin(margin);
        style.setPadding(padding);
        fieldAp.setStyle(style);
        fieldAp.setFireUpdEvt(true);
    }

    public static void buildMultiSelectF7ReturnValue(StringBuilder sb, String name, int val) {
        if (RangeEnum.getRangeByVal((int)val) == RangeEnum.ONLY) {
            sb.append(name).append(',');
        } else {
            sb.append(name).append(ResManager.loadKDString((String)"\u7684", (String)"BgTemplatePartitionSettingPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)val).getName()).append(',');
        }
    }

    public static void openCustomF7Range(Long modelId, Long dataSetId, Long bizModelId, String dimNumber, long viewId, String callback, List<QFilter> qFilters, String selectItemStr, IFormView formView, IFormPlugin formPlugin) {
        RangeF7Param param = new RangeF7Param();
        param.setCloseCallBack(new CloseCallBack(formPlugin, callback));
        param.setEnableView(true);
        param.setNeedPermCheck(true);
        param.setSign(dimNumber);
        param.setIsNeedVar("isNeedVar");
        param.setBizModelId(bizModelId);
        param.setDatasetId(dataSetId);
        param.setCanSelectBudgetPeriodRoot(false);
        if (StringUtils.isNotEmpty((String)selectItemStr)) {
            List selectItemList = JSON.parseArray((String)selectItemStr, TextEditSelectItem.class);
            List conList = selectItemList.stream().map(s -> {
                MemberCondition memberCondition = new MemberCondition();
                if (StringUtils.isNotEmpty((String)s.getId()) && !"null".equalsIgnoreCase(s.getId()) && !"0".equalsIgnoreCase(s.getId())) {
                    memberCondition.setId(s.getId());
                }
                memberCondition.setNumber(s.getNumber());
                memberCondition.setRange(s.getScope());
                return memberCondition;
            }).collect(Collectors.toList());
            param.setCon_list(conList);
        }
        CustomF7utils.openCustomF7Range((Long)modelId, (String)dimNumber, (Long)viewId, (IFormView)formView, (RangeF7Param)param);
    }

    public static void openNewF7(Long modelId, Long dataSetId, Long bizModelId, String dimNumber, long viewId, String callback, List<QFilter> qFilters, String selectItemStr, IFormView formView, IFormPlugin formPlugin) {
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
        f7Param.setBusModelId(bizModelId);
        f7Param.setDatasetId(dataSetId);
        f7Param.setViewId(Long.valueOf(viewId));
        f7Param.addCustomFilter(qFilters);
        f7Param.setEnableView(true);
        f7Param.setReturnAllData(true);
        f7Param.setShowVariable(true);
        f7Param.setCanSelectBudgetPeriodRoot(false);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        if (StringUtils.isNotEmpty((String)selectItemStr)) {
            List selectItemList = JSON.parseArray((String)selectItemStr, TextEditSelectItem.class);
            Set ids = selectItemList.stream().map(p -> {
                if (StringUtils.isNotEmpty((String)p.getId()) && !"null".equalsIgnoreCase(p.getId()) && !"0".equalsIgnoreCase(p.getId())) {
                    return IDUtils.toLong((Object)p.getId());
                }
                Member member = modelCache.getMember(dimNumber, Long.valueOf(viewId), p.getNumber());
                return member == null ? null : member.getId();
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            f7Param.setSelectIds(ids);
        }
        CloseCallBack closeCallBack = new CloseCallBack(formPlugin, callback);
        NewF7Utils.openF7((IFormView)formView, (MemberF7Parameter)f7Param, (CloseCallBack)closeCallBack);
    }

    public static void updateDimensionView(String dimNumber, Long viewId, IFormView formView) {
        String dimViewStr = formView.getPageCache().get("dimension_view");
        JSONObject dimensionViews = StringUtils.isNotEmpty((String)dimViewStr) ? JSON.parseObject((String)dimViewStr) : new JSONObject();
        if (IDUtils.isNotEmptyLong((Long)viewId).booleanValue()) {
            dimensionViews.put(dimNumber, (Object)viewId);
        }
        formView.getPageCache().put("dimension_view", JSON.toJSONString((Object)dimensionViews));
    }

    public static Long getViewId(Long modelId, Long dataSetId, String dimNumber, IFormView formView) {
        JSONObject dimView;
        String dimViewStr = formView.getPageCache().get("dimension_view");
        Long viewId = StringUtils.isNotEmpty((String)dimViewStr) ? ((dimView = JSON.parseObject((String)dimViewStr)).getLong(dimNumber) == null ? QingAnalysisDSControlHelper.getDimDefaultView(modelId, dataSetId, dimNumber) : dimView.getLong(dimNumber)) : QingAnalysisDSControlHelper.getDimDefaultView(modelId, dataSetId, dimNumber);
        return viewId;
    }

    public static Map<String, Long> getDimViewMap(IFormView formView) {
        String dimViewStr = formView.getPageCache().get("dimension_view");
        JSONObject dimensionView = new JSONObject();
        HashMap<String, Long> dimNumberView = new HashMap<String, Long>(16);
        if (StringUtils.isNotEmpty((String)dimViewStr)) {
            dimensionView = JSONObject.parseObject((String)dimViewStr);
        }
        for (String key : dimensionView.keySet()) {
            if (View.NoViewDimNums.contains(key)) continue;
            dimNumberView.put(key, dimensionView.getLong(key));
        }
        return dimNumberView;
    }

    public static Long getDimDefaultView(Long modelId, Long datasetId, String dimNumber) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        return IDUtils.toLong((Object)modelCache.getViewByDataSetAndDimNumber(datasetId, dimNumber));
    }
}

