/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.qinganalysis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.event.ISpreadAction;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.qinganalysis.QingAnalysisDSConstants;
import kd.epm.eb.business.qinganalysis.QingAnalysisDSQuery;
import kd.epm.eb.business.qinganalysis.QingAnalysisDSService;
import kd.epm.eb.business.qinganalysis.QingAnalysisDSVarService;
import kd.epm.eb.business.qinganalysis.entity.QingAnalysisDS;
import kd.epm.eb.business.qinganalysis.entity.QingAnalysisDSVar;
import kd.epm.eb.business.qinganalysis.model.DimMemberDto;
import kd.epm.eb.business.qinganalysis.model.DimensionDto;
import kd.epm.eb.business.qinganalysis.model.DsDataModel;
import kd.epm.eb.business.qinganalysis.model.ValueFieldConfigDto;
import kd.epm.eb.business.qinganalysis.processor.IQingAnalysisDSProcessor;
import kd.epm.eb.business.qinganalysis.processor.PreviewProcessor;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.qinganalysis.QingAnalysisDSControlHelper;
import kd.epm.eb.formplugin.qinganalysis.constant.QingAnalysisDSPluginConstants;
import kd.epm.eb.formplugin.qinganalysis.model.DimensionItem;
import kd.epm.eb.formplugin.qinganalysis.model.TextEditSelectItem;
import kd.epm.eb.spread.adaptor.SpreadJsAction;
import kd.epm.eb.spread.command.event.SpreadActionListener;
import kd.epm.eb.spread.control.SpreadContainer;
import org.apache.commons.collections4.CollectionUtils;

public class QingAnalysisDSEditPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener,
ClickListener,
SpreadActionListener {
    public void initialize() {
        super.initialize();
        this.getView().addService(ISpreadAction.class, (Object)new SpreadJsAction((AbstractFormPlugin)this, "previewspread"));
    }

    public void afterCreateNewData(EventObject e) {
        this.setInitData();
    }

    public void afterLoadData(EventObject e) {
        this.setFieldDisabled();
        this.setInitData();
        this.initDimPool();
        String dsStatus = this.getPageCache().get("status");
        if (QingAnalysisDSConstants.Status.RELEASE.getValue().equals(dsStatus)) {
            this.setPublishFieldDisable();
        }
    }

    public void afterBindData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"spreadpanel"});
        if (this.isNewEbForm()) {
            Label label = (Label)this.getControl("labelap");
            label.hideTips();
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"btn_valueconfig", "btn_bpftype"});
        BasedataEdit dataSet = (BasedataEdit)this.getControl("dataset");
        dataSet.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private void setFieldDisabled() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"bizmodel", "dataset"});
    }

    private void setPublishFieldDisable() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"btn_save", "btn_publish", "btn_valueconfig"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"name", "hidepool", "textpool", "valuepool", "filterempty", "btn_bpftype"});
        this.setDragDisable();
    }

    private void setInitData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String modelId = (String)formShowParameter.getCustomParam("model");
        if (StringUtils.isEmpty((String)modelId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e3a\u7a7a\u3002", (String)"QingAnalysisDsEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put("model", modelId);
        this.getModel().setValue("model", (Object)modelId);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btn_bpftype"});
        String pkId = (String)formShowParameter.getCustomParam("id");
        if (StringUtils.isNotEmpty((String)pkId)) {
            QingAnalysisDS model = QingAnalysisDSService.getInstance().load(IDUtils.toLong((Object)pkId));
            DsDataModel dsDataModel = (DsDataModel)JSON.parseObject((String)model.getData(), DsDataModel.class);
            this.getPageCache().put("id", pkId);
            this.getPageCache().put("status", model.getStatus());
            this.getPageCache().put("data_model", JSON.toJSONString((Object)dsDataModel));
            this.getPageCache().put("bizmodel", String.valueOf(model.getBizModelId()));
            this.getPageCache().put("dataset", String.valueOf(model.getDataset()));
            this.getModel().setValue("bizmodel", (Object)model.getBizModelId());
            this.getModel().setValue("dataset", (Object)model.getDataset());
            Optional<DimensionDto> optional = dsDataModel.getTextFields().stream().filter(dim -> SysDimensionEnum.BudgetPeriod.getNumber().equals(dim.getDimNumber())).findAny();
            if (optional.isPresent()) {
                this.getPageCache().put("bpfieldtype", StringUtils.isNotEmpty((String)model.getBpFieldType()) ? model.getBpFieldType() : "2");
            }
        }
    }

    @Override
    public Long getModelId() {
        String modelId = this.getPageCache().get("model");
        if (StringUtils.isEmpty((String)modelId)) {
            DynamicObject value = (DynamicObject)this.getModel().getValue("model");
            if (value == null) {
                return 0L;
            }
            modelId = value.getString("id");
            this.getPageCache().put("model", modelId);
        }
        return IDUtils.toLong((Object)modelId);
    }

    protected Long getBizModelId() {
        Long bizModelId = (Long)this.getValue("bizmodel", "id");
        if (bizModelId == null) {
            bizModelId = 0L;
        }
        return bizModelId;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        DimensionItem dimItem;
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        String propName = e.getProperty().getName();
        if (QingAnalysisDSPluginConstants.isCustomItem(propName) && (dimItem = this.findItemByKey(propName)) != null) {
            String dimNumber = dimItem.getNumber();
            String bizModelId = this.getPageCache().get("bizmodel");
            Long modelId = this.getModelId();
            Long dataSetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
            long viewId = QingAnalysisDSControlHelper.getViewId(modelId, dataSetId, dimNumber, this.getView());
            MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
            f7Param.setBusModelId(IDUtils.toLong((Object)bizModelId));
            f7Param.setDatasetId(dataSetId);
            if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
                f7Param.addCustomFilter(new QFilter("datatype", "in", (Object)Lists.newArrayList((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex(), MetricDataTypeEnum.RATE.getIndex()})));
            }
            f7Param.setEnableView(true);
            f7Param.setViewId(Long.valueOf(viewId));
            f7Param.setReturnAllData(true);
            f7Param.setCutTree(false);
            f7Param.setShowVariable(true);
            NewF7Utils.openF7((BeforeF7SelectEvent)e, (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, propName));
        }
        e.addCustomQFilter(qFilter);
    }

    public String getCurrentDimNumber(String controlKey) {
        DimensionItem dimItem = this.findItemByKey(controlKey);
        return dimItem.getNumber();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove("all_dim");
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("dataset".equals(key)) {
            DynamicObject newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newVal != null) {
                String dataSetId = newVal.getString("id");
                this.getPageCache().put("dataset", dataSetId);
                Long bizModelId = this.getIModelCacheHelper().getBusModelByDataSet(IDUtils.toLong((Object)dataSetId));
                this.getModel().setValue("bizmodel", (Object)bizModelId);
                this.getPageCache().put("bizmodel", String.valueOf(bizModelId));
                this.getPageCache().put("bpfieldtype", "1");
                this.clearDimPool();
                this.initDimPool();
            } else {
                this.getPageCache().put("dataset", null);
                this.getPageCache().put("bizmodel", null);
                this.clearDimPool();
            }
        } else if (QingAnalysisDSPluginConstants.isCustomItem(key)) {
            DimensionItem dimItem = this.findItemByKey(key);
            if (dimItem == null) {
                return;
            }
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.isEmpty((String)newVal)) {
                this.getPageCache().remove(dimItem.getFieldKey() + "_select");
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_save": {
                this.save(true);
                break;
            }
            case "btn_publish": {
                this.publish();
                break;
            }
            case "btn_preview": {
                this.preview();
                break;
            }
        }
    }

    private boolean save(boolean showSuccessMsg) {
        if (!this.check()) {
            return false;
        }
        List<DimensionItem> allDims = this.getAllDimension();
        String hideFieldStr = allDims.stream().filter(d -> "hidepool".equals(d.getPanel())).map(DimensionItem::getName).collect(Collectors.joining(","));
        if (StringUtils.isEmpty((String)hideFieldStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9690\u85cf\u5b57\u6bb5\u4e0d\u5141\u8bb8\u5c11\u4e8e\u4e00\u4e2a\uff0c\u8bf7\u914d\u7f6e\u3002", (String)"QingAnalysisDsEditPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        String textFieldStr = allDims.stream().filter(d -> "textpool".equals(d.getPanel())).map(DimensionItem::getName).collect(Collectors.joining(","));
        if (StringUtils.isEmpty((String)textFieldStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u672c\u5b57\u6bb5\u4e0d\u5141\u8bb8\u5c11\u4e8e\u4e00\u4e2a\uff0c\u8bf7\u914d\u7f6e\u3002", (String)"QingAnalysisDsEditPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        String valueFieldStr = allDims.stream().filter(d -> "valuepool".equals(d.getPanel())).map(DimensionItem::getName).collect(Collectors.joining(","));
        RequestContext requestContext = RequestContext.get();
        Date now = TimeServiceHelper.now();
        Long id = IDUtils.toLong((Object)this.getPageCache().get("id"));
        String number = (String)this.getModel().getValue("number");
        if (IDUtils.isNull((Long)id)) {
            number = "QingAnalysisDS-" + System.currentTimeMillis();
            this.getModel().setValue("number", (Object)number);
        }
        DsDataModel dataModel = this.buildDataModelFromPage(allDims);
        QingAnalysisDS model = new QingAnalysisDS();
        model.setId(id);
        model.setName((ILocaleString)this.getModel().getValue("name"));
        model.setNumber(number);
        model.setModelId(this.getModelId());
        model.setBizModelId(IDUtils.toLong((Object)this.getPageCache().get("bizmodel")));
        model.setDataset(IDUtils.toLong((Object)this.getPageCache().get("dataset")));
        model.setStatus(QingAnalysisDSConstants.Status.SAVE.getValue());
        model.setTextField(textFieldStr);
        model.setValueField(valueFieldStr);
        model.setData(JSON.toJSONString((Object)dataModel));
        model.setDataModel(dataModel);
        model.setFilterEmpty((Boolean)this.getModel().getValue("filterempty"));
        model.setBpFieldType(this.getPageCache().get("bpfieldtype"));
        model.setCreatorId(Long.valueOf(requestContext.getCurrUserId()));
        model.setCreateTime(now);
        model.setModifierId(Long.valueOf(requestContext.getCurrUserId()));
        model.setModifyTime(now);
        id = QingAnalysisDSService.getInstance().save(model);
        this.getPageCache().put("id", String.valueOf(id));
        this.setFieldDisabled();
        if (showSuccessMsg) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"QingAnalysisDsEditPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "QingAnalysisDsEditPlugin_15", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f\u3002", "QingAnalysisDsEditPlugin_7", "epm-eb-formplugin");
            this.writeLog(null, "save", opName, opDesc, null);
        }
        return true;
    }

    private DsDataModel buildDataModelFromPage(List<DimensionItem> allDims) {
        String dimViewStr = this.getPageCache().get("dimension_view");
        JSONObject dimensionViews = StringUtils.isNotEmpty((String)dimViewStr) ? JSON.parseObject((String)dimViewStr) : new JSONObject();
        String configData = this.getPageCache().get("config_data");
        List dtoList = StringUtils.isNotEmpty((String)configData) ? JSON.parseArray((String)configData, ValueFieldConfigDto.class) : Collections.emptyList();
        List hideDims = allDims.stream().filter(d -> "hidepool".equals(d.getPanel())).map(this::buildDimensionDto).collect(Collectors.toList());
        List textDims = allDims.stream().filter(d -> "textpool".equals(d.getPanel())).map(this::buildDimensionDto).collect(Collectors.toList());
        List valueDimNumberList = allDims.stream().filter(d -> "valuepool".equals(d.getPanel())).map(DimensionItem::getNumber).collect(Collectors.toList());
        dtoList.forEach(dto -> {
            List newDto = dto.getDims().stream().filter(e -> valueDimNumberList.contains(e.getDimNumber())).collect(Collectors.toList());
            dto.setDims(newDto);
        });
        this.getPageCache().put("config_data", JSON.toJSONString((Object)dtoList));
        DsDataModel dataModel = new DsDataModel();
        dataModel.setHideFields(hideDims);
        dataModel.setTextFields(textDims);
        dataModel.setValueFields(valueDimNumberList);
        dataModel.setValueFieldConf(dtoList);
        dataModel.setDimensionViews(dimensionViews);
        return dataModel;
    }

    private DimensionDto buildDimensionDto(DimensionItem d) {
        DimensionDto dto = new DimensionDto();
        String dimNumber = d.getNumber();
        dto.setDimNumber(dimNumber);
        String fieldKey = d.getFieldKey();
        List memDtoList = Collections.emptyList();
        String selectStr = this.getPageCache().get(fieldKey + "_select");
        if (StringUtils.isNotEmpty((String)selectStr)) {
            List selectItems = JSON.parseArray((String)selectStr, TextEditSelectItem.class);
            memDtoList = selectItems.stream().map(item -> {
                String memNumber = item.getNumber();
                DimMemberDto memDto = new DimMemberDto();
                memDto.setId(IDUtils.toLong((Object)item.getId()));
                memDto.setName(item.getName());
                memDto.setNumber(memNumber);
                memDto.setScope(item.getScope());
                return memDto;
            }).collect(Collectors.toList());
        }
        dto.setMembers(memDtoList);
        return dto;
    }

    private void preview() {
        Optional<QingAnalysisDSVar> optional;
        if (!this.save(false)) {
            return;
        }
        Long qingDsId = IDUtils.toLong((Object)this.getPageCache().get("id"));
        List varList = QingAnalysisDSVarService.getInstance().queryVarConf(this.getModelId().longValue(), qingDsId.longValue());
        if (CollectionUtils.isNotEmpty((Collection)varList) && (optional = varList.stream().filter(var -> StringUtils.isEmpty((String)var.getVariableJson())).findAny()).isPresent()) {
            HashMap<Integer, String> btnNames = new HashMap<Integer, String>(2);
            btnNames.put(2, ResManager.loadKDString((String)"\u53d6\u6d88", (String)"QingAnalysisDsEditPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            btnNames.put(6, ResManager.loadKDString((String)"\u53d8\u91cf\u8d4b\u503c", (String)"QingAnalysisDsEditPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u53d8\u91cf\u672a\u8d4b\u503c\uff0c\u8bf7\u5bf9\u53d8\u91cf\u8d4b\u503c\u3002", (String)"QingAnalysisDsEditPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("varConf", (IFormPlugin)this), btnNames);
            return;
        }
        DsDataModel dataModel = this.buildDataModelFromPage(this.getAllDimension());
        dataModel = QingAnalysisDSService.getInstance().checkFieldIsComplete(this.getModelId().longValue(), dataModel, this.getView());
        if (dataModel == null) {
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"spreadpanel"});
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        long dataSetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
        SpreadContainer spreadContainer = new SpreadContainer(this.getView(), "previewspread");
        PreviewProcessor previewProcessor = new PreviewProcessor(qingDsId, spreadContainer, modelCache, dataModel);
        QingAnalysisDSQuery qingAnalysisDSQuery = new QingAnalysisDSQuery(dataModel, modelCache, dataSetId, (IQingAnalysisDSProcessor)previewProcessor, 1, 1000);
        qingAnalysisDSQuery.query();
    }

    private void publish() {
        if (!this.save(false)) {
            return;
        }
        Long id = IDUtils.toLong((Object)this.getPageCache().get("id"));
        DsDataModel dataModel = QingAnalysisDSService.getInstance().publishCheck(id.longValue(), this.getView());
        if (dataModel == null) {
            return;
        }
        QingAnalysisDSService.getInstance().updateStatus(QingAnalysisDSConstants.Status.RELEASE, Collections.singletonList(id));
        this.setPublishFieldDisable();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f\u3002", (String)"QingAnalysisDsEditPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private boolean check() {
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
        if (name == null || name.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e3a\u7a7a\u3002", (String)"QingAnalysisDsEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject dataObj = (DynamicObject)this.getModel().getValue("dataset");
        if (dataObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6\u3002", (String)"QingAnalysisDsEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String key = evt.getCallBackId();
        if ("varConf".equals(key) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.openVariableConfigPage();
        }
    }

    private void openValueFieldConfigPage() {
        List<DimensionItem> allDimension = this.getAllDimension();
        List valueFields = allDimension.stream().filter(d -> "valuepool".equals(d.getPanel())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(valueFields)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u6210\u6570\u503c\u5b57\u6bb5\u7ef4\u5ea6\u81f3\u5c11\u6709\u4e00\u4e2a\u7ef4\u5ea6\u3002", (String)"QingAnalysisDsEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long modelId = this.getModelId();
        Long datasetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
        JSONObject dimView = new JSONObject();
        valueFields.stream().map(DimensionItem::getNumber).forEach(dimNumber -> dimView.put(dimNumber, (Object)QingAnalysisDSControlHelper.getViewId(modelId, datasetId, dimNumber, this.getView())));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_qinganalysisds_config");
        showParameter.setShowTitle(true);
        showParameter.setCaption(ResManager.loadKDString((String)"\u6570\u503c\u5b57\u6bb5\u914d\u7f6e", (String)"QingAnalysisDsEditPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("model", (Object)String.valueOf(this.getModelId()));
        showParameter.setCustomParam("bizmodel", (Object)this.getPageCache().get("bizmodel"));
        showParameter.setCustomParam("dataset", (Object)this.getPageCache().get("dataset"));
        showParameter.setCustomParam("dimension_view", (Object)dimView.toJSONString());
        showParameter.setCustomParam("valuePoolField", (Object)JSON.toJSONString(valueFields));
        showParameter.setCustomParam("config_data", (Object)this.getPageCache().get("config_data"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "configCloseCallback");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void openFieldTypeConfigPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_qinganalysisds_ftype");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("bpfieldtype", (Object)this.getPageCache().get("bpfieldtype"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "fieldTypeCloseCallback");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void openVariableConfigPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_qingds_varconf");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("model", (Object)String.valueOf(this.getModelId()));
        showParameter.setCustomParam("id", (Object)this.getPageCache().get("id"));
        showParameter.setCustomParam("bizmodel", (Object)String.valueOf(this.getBizModelId()));
        showParameter.setCustomParam("dataset", (Object)this.getPageCache().get("dataset"));
        this.getView().showForm(showParameter);
    }

    private void clearDimPool() {
        FlexPanelAp hidePanel = QingAnalysisDSControlHelper.createFlexPanel("hidepool");
        hidePanel.getItems().clear();
        QingAnalysisDSControlHelper.updateControlMetadata(this.getView(), "hidepool", hidePanel.createControl());
        FlexPanelAp textPanel = QingAnalysisDSControlHelper.createFlexPanel("textpool");
        textPanel.getItems().clear();
        QingAnalysisDSControlHelper.updateControlMetadata(this.getView(), "textpool", textPanel.createControl());
        FlexPanelAp valuePanel = QingAnalysisDSControlHelper.createFlexPanel("valuepool");
        valuePanel.getItems().clear();
        QingAnalysisDSControlHelper.updateControlMetadata(this.getView(), "valuepool", valuePanel.createControl());
        FlexPanelAp valueConfPanel = QingAnalysisDSControlHelper.createFlexPanel("valueconfigpool");
        valueConfPanel.getItems().clear();
        QingAnalysisDSControlHelper.updateControlMetadata(this.getView(), "valueconfigpool", valueConfPanel.createControl());
        this.getPageCache().remove("config_data");
        this.getPageCache().remove("all_dim");
        this.getPageCache().remove("dimension_view");
    }

    private void initDimPool() {
        this.getPageCache().remove("all_dim");
        this.refreshDimPool();
        this.registerDynamicProps(null);
        this.setDraggable();
        this.setDefaultValue();
        this.refreshConfigPool();
        this.refreshFieldTypeBtn();
    }

    private void refreshDimPool() {
        this.initDimPanel("hidepool");
        this.initDimPanel("textpool");
        this.initDimPanel("valuepool");
    }

    private void initDimPanel(String panel) {
        FlexPanelAp flexPanelAp = QingAnalysisDSControlHelper.createFlexPanel(panel);
        List<DimensionItem> allDims = this.getAllDimension();
        List<DimensionItem> panelDims = allDims.stream().filter(d -> panel.equals(d.getPanel())).collect(Collectors.toList());
        this.addDimItems(flexPanelAp, panelDims);
        QingAnalysisDSControlHelper.updateControlMetadata(this.getView(), panel, flexPanelAp.createControl());
    }

    private List<DimensionItem> loadAllDim() {
        String dataSetId = this.getPageCache().get("dataset");
        if (StringUtils.isEmpty((String)dataSetId)) {
            return Collections.emptyList();
        }
        String dsStatus = this.getPageCache().get("status");
        DsDataModel dsDataModel = null;
        String dataModelJson = this.getPageCache().get("data_model");
        if (StringUtils.isNotEmpty((String)dataModelJson)) {
            dsDataModel = (DsDataModel)JSON.parseObject((String)dataModelJson, DsDataModel.class);
        }
        List dimensionList = this.getIModelCacheHelper().getDimensionList(IDUtils.toLong((Object)dataSetId));
        ArrayList<DimensionItem> itemList = new ArrayList<DimensionItem>(dimensionList.size());
        for (Dimension d : dimensionList) {
            String dimNumber = d.getNumber();
            String panel = null;
            if (dsDataModel != null) {
                if (dsDataModel.getValueFields().contains(dimNumber)) {
                    panel = "valuepool";
                } else {
                    List textFields = dsDataModel.getTextFields();
                    Optional<DimensionDto> optional = textFields.stream().filter(dto -> dto.getDimNumber().equals(dimNumber)).findFirst();
                    if (optional.isPresent()) {
                        panel = "textpool";
                    } else {
                        List hideFields = dsDataModel.getHideFields();
                        Optional<DimensionDto> hideOptional = hideFields.stream().filter(dto -> dto.getDimNumber().equals(dimNumber)).findFirst();
                        if (hideOptional.isPresent()) {
                            panel = "hidepool";
                        } else if (QingAnalysisDSConstants.Status.SAVE.getValue().equals(dsStatus)) {
                            panel = "hidepool";
                        }
                    }
                }
            } else {
                panel = QingAnalysisDSPluginConstants.DEFAULT_TEXT_FIELDS.contains(dimNumber) ? "textpool" : (QingAnalysisDSPluginConstants.DEFAULT_VALUE_FIELDS.contains(dimNumber) ? "valuepool" : "hidepool");
            }
            if (panel == null) continue;
            DimensionItem dimensionItem = new DimensionItem(d.getId(), d.getName(), d.getNumber(), d.getMemberModel(), d.getSeq(), panel);
            itemList.add(dimensionItem);
        }
        this.getPageCache().put("all_dim", JSON.toJSONString(itemList));
        if (dsDataModel != null) {
            this.cacheSelectedDimMem(dsDataModel.getTextFields(), itemList);
            this.cacheSelectedDimMem(dsDataModel.getHideFields(), itemList);
            this.getPageCache().put("data_model", JSON.toJSONString((Object)dsDataModel));
            this.getPageCache().put("config_data", JSON.toJSONString((Object)dsDataModel.getValueFieldConf()));
            this.getPageCache().put("dimension_view", dsDataModel.getDimensionViews().toJSONString());
        }
        return itemList;
    }

    private void cacheSelectedDimMem(List<DimensionDto> dimDtoList, List<DimensionItem> itemList) {
        dimDtoList.forEach(dim -> {
            if (CollectionUtils.isNotEmpty((Collection)dim.getMembers())) {
                List selectItemList = dim.getMembers().stream().map(mem -> {
                    TextEditSelectItem item = new TextEditSelectItem();
                    item.setId(IDUtils.isNotNull((Long)mem.getId()) ? String.valueOf(mem.getId()) : "");
                    item.setName(mem.getName());
                    item.setNumber(mem.getNumber());
                    item.setScope(mem.getScope());
                    return item;
                }).collect(Collectors.toList());
                Optional<DimensionItem> optional = itemList.stream().filter(d -> d.getNumber().equals(dim.getDimNumber())).findFirst();
                optional.ifPresent(dimensionItem -> this.getPageCache().put(dimensionItem.getFieldKey() + "_select", JSON.toJSONString((Object)selectItemList)));
            }
        });
    }

    private void updateAllDimCache(List<DimensionItem> list) {
        this.getPageCache().put("all_dim", JSON.toJSONString(list));
    }

    private List<DimensionItem> getAllDimension() {
        String allDim = this.getPageCache().get("all_dim");
        if (StringUtils.isEmpty((String)allDim)) {
            return this.loadAllDim();
        }
        return JSON.parseArray((String)this.getPageCache().get("all_dim"), DimensionItem.class);
    }

    private DimensionItem findItemByKey(String key) {
        List<DimensionItem> allDimension = this.getAllDimension();
        Optional<DimensionItem> optional = allDimension.stream().filter(d -> d.getFieldKey().equals(key)).findFirst();
        return optional.orElse(null);
    }

    private void addDimItems(FlexPanelAp flexPanelAp, List<DimensionItem> list) {
        String panelKey = flexPanelAp.getKey();
        for (DimensionItem item : list) {
            String fieldKey = item.getFieldKey();
            if ("textpool".equals(panelKey) || "hidepool".equals(panelKey)) {
                QingAnalysisDSControlHelper.createTextFieldAp(flexPanelAp, fieldKey, item.getName(), false, true);
                continue;
            }
            QingAnalysisDSControlHelper.createTextFieldAp(flexPanelAp, fieldKey, item.getName(), true, false);
        }
    }

    private void setDefaultValue() {
        DsDataModel dsDataModel = null;
        String fData = this.getPageCache().get("data_model");
        if (StringUtils.isNotEmpty((String)fData)) {
            dsDataModel = (DsDataModel)JSON.parseObject((String)fData, DsDataModel.class);
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Long datasetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
        List<DimensionItem> allDimension = this.getAllDimension();
        for (DimensionItem d : allDimension) {
            List textFields;
            Optional<DimensionDto> optional;
            String fieldKey = d.getFieldKey();
            String dimNumber = d.getNumber();
            Long viewId = QingAnalysisDSControlHelper.getViewId(this.getModelId(), datasetId, dimNumber, this.getView());
            if (!QingAnalysisDSPluginConstants.isCustomItem(fieldKey)) continue;
            this.getModel().setValue(fieldKey, null);
            if (QingAnalysisDSPluginConstants.isCustomItemHideField(d.getPanel())) {
                DimensionDto dimDto;
                List hideFields;
                Optional<DimensionDto> optional2;
                DimMemberDto memberDto = null;
                if (dsDataModel != null && (optional2 = (hideFields = dsDataModel.getHideFields()).stream().filter(dto -> dto.getDimNumber().equals(dimNumber)).findFirst()).isPresent() && CollectionUtils.isNotEmpty((Collection)(dimDto = optional2.get()).getMembers())) {
                    memberDto = (DimMemberDto)dimDto.getMembers().get(0);
                }
                TextEditSelectItem defaultSelectItem = null;
                StringBuilder sb = new StringBuilder();
                if (memberDto != null) {
                    defaultSelectItem = new TextEditSelectItem();
                    defaultSelectItem.setId(String.valueOf(memberDto.getId()));
                    defaultSelectItem.setScope(memberDto.getScope());
                    defaultSelectItem.setNumber(memberDto.getNumber());
                    defaultSelectItem.setName(memberDto.getName());
                    QingAnalysisDSControlHelper.buildMultiSelectF7ReturnValue(sb, memberDto.getName(), RangeEnum.ONLY.getIndex());
                } else {
                    Member member = null;
                    if (QingAnalysisDSPluginConstants.DEFAULT_MEMBER.containsKey(dimNumber)) {
                        String memberNumber = QingAnalysisDSPluginConstants.DEFAULT_MEMBER.get(dimNumber);
                        member = modelCache.getMember(dimNumber, viewId, memberNumber);
                    } else if (QingAnalysisDSPluginConstants.isUserDefineDimension(dimNumber)) {
                        member = modelCache.getRootMember(dimNumber, viewId);
                    }
                    if (member != null) {
                        defaultSelectItem = new TextEditSelectItem();
                        defaultSelectItem.setId(String.valueOf(member.getId()));
                        defaultSelectItem.setScope(String.valueOf(RangeEnum.ONLY.getIndex()));
                        defaultSelectItem.setNumber(member.getNumber());
                        defaultSelectItem.setName(member.getName());
                        defaultSelectItem.setPid(String.valueOf(member.getParentId()));
                        QingAnalysisDSControlHelper.buildMultiSelectF7ReturnValue(sb, member.getName(), RangeEnum.ONLY.getIndex());
                    }
                }
                if (defaultSelectItem == null) continue;
                List<TextEditSelectItem> selectItems = Collections.singletonList(defaultSelectItem);
                this.getPageCache().put(fieldKey + "_select", JSON.toJSONString(selectItems));
                this.getModel().setValue(fieldKey, (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""));
                this.getView().updateView(fieldKey);
                continue;
            }
            if (!QingAnalysisDSPluginConstants.isCustomItemTextField(d.getPanel()) || dsDataModel == null || !(optional = (textFields = dsDataModel.getTextFields()).stream().filter(dto -> dto.getDimNumber().equals(dimNumber)).findFirst()).isPresent()) continue;
            DimensionDto dimDto = optional.get();
            StringBuilder sb = new StringBuilder();
            if (CollectionUtils.isNotEmpty((Collection)dimDto.getMembers())) {
                dimDto.getMembers().forEach(mem -> QingAnalysisDSControlHelper.buildMultiSelectF7ReturnValue(sb, mem.getName(), Integer.parseInt(mem.getScope())));
            }
            this.getModel().setValue(fieldKey, (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""));
            this.getView().updateView(fieldKey);
        }
    }

    private void setDraggable() {
        this.getControl("hidepool").setDroppable(true);
        this.getControl("textpool").setDroppable(true);
        this.getControl("valuepool").setDroppable(true);
        List<DimensionItem> allDimension = this.getAllDimension();
        allDimension.forEach(d -> {
            this.getControl(d.getFieldKey()).setDraggable(true);
            this.getControl(d.getFieldKey()).setDroppable(true);
        });
    }

    private void setDragDisable() {
        this.getControl("hidepool").setDroppable(false);
        this.getControl("textpool").setDroppable(false);
        this.getControl("valuepool").setDroppable(false);
        List<DimensionItem> allDimension = this.getAllDimension();
        allDimension.forEach(d -> {
            this.getControl(d.getFieldKey()).setDraggable(false);
            this.getControl(d.getFieldKey()).setDroppable(false);
        });
    }

    private void registerDynamicProps(MainEntityType mainEntityType) {
        String allDim = this.getPageCache().get("all_dim");
        if (StringUtils.isEmpty((String)allDim)) {
            return;
        }
        List dimItems = JSON.parseArray((String)this.getPageCache().get("all_dim"), DimensionItem.class);
        if (mainEntityType == null) {
            mainEntityType = this.getModel().getDataEntityType();
        }
        for (DimensionItem item : dimItems) {
            String fieldKey = item.getFieldKey();
            QingAnalysisDSControlHelper.registerSimplePropWithId((EntityType)mainEntityType, fieldKey);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            MainEntityType newEntityType = (MainEntityType)e.getOriginalEntityType().clone();
            this.registerDynamicProps(newEntityType);
            e.setNewEntityType(newEntityType);
        }
        catch (CloneNotSupportedException ex) {
            throw new KDException((Throwable)ex, new ErrorCode("getEntityType", ex.getMessage()), new Object[0]);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        String ctrlKey = e.getKey();
        if (QingAnalysisDSPluginConstants.isCustomItemConfigField(ctrlKey)) {
            TextEdit edit = QingAnalysisDSControlHelper.createTextCtl(ctrlKey, this.getModel(), this.getView());
            e.setControl((Control)edit);
        } else if (QingAnalysisDSPluginConstants.isCustomItem(ctrlKey)) {
            DimensionItem dimItem = this.findItemByKey(ctrlKey);
            if (dimItem == null) {
                return;
            }
            TextEdit edit = QingAnalysisDSControlHelper.createTextCtl(ctrlKey, this.getModel(), this.getView());
            if (!QingAnalysisDSPluginConstants.isCustomItemValueField(dimItem.getPanel())) {
                edit.addClickListener((ClickListener)this);
            }
            e.setControl((Control)edit);
        }
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String name = e.getEventName();
        if ("drop".equals(name)) {
            String eventArgs = e.getEventArgs();
            String[] msg = this.translateMessage(eventArgs);
            String target = msg[0];
            String source = msg[1];
            if (QingAnalysisDSPluginConstants.isCustomItem(source)) {
                DimensionItem dimItem = this.findItemByKey(source);
                if (dimItem == null) {
                    return;
                }
                String sourcePanel = dimItem.getPanel();
                boolean changeFlag = this.interChange(target, source, dimItem);
                if (changeFlag) {
                    this.refreshDimPool();
                    this.setDraggable();
                    this.getModel().setDataChanged(true);
                    if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimItem.getNumber()) && "textpool".equals(dimItem.getPanel()) && !"textpool".equals(sourcePanel)) {
                        this.openFieldTypeConfigPage();
                    } else if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimItem.getNumber()) && !"textpool".equals(dimItem.getPanel())) {
                        this.getPageCache().remove("bpfieldtype");
                        this.getView().setVisible(Boolean.FALSE, new String[]{"btn_bpftype"});
                    }
                }
            }
        }
    }

    private String[] translateMessage(String text) {
        text = text.substring(1, text.length() - 1);
        String[] msg = text.split(",");
        for (int i = 0; i < msg.length; ++i) {
            msg[i] = msg[i].substring(1, msg[i].length() - 1);
        }
        return msg;
    }

    private boolean interChange(String target, String source, DimensionItem srcDimItem) {
        List<DimensionItem> dimItems = this.getAllDimension();
        String sourcePanel = srcDimItem.getPanel();
        if (StringUtils.isEmpty((String)sourcePanel) || StringUtils.isEmpty((String)target) || sourcePanel.equals(target)) {
            return false;
        }
        if ("hidepool".equals(target) || "textpool".equals(target) || "valuepool".equals(target)) {
            if (this.hasChangeError(target, srcDimItem.getNumber(), dimItems)) {
                return false;
            }
            dimItems.remove(srcDimItem);
            dimItems.add(srcDimItem);
            this.getModel().setValue(source, null);
            this.getView().updateView(source);
            srcDimItem.setPanel(target);
        } else {
            DimensionItem targetItem = this.findItemByKey(target);
            if (targetItem == null) {
                return false;
            }
            int targetIndex = dimItems.indexOf(targetItem);
            if (this.hasChangeError(targetItem.getPanel(), srcDimItem.getNumber(), dimItems)) {
                return false;
            }
            if (!srcDimItem.getPanel().equals(targetItem.getPanel())) {
                this.getModel().setValue(source, null);
                this.getView().updateView(source);
            }
            srcDimItem.setPanel(targetItem.getPanel());
            dimItems.remove(srcDimItem);
            dimItems.add(targetIndex, srcDimItem);
        }
        this.updateAllDimCache(dimItems);
        return true;
    }

    private boolean hasChangeError(String targetPanel, String dimNumber, List<DimensionItem> dimItems) {
        if ("textpool".equals(targetPanel)) {
            if (!QingAnalysisDSPluginConstants.canMove2TextPanel(dimNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e01\u79cd\u3001\u7ebf\u7d22\u3001\u7248\u672c\u3001\u53d8\u52a8\u7c7b\u578b\u3001\u6570\u636e\u7c7b\u578b\u3001\u5ea6\u91cf\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u62d6\u62fd\u81f3\u6b64\u533a\u57df\u3002", (String)"QingAnalysisDsEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return true;
            }
            long textPoolItemSize = dimItems.stream().filter(d -> d.getPanel().equals("textpool")).count();
            if (textPoolItemSize == 5L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u672c\u5b57\u6bb5\u652f\u63015\u4e2a\u7ef4\u5ea6\uff0c\u5df2\u8d85\u51fa\u7ef4\u5ea6\u6570\u91cf\u4e0a\u9650\u3002", (String)"QingAnalysisDsEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key == null) {
            return;
        }
        if (QingAnalysisDSPluginConstants.isCustomItem(key)) {
            DimensionItem dimItem = this.findItemByKey(key);
            if (dimItem == null) {
                return;
            }
            String dimNumber = dimItem.getNumber();
            Long modelId = this.getModelId();
            Long dataSetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
            qFilters.add(new QFilter("model", "=", (Object)modelId));
            if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
                qFilters.add(new QFilter("dataset", "=", (Object)dataSetId));
            } else if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
                qFilters.add(new QFilter("datatype", "in", (Object)Lists.newArrayList((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex(), MetricDataTypeEnum.RATE.getIndex()})));
            }
            long viewId = QingAnalysisDSControlHelper.getViewId(modelId, dataSetId, dimNumber, this.getView());
            String selectItemStr = this.getPageCache().get(key + "_select");
            this.getPageCache().remove(key);
            if ("hidepool".equals(dimItem.getPanel())) {
                QingAnalysisDSControlHelper.openNewF7(modelId, dataSetId, this.getBizModelId(), dimNumber, viewId, key, qFilters, selectItemStr, this.getView(), (IFormPlugin)this);
            } else {
                QingAnalysisDSControlHelper.openCustomF7Range(modelId, dataSetId, this.getBizModelId(), dimNumber, viewId, key, qFilters, selectItemStr, this.getView(), (IFormPlugin)this);
            }
        } else if ("btn_valueconfig".equals(key)) {
            this.openValueFieldConfigPage();
        } else if ("btn_bpftype".equals(key)) {
            this.openFieldTypeConfigPage();
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (QingAnalysisDSPluginConstants.isCustomItem(actionId)) {
            ListSelectedRowCollection members;
            if (closedCallBackEvent.getReturnData() == null) {
                return;
            }
            DimensionItem dimItem = this.findItemByKey(actionId);
            if (dimItem == null) {
                return;
            }
            String dimNumber = dimItem.getNumber();
            ArrayList<TextEditSelectItem> list = new ArrayList<TextEditSelectItem>();
            if (closedCallBackEvent.getReturnData() instanceof DynamicObjectCollection) {
                DynamicObjectCollection rows = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
                long viewId = IDUtils.toLong((Object)this.getPageCache().get(actionId + "viewId"));
                if (CollectionUtils.isNotEmpty((Collection)rows)) {
                    StringBuilder sb = new StringBuilder();
                    for (DynamicObject row : rows) {
                        TextEditSelectItem item = new TextEditSelectItem();
                        item.setId(row.getString("memberid"));
                        item.setScope(row.getString("scope"));
                        item.setNumber(row.getString("number"));
                        item.setName(row.getString("name"));
                        item.setPid(row.getString("pid"));
                        QingAnalysisDSControlHelper.buildMultiSelectF7ReturnValue(sb, row.getString("name"), row.getInt("scope"));
                        list.add(item);
                        viewId = row.getLong("viewid");
                    }
                    QingAnalysisDSControlHelper.updateDimensionView(dimNumber, viewId, this.getView());
                    this.getModel().setValue(actionId, (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""));
                    this.getPageCache().put(actionId + "_select", JSON.toJSONString(list));
                }
            } else if (closedCallBackEvent.getReturnData() instanceof ListSelectedRowCollection && CollectionUtils.isNotEmpty((Collection)(members = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()))) {
                StringBuilder sb = new StringBuilder();
                for (ListSelectedRow member : members) {
                    TextEditSelectItem item = new TextEditSelectItem();
                    item.setId(member.getPrimaryKeyValue().toString());
                    item.setScope(String.valueOf(RangeEnum.ONLY.getIndex()));
                    item.setNumber(member.getNumber());
                    item.setName(member.getName());
                    QingAnalysisDSControlHelper.buildMultiSelectF7ReturnValue(sb, member.getName(), RangeEnum.ONLY.getIndex());
                    list.add(item);
                    Object viewId = member.getDataMap().get("viewid");
                    QingAnalysisDSControlHelper.updateDimensionView(dimNumber, IDUtils.toLong(viewId), this.getView());
                }
                this.getModel().setValue(actionId, (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""));
                this.getPageCache().put(actionId + "_select", JSON.toJSONString(list));
            }
        } else if ("configCloseCallback".equals(actionId)) {
            if (closedCallBackEvent.getReturnData() instanceof Map) {
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                this.getPageCache().put("config_data", (String)returnData.get("config_data"));
                String view = (String)returnData.get("dimension_view");
                JSONObject dimensionView = JSONObject.parseObject((String)view);
                for (String key : dimensionView.keySet()) {
                    QingAnalysisDSControlHelper.updateDimensionView(key, dimensionView.getLong(key), this.getView());
                }
                this.refreshConfigPool();
            }
        } else if ("fieldTypeCloseCallback".equals(actionId) && closedCallBackEvent.getReturnData() instanceof Map) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            this.getPageCache().put("bpfieldtype", (String)returnData.get("bpfieldtype"));
            this.refreshFieldTypeBtn();
        }
    }

    private void refreshFieldTypeBtn() {
        String type = this.getPageCache().get("bpfieldtype");
        if (StringUtils.isEmpty((String)type)) {
            return;
        }
        String typeLabel = type.equals("1") ? ResManager.loadKDString((String)"\u6587\u672c", (String)"QingAnalysisDsConfigPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u65e5\u671f", (String)"QingAnalysisDsConfigPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        Label btn = (Label)this.getControl("btn_bpftype");
        btn.setText(ResManager.loadResFormat((String)"\u671f\u95f4\u5b57\u6bb5\u7c7b\u578b\uff1a%1", (String)"QingAnalysisDsConfigPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{typeLabel}));
        this.getView().setVisible(Boolean.TRUE, new String[]{"btn_bpftype"});
    }

    private void refreshConfigPool() {
        String configData = this.getPageCache().get("config_data");
        if (StringUtils.isEmpty((String)configData)) {
            return;
        }
        MainEntityType mainEntityType = this.getModel().getDataEntityType();
        FlexPanelAp flexPanelAp = QingAnalysisDSControlHelper.createFlexPanel("valueconfigpool");
        List dtoList = JSON.parseArray((String)configData, ValueFieldConfigDto.class);
        dtoList.forEach(dto -> {
            String configStr = dto.getDims().stream().map(dimDto -> dimDto.getMembers().stream().map(DimMemberDto::getName).collect(Collectors.joining(""))).collect(Collectors.joining(","));
            String fieldKey = dto.getKey();
            FieldAp fieldAp = QingAnalysisDSControlHelper.createTextFieldAp(flexPanelAp, fieldKey, dto.getName(), true, false);
            fieldAp.setWidth(new LocaleString("250px"));
            fieldAp.setFieldTextAlign("left");
            QingAnalysisDSControlHelper.registerSimpleProp((EntityType)mainEntityType, fieldKey);
            this.getModel().setValue(fieldKey, (Object)configStr);
            this.getView().updateView(fieldKey);
        });
        QingAnalysisDSControlHelper.updateControlMetadata(this.getView(), "valueconfigpool", flexPanelAp.createControl());
    }

    public boolean triggerPropChange() {
        return true;
    }

    public String getBizCtrlRangeKey() {
        return "bizmodel";
    }

    public String getBizModelKey() {
        return "dataset";
    }
}

